/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.settings.service.EncryptionKeyService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.EncryptionKeyElement;
import com.parablu.pcbd.domain.User;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EncryptionKeyController
extends BaseController {
    private static Logger logger = LogManager.getLogger(EncryptionKeyController.class);
    @Autowired
    private EncryptionKeyService encryptionKeyService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String SALT_KEY = "saltKey";
    private static final String PRODUCT_TYPE = "productType";
    private static final String EXCEPTION = " Exception  :";

    @Deprecated
    @RequestMapping(value={"/cloud/{cloudName}/save/encryptionKey/"}, method={RequestMethod.POST})
    public void saveEncryptionKey(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering saveEncryptionKey ..... ");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save encryptionkey ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                logger.error("Error performAuthorization during save encryptionkey ......");
                return;
            }
            String saltKey = request.getHeader(SALT_KEY);
            String userName = request.getHeader("userName");
            String productType = request.getHeader(PRODUCT_TYPE);
            this.encryptionKeyService.saveEncryptionKey(cloudId, userName, saltKey, productType);
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.debug("exception trying to save encryption key ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of saveEncryptionKey ..... ");
    }

    @Deprecated
    @RequestMapping(value={"/cloud/{cloudName}/load/encryptionKey/"}, method={RequestMethod.POST})
    public void loadEncryptionKey(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        int cloudId = cl.getCloud().getCloudId();
        try {
            String productType = request.getHeader(PRODUCT_TYPE);
            EncryptionKeyElement encryptionKey = this.encryptionKeyService.getEncryptionKey(cloudId, productType);
            response.setStatus(200);
            if (encryptionKey != null) {
                response.setHeader(SALT_KEY, encryptionKey.getSaltKey());
            } else {
                response.setHeader(SALT_KEY, "");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
    }

    @Deprecated
    @RequestMapping(value={"/cloud/{cloudName}/get/decryptionKey/"}, method={RequestMethod.GET})
    public void getKeyForDecryption(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        int cloudId = cl.getCloud().getCloudId();
        String timeStampAsHeader = request.getHeader("timeStamp");
        if (timeStampAsHeader == null) {
            response.setStatus(500);
            return;
        }
        long timeStamp = Long.valueOf(timeStampAsHeader);
        try {
            String productType = request.getHeader(PRODUCT_TYPE);
            EncryptionKeyElement encryptionKey = this.encryptionKeyService.getKeyForDecryption(cloudId, timeStamp, productType);
            response.setStatus(200);
            if (encryptionKey != null) {
                response.setHeader(SALT_KEY, encryptionKey.getSaltKey());
            } else {
                response.setHeader(SALT_KEY, "");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cryptokeys/products/"}, method={RequestMethod.POST})
    public void saveNewEncryptionKey(@PathVariable(value="cloudName") String cloudName1, @RequestBody EncryptionKeyElement encryptionKey, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Entering saveEncryptionKey ..... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("Error checkLicense during save encryptionkey ......");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                logger.error("Error performAuthorization during save encryptionkey ......");
                return;
            }
            this.encryptionKeyService.saveEncryptionKey(cloudId, encryptionKey.getUserName(), encryptionKey.getSaltKey(), encryptionKey.getProductType());
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created a new Encryption configuration for ", currentUser.getUserName(), encryptionKey.getProductType(), "Portal", System.currentTimeMillis(), PCActionTypes.ENCRYPTIONKEY_CREATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.debug("exception trying to save encryption key ... ", (Throwable)exception);
            response.setStatus(500);
        }
        logger.debug("end of saveEncryptionKey ..... ");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cryptokeys/products/{product}"}, method={RequestMethod.GET})
    public ModelAndView getNewKeyForDecryption(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="product") String productType, @RequestParam(value="timeStamp") String timeStampValue, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        int cloudId = cl.getCloud().getCloudId();
        if (StringUtils.isEmpty((String)timeStampValue)) {
            response.setStatus(500);
            return null;
        }
        long timeStamp = Long.valueOf(timeStampValue);
        try {
            EncryptionKeyElement encryptionKeyElement = this.encryptionKeyService.getKeyForDecryption(cloudId, timeStamp, productType);
            response.setStatus(200);
            if (encryptionKeyElement != null) {
                modelAndView.addObject((Object)encryptionKeyElement);
                response.setStatus(200);
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cryptokeys/products/"}, method={RequestMethod.GET})
    public ModelAndView getAllKey(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String token;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.error("Error checkLicense during get encryptionkey ......");
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
            logger.error("Error performAuthorization during get encryptionkey ......");
            return null;
        }
        try {
            List<EncryptionKeyElement> encryptionKeyElements = this.encryptionKeyService.getAllEncryptionKeys(cloudId);
            if (!CollectionUtils.isEmpty(encryptionKeyElements)) {
                modelAndView.addObject(encryptionKeyElements);
                response.setStatus(200);
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }
}

