/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.settings.controller;

import com.parablu.bluvault.settings.controller.MyAuthenticator;
import com.parablu.bluvault.settings.mem.MemoryStore;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.service.UpgradeService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Release;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ClientUpgradeController
extends BaseController {
    @Autowired
    UpgradeService upgradeService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private UserManagementService userManagementService;
    Logger logger = LogManager.getLogger(ClientUpgradeController.class);
    private static final String METHOD_ENTRY_UPDATE_CONTROLLER_GET_LATEST_BLU_SYNC_VERSION = "Method Entry UpdateController.getLatestBluSyncVersion";
    private static final String EXCEPTION = "Exception";
    private static final String KEY_FOR_CLIENT_VERSION = "clientVersion";
    private static final String KEY_FOR_CLIENT_SERVICE_VERSION = "clientServiceVersion";
    private static final String SERVICE = "service";
    private static int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;
    protected static final String JSONVIEW = "jsonview";
    protected static final String KEY_FOR_UPDATEFILE = "updateFilePresent";
    protected static final String KEY_FOR_AUTOUPDATE_ENABLED = "autoUpdateEnabled";
    public static final String KEY_ROLLBACK = "rollBack";

    @RequestMapping(value={"/cloud/{cloudName}/update/details"}, method={RequestMethod.POST})
    public void getLatestBluSyncVersion(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug(METHOD_ENTRY_UPDATE_CONTROLLER_GET_LATEST_BLU_SYNC_VERSION);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Cloud cloud = cl.getCloud();
        String productMinorType = request.getHeader("version-type");
        String productVersion = request.getHeader("current-version");
        try {
            Object version = SERVICE.equalsIgnoreCase(productMinorType) ? MemoryStore.get(KEY_FOR_CLIENT_SERVICE_VERSION) : MemoryStore.get(KEY_FOR_CLIENT_VERSION);
            Object autoUpdateEnabled = MemoryStore.get(KEY_FOR_AUTOUPDATE_ENABLED);
            Object rollBack = MemoryStore.get(KEY_ROLLBACK);
            if (version == null || autoUpdateEnabled == null || rollBack == null) {
                Release currentRelease = this.upgradeService.getReleaseVersionForClientMinorVersionType(productMinorType, productVersion);
                if (currentRelease == null) {
                    response.setStatus(500);
                } else if (StringUtils.isNotEmpty((String)String.valueOf(currentRelease.isUpdateAgent())) && !currentRelease.isUpdateAgent()) {
                    response.setStatus(430);
                } else {
                    if (SERVICE.equalsIgnoreCase(productMinorType)) {
                        MemoryStore.add(KEY_FOR_CLIENT_SERVICE_VERSION, currentRelease.getProductVersion());
                    } else {
                        MemoryStore.add(KEY_FOR_CLIENT_VERSION, currentRelease.getProductVersion());
                    }
                    MemoryStore.add(KEY_FOR_AUTOUPDATE_ENABLED, currentRelease.isUpdateAgent());
                    MemoryStore.add(KEY_ROLLBACK, currentRelease.isRollBackEnabled());
                    response.setStatus(200);
                    this.logger.debug("agent headers " + currentRelease.getProductVersion());
                    response.setHeader("current-version", currentRelease.getProductVersion());
                    response.setHeader(KEY_FOR_AUTOUPDATE_ENABLED, String.valueOf(currentRelease.isUpdateAgent()));
                    response.setHeader(KEY_ROLLBACK, String.valueOf(currentRelease.isRollBackEnabled()));
                }
            } else {
                this.logger.debug("Inside version from memory store......");
                String clientVersionFromServer = version.toString();
                String allowAutoUpdate = autoUpdateEnabled.toString();
                if (!StringUtils.isEmpty((String)clientVersionFromServer)) {
                    if (StringUtils.isNotEmpty((String)allowAutoUpdate) && allowAutoUpdate.equals("false")) {
                        response.setStatus(430);
                    } else {
                        this.logger.debug("client needs an agent update:" + clientVersionFromServer);
                        response.setStatus(200);
                        response.setHeader("current-version", clientVersionFromServer);
                        response.setHeader(KEY_FOR_AUTOUPDATE_ENABLED, allowAutoUpdate);
                        response.setHeader(KEY_ROLLBACK, String.valueOf(rollBack));
                    }
                } else {
                    response.setStatus(500);
                }
            }
            response.setHeader("updateFrequency", Integer.toString(cloud.getUpdateFrequency()));
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION, (Throwable)e);
            response.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/cloud/{cloudName}/update/download"}, method={RequestMethod.GET})
    public void downloadLatestBluSyncVersion(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        this.logger.debug(METHOD_ENTRY_UPDATE_CONTROLLER_GET_LATEST_BLU_SYNC_VERSION);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        String productMinorType = request.getHeader("version-type");
        String productVersion = request.getHeader("current-version");
        String deviceUUID = request.getHeader("deviceUUID");
        String serviceUpdate = request.getHeader("serviceUpdate");
        this.logger.debug(".......check deviceUUID...." + deviceUUID);
        InputStream input = null;
        BackupPolicy policy = null;
        boolean isAutoUpdateAgent = false;
        UserElement user = null;
        String policyName = null;
        DeviceElement device = null;
        try {
            Release currentRelease = this.upgradeService.getReleaseVersionForClientMinorVersionType(productMinorType, productVersion);
            if (StringUtils.isNotEmpty((String)deviceUUID)) {
                try {
                    device = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                    if (device != null) {
                        user = this.userManagementService.getUserByUserNameOrEmail(cloud, device.getUserName());
                    }
                    if (user != null) {
                        policyName = user.getPolicyName();
                    }
                    if (StringUtils.isNotEmpty(policyName)) {
                        policy = this.userManagementService.getBackupPolicy(cloudId, policyName);
                    }
                    if (policy != null && policy.isAutoUpdateAgent()) {
                        isAutoUpdateAgent = true;
                    }
                }
                catch (Exception e) {
                    isAutoUpdateAgent = true;
                    this.logger.error(".......erorr....", (Throwable)e);
                }
            }
            if (!StringUtils.isNotEmpty((String)deviceUUID) || deviceUUID.equalsIgnoreCase("null") || isAutoUpdateAgent) {
                if (currentRelease == null) {
                    response.setStatus(500);
                    return;
                }
                if (currentRelease.getProductVersion().equals(productVersion)) {
                    input = this.upgradeService.downloadLatestBlusyncVersion(productVersion, productMinorType);
                    if (input != null) {
                        response.setStatus(200);
                        IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
                        if (!StringUtils.isEmpty((String)serviceUpdate)) return;
                        this.upgradeService.updateVersionInDeviceTable(cloudId, productVersion, deviceUUID);
                        return;
                    }
                    response.setStatus(500);
                    return;
                }
                response.setStatus(400);
                response.setHeader("current-version", currentRelease.getProductVersion());
                return;
            }
            this.logger.debug(".....auto update disabled in policy..........");
            response.setStatus(500);
            if (input == null) return;
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return;
        }
        IOUtils.closeQuietly((InputStream)input);
        return;
        finally {
            if (input != null) {
                IOUtils.closeQuietly(input);
            }
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/update/serverupgrade/version/"}, method={RequestMethod.PUT})
    public void updateServerUpgradeVersion(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug(METHOD_ENTRY_UPDATE_CONTROLLER_GET_LATEST_BLU_SYNC_VERSION);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        String productMinorType = request.getHeader("version-type");
        String productVersion = request.getHeader("current-version");
        try {
            this.upgradeService.updateServerUpgradeVersion(productVersion, productMinorType);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION, (Throwable)e);
            response.setStatus(500);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/cloud/{cloudName}/update/agent"}, method={RequestMethod.POST})
    public void editUpdateAgentDetail(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) throws MalformedURLException {
        this.logger.debug("calling /update/agent details");
        boolean updateAgent = false;
        boolean downloadAgent = false;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Release productElement = new Release();
        String fileToDwonload = null;
        String agentUpdateEnabled = request.getHeader("autoUpdate");
        String downloadAgentEnabled = request.getHeader("downloadAgent");
        String fileName = request.getHeader("updateFileName");
        String FILE_URL = request.getHeader("link");
        String productType = request.getHeader("productType");
        if (StringUtils.isNotEmpty((String)agentUpdateEnabled)) {
            updateAgent = Boolean.valueOf(agentUpdateEnabled);
        }
        if (StringUtils.isNotEmpty((String)downloadAgentEnabled)) {
            downloadAgent = Boolean.valueOf(downloadAgentEnabled);
        }
        if (StringUtils.isNotEmpty((String)FILE_URL)) {
            fileName = FilenameUtils.getName((String)new URL(FILE_URL).getPath());
        }
        try {
            if (StringUtils.isNotEmpty((String)fileName)) {
                fileToDwonload = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "updates/" + fileName;
            }
            if (StringUtils.isNotEmpty((String)FILE_URL) && StringUtils.isNotEmpty((String)fileName) && fileName.toLowerCase().startsWith(productType)) {
                if (!this.downloadFile(productElement, fileName, FILE_URL, productType, fileToDwonload)) {
                    this.logger.debug("unable to download the file from link");
                    response.setStatus(507);
                    return;
                }
                this.logger.debug("download link successfull");
            } else if (StringUtils.isNotEmpty((String)fileName) && fileName.toLowerCase().startsWith(productType)) {
                this.logger.debug("file present in updates");
            } else if (StringUtils.isNotEmpty((String)fileName)) {
                response.setStatus(412);
                return;
            }
            if (this.upgradeService.saveUpdatefile(productType, fileToDwonload, downloadAgent, updateAgent, fileName)) {
                response.setStatus(200);
                return;
            }
            this.logger.debug("not able to copy file to parablusys/base folder doesnot exist");
            response.setStatus(500);
            return;
        }
        catch (Exception e) {
            this.logger.error("" + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean downloadFile(Release productElement, String fileName, String FILE_URL, String productType, String fileToDwonload) throws IOException, MalformedURLException, FileNotFoundException {
        try {
            File file = new File(fileToDwonload);
            Authenticator.setDefault(new MyAuthenticator());
            if (!this.cleanBaseFolder(file)) {
                this.logger.debug("not able to create base folder/not able to delete existing file");
                return false;
            }
            FileUtils.copyURLToFile((URL)new URL(FILE_URL), (File)new File(fileToDwonload), (int)CONNECT_TIMEOUT, (int)60000);
        }
        catch (IOException e) {
            this.logger.error("failed to download file from dns " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean cleanBaseFolder(File file) {
        boolean result = false;
        try {
            this.logger.debug("base directory " + file.getAbsolutePath());
            if (!file.getParentFile().exists()) {
                return false;
            }
            if (file.exists()) {
                file.delete();
                result = true;
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.logger.error("error to create base folder" + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/cloud/{cloudName}/agentupdate/details"}, method={RequestMethod.GET})
    public ModelAndView getProductTable(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        try {
            List currentRelease = this.upgradeService.getAllRelease();
            if (currentRelease.isEmpty()) {
                response.setStatus(204);
                return null;
            }
            modelAndView.addObject((Object)currentRelease);
            response.setStatus(200);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION, (Throwable)e);
            response.setStatus(500);
        }
        return modelAndView;
    }
}

