/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.paracloud.constant.PCHelperConstant;
import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheHelper {
    private final MemcachedClient memcachedClient;
    private Logger logger = LogManager.getLogger(CacheHelper.class);

    public CacheHelper() throws IOException {
        this.memcachedClient = new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(PCHelperConstant.getPropertyFileValueMemcachedUrl(), (int)Integer.valueOf(PCHelperConstant.getPropertyFileValueMemcachedPort()))});
    }

    public Long getCachedDiskSpace(String cloudName) {
        String key = cloudName.toLowerCase() + "size";
        String stringVal = (String)this.memcachedClient.get(key);
        if (stringVal == null) {
            return null;
        }
        Long val = Long.valueOf(stringVal.trim());
        this.logger.debug("getCachedDiskSpace Key: " + key + " and val: " + val);
        return val;
    }

    public void putCachedDiskSpace(String cloudName, long val) {
        String key = cloudName.toLowerCase() + "size";
        this.logger.debug("putCachedDiskSpace Key:" + key + " value " + val);
        OperationFuture mutatedValue = this.memcachedClient.set(key, Integer.valueOf(PCHelperConstant.getPropertyFileValueMemcachedTimeout()).intValue(), (Object)String.valueOf(val));
        this.logger.debug("value set without exception:" + mutatedValue.toString());
    }

    public Long incrCachedDiskSpace(String cloudName, long val) {
        String key = cloudName.toLowerCase() + "size";
        this.logger.debug("incrCachedDiskSpace Key:" + key);
        this.logger.debug(" inc by:" + val);
        Long long1 = this.memcachedClient.incr(key, val);
        this.logger.debug("incrCachedDiskSpace new key:" + key + "  value:" + long1);
        return long1;
    }

    public Long decrCachedDiskSpace(String cloudName, long val) {
        String key = cloudName.toLowerCase() + "size";
        this.logger.debug("decrCachedDiskSpace Key:" + key);
        this.logger.debug(" inc by:" + val);
        Long long1 = this.memcachedClient.decr(key, val);
        this.logger.debug(" decrCachedDiskSpace new value:" + long1);
        return long1;
    }

    public void addValueToCache(String key, String value, int timeinSeconds) {
        OperationFuture mutatedValue = this.memcachedClient.set(key.toLowerCase(), timeinSeconds, (Object)value);
        this.logger.debug("value set without exception:" + mutatedValue.toString());
    }

    public String getValueFromCache(String key) {
        return (String)this.memcachedClient.get(key.toLowerCase());
    }

    public void removeKeyFromCache(String key) {
        this.memcachedClient.delete(key.toLowerCase());
    }
}

