/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MD5Generator {
    private static Logger logger = LogManager.getLogger(MD5Generator.class);
    private static final String IO_EXCEPTION = "IOException  :";

    private MD5Generator() {
    }

    public static String generateMD5OfFile(File file) {
        String md5 = null;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)input)));
        }
        catch (FileNotFoundException exception) {
            logger.trace("FileNotFoundException  :" + exception);
            logger.error("FileNotFoundException  :" + exception.getMessage());
        }
        catch (SecurityException exception) {
            logger.trace("SecurityException  :" + exception);
            logger.error("SecurityException  :" + exception.getMessage());
        }
        catch (IOException exception) {
            logger.trace(IO_EXCEPTION + exception);
            logger.error(IO_EXCEPTION + exception.getMessage());
        }
        catch (Exception exception) {
            logger.trace("exception  :" + exception);
            logger.error("exception  :" + exception.getMessage());
        }
        return md5;
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex((byte[])DigestUtils.md5((String)convertTo)));
    }
}

