/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.response;

import com.parablu.helper.response.FailureJSONResponse;
import com.parablu.helper.response.JSONResponse;
import com.parablu.helper.response.PropertyHandler;
import com.parablu.paracloud.element.response.ResponseMetadataElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class ResponseHandler {
    private static Logger logger = LogManager.getLogger(ResponseHandler.class);
    private static final String SUCCESS = "Success";
    private static final String FAILURE = "Failure";
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String RECORDS_COUNT = "recordsPerPage";
    private static final String EQUALS_SIGN = "=";
    private static final String PARAM_SEPERATOR = "&";
    private static final String JSON_PARSE_EXCEPTION_MESSAGE = "Exception while parsingto JSON";

    public Object toJSON(int statusCode) {
        try {
            JSONResponse response = new JSONResponse();
            if (statusCode == 200) {
                response.setSatus(SUCCESS);
            } else {
                response.setSatus(FAILURE);
                FailureJSONResponse failureJSONResponse = new FailureJSONResponse();
                failureJSONResponse.setErrorCode(Integer.toString(statusCode));
                failureJSONResponse.setErrorHelper(PropertyHandler.getInstance().getProperty("response.failure.help." + Integer.toString(statusCode)));
                failureJSONResponse.setErrorMessage(PropertyHandler.getInstance().getProperty("response.failure.message." + Integer.toString(statusCode)));
                response.setFailure(failureJSONResponse);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
            return mapper.writeValueAsBytes((Object)response);
        }
        catch (Exception e) {
            logger.trace(JSON_PARSE_EXCEPTION_MESSAGE + e);
            logger.error(JSON_PARSE_EXCEPTION_MESSAGE + e.getMessage());
            return JSON_PARSE_EXCEPTION_MESSAGE;
        }
    }

    public Object toJSON(int statusCode, Object metadata, Object data) {
        try {
            JSONResponse response = new JSONResponse();
            response.setSatus(SUCCESS);
            response.setMetadata(metadata);
            response.setData(data);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
            return mapper.writeValueAsBytes((Object)response);
        }
        catch (Exception e) {
            logger.trace(JSON_PARSE_EXCEPTION_MESSAGE + e);
            logger.error(JSON_PARSE_EXCEPTION_MESSAGE + e.getMessage());
            return JSON_PARSE_EXCEPTION_MESSAGE;
        }
    }

    public Object toJSON(int statusCode, Object data) {
        try {
            JSONResponse response = new JSONResponse();
            response.setSatus(SUCCESS);
            response.setData(data);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
            return mapper.writeValueAsBytes((Object)response);
        }
        catch (Exception e) {
            logger.trace(JSON_PARSE_EXCEPTION_MESSAGE + e);
            logger.error(JSON_PARSE_EXCEPTION_MESSAGE + e.getMessage());
            return JSON_PARSE_EXCEPTION_MESSAGE;
        }
    }

    public ResponseMetadataElement getMetadataElement(int recordsCount, int currentPage, long totalRecords, String link, Map<String, String[]> queryMap) {
        ResponseMetadataElement metadata = new ResponseMetadataElement();
        metadata.setRecordsPerPage(recordsCount);
        metadata.setPageNumber(currentPage);
        metadata.setTotalCount(totalRecords);
        String queryParams = this.getQueryParametersAsString(queryMap);
        long lastPageNumber = totalRecords % (long)recordsCount == 0L ? totalRecords / (long)recordsCount : totalRecords / (long)recordsCount + 1L;
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("self", link + "?" + PAGE_NUMBER + EQUALS_SIGN + currentPage + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        links.put("first", link + "?" + PAGE_NUMBER + EQUALS_SIGN + 1 + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        logger.debug("..currentPAge..." + currentPage);
        long prev = 1L;
        long next = 1L;
        if (currentPage > 1) {
            prev = currentPage - 1;
        }
        next = (long)currentPage == lastPageNumber ? lastPageNumber : (long)(currentPage + 1);
        logger.debug(prev + "...prev and next" + next);
        links.put("previous", link + "?" + PAGE_NUMBER + EQUALS_SIGN + prev + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        links.put("next", link + "?" + PAGE_NUMBER + EQUALS_SIGN + next + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        logger.debug(totalRecords + "..totalrec/recordsCount..." + recordsCount);
        links.put("last", link + "?" + PAGE_NUMBER + EQUALS_SIGN + lastPageNumber + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + queryParams);
        metadata.setLinks(links);
        return metadata;
    }

    public ResponseMetadataElement getPaginationMetadataElement(int recordsCount, int currentPage, String link, AtomicInteger nextCur, AtomicInteger prevCur, boolean ltf, String prevOperation) {
        ResponseMetadataElement metadata = new ResponseMetadataElement();
        metadata.setRecordsPerPage(recordsCount);
        metadata.setPageNumber(currentPage);
        metadata.setTotalCount(0L);
        if (StringUtils.isEmpty((Object)prevOperation)) {
            prevOperation = "first";
        }
        long next = nextCur.get();
        long prev = prevCur.get();
        boolean nextltf = ltf;
        if ("first".equalsIgnoreCase(prevOperation)) {
            nextltf = true;
        }
        if ("last".equalsIgnoreCase(prevOperation)) {
            nextltf = false;
        }
        logger.debug("...current values....." + prevOperation + "...." + next + "..." + prev);
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("self", link + "?" + PAGE_NUMBER + EQUALS_SIGN + currentPage + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + PARAM_SEPERATOR + "nextPage" + EQUALS_SIGN + next + PARAM_SEPERATOR + "ltf" + EQUALS_SIGN + ltf);
        links.put("first", link + "?first" + EQUALS_SIGN + true + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + PARAM_SEPERATOR + "nextPage" + EQUALS_SIGN + -1 + PARAM_SEPERATOR + "ltf" + EQUALS_SIGN + true);
        links.put("previous", link + "?prev" + EQUALS_SIGN + true + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + PARAM_SEPERATOR + "nextPage" + EQUALS_SIGN + prev + PARAM_SEPERATOR + "ltf" + EQUALS_SIGN + nextltf);
        links.put("next", link + "?next" + EQUALS_SIGN + true + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + PARAM_SEPERATOR + "nextPage" + EQUALS_SIGN + next + PARAM_SEPERATOR + "ltf" + EQUALS_SIGN + nextltf);
        links.put("last", link + "?last" + EQUALS_SIGN + true + PARAM_SEPERATOR + RECORDS_COUNT + EQUALS_SIGN + recordsCount + PARAM_SEPERATOR + "nextPage" + EQUALS_SIGN + -1 + PARAM_SEPERATOR + "ltf" + EQUALS_SIGN + false);
        metadata.setLinks(links);
        logger.debug("......links first..." + (String)links.get("first"));
        logger.debug("......links prev..." + (String)links.get("previous"));
        logger.debug("......links next..." + (String)links.get("next"));
        logger.debug("......links last..." + (String)links.get("last"));
        return metadata;
    }

    public String getQueryParametersAsString(Map<String, String[]> queryMap) {
        StringBuilder queryParams = new StringBuilder();
        if (!CollectionUtils.isEmpty(queryMap)) {
            for (String key : queryMap.keySet()) {
                if (key.equalsIgnoreCase(PAGE_NUMBER) || key.equalsIgnoreCase(RECORDS_COUNT)) continue;
                queryParams.append(PARAM_SEPERATOR).append(key).append(EQUALS_SIGN).append(queryMap.get(key)[0]);
            }
        }
        return queryParams.toString();
    }
}

