/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.sp.service.impl;

import com.parablu.helper.utils.SyncPolicyDiffFinder;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BSPrivacyGatewayElement;
import com.parablu.paracloud.element.BSPrivacyGatewayMappingElement;
import com.parablu.paracloud.element.BluSyncGroupSyncPolicyElement;
import com.parablu.paracloud.element.BluVaultMappingElement;
import com.parablu.paracloud.element.EndpointUiDisabledPreferencesElement;
import com.parablu.paracloud.element.EndpointUiPreferencesElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.paracloud.element.NetworkThrottlingElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.Policy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import com.parablu.sp.service.SyncPolicyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SyncPolicyServiceImpl
implements SyncPolicyService {
    private Logger logger = LogManager.getLogger(SyncPolicyServiceImpl.class);
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    private SchedulesDao schedulesDao;
    @Resource
    private NetworkThrottlingDao networkThrottlingDao;
    @Resource
    private CloudDao cloudDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    @Resource
    private EventHubDao eventHubDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private ReleaseDao releaseDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Resource
    private UserDao userDao;

    @Override
    public void saveSyncPolicy(int cloudId, String cloudName, SyncPolicyElement syncPolicyElement, String userName) {
        SyncPolicy existingSyncPolicy = this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, syncPolicyElement.getPolicygroupName());
        List networkThrottlingNames = syncPolicyElement.getNetworkThrottlingNames();
        List networkThrottlings = this.networkThrottlingDao.getNetworkThrottlings(cloudId, cloudName, networkThrottlingNames);
        ArrayList<String> existingEndpointUri = new ArrayList<String>();
        List filterNames = syncPolicyElement.getFilterInclusionName();
        String shareDomainType = syncPolicyElement.getShareDomainType();
        List shareDomainIncExclusions = syncPolicyElement.getShareDomainIncExclusions();
        if (!CollectionUtils.isEmpty((Collection)shareDomainIncExclusions)) {
            for (String incl : shareDomainIncExclusions) {
                this.logger.debug(shareDomainType + ".....share inclusions/exclusions...." + incl);
            }
        }
        ArrayList<Object> filters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)filterNames)) {
            filters = this.getFiltersbyName(cloudId, cloudName, filterNames);
        }
        List searchfilterNames = syncPolicyElement.getSearchFilterInclusionName();
        ArrayList<Object> searchfilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)searchfilterNames)) {
            searchfilters = this.getFiltersbyName(cloudId, cloudName, searchfilterNames);
        }
        CloudCredentials cloudCredentials = null;
        if (!StringUtils.isEmpty((Object)syncPolicyElement.getCloudCredential())) {
            cloudCredentials = this.cloudDao.getCloudCredentials(cloudId, syncPolicyElement.getCloudCredential());
        }
        SyncPolicy syncPolicy = new SyncPolicy();
        BeanUtils.copyProperties((Object)syncPolicyElement, (Object)syncPolicy);
        syncPolicy.setPolicyName(syncPolicyElement.getPolicygroupName());
        syncPolicy.setNetworkThrottlings(new ArrayList());
        syncPolicy.getNetworkThrottlings().addAll(networkThrottlings);
        syncPolicy.setInclusionFilter(filters);
        syncPolicy.setSearchInclusionFilter(searchfilters);
        syncPolicy.setEndpointUiPreferences(new ArrayList(syncPolicyElement.getEndpointUiPreferences()));
        syncPolicy.setEnableAVScan(syncPolicyElement.isEnableAVScan());
        syncPolicy.setShowShareLink(syncPolicyElement.isShowShareLink());
        if (existingSyncPolicy != null) {
            SyncPolicyElement existingSyncPolicyElement = new SyncPolicyElement();
            ArrayList<String> existingPrivacyGateways = new ArrayList<String>();
            if (StringUtils.isEmpty((Object)existingSyncPolicy.getPrivacyGateways())) {
                existingSyncPolicy.setPrivacyGateways(new ArrayList());
            }
            for (Object pg : existingSyncPolicy.getPrivacyGateways()) {
                if (pg == null) continue;
                existingPrivacyGateways.add(pg.getGatewayName());
            }
            PrivacyGatewayMappingElement privacyGatewayMappingElement = new PrivacyGatewayMappingElement();
            privacyGatewayMappingElement.setPrivacyGatewayNames(existingPrivacyGateways);
            existingSyncPolicyElement.setPrivacyGatewayMappingElement(privacyGatewayMappingElement);
            for (String st : existingSyncPolicy.getEndpointUiPreferences()) {
                existingEndpointUri.add(st);
            }
            SyncPolicyDiffFinder syncPolicyDiffFinder = new SyncPolicyDiffFinder();
            BeanUtils.copyProperties((Object)existingSyncPolicy, (Object)existingSyncPolicyElement);
            String changedFields = syncPolicyDiffFinder.findDiff(existingSyncPolicyElement, syncPolicyElement);
            ObjectId id = existingSyncPolicy.getId();
            BeanUtils.copyProperties((Object)syncPolicy, (Object)existingSyncPolicy);
            existingSyncPolicy.setId(id);
            this.logger.debug("creating new sync policy:" + syncPolicy.getPolicyName());
            if (!CollectionUtils.isEmpty((Collection)syncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames())) {
                this.setPrivacyGateWayElements(cloudId, cloudName, existingSyncPolicy, syncPolicyElement.getPrivacyGatewayMappingElement());
            }
            existingSyncPolicy.setCloudCredentials(cloudCredentials);
            existingSyncPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
            existingSyncPolicy.setEndpointUiPreferences(new ArrayList(syncPolicyElement.getEndpointUiPreferences()));
            existingSyncPolicy.setInclusionFilter(filters);
            existingSyncPolicy.setSearchInclusionFilter(searchfilters);
            existingSyncPolicy.setGoogleAuth(syncPolicyElement.isGoogleAuth());
            existingSyncPolicy.setEnableAVScan(syncPolicyElement.isEnableAVScan());
            existingSyncPolicy.setShowShareLink(syncPolicyElement.isShowShareLink());
            existingSyncPolicy.setShareDomainType(syncPolicyElement.getShareDomainType());
            existingSyncPolicy.setShareDomainIncExclusions(new ArrayList(syncPolicyElement.getShareDomainIncExclusions()));
            this.syncPolicyDao.saveSyncPolicy(cloudId, cloudName, existingSyncPolicy);
            this.userDao.updateSyncPolicyModifiedTime(cloudId, userName);
            if (!StringUtils.isEmpty((Object)changedFields)) {
                this.saveStatisticToDatabase(cloudId, cloudName, " modified sync policy " + syncPolicyElement.getPolicygroupName() + ". The changed fields are " + changedFields, userName, "", PCActionTypes.SYNC_POLICY_UPDATE.getActionTypeValue());
            }
        } else {
            this.logger.debug("creating new sync policy:" + syncPolicy.getPolicyName());
            if (!syncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().isEmpty()) {
                this.setPrivacyGateWayElements(cloudId, cloudName, syncPolicy, syncPolicyElement.getPrivacyGatewayMappingElement());
            }
            syncPolicy.setCloudCredentials(cloudCredentials);
            this.syncPolicyDao.saveSyncPolicy(cloudId, cloudName, syncPolicy);
            this.saveStatisticToDatabase(cloudId, cloudName, "created sync policy", userName, syncPolicyElement.getPolicygroupName(), PCActionTypes.SYNC_POLICY_CREATE.getActionTypeValue());
        }
    }

    private ArrayList<InclusionFilter> getFiltersbyName(int cloudId, String cloudName, List<String> filterNames) {
        ArrayList<InclusionFilter> inclusionFilters = new ArrayList<InclusionFilter>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            inclusionFilters.add(inclusionFilter);
        }
        return inclusionFilters;
    }

    private List<InclusionFilterElement> getFilterElementbyName(int cloudId, String cloudName, List<String> filterNames, String filterType) {
        ArrayList<InclusionFilterElement> inclusionFilters = new ArrayList<InclusionFilterElement>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            InclusionFilterElement filterElement = new InclusionFilterElement();
            filterElement.setFilterName(inclusionFilter.getFilterName());
            filterElement.setFilterType(filterType);
            filterElement.setFilters(inclusionFilter.getExtensionName());
            inclusionFilters.add(filterElement);
        }
        return inclusionFilters;
    }

    private InclusionFilterElement getFilter(List<InclusionFilter> filters, String filterType) {
        InclusionFilterElement filterElement = new InclusionFilterElement();
        StringBuilder fileExtensions = new StringBuilder();
        InclusionFilter inclusionFilter = new InclusionFilter();
        inclusionFilter = filters.get(0);
        filterElement.setFilterName(inclusionFilter.getFilterName());
        filterElement.setFilterType(filterType);
        for (InclusionFilter filter : filters) {
            fileExtensions.append(filter.getExtensionName());
            fileExtensions.append(",");
        }
        filterElement.setFilters(fileExtensions.toString().replaceAll(",$", ""));
        return filterElement;
    }

    private List<InclusionFilterElement> getFilters(List<InclusionFilter> filters, String filterType) {
        ArrayList<InclusionFilterElement> filterElements = new ArrayList<InclusionFilterElement>();
        for (InclusionFilter filter : filters) {
            InclusionFilterElement filterElement = new InclusionFilterElement();
            StringBuilder fileExtensions = new StringBuilder();
            filterElement.setFilterName(filter.getFilterName());
            filterElement.setFilterType(filterType);
            fileExtensions.append(filter.getExtensionName());
            fileExtensions.append(",");
            filterElement.setFilters(fileExtensions.toString().replaceAll(",$", ""));
            filterElements.add(filterElement);
        }
        return filterElements;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        audit.setActionOnObject(actionOnUser);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    private void setPrivacyGateWayElements(int cloudId, String cloudName, SyncPolicy syncPolicy, PrivacyGatewayMappingElement privacyGatewayMappingElement) {
        List list = this.privacyGateWayDao.getAllGateways(cloudId);
        syncPolicy.setPrivacyGateways(new ArrayList());
        List<String> pgList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)privacyGatewayMappingElement.getPrivacyGatewayNames())) {
            for (PrivacyGateway pg : list) {
                pgList.add(pg.getGatewayName());
            }
        } else {
            pgList = privacyGatewayMappingElement.getPrivacyGatewayNames();
        }
        for (String pgname : pgList) {
            PrivacyGateway gateway = this.getPrivacyGateWay(list, pgname);
            syncPolicy.getPrivacyGateways().add(gateway);
        }
    }

    private PrivacyGateway getPrivacyGateWay(List<PrivacyGateway> pgList, String gateWayName) {
        PrivacyGateway privacyGateway = null;
        for (PrivacyGateway gateway : pgList) {
            if (!gateway.getGatewayName().equals(gateWayName)) continue;
            privacyGateway = gateway;
            break;
        }
        return privacyGateway;
    }

    @Override
    public List<SyncPolicyElement> getAllSyncPolicies(int cloudId, String cloudName) {
        List syncPolicyList = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
        ArrayList<SyncPolicyElement> elements = new ArrayList<SyncPolicyElement>();
        for (SyncPolicy syncPolicy : syncPolicyList) {
            SyncPolicyElement element = this.getSyncPolicyElement(cloudId, syncPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<SyncPolicyElement> getAllSyncPoliciesWithPagination(int cloudId, int pagNum) {
        List syncPolicyList = this.syncPolicyDao.getAllSyncPoliciesWithPagination(cloudId, pagNum);
        ArrayList<SyncPolicyElement> elements = new ArrayList<SyncPolicyElement>();
        for (SyncPolicy syncPolicy : syncPolicyList) {
            SyncPolicyElement element = this.getSyncPolicyElement(cloudId, syncPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public long getSyncPoliciesCount(int cloudId) {
        return this.syncPolicyDao.getSyncPoliciesCount(cloudId);
    }

    public SyncPolicyElement getSyncPolicyElement(int cloudId, SyncPolicy syncPolicy) {
        List searchFilterNames;
        List filters;
        List<String> filterNames;
        ArrayList<String> netWorkThrottlingNames = new ArrayList<String>();
        if (syncPolicy == null) {
            return null;
        }
        for (NetworkThrottling netWorkThrottling : syncPolicy.getNetworkThrottlings()) {
            netWorkThrottlingNames.add(netWorkThrottling.getNetworkThrottlingName());
        }
        SyncPolicyElement element = new SyncPolicyElement();
        BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
        element.setPolicygroupName(syncPolicy.getPolicyName());
        element.setNetworkThrottlingNames(new ArrayList());
        element.getNetworkThrottlingNames().addAll(netWorkThrottlingNames);
        ArrayList list = syncPolicy.getPrivacyGateways();
        PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
        if (element.getNwFromClientToPGMB() <= 0.0) {
            element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
        }
        if (!CollectionUtils.isEmpty(filterNames = (filters = syncPolicy.getInclusionFilter()).stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
            element.setFilterInclusionName(filterNames);
        }
        element.setInclusionFilterElement(this.getFilterElementbyName(cloudId, "", filterNames, syncPolicy.getFilterType()));
        ArrayList searchfilters = syncPolicy.getSearchInclusionFilter();
        if (!CollectionUtils.isEmpty((Collection)searchfilters) && !CollectionUtils.isEmpty(searchFilterNames = searchfilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
            element.setSearchFilterInclusionName(searchFilterNames);
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
        } else {
            element.setPrivacyGatewayMappingElement(mappingElement);
        }
        if (syncPolicy.getCloudCredentials() != null) {
            element.setCloudCredential(syncPolicy.getCloudCredentials().getIdentity());
        }
        element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
        element.setEndpointUiPreferences((List)syncPolicy.getEndpointUiPreferences());
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            element.setInclusionFilterElement(this.getFilters(filters, syncPolicy.getFilterType()));
        }
        return element;
    }

    @Override
    public SyncPolicyElement getSyncPolicy(int cloudId, String cloudName, String policyName) {
        SyncPolicy syncPolicy = this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, policyName);
        return this.getSyncPolicyElement(cloudId, syncPolicy);
    }

    @Override
    public Boolean isPolicyModified(int cloudId, String cloudName, String userName, long lastModifiedTimeVal) {
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null && !StringUtils.isEmpty((Object)user.getSyncPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getPolicyModifiedTime();
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
            if (syncPolicy != null && (policyModifiedTime = syncPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    @Override
    public BluSyncGroupSyncPolicyElement getBluSyncGroupSyncPolicyElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        Object pgelement;
        List filters;
        BluSyncGroupSyncPolicyElement element = new BluSyncGroupSyncPolicyElement();
        User user = this.userDao.getUserByName(cloudId, userName);
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
        BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
        element.setPolicygroupName(syncPolicy.getPolicyName());
        if (syncPolicy.getFileChunkableSize() != 0) {
            element.setFileChunkableSize(String.valueOf(syncPolicy.getFileChunkableSize()));
        }
        if (!CollectionUtils.isEmpty((Collection)(filters = syncPolicy.getInclusionFilter()))) {
            element.setInclusionFilterElement(this.getFilter(filters, syncPolicy.getFilterType()));
        }
        BSPrivacyGatewayMappingElement mappingElement = new BSPrivacyGatewayMappingElement();
        mappingElement.setBsPrivacyGatewayElementsList(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)syncPolicy.getPrivacyGateways())) {
            List privacygateways = this.privacyGateWayDao.getAllGateways(cloudId);
            for (PrivacyGateway childPrivacyGateway : privacygateways) {
                if (!StringUtils.isEmpty((Object)childPrivacyGateway.getProductType()) && !"blusync".equalsIgnoreCase(childPrivacyGateway.getProductType()) && !"both".equalsIgnoreCase(childPrivacyGateway.getProductType())) continue;
                pgelement = new BSPrivacyGatewayElement();
                mappingElement.setGatewayNwThrottlingName("GATEWAY");
                pgelement.setName(childPrivacyGateway.getGatewayName());
                pgelement.setType(childPrivacyGateway.getType());
                mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
            }
        } else {
            ArrayList defaultPGList = syncPolicy.getPrivacyGateways();
            for (PrivacyGateway gateway : defaultPGList) {
                mappingElement.setGatewayNwThrottlingName("GATEWAY");
                if (gateway == null) continue;
                pgelement = new BSPrivacyGatewayElement();
                pgelement.setName(gateway.getGatewayName());
                pgelement.setType(gateway.getType());
                mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
            }
        }
        element.setBSPrivacyGatewayMappingElement(mappingElement);
        List<NetworkThrottlingElement> networkThrottlingElements = this.getNetworkThrottlingElements(syncPolicy);
        element.setUiVersion(1);
        element.setNetworkThrottlingElements(networkThrottlingElements);
        element.setLastModifiedTimestamp(user.getSyncPolicyModifiedTime());
        element.setPolicyRefresh(syncPolicy.getPolicyRefresh());
        List ebmsMappingsList = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
        ArrayList<BluVaultMappingElement> ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
        if (!CollectionUtils.isEmpty((Collection)ebmsMappingsList)) {
            for (Object ebmsMapping : ebmsMappingsList) {
                BluVaultMappingElement ebmsMappingElement = new BluVaultMappingElement();
                BeanUtils.copyProperties((Object)ebmsMapping, (Object)ebmsMappingElement);
                ebmsMappingElements.add(ebmsMappingElement);
            }
            element.setBluVaultMappingElements(ebmsMappingElements);
        }
        element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
        ArrayList<EndpointUiPreferencesElement> uiPreferenceElements = new ArrayList<EndpointUiPreferencesElement>();
        if (!CollectionUtils.isEmpty((Collection)syncPolicy.getEndpointUiPreferences())) {
            for (String uiPreference : syncPolicy.getEndpointUiPreferences()) {
                EndpointUiPreferencesElement endpointUiPreferencesElement = new EndpointUiPreferencesElement();
                endpointUiPreferencesElement.setEndpointsUiPreferences(uiPreference);
                uiPreferenceElements.add(endpointUiPreferencesElement);
            }
        }
        element.setEndpointUiPreferencesElementList(uiPreferenceElements);
        ArrayList<EndpointUiDisabledPreferencesElement> uiDisabledPreferenceElements = new ArrayList<EndpointUiDisabledPreferencesElement>();
        if (!CollectionUtils.isEmpty((Collection)syncPolicy.getEndpointDisabledUiPreferences())) {
            for (String uiPreference : syncPolicy.getEndpointDisabledUiPreferences()) {
                EndpointUiDisabledPreferencesElement endpointUiPreferencesElement = new EndpointUiDisabledPreferencesElement();
                endpointUiPreferencesElement.setEndpointDisabledUiPreferences(uiPreference);
                uiDisabledPreferenceElements.add(endpointUiPreferencesElement);
            }
        }
        element.setEndpointUiDisabledPreferencesElementList(uiDisabledPreferenceElements);
        this.logger.debug(".....uiDisabledPreferenceElements...." + uiDisabledPreferenceElements.size());
        return element;
    }

    private List<NetworkThrottlingElement> getNetworkThrottlingElements(SyncPolicy syncPolicy) {
        ArrayList<NetworkThrottlingElement> networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
        ArrayList networkThrottlings = syncPolicy.getNetworkThrottlings();
        for (NetworkThrottling networkThrottling : networkThrottlings) {
            NetworkThrottlingElement networkThrottlingElement = new NetworkThrottlingElement();
            BeanUtils.copyProperties((Object)networkThrottling, (Object)networkThrottlingElement);
            networkThrottlingElement.setEndTime(networkThrottling.getEndTime());
            networkThrottlingElements.add(networkThrottlingElement);
        }
        return networkThrottlingElements;
    }

    @Override
    public List<String> getAllSyncPoliciyNames(int cloudId, String cloudName) {
        List syncPolicyList = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
        this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + syncPolicyList.size());
        return syncPolicyList.stream().filter(policy -> !StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(Policy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    @Override
    public long getSyncPoliciesCount(int cloudId, List<String> policyNames) {
        if (CollectionUtils.isEmpty(policyNames)) {
            return this.syncPolicyDao.getSyncPoliciesCount(cloudId);
        }
        return this.syncPolicyDao.getSyncPoliciesForPolicyNameCount(cloudId, policyNames);
    }

    @Override
    public List<SyncPolicyElement> getAllSyncPoliciesWithPagination(int cloudId, List<String> policyNames, int skipValue) {
        List syncPolicyList = this.syncPolicyDao.getAllSyncPoliciesWithPagination(cloudId, policyNames, skipValue);
        ArrayList<SyncPolicyElement> elements = new ArrayList<SyncPolicyElement>();
        for (SyncPolicy syncPolicy : syncPolicyList) {
            SyncPolicyElement element = this.getSyncPolicyElement(cloudId, syncPolicy);
            elements.add(element);
        }
        return elements;
    }
}

