/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.PrivacyGatewayService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.MSAppBluKryptElement;
import com.parablu.paracloud.element.MongoPropertiesElement;
import com.parablu.paracloud.element.PrivacyGatewayElement;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PrivacyGatewayController
extends BaseController {
    private static Logger logger = LogManager.getLogger(PrivacyGatewayController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private PrivacyGatewayService privacyGatewayService;
    private static final String EXCEPTION = "Exception ";
    @Autowired
    private AuditHistoryService auditHistoryService;

    @RequestMapping(value={"cloud/{cloudName}/gp/privacyGateway/load/all"}, method={RequestMethod.GET})
    public ModelAndView loadAllPrivacyGateway(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load privacyGatewayElements ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<PrivacyGatewayElement> privacyGatewayElements = this.privacyGatewayService.getAllGateways(cloudId);
            if (privacyGatewayElements == null) {
                privacyGatewayElements = new ArrayList<PrivacyGatewayElement>();
            }
            modelAndView.addObject(privacyGatewayElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load privacyGatewayElements ..." + (Object)((Object)e));
            logger.error("Error failed to load privacyGatewayElements ..." + e.getMessage());
        }
        logger.debug("end of calling load privacyGatewayElements ...");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/update/pg/"}, method={RequestMethod.POST})
    public void saveOrUpdatePG(HttpServletRequest request, HttpServletResponse response) {
        try {
            String gatewayName = request.getHeader("LOCAL_IP");
            logger.debug(" UPDATE PG ......." + gatewayName);
            int cloudId = 1;
            PrivacyGatewayElement element = new PrivacyGatewayElement();
            element.setGatewayName(gatewayName);
            this.privacyGatewayService.saveorUpdateGateway(cloudId, element);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/blukrypt/"}, method={RequestMethod.POST})
    public void saveOrUpdateBluKrypt(@PathVariable(value="cloudName") String cloudName, @RequestBody PrivacyGatewayElement privacyGatewayElement, HttpServletRequest request, HttpServletResponse response) {
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return;
            }
            boolean isGateWayNameExist = this.privacyGatewayService.isGateWayNameExist(cloudId, privacyGatewayElement.getGatewayName());
            boolean result = this.privacyGatewayService.saveorUpdateGateway(cloudId, privacyGatewayElement, cloudName);
            if (result) {
                response.setStatus(200);
                if (isGateWayNameExist) {
                    String status = "Disabled";
                    if (privacyGatewayElement.isActive()) {
                        status = "Enabled";
                    }
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edit a Watchdog status " + status + " for ", currentUser.getUserName(), privacyGatewayElement.getGatewayName(), "Portal", System.currentTimeMillis(), PCActionTypes.EDIT_BLUKRYPT.getActionTypeValue());
                } else {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "added a new blukrypt ip address ", currentUser.getUserName(), privacyGatewayElement.getGatewayName(), "Portal", System.currentTimeMillis(), PCActionTypes.ADD_BLUKRYPT.getActionTypeValue());
                }
                return;
            }
            response.setStatus(406);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/delete/blukrypt/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteBluKrypt(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String gatewayName = request.getHeader("gatewayName");
            logger.debug(StringUtils.isEmpty((String)gatewayName) + "Remove PG API ......." + gatewayName);
            if (!StringUtils.isEmpty((String)gatewayName)) {
                String token;
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    response.setStatus(400);
                    return modelAndView;
                }
                User currentUser = new User();
                int cloudId = cl.getCloud().getCloudId();
                if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                    return null;
                }
                List<String> mappedPolicies = this.privacyGatewayService.deleteGateway(cloudId, gatewayName);
                modelAndView.addObject(mappedPolicies);
                if (CollectionUtils.isEmpty(mappedPolicies)) {
                    response.setStatus(200);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted blukrypt ip address ", currentUser.getUserName(), gatewayName, "Portal", System.currentTimeMillis(), PCActionTypes.DELETE_BLUKRYPT.getActionTypeValue());
                    return modelAndView;
                }
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
        response.setStatus(406);
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/msappblukrypt/"}, method={RequestMethod.POST})
    public void saveOrUpdateODBluKrypt(@PathVariable(value="cloudName") String cloudName, @RequestBody MSAppBluKryptElement msAppBluKryptElement, HttpServletRequest request, HttpServletResponse response) {
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return;
            }
            boolean isGateWayNameExist = this.privacyGatewayService.isMSAppBluKryptExist(cloudId, msAppBluKryptElement.getHost());
            boolean result = this.privacyGatewayService.saveorUpdateMSAppBlukrypt(cloudId, msAppBluKryptElement, cloudName);
            if (result) {
                response.setStatus(200);
                if (isGateWayNameExist) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edit a ms app ip address ", currentUser.getUserName(), msAppBluKryptElement.getName(), "Portal", System.currentTimeMillis(), PCActionTypes.EDIT_BLUKRYPT.getActionTypeValue());
                } else {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "added a new blukrypt ip address ", currentUser.getUserName(), msAppBluKryptElement.getName(), "Portal", System.currentTimeMillis(), PCActionTypes.ADD_BLUKRYPT.getActionTypeValue());
                }
                return;
            }
            response.setStatus(406);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/load/msappblukrypt/"}, method={RequestMethod.GET})
    public ModelAndView loadMSAppBlukrypt(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load msappblukrypt ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return modelAndView;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return modelAndView;
            }
            List<MSAppBluKryptElement> privacyGatewayElements = this.privacyGatewayService.getAllMSAppBlukrypt(cloudId);
            if (privacyGatewayElements == null) {
                privacyGatewayElements = new ArrayList<MSAppBluKryptElement>();
            }
            modelAndView.addObject(privacyGatewayElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load msappblukrypt ..." + (Object)((Object)e));
            logger.error("Error failed to load msappblukrypt ..." + e.getMessage());
        }
        logger.debug("end of calling load msappblukrypt ...");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/delete/msappblukrypt/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteMSBluKrypt(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String gatewayName = request.getHeader("gatewayName");
            logger.debug(StringUtils.isEmpty((String)gatewayName) + "Remove msappblukrypt API ......." + gatewayName);
            if (!StringUtils.isEmpty((String)gatewayName)) {
                String token;
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    response.setStatus(400);
                    return modelAndView;
                }
                User currentUser = new User();
                int cloudId = cl.getCloud().getCloudId();
                if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                    return null;
                }
                List<String> mappedPolicies = this.privacyGatewayService.deleteMSBluKrypt(cloudId, gatewayName);
                modelAndView.addObject(mappedPolicies);
                if (CollectionUtils.isEmpty(mappedPolicies)) {
                    response.setStatus(200);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted msBlukrypt ip address ", currentUser.getUserName(), gatewayName, "Portal", System.currentTimeMillis(), PCActionTypes.DELETE_BLUKRYPT.getActionTypeValue());
                    return modelAndView;
                }
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
        response.setStatus(406);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/mongoProperties/load/all"}, method={RequestMethod.GET})
    public ModelAndView loadAllMongoProperties(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load loadAllMongoProperties ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            List<MongoPropertiesElement> mongoPropertiesElements = this.privacyGatewayService.getAllMongoProperties(cloudId);
            if (mongoPropertiesElements == null) {
                mongoPropertiesElements = new ArrayList<MongoPropertiesElement>();
            }
            modelAndView.addObject(mongoPropertiesElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to loadAllMongoProperties ..." + (Object)((Object)e));
            logger.error("Error failed to loadAllMongoProperties ..." + e.getMessage());
        }
        logger.debug("end of calling loadAllMongoProperties ...");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/mongoProperties/"}, method={RequestMethod.POST})
    public void saveOrUpdateMongoProperties(@PathVariable(value="cloudName") String cloudName, @RequestBody MongoPropertiesElement mongoPropertiesElement, HttpServletRequest request, HttpServletResponse response) {
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return;
            }
            this.privacyGatewayService.updateMongoProperties(cloudId, mongoPropertiesElement);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edit a Mongo properties ", currentUser.getUserName(), mongoPropertiesElement.getMongoIp(), "Portal", System.currentTimeMillis(), PCActionTypes.EDIT_BLUKRYPT.getActionTypeValue());
            response.setStatus(200);
            return;
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/serverDetails/"}, method={RequestMethod.POST})
    public void saveOrUpdateServerDetails(@PathVariable(value="cloudName") String cloudName, @RequestBody PrivacyGatewayElement serverDetailsElement, HttpServletRequest request, HttpServletResponse response) {
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.privacyGatewayService.saveorUpdateServerDetailsElement(cloudId, serverDetailsElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/save/serverDetails/"}, method={RequestMethod.GET})
    public ModelAndView getServerDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getServerDetails ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            String gatewayName = request.getHeader("gatewayName");
            int cloudId = cl.getCloud().getCloudId();
            PrivacyGatewayElement detailsElement = this.privacyGatewayService.getServerDetails(cloudId, gatewayName);
            if (detailsElement == null) {
                detailsElement = new PrivacyGatewayElement();
            }
            modelAndView.addObject((Object)detailsElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to loadAllMongoProperties ..." + (Object)((Object)e));
            logger.error("Error failed to loadAllMongoProperties ..." + e.getMessage());
        }
        logger.debug("end of calling getServerDetails ...");
        return modelAndView;
    }
}

