/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bp.service.InclusionFilterService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.FilterTemplateElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InclusionFilterController
extends BaseController {
    private static Logger logger = LogManager.getLogger(InclusionFilterController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private InclusionFilterService inclusionFilterService;
    private static final String ERROR_FAILED_TO_LOAD_INCLUSIONFILTER = "Error failed to load InclusionFilter ...";

    private static boolean checkSpecialCharacters(String checkStr) {
        boolean isSpecCharExists = false;
        if (StringUtils.isEmpty((CharSequence)checkStr)) {
            return false;
        }
        String specialCharactersString = "/([{}<>;:=]+)(*)/";
        for (int i = 0; i < checkStr.length(); ++i) {
            char ch = checkStr.charAt(i);
            if (specialCharactersString.contains(Character.toString(ch))) {
                return true;
            }
            if (i != checkStr.length() - 1) continue;
            isSpecCharExists = false;
        }
        return isSpecCharExists;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/inclusionfilter/save"}, method={RequestMethod.POST})
    public void saveInclusionFilter(@PathVariable(value="cloudName") String cloudName1, @RequestBody InclusionFilterElement inclusionFilterElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save InclusionFilter ...");
        try {
            String[] extensions;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return;
            }
            InclusionFilter inclusionFilter = new InclusionFilter();
            inclusionFilter.setFilterName(inclusionFilterElement.getFilterName());
            inclusionFilter.setExtensionName(inclusionFilterElement.getFilters());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (InclusionFilterController.checkSpecialCharacters(inclusionFilter.getFilterName())) {
                logger.error("...bad value for filter name..." + inclusionFilter.getFilterName());
                response.setStatus(400);
                return;
            }
            if (InclusionFilterController.checkSpecialCharacters(inclusionFilterElement.getFilterType())) {
                logger.error("...bad value for filter type..." + inclusionFilterElement.getFilterName());
                response.setStatus(400);
                return;
            }
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                if (!InclusionFilterController.checkSpecialCharacters(ext = ext.toLowerCase())) continue;
                logger.error("...bad value for extensions..." + ext);
                response.setStatus(400);
                return;
            }
            this.inclusionFilterService.saveInclusionFilter(cloudId, cloudName, inclusionFilter, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save InclusionFilter ..." + (Object)((Object)e));
            logger.error("Error failed to save InclusionFilter ..." + e.getMessage());
        }
        logger.debug("end of calling save InclusionFilter ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/inclusionfilter/save"}, method={RequestMethod.PUT})
    public void createInclusionFilter(@PathVariable(value="cloudName") String cloudName1, @RequestBody InclusionFilterElement inclusionFilterElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling save InclusionFilter ..." + inclusionFilterElement.getFilterType());
        try {
            String[] extensions;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return;
            }
            InclusionFilterElement inclusionFilterElement1 = this.inclusionFilterService.getInclusionFilter(cloudId, cloudName, inclusionFilterElement.getFilterName());
            if (inclusionFilterElement1 != null) {
                logger.debug("inclusionfilter Already exists----");
                response.setStatus(406);
                return;
            }
            InclusionFilter inclusionFilter = new InclusionFilter();
            inclusionFilter.setFilterName(inclusionFilterElement.getFilterName());
            inclusionFilter.setExtensionName(inclusionFilterElement.getFilters());
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (InclusionFilterController.checkSpecialCharacters(inclusionFilter.getFilterName())) {
                logger.error("...bad value for filter name..." + inclusionFilter.getFilterName());
                response.setStatus(400);
                return;
            }
            if (InclusionFilterController.checkSpecialCharacters(inclusionFilterElement.getFilterType())) {
                logger.error("...bad value for filter type..." + inclusionFilterElement.getFilterName());
                response.setStatus(400);
                return;
            }
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                if (!InclusionFilterController.checkSpecialCharacters(ext = ext.toLowerCase())) continue;
                logger.error("...bad value for extensions..." + ext);
                response.setStatus(400);
                return;
            }
            this.inclusionFilterService.saveInclusionFilter(cloudId, cloudName, inclusionFilter, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to save InclusionFilter ..." + (Object)((Object)e));
            logger.error("Error failed to save InclusionFilter ..." + e.getMessage());
        }
        logger.debug("end of calling save InclusionFilter ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/inclusionfilter/load/{filterName}/"}, method={RequestMethod.GET})
    public ModelAndView loadInclusionFilter(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="filterName") String filterName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling load InclusionFilter  ...");
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            InclusionFilterElement inclusionFilterElement = this.inclusionFilterService.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilterElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)inclusionFilterElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + e.getMessage());
        }
        logger.debug("end of loading inclusionFilterElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/filter/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteInclusionFilter(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling load InclusionFilter  ...");
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            User currentUser = new User();
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String filterName = request.getHeader("filterName");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            boolean deleted = this.inclusionFilterService.deleteInclusionFilter(cloudId, cloudName, filterName, currentUser.getUserName());
            if (!deleted) {
                response.setStatus(412);
                return null;
            }
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + e.getMessage());
        }
        logger.debug("end of loading inclusionFilterElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/inclusionfilter/load/all"}, method={RequestMethod.GET})
    public ModelAndView loadAllInclusionFilter(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load InclusionFilter ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<InclusionFilterElement> inclusionFilterElements = this.inclusionFilterService.getAllInclusionFilters(cloudId, cloudName);
            if (inclusionFilterElements == null) {
                inclusionFilterElements = new ArrayList<InclusionFilterElement>();
            }
            modelAndView.addObject(inclusionFilterElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + e.getMessage());
        }
        logger.debug("end of calling load InclusionFilter ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/filter/load/filters"}, method={RequestMethod.GET})
    public ModelAndView getFiltersByNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load InclusionFilter ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String filters = request.getHeader("filters");
            String[] items = filters.split(",");
            ArrayList<String> filtersList = new ArrayList<String>(Arrays.asList(items));
            List<InclusionFilterElement> inclusionFilterElements = this.inclusionFilterService.getInclusionFiltersByNames(cloudId, cloudName, filtersList);
            if (inclusionFilterElements == null) {
                inclusionFilterElements = new ArrayList<InclusionFilterElement>();
            }
            modelAndView.addObject(inclusionFilterElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + e.getMessage());
        }
        logger.debug("end of calling load InclusionFilter ...");
        return modelAndView;
    }

    public static Date convertStringToDate(String dateString) {
        Date date = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            date = df.parse(dateString);
            logger.debug("  converted date " + date.toString());
        }
        catch (Exception ex) {
            logger.debug("Exception .... " + ex);
        }
        return date;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/filterTemplets/load/all"}, method={RequestMethod.GET})
    public ModelAndView getFilterTemplets(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@@@@@Get All filterTemplets.......@@@@@");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<FilterTemplateElement> defaultFilterElementList = this.inclusionFilterService.getFilterTemplets(cloudId);
            if (defaultFilterElementList == null) {
                defaultFilterElementList = new ArrayList<FilterTemplateElement>();
            }
            modelAndView.addObject(defaultFilterElementList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
        }
        logger.debug("@@@@ End get all filterTemplets @@@@");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/gp/filter/load/filterTemplets"}, method={RequestMethod.GET})
    public ModelAndView getFilterTempletsByNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load filterTemplets ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String filters = request.getHeader("filters");
            String[] items = filters.split(",");
            ArrayList<String> filtersList = new ArrayList<String>(Arrays.asList(items));
            List<FilterTemplateElement> filterElements = this.inclusionFilterService.getFilterTempletsByName(cloudId, filtersList);
            if (filterElements == null) {
                filterElements = new ArrayList<FilterTemplateElement>();
            }
            modelAndView.addObject(filterElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_INCLUSIONFILTER + e.getMessage());
        }
        logger.debug("end of calling load filterTemplets ...");
        return modelAndView;
    }
}

