/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.sync.element.SyncOverviewElement;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupActivityHistoryResponse;
import com.parablu.paracloud.element.BackupBatchReportResponse;
import com.parablu.paracloud.element.BackupHistoryResponse;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.paracloud.element.BackupoverviewResponse;
import com.parablu.paracloud.element.CloudOverviewElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DailyUserBackupOverViewResponse;
import com.parablu.paracloud.element.DevicePolicyDetailsResponse;
import com.parablu.paracloud.element.NotificationElementList;
import com.parablu.paracloud.element.NotificationElementResponse;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.paracloud.element.ResponseElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.paracloud.element.RestoreHistoyResponse;
import com.parablu.paracloud.element.RestoreProgressEventsElement;
import com.parablu.paracloud.element.StorageInfoElement;
import com.parablu.paracloud.element.SyncOverviewListElement;
import com.parablu.paracloud.element.response.AuditHistoryResponse;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.report.service.ReportService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class GroupPolicyReportController
extends BaseController {
    private static Logger logger = LogManager.getLogger(GroupPolicyReportController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AlertHistoryService alertHistoryService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    @Autowired
    BackupService backupService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String USER_NAME = "userName";
    private static final String DEVICE_NAME = "deviceName";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String ERROR_FAILED_TO_LOAD_BACKUPPOLICY = "Error failed to load BackupPolicy ...";
    private static final String SKIP_VALUE = "skipValue";
    private static final String CALLING_LOAD_FAILED_JOB_NOTIFICATION_HISTORY = "calling load FailedJobNotificationHistory ... ";
    private static final String END_OF_LOADING_FAILED_JOB_NOTIFICATION_HISTORY = "end of loading FailedJobNotificationHistory ...";
    private static final String CALLING_LOAD_GET_CLOUD_OVERVIEW = "calling load getCloudOverview ... ";
    private static final String ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW = "Error failed to load getCloudOverview ...";
    private static final String END_OF_LOADING_GET_CLOUD_OVERVIEW = "end of loading getCloudOverview ...";
    private static final String INVALID_CLOUD_NAME = "Invalid cloud name ....";
    private static final String EXCEPTION = "Exception ";
    private static final String OVER_VIEW_JOB_TIME = "overViewJobTime";
    private static final String ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH = "Error failed to load report/sync/overview/search/ ...";
    private static final String ERROR_FAILED_TO_LOAD_REPORT_DAILY_BKPOVERVIEW_EXCEL = "Error failed to load report daily/bkpoverview/excel/ ...";
    private static final String DATES = " dates .........";
    private static final String ERROR_FAILED_TO_LOAD_BACKUP_HISTORY = "Error failed to load getNoBackupHistory ...";

    @RequestMapping(value={"cloud/{cloudName}/report/userinfo/backupHistory"}, method={RequestMethod.POST})
    public ModelAndView getUserInfoBackupHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfoBackupHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            ArrayList backupHistoryElements = this.reportService.getBackupHistoryElement(cloud, reportQueryElement);
            if (CollectionUtils.isEmpty((Collection)backupHistoryElements)) {
                backupHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)backupHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/userinfo/backupHistory/excel/"}, method={RequestMethod.POST})
    public void createExcelUserInfoBackupHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfoBackupHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean createExcelBkpHistory = this.reportService.createExcelBkpHistory(cloud, reportQueryElement);
            if (createExcelBkpHistory) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
    }

    private void checkIsReadOnlyAdminAndSetPolicies(ReportQueryElement reportQueryElement, String cloudName, int cloudId, User user) {
        if (user.isReadOnlyAdmin()) {
            logger.debug("....." + user.getBackupPoliciesAdmin());
            if (CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames()) && StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
                if (user.isBackupEnabled() && !CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    reportQueryElement.getPolicyNames().addAll(user.getBackupPoliciesAdmin());
                }
                if ((user.isOnedriveBkpEnabled() || user.isExchangeBkpEnabled()) && !CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    reportQueryElement.getPolicyNames().addAll(user.getOdbPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    reportQueryElement.getPolicyNames().addAll(user.getSyncPoliciesAdmin());
                }
            }
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/report/userinfo/deviceHistory"}, method={RequestMethod.GET})
    public ModelAndView getUserInfoDeviceHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfo DeviceHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String deviceName = request.getHeader(DEVICE_NAME);
            int skipValue = request.getIntHeader(SKIP_VALUE);
            logger.debug("calling load UserInfo DeviceHistory device name ..." + deviceName);
            ArrayList userDeviceHistoryElements = this.reportService.getDeviceHistoryElement(cloudId, cloudName, deviceName, skipValue);
            if (CollectionUtils.isEmpty((Collection)userDeviceHistoryElements)) {
                userDeviceHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)userDeviceHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of load UserInfo DeviceHistory  ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/userinfoHistory"}, method={RequestMethod.GET})
    public ModelAndView getUserInfoHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfo userinfoHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            int skipValue;
            String userName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            ArrayList userDeviceHistoryElements = this.reportService.getUserHistoryElement(cloudId, cloudName, userName = request.getHeader(USER_NAME), skipValue = request.getIntHeader(SKIP_VALUE));
            if (CollectionUtils.isEmpty((Collection)userDeviceHistoryElements)) {
                userDeviceHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)userDeviceHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of load UserInfo DeviceHistory  ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/userinfo/restoreHistory"}, method={RequestMethod.POST})
    public ModelAndView getUserInfoRestoreHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfo restoreHistory...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            ArrayList restoreHistoryElements = this.reportService.getRestoreHistoryElement(cloud, reportQueryElement);
            if (CollectionUtils.isEmpty((Collection)restoreHistoryElements)) {
                restoreHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)restoreHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
        }
        logger.debug("end of load UserInfo restoreHistory ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/userinfo/restoreHistory/Excel/"}, method={RequestMethod.POST})
    public void createUserInfoRestoreHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load UserInfo restoreHistory...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            logger.debug(user.isReadOnlyAdmin() + "......." + user.getUserName());
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean createRestoreHistoryElement = this.reportService.createRestoreHistoryElement(cloud, reportQueryElement);
            if (createRestoreHistoryElement) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
        }
        logger.debug("end of load UserInfo restoreHistory ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/report/longBkp/notifications"}, method={RequestMethod.GET})
    public ModelAndView getLongBackupNotificationHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_FAILED_JOB_NOTIFICATION_HISTORY);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            String startDate = request.getHeader(START_DATE);
            String endDate = request.getHeader(END_DATE);
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader(DEVICE_NAME);
            int skipValue = request.getIntHeader(SKIP_VALUE);
            int cloudId = cl.getCloud().getCloudId();
            NotificationElementList notificationHistoryElement = this.reportService.getLongBkpNotificationHistoryElement(cloudId, cloudName, startDate, endDate, userName, deviceName, skipValue);
            if (notificationHistoryElement == null) {
                notificationHistoryElement = new NotificationElementList();
            }
            modelAndView.addObject((Object)notificationHistoryElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug(END_OF_LOADING_FAILED_JOB_NOTIFICATION_HISTORY);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/currentBkp/notifications"}, method={RequestMethod.GET})
    public ModelAndView getCurrentBkpNotificationHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load currentBkp notifications ... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            String startDate = request.getHeader(START_DATE);
            String endDate = request.getHeader(END_DATE);
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader(DEVICE_NAME);
            int skipValue = request.getIntHeader(SKIP_VALUE);
            int cloudId = cl.getCloud().getCloudId();
            NotificationElementList notificationHistoryElement = this.reportService.getCurrentBkpNotificationHistoryElement(cloudId, cloudName, startDate, endDate, userName, deviceName, skipValue);
            if (notificationHistoryElement == null) {
                notificationHistoryElement = new NotificationElementList();
            }
            modelAndView.addObject((Object)notificationHistoryElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
        }
        logger.debug("end of load currentBkp notifications ... ");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/failedJob/notifications"}, method={RequestMethod.POST})
    public ModelAndView getFailedJobNotificationHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_FAILED_JOB_NOTIFICATION_HISTORY);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            NotificationElementList notificationHistoryElement = this.reportService.getFailedNotificationHistoryElement(cl.getCloud(), reportQueryElement);
            if (notificationHistoryElement == null) {
                notificationHistoryElement = new NotificationElementList();
            }
            modelAndView.addObject((Object)notificationHistoryElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug(END_OF_LOADING_FAILED_JOB_NOTIFICATION_HISTORY);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/failedJob/notifications/Excel/"}, method={RequestMethod.POST})
    public void createFailedJobNotificationHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_FAILED_JOB_NOTIFICATION_HISTORY);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean createFailedNotificationHistoryElement = this.reportService.createFailedNotificationHistoryElement(cl.getCloud(), reportQueryElement);
            if (createFailedNotificationHistoryElement) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug(END_OF_LOADING_FAILED_JOB_NOTIFICATION_HISTORY);
    }

    @RequestMapping(value={"cloud/{cloudName}/report/cloud/overview"}, method={RequestMethod.GET})
    public ModelAndView getCloudOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_GET_CLOUD_OVERVIEW);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            try {
                cloudOverviewElement = this.reportService.getCloudOverviewElement(cl.getCloud(), cloudName);
                cloudOverviewElement.setCloudValidityUntil(cl.getCloud().getValidityPeriod());
                String formatedTotalUsers = "";
                NumberFormat myFormat = NumberFormat.getInstance();
                myFormat.setGroupingUsed(true);
                formatedTotalUsers = myFormat.format(cl.getCloud().getNoOfBackupUsersAllowed());
                logger.debug(".....formatedTotalUsers...." + formatedTotalUsers);
                cloudOverviewElement.setNoOfBackupUsersAllowed(formatedTotalUsers);
            }
            catch (Exception e) {
                logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e);
                logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
            }
            modelAndView.addObject((Object)cloudOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
        }
        logger.debug(END_OF_LOADING_GET_CLOUD_OVERVIEW);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/cloud/size/overview"}, method={RequestMethod.GET})
    public ModelAndView getCloudOverviewForSize(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_GET_CLOUD_OVERVIEW);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            try {
                cloudOverviewElement = this.reportService.getCloudOverviewElementForSize(cloudId, cloudName);
            }
            catch (Exception e) {
                logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e);
                logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
            }
            modelAndView.addObject((Object)cloudOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
        }
        logger.debug(END_OF_LOADING_GET_CLOUD_OVERVIEW);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/storageused"}, method={RequestMethod.GET})
    public ModelAndView getStorageUsed(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(CALLING_LOAD_GET_CLOUD_OVERVIEW);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            int skipValue;
            String deviceName;
            String userName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            ArrayList elements = this.reportService.getStorageInfoElements(cloudId, cloudName, userName = request.getHeader(USER_NAME), deviceName = request.getHeader(DEVICE_NAME), skipValue = request.getIntHeader(SKIP_VALUE));
            if (CollectionUtils.isEmpty((Collection)elements)) {
                elements = new ArrayList();
            } else {
                for (StorageInfoElement element : elements) {
                    element.setTotalStorage(cl.getCloud().getCloudSizeAllowed() / 1024 + " GB");
                }
            }
            modelAndView.addObject(elements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
        }
        logger.debug(END_OF_LOADING_GET_CLOUD_OVERVIEW);
        return modelAndView;
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static String avgStoragePerUser(long size, Long noOfUsers) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            double avgSize = t / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" TB");
        } else if (g > 1.0) {
            double avgSize = g / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" GB");
        } else {
            double avgSize = m / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" MB");
        }
        return hrSize;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/backup/week/"}, method={RequestMethod.GET})
    public ModelAndView getNotificationHistoryElement(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load NotificationHistoryElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            ArrayList notificationHistoryElements = this.reportService.getFailedNotificationHistoryElement(cloudId, cloudName);
            if (CollectionUtils.isEmpty((Collection)notificationHistoryElements)) {
                notificationHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)notificationHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/restore/info"}, method={RequestMethod.GET})
    public ModelAndView getUserInfoRestoreHistoryElement(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getUserInfoRestoreHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setUserName(request.getHeader(USER_NAME));
            reportQueryElement.setDeviceName(request.getHeader(DEVICE_NAME));
            reportQueryElement.setStartDate(request.getHeader(START_DATE));
            reportQueryElement.setEndDate(request.getHeader(END_DATE));
            reportQueryElement.setSkipValue(0);
            ArrayList restoreHistoryElements = this.reportService.getRestoreHistoryElement(cl.getCloud(), reportQueryElement);
            if (CollectionUtils.isEmpty((Collection)restoreHistoryElements)) {
                restoreHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)restoreHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load getUserInfoRestoreHistory ..." + (Object)((Object)e));
            logger.error("Error failed to load getUserInfoRestoreHistory ..." + e.getMessage());
        }
        logger.debug("end of loading getUserInfoRestoreHistory ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/lastBackup"}, method={RequestMethod.GET})
    public ModelAndView getLastBackupHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getLastBackupHistory ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader(DEVICE_NAME);
            logger.debug(deviceName + "calling load getLastBackupHistory username ..." + userName);
            ArrayList backupHistoryElements = this.reportService.getLastBackupReport(cloudId, cloudName, userName, deviceName);
            if (CollectionUtils.isEmpty((Collection)backupHistoryElements)) {
                backupHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)backupHistoryElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to load getLastBackupHistory ..." + e);
            logger.error("Error failed to load getLastBackupHistory ..." + e.getMessage());
        }
        logger.debug("end of loading getLastBackupHistory ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/noBackup"}, method={RequestMethod.POST})
    public ModelAndView getNoBackupHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = null;
        String systemBased = "true";
        logger.debug("calling load getNoBackupHistory ...");
        response.setStatus(200);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            systemBased = request.getHeader("system-based");
            if (org.springframework.util.StringUtils.isEmpty((Object)systemBased)) {
                systemBased = "true";
            }
            boolean systemNotProtected = Boolean.parseBoolean(systemBased);
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return null;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            ArrayList backupHistoryElements = this.reportService.getNoBackup(cl.getCloud(), cloudName, reportQueryElement, productType, systemNotProtected);
            if (CollectionUtils.isEmpty((Collection)backupHistoryElements)) {
                backupHistoryElements = new ArrayList();
                logger.debug("... no records ... ");
                response.setStatus(204);
            } else {
                response.setStatus(200);
            }
            modelAndView.addObject(backupHistoryElements);
        }
        catch (Exception e) {
            logger.debug("... exception inside no backup...." + e.getMessage());
            response.setStatus(500);
            logger.trace("" + e);
            logger.error(ERROR_FAILED_TO_LOAD_BACKUP_HISTORY + e.getMessage());
        }
        logger.debug("end of loading getNoBackupHistory ..." + response.getStatus());
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/noBackup/excel/"}, method={RequestMethod.POST})
    public void createExcelNoBackup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody ReportQueryElement reportQueryElement) {
        String cloudName = cloudName1;
        String productType = null;
        String systemBased = "";
        logger.debug("calling load create NoBackupHistory ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            systemBased = request.getHeader("system-based");
            if (org.springframework.util.StringUtils.isEmpty((Object)systemBased)) {
                systemBased = "true";
            }
            boolean systemNotProtected = Boolean.parseBoolean(systemBased);
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean excelGenerated = this.reportService.createExcelForNoBackup(cl.getCloud(), cloudName, reportQueryElement, productType, systemNotProtected);
            if (excelGenerated) {
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
            logger.debug(excelGenerated + "...excel generated... " + response.getStatus());
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUP_HISTORY + e);
            logger.error(ERROR_FAILED_TO_LOAD_BACKUP_HISTORY + e.getMessage());
        }
        logger.debug("end of loading getNoBackupHistory ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/report/adReports"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAdReportsHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestParam(value="pageNumber") Integer pageNumberInteger, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load userMigratedElements ..." + pageNumberInteger);
        response.setStatus(200);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            ArrayList userMigratedElements;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            int pageNumber = pageNumberInteger;
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            if (CollectionUtils.isEmpty((Collection)(userMigratedElements = this.reportService.getAllMigratedUsers(cloudId, pagNum)))) {
                userMigratedElements = new ArrayList();
            }
            modelAndView.addObject((Object)userMigratedElements);
            response.setStatus(200);
            long totalRecordsCount = this.reportService.countAllMigratedUsers(cloudId);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug(pagNum + "end of loading adReports ..." + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(PCHelperConstant.getReportDisplayRecords(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), userMigratedElements);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to load userMigratedElements ..." + e);
            logger.error("Error failed to load userMigratedElements ..." + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/report/alertHistory"}, method={RequestMethod.GET})
    public ModelAndView getAlertHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load AlertHistoryElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String endDate;
            String startDate;
            String deviceName;
            String userName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            ArrayList alertHistoryElements = this.alertHistoryService.getAllAlertHistoryForJobType(cloudId, cloudName, userName = request.getHeader(USER_NAME), deviceName = request.getHeader(DEVICE_NAME), startDate = request.getHeader(START_DATE), endDate = request.getHeader(END_DATE));
            if (CollectionUtils.isEmpty((Collection)alertHistoryElements)) {
                alertHistoryElements = new ArrayList();
            }
            modelAndView.addObject((Object)alertHistoryElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load AlertHistoryElement ..." + (Object)((Object)e));
            logger.error("Error failed to load AlertHistoryElement ..." + e.getMessage());
        }
        logger.debug("end of loading AlertHistoryElement ...");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/load/statistics/"}, method={RequestMethod.GET})
    public ModelAndView loadStatistics(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        String userName = request.getHeader(USER_NAME);
        String deviceName = request.getHeader(DEVICE_NAME);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        List statisticsElementList = new ArrayList();
        try {
            statisticsElementList = this.backupService.getStatistics(cloudId, cloudName, userName, deviceName);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        modelAndView.addObject(statisticsElementList);
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/overviewReport/"}, method={RequestMethod.GET})
    public ModelAndView overView(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        String userName = request.getHeader(USER_NAME);
        int skipValue = request.getIntHeader(SKIP_VALUE);
        logger.debug("Inside overview report api ..." + userName);
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        List backupOverviewElementList = new ArrayList();
        try {
            backupOverviewElementList = this.reportService.getAllBackupOverviewElements(cloudId, cloudName, userName, skipValue);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        modelAndView.addObject(backupOverviewElementList);
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/overviewReport/all/"}, method={RequestMethod.GET})
    public ModelAndView backupOverViewReportForAll(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        int skipValue = request.getIntHeader(SKIP_VALUE);
        logger.debug("Inside backup OverViewReport For All api ...");
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        List backupOverviewElementList = new ArrayList();
        try {
            backupOverviewElementList = this.reportService.getAllBackupOverviewElements(cl.getCloud(), skipValue, false);
            if (!CollectionUtils.isEmpty(backupOverviewElementList)) {
                BackupOverviewElement element = (BackupOverviewElement)backupOverviewElementList.get(0);
                if (element != null) {
                    response.setHeader(OVER_VIEW_JOB_TIME, element.getOverviewJobTime());
                }
            } else {
                response.setHeader(OVER_VIEW_JOB_TIME, String.valueOf(System.currentTimeMillis()));
            }
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        modelAndView.addObject(backupOverviewElementList);
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/overviewReport/excel/"}, method={RequestMethod.GET})
    public ModelAndView backupOverViewReportForExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        int skipValue = request.getIntHeader(SKIP_VALUE);
        logger.debug("Inside backup OverViewReport For All excel  api ...");
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        List backupOverviewElementList = new ArrayList();
        try {
            backupOverviewElementList = this.reportService.getAllBackupOverviewElements(cl.getCloud(), skipValue, true);
            if (!CollectionUtils.isEmpty(backupOverviewElementList)) {
                BackupOverviewElement element = (BackupOverviewElement)backupOverviewElementList.get(0);
                if (element != null) {
                    response.setHeader(OVER_VIEW_JOB_TIME, element.getOverviewJobTime());
                }
            } else {
                response.setHeader(OVER_VIEW_JOB_TIME, String.valueOf(System.currentTimeMillis()));
            }
            modelAndView.addObject(backupOverviewElementList);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }

    void writeExcel(HSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/ExcelSheet.xls"));){
            HSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelFile(List<List> l1, HSSFWorkbook workbook) throws Exception {
        HSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                HSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    HSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont(font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/overview/createExcel/"}, method={RequestMethod.POST})
    public void createExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = null;
        logger.debug("calling createExcel ... ");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportCreated = this.reportService.createExcelForBackupOverview(cl.getCloud(), reportQueryElement, productType);
            if (isReportCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/syncoverview/createExcel/"}, method={RequestMethod.GET})
    public void syncOverviewcreateExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling syncOverviewcreateExcel ... ");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            this.reportService.createExcelForSyncOverview(cl.getCloud().getCloudId());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/report/cloud/overview/serverbackup"}, method={RequestMethod.GET})
    public ModelAndView getCloudOverviewForServerBackup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("ModelAndView getCloudOverviewForServerBackup(@PathVariable(cloudName) String cloudName HttpServletRequest request, HttpServletResponse response)");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            try {
                cloudOverviewElement = this.reportService.getCloudOverviewElementForServerBackup(cloudId, cloudName);
            }
            catch (Exception e) {
                logger.trace("Error failed to load getCloudOverview for serverbackup ..." + e);
                logger.error("Error failed to load getCloudOverview for serverbackup ..." + e.getMessage());
            }
            modelAndView.addObject((Object)cloudOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load getCloudOverview for serverbackup..." + (Object)((Object)e));
            logger.error("Error failed to load getCloudOverview for serverbackup..." + e.getMessage());
        }
        logger.debug("end of loading getCloudOverview for serverbackup...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/sync/overview"}, method={RequestMethod.GET})
    public ModelAndView getSyncOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getSyncOverview ... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
            try {
                syncOverviewElement = this.reportService.getSyncOverview(cloudId, cl.getCloud());
            }
            catch (Exception e) {
                logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e);
                logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
            }
            modelAndView.addObject((Object)syncOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_GET_CLOUD_OVERVIEW + e.getMessage());
        }
        logger.debug("end of loading getSyncOverview ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/sync/overview/search/"}, method={RequestMethod.GET})
    public ModelAndView getSyncOverviewList(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load report/sync/overview/search/ ... ");
        ModelAndView modelAndView = new ModelAndView();
        String startDate = request.getHeader(START_DATE);
        String endDate = request.getHeader(END_DATE);
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            logger.debug(startDate + DATES + endDate);
            SyncOverviewListElement syncOverviewListElement = new SyncOverviewListElement();
            List fileElementList = new ArrayList();
            try {
                fileElementList = this.reportService.getSyncOverview(cloudId, cl.getCloud(), startDate, endDate);
                syncOverviewListElement.setFileElementList(new ArrayList());
                syncOverviewListElement.setFileElementList(fileElementList);
            }
            catch (Exception e) {
                logger.trace(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e);
                logger.error(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e.getMessage());
            }
            modelAndView.addObject((Object)syncOverviewListElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e.getMessage());
        }
        logger.debug("end of loading report/sync/overview/search/ ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/sync/overview/excel/"}, method={RequestMethod.GET})
    public void getSyncOverviewExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        block6: {
            String cloudName = cloudName1;
            logger.debug("calling load report/sync/overview/excel/ ... ");
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName("jsonview");
            try {
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    response.setStatus(400);
                    return;
                }
                int cloudId = cl.getCloud().getCloudId();
                String startDate = request.getHeader(START_DATE);
                String endDate = request.getHeader(END_DATE);
                logger.debug(startDate + DATES + endDate);
                try {
                    boolean excelGenerated = this.reportService.createExcelForSyncOverview(cloudId, cl.getCloud(), startDate, endDate);
                    if (excelGenerated) {
                        response.setStatus(200);
                        break block6;
                    }
                    response.setStatus(500);
                }
                catch (Exception e) {
                    logger.trace(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e);
                    logger.error(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e.getMessage());
                    response.setStatus(500);
                }
            }
            catch (BaseException e) {
                response.setStatus(500);
                logger.trace("" + (Object)((Object)e));
                logger.error("Error failed to load report/sync/overview/excel/ ..." + e.getMessage());
            }
        }
        logger.debug("end of loading report/sync/overview/excel/ ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/report/daily/bkpoverview/"}, method={RequestMethod.POST})
    public ModelAndView getDailyBkpOverviewList(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load cloud/{cloudName}/report/daily/bkpoverview/... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            List dailyUserBackupOverViewList = new ArrayList();
            dailyUserBackupOverViewList = this.reportService.getDailyUserBackupOverview(cl.getCloud(), reportQueryElement);
            if (PCHelperConstant.isHideStorageSizeInCloud()) {
                response.setHeader("hideStorageSizeInCloud", "true");
            } else {
                response.setHeader("hideStorageSizeInCloud", "false");
            }
            modelAndView.addObject(dailyUserBackupOverViewList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(204);
            logger.trace(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_REPORT_SYNC_OVERVIEW_SEARCH + e.getMessage());
        }
        logger.debug("end of loading report cloud/{cloudName}/report/daily/bkpoverview/ ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/daily/bkpoverview/excel/"}, method={RequestMethod.POST})
    public void getUserDailyBkpOverviewExcel(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        block7: {
            String cloudName = cloudName1;
            logger.debug("calling load report daily/bkpoverview/excel/... ");
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName("jsonview");
            try {
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    response.setStatus(400);
                    return;
                }
                try {
                    int cloudId = cl.getCloud().getCloudId();
                    CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
                    String token = request.getHeader("token");
                    User user = new User();
                    if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                        return;
                    }
                    this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
                    boolean excelGenerated = this.reportService.createExcelForDailyBkpOverview(cl.getCloud(), reportQueryElement, cloudPropertyElement.isShowLatestBkpInfo(), cloudPropertyElement.isHideCompressedSize());
                    if (excelGenerated) {
                        response.setStatus(200);
                        break block7;
                    }
                    response.setStatus(204);
                }
                catch (Exception e) {
                    response.setStatus(204);
                    logger.trace(ERROR_FAILED_TO_LOAD_REPORT_DAILY_BKPOVERVIEW_EXCEL + e);
                    logger.error(ERROR_FAILED_TO_LOAD_REPORT_DAILY_BKPOVERVIEW_EXCEL + e.getMessage());
                }
            }
            catch (BaseException e) {
                response.setStatus(500);
                logger.trace(ERROR_FAILED_TO_LOAD_REPORT_DAILY_BKPOVERVIEW_EXCEL + (Object)((Object)e));
                logger.error(ERROR_FAILED_TO_LOAD_REPORT_DAILY_BKPOVERVIEW_EXCEL + e.getMessage());
            }
        }
        logger.debug("end of loading report daily/bkpoverview/excel/ ...");
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/user/overviewReport/"}, method={RequestMethod.POST})
    public ModelAndView overViewForUserNDevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("inside backup user overview report");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        Cloud cloud = cl.getCloud();
        cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return null;
        }
        boolean isODBBackupEnabled = GroupPolicyReportController.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        boolean exchangeBackupEnabled = GroupPolicyReportController.isExchangeBackupEnabled(cloud.getCloudCustomisableDetails());
        this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
        List backupOverviewElementList = new ArrayList();
        try {
            backupOverviewElementList = this.reportService.getAllBackupOverviewElementsByQuery(cloud, reportQueryElement, isODBBackupEnabled || exchangeBackupEnabled, reportQueryElement.getSkipValue());
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        modelAndView.addObject(backupOverviewElementList);
        return modelAndView;
    }

    private static boolean isODBBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private static boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExchangeBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Exchange Backup Enabled".equals(customisableDetails.getName())) continue;
            isExchangeBackupEnabled = true;
            break;
        }
        return isExchangeBackupEnabled;
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/report/lastAgentServerConnectionDetails/"}, method={RequestMethod.POST})
    public ModelAndView createExcelForAgentToServerConnection(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("inside /report/lastAgentServerConnectionDetails/  api's");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return null;
        }
        this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
        List devicePolicyDetailsList = new ArrayList();
        try {
            devicePolicyDetailsList = this.reportService.getLastAgentServerConnectionDetails(cl.getCloud(), reportQueryElement);
            response.setStatus(200);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        modelAndView.addObject(devicePolicyDetailsList);
        return modelAndView;
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/report/lastAgentServerConnectionDetails/excel/"}, method={RequestMethod.POST})
    public void createExcelForAgentToServerConnectionExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        int cloudId;
        String cloudName = cloudName1;
        logger.debug("inside /report/lastAgentServerConnectionDetails/excel/  generate excel api's");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
        }
        if (!this.performAuthorization(cloudId = cl.getCloud().getCloudId(), cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return;
        }
        this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
        try {
            if (this.reportService.generateReportForAgentLastServerConection(cl.getCloud(), reportQueryElement)) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/{clouds}/{cloudName}/support/installedVersion"}, method={RequestMethod.GET})
    public ModelAndView getParabluInstalledVersion(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        User user;
        String token;
        String cloudName = cloudName1;
        logger.debug("Fetching parablu installed version-------");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return null;
        }
        try {
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            String installedVersion = Files.lines(Paths.get(cloudPropertyElement.getMntParacloudPath() + "installed_version", new String[0])).findFirst().orElse("<N/A>");
            ResponseElement parabluInstalledResponse = new ResponseElement();
            parabluInstalledResponse.setParabluInstalledVerion(installedVersion);
            parabluInstalledResponse.setCloudValidityUntil(cl.getCloud().getValidityPeriod());
            parabluInstalledResponse.setCurrentLicenseKey(cl.getCloud().getLicenseKeyFileName());
            modelAndView.addObject((Object)parabluInstalledResponse);
            response.setStatus(200);
        }
        catch (IOException e) {
            logger.trace("Exception" + e);
            logger.error("error failed to get server version");
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/overview/createExcelForScripts/"}, method={RequestMethod.POST})
    public void createExcelForScripts(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = null;
        logger.debug("calling createExcel ... ");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setIsUserWithoutDeviceEnabled(true);
            reportQueryElement.setShowBlockedDevices(true);
            boolean isReportCreated = this.reportService.createExcelForBackupOverview(cl.getCloud(), reportQueryElement, productType);
            if (isReportCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/report/cloud/odb/overview"}, method={RequestMethod.GET})
    public ModelAndView getOdbCloudOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getOdbCloudOverview ... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            try {
                cloudOverviewElement = this.reportService.getOdbCloudOverviewElement(cl.getCloud(), cloudName);
                cloudOverviewElement.setCloudValidityUntil(cl.getCloud().getValidityPeriod());
                cloudOverviewElement.setNoOfOdbBackupUsersAllowed(this.getFormattedValue(cl.getCloud().getNoOfOneDriveUsersAllowed() + cl.getCloud().getNoOfExchangeUsersAllowed()));
                logger.debug("....cloudOverviewElement..." + cloudOverviewElement.getNoOfUsersProtected());
            }
            catch (Exception e) {
                logger.trace("...Error failed to load getOdbCloudOverview ..." + e);
                logger.error("...Error failed to load getOdbCloudOverview ..." + e.getMessage());
            }
            modelAndView.addObject((Object)cloudOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("...Error failed to load getOdbCloudOverview ..." + (Object)((Object)e));
            logger.error("...Error failed to load getOdbCloudOverview ..." + e.getMessage());
        }
        logger.debug("... end of calling load getOdbCloudOverview ... ");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/report/cloud/backup/summary"}, method={RequestMethod.GET})
    public ModelAndView getBackupSummary(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getOdbCloudOverview ... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            try {
                cloudOverviewElement = this.reportService.getOdbCloudOverviewElement(cl.getCloud(), cloudName);
                cloudOverviewElement.setCloudValidityUntil(cl.getCloud().getValidityPeriod());
                cloudOverviewElement.setNoOfOdbBackupUsersAllowed(this.getFormattedValue(cl.getCloud().getNoOfOneDriveUsersAllowed() + cl.getCloud().getNoOfExchangeUsersAllowed()));
            }
            catch (Exception e) {
                logger.trace("...Error failed to load getOdbCloudOverview ..." + e);
                logger.error("...Error failed to load getOdbCloudOverview ..." + e.getMessage());
            }
            modelAndView.addObject((Object)cloudOverviewElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("...Error failed to load getOdbCloudOverview ..." + (Object)((Object)e));
            logger.error("...Error failed to load getOdbCloudOverview ..." + e.getMessage());
        }
        logger.debug("... end of calling load getOdbCloudOverview ... ");
        return modelAndView;
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/report/backupSummary/"}, method={RequestMethod.POST})
    public ModelAndView getBackupSummary(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = null;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("inside /report/backupSummary/  api's");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        String inernalCall = request.getHeader("Internal-Call");
        User user = new User();
        if (org.springframework.util.StringUtils.isEmpty((Object)inernalCall) && !this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        try {
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            CloudOverviewElement getCloudOverViewElement = this.reportService.getBackupSummary(cl.getCloud(), reportQueryElement, productType);
            response.setStatus(200);
            modelAndView.addObject((Object)getCloudOverViewElement);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/report/backupSummary/excel/"}, method={RequestMethod.POST})
    public void createExcelBackupSummary(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        int cloudId;
        String cloudName = cloudName1;
        String productType = request.getHeader("productType");
        logger.debug("inside /report/backupSummary/excel/  generate excel api's...." + productType);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
        }
        if (!this.performAuthorization(cloudId = cl.getCloud().getCloudId(), cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return;
        }
        try {
            if (this.reportService.createExcelBackupSummary(cl.getCloud(), reportQueryElement, productType)) {
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/userinfo/backupHistory/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForBkpHistoryReport(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@@@@@@@@create pdf for bkp History report@@@@@@@@");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportPdfCreated = this.reportService.createPdfForBackupHistory(reportQueryElement, cl.getCloud());
            if (isReportPdfCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/overview/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForBkpOverViewReport(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = null;
        logger.debug("@@@@@@@@@create pdf for bkp overview report@@@@@@@@");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportCreated = this.reportService.createPdfForBackupOverview(reportQueryElement, cl.getCloud(), productType);
            if (isReportCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/noBackup/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForNoBkpHistoryReport(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        String systemBased = "";
        logger.debug("@@@@@@@@@create pdf for No bkp History report@@@@@@@@");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            systemBased = request.getHeader("system-based");
            if (org.springframework.util.StringUtils.isEmpty((Object)systemBased)) {
                systemBased = "true";
            }
            boolean systemNotProtected = Boolean.parseBoolean(systemBased);
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            String productType = null;
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportPdfCreated = this.reportService.createPdfForNoBackupHistory(reportQueryElement, cl.getCloud(), productType, systemNotProtected);
            if (isReportPdfCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/daily/bkpoverview/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForUserDailyBkpOverviewReport(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@@@@@@@@create pdf for user daily bkp overview report@@@@@@@@");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            String token = request.getHeader("token");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportPdfCreated = this.reportService.createPdfForUserDailyBkpOverviewReport(reportQueryElement, cloudId, cloudPropertyElement.isShowLatestBkpInfo(), cloudPropertyElement.isHideCompressedSize());
            if (isReportPdfCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/report/lastAgentServerConnectionDetails/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForAgentToServerConnectionReport(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        int cloudId;
        String cloudName = cloudName1;
        logger.debug("@@@@@@@@@create pdf for last Agent Server Connection Details  report@@@@@@@@");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
        }
        if (!this.performAuthorization(cloudId = cl.getCloud().getCloudId(), cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return;
        }
        String productType = null;
        this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
        try {
            if (this.reportService.createPdfForAgentToServerConnectionReport(cl.getCloud(), reportQueryElement, productType)) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception ex) {
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/report/userinfo/restoreHistory/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForUserInfoRestoreHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("@@@@@@@@@create pdf for last restore History report@@@@@@@@");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportPdfCreated = this.reportService.createPdfForUserInfoRestoreHistory(cl.getCloud(), reportQueryElement);
            if (isReportPdfCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + e.getMessage());
            logger.error(EXCEPTION + (Object)((Object)e));
        }
    }

    @RequestMapping(value={"/versions/{versionNumber}/clouds/{cloudName}/report/failedJob/notifications/createPdf/"}, method={RequestMethod.POST})
    public void createPdfForFailedJobNotificationHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("generating pdf for failed backup files");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            boolean isReportPdfCreated = this.reportService.createPdfForFailedJobNotificationHistory(cloudId, reportQueryElement);
            if (isReportPdfCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + (Object)((Object)e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug(" end of generating pdf Fof failed backup files");
    }

    @RequestMapping(value={"/versions/{versionnumber}/clouds/{cloudName}/report/backupSummary/createPdf/"}, method={RequestMethod.POST})
    public void createPDFBackupSummary(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response) {
        User user;
        String token;
        int cloudId;
        String cloudName = cloudName1;
        String productType = request.getHeader("productType");
        logger.debug("inside /report/backupSummary/excel/  generate createPdf api's..." + productType);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
        }
        if (!this.performAuthorization(cloudId = cl.getCloud().getCloudId(), cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return;
        }
        try {
            if (this.reportService.createPDFBackupSummary(cl.getCloud(), reportQueryElement.getNoOfDays(), productType)) {
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/backup/user/overviewReport"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getOverview(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        User user;
        String token;
        String cloudName = cloudName1;
        String productType = null;
        logger.debug("...inside versions/{versionNumber}/clouds/{cloudName}/backup/user/overviewReport/..productType..." + productType);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return this.toJSON(1202);
        }
        Cloud cloud = cl.getCloud();
        cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        int pageNumber = 0;
        int skipValue = 0;
        if (pageNumberInteger != null) {
            pageNumber = pageNumberInteger;
            skipValue = pageNumber - 1;
        }
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return this.toJSON(1201);
        }
        boolean isODBBackupEnabled = GroupPolicyReportController.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        boolean isExchangeBackupEnabled = GroupPolicyReportController.isExchangeBackupEnabled(cloud.getCloudCustomisableDetails());
        CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
        reportQueryElement.setRowsPerPage(cloudPropertyElement.getReportRows());
        this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
        List backupOverviewElementList = new ArrayList();
        BackupoverviewResponse backupoverviewResponse = new BackupoverviewResponse();
        try {
            backupOverviewElementList = this.reportService.getAllBackupOverviewElementsByNewQuery(cloud, reportQueryElement, isODBBackupEnabled || isExchangeBackupEnabled, productType);
            long totalRecordsCount = backupOverviewElementList.size();
            List resultList = GroupPolicyReportController.getPage(backupOverviewElementList, skipValue, PCHelperConstant.getReportDisplayRecords());
            backupoverviewResponse.setBackupOverview(resultList);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug(".....overview results ...." + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), backupoverviewResponse);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.trace(EXCEPTION + ex);
            logger.error(EXCEPTION + ex.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/BackupBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getBackupBatch(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        User user;
        String token;
        String cloudName = cloudName1;
        logger.debug("inside versions/{versionNumber}/clouds/{cloudName}/report/BackupBatch");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug(INVALID_CLOUD_NAME);
            return this.toJSON(1202);
        }
        Cloud cloud = cl.getCloud();
        cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        int pageNumber = 0;
        int skipValue = 0;
        if (pageNumberInteger != null) {
            pageNumber = pageNumberInteger;
            skipValue = pageNumber - 1;
        }
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
            return this.toJSON(1201);
        }
        CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
        reportQueryElement.setRowsPerPage(cloudPropertyElement.getReportRows());
        ArrayList backupBatchList = new ArrayList();
        List backupBatchReportElements = new ArrayList();
        BackupBatchReportResponse backupBatchReportResponse = new BackupBatchReportResponse();
        try {
            backupBatchReportElements = this.reportService.getBackupBatchForReport(cloud, reportQueryElement);
            long totalRecordsCount = backupBatchReportElements.size();
            Long totalCompletedStatusCount = backupBatchReportElements.stream().filter(obj -> obj.getStatus().equals("COMPLETED")).count();
            logger.debug("totalCompletedStatusCount is {}", (Object)totalCompletedStatusCount);
            List resultList = GroupPolicyReportController.getPage(backupBatchReportElements, skipValue, PCHelperConstant.getReportDisplayRecords());
            backupBatchReportResponse.setBackupBatchReportElements(resultList);
            backupBatchReportResponse.setTotalCompletedStatusCount(totalCompletedStatusCount);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug("backup batch results is, pageNumber={}, totalRecordsCount={}", (Object)pageNumber, (Object)totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), backupBatchReportResponse);
        }
        catch (Exception ex) {
            response.setHeader("errorMessage", EXCEPTION);
            response.setStatus(500);
            logger.error(EXCEPTION + ex);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/report/BackupBatch/Excel/"}, method={RequestMethod.POST})
    public void createExcelReportBackupBatch(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("inside versions/{versionNumber}/cloud/{cloudName}/report/BackupBatch/Excel");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            boolean createdBackupBatchElementExcel = this.reportService.createBackupBatchElementForExcel(cloud, reportQueryElement);
            if (createdBackupBatchElementExcel) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
        }
        logger.debug("end of load excel backup batch report...");
    }

    @RequestMapping(value={"cloud/{cloudName}/report/BackupBatch/Pdf/"}, method={RequestMethod.POST})
    public void createPdfReportBackupBatch(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("inside versions/{versionNumber}/cloud/{cloudName}/report/BackupBatch/Pdf");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            boolean createdBackupBatchElementPdf = this.reportService.createBackupBatchElementForPdf(cloud, reportQueryElement);
            if (createdBackupBatchElementPdf) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
        }
        logger.debug("end of load Pdf backup batch report...");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/user/backupHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getBackupHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling load backupHistory ...versions/{versionNumber}/clouds/{cloudName}/report/user/backupHistory....");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = 0;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            reportQueryElement.setSkipValue(skipValue);
            reportQueryElement.setPageNo(skipValue);
            logger.debug(skipValue + "...pagenum.." + pageNumber);
            List backupHistoryElements = this.reportService.getBackupHistoryElement(cloud, reportQueryElement);
            BackupHistoryResponse histoyResponse = new BackupHistoryResponse();
            long totalRecordsCount = backupHistoryElements.size();
            List resultList = GroupPolicyReportController.getPage(backupHistoryElements, reportQueryElement.getSkipValue(), PCHelperConstant.getReportDisplayRecords());
            histoyResponse.setBackupHistoryElement(resultList);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug(totalRecordsCount + ".....pagination logs... " + pageNumber);
            logger.debug(totalRecordsCount + "end of calling load backupHistory ...versions/{versionNumber}/clouds/{cloudName}/report/user/backupHistory....");
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), histoyResponse);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e);
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/failedBackup"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getFailedBackup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling load versions/{versionNumber}/clouds/{cloudName}/report/failedBackup.. ..." + pageNumberInteger);
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumberInteger;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            reportQueryElement.setSkipValue(skipValue);
            logger.debug("...pagenum report.." + pageNumber);
            NotificationElementList notificationHistoryElement = this.reportService.getFailedNotificationHistoryElementForReport(cl.getCloud(), reportQueryElement);
            long totalRecordsCount = notificationHistoryElement.getNotificationHistoryElementList().size();
            List results = GroupPolicyReportController.getPage(notificationHistoryElement.getNotificationHistoryElementList(), reportQueryElement.getSkipValue(), PCHelperConstant.getReportDisplayRecords());
            NotificationElementList elementList = new NotificationElementList();
            elementList.setNotificationHistoryElementList(results);
            elementList.setDelayedNotificationHistoryElements(new ArrayList());
            elementList.setCurrentBatchElements(new ArrayList());
            NotificationElementResponse elementResponse = new NotificationElementResponse();
            elementResponse.setNotificationElementList(elementList);
            response.setStatus(200);
            Map paramSet = request.getParameterMap();
            logger.debug(PCHelperConstant.getReportDisplayRecords() + "....total count of failed files ... " + totalRecordsCount);
            logger.debug(request.getRequestURI() + "end of calling load versions/{versionNumber}/clouds/{cloudName}/report/failedBackup.. ..." + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(PCHelperConstant.getReportDisplayRecords(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e);
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/noBackup"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getSystemwithoutBackup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        String productType = null;
        logger.debug("calling load noBackup ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumberInteger;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            reportQueryElement.setSkipValue(skipValue);
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            List backupHistoryElements = this.reportService.getNoBackup(cl.getCloud(), cloudName, reportQueryElement, productType, false);
            long totalRecordsCount = this.reportService.getNoBackupTotalCount(cloud, reportQueryElement, productType, false);
            List resultList = GroupPolicyReportController.getPage(backupHistoryElements, reportQueryElement.getSkipValue(), PCHelperConstant.getReportDisplayRecords());
            BackupHistoryResponse histoyResponse = new BackupHistoryResponse();
            histoyResponse.setBackupHistoryElement(resultList);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug(totalRecordsCount + ".....before sending results...." + backupHistoryElements.size());
            return this.toJSON(200, this.getMetadataElement(PCHelperConstant.getReportDisplayRecords(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), histoyResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e);
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(400);
        }
    }

    public static <T> List<T> getPage(List<T> sourceList, int page, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = page * pageSize;
        if (sourceList == null || sourceList.size() < fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/restoreHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getRestoreHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling load restoreHistory ...");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumberInteger;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            reportQueryElement.setPageNo(skipValue);
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            List restoreHistoryElements = this.reportService.getRestoreHistoryElementForReport(cloud, reportQueryElement);
            long totalRecordsCount = restoreHistoryElements.size();
            RestoreHistoyResponse histoyResponse = new RestoreHistoyResponse();
            List resultList = GroupPolicyReportController.getPage(restoreHistoryElements, skipValue, PCHelperConstant.getReportDisplayRecords());
            histoyResponse.setRestoreHistoryElement(resultList);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            return this.toJSON(200, this.getMetadataElement(PCHelperConstant.getReportDisplayRecords(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), histoyResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/storageUtilizitaion"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getStorageUtilization(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling load storageUtilizitaion ...");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            int pageNumber = 0;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            int recordsCount = PCHelperConstant.getReportDisplayRecords();
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            reportQueryElement.setSkipValue(skipValue);
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            long totalRecordsCount = this.reportService.getCountStorageUtilizeReport(cloud, reportQueryElement);
            reportQueryElement.setSkipValue(skipValue);
            List dailyUserBackupOverViewList = this.reportService.getDailyUserBackupOverview(cl.getCloud(), reportQueryElement);
            DailyUserBackupOverViewResponse backupOverViewResponse = new DailyUserBackupOverViewResponse();
            backupOverViewResponse.setOverview(dailyUserBackupOverViewList);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug(skipValue + ".... storage utilization report end ..." + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), backupOverViewResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/deviceHeartBeat"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getDeviceHeartBeat(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement reportQueryElement, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling load deviceHeartBeat ..." + pageNumberInteger);
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return this.toJSON(1202);
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = 0;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            int recordsCount = PCHelperConstant.getReportDisplayRecords();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return this.toJSON(1201);
            }
            reportQueryElement.setSkipValue(skipValue);
            this.checkIsReadOnlyAdminAndSetPolicies(reportQueryElement, cloudName, cloudId, user);
            DevicePolicyDetailsResponse backupHistoryResponse = new DevicePolicyDetailsResponse();
            List devicePolicyDetailsList = this.reportService.getLastAgentServerConnectionDetails(cl.getCloud(), reportQueryElement);
            int totalCount = devicePolicyDetailsList.size();
            logger.debug(skipValue + "....before results.... " + totalCount);
            List results = GroupPolicyReportController.getPage(devicePolicyDetailsList, skipValue, PCHelperConstant.getReportDisplayRecords());
            response.setStatus(200);
            backupHistoryResponse.setDevicePolicyDetailsList(results);
            Map paramSet = request.getParameterMap();
            response.setStatus(200);
            logger.debug("end of calling load deviceHeartBeat ..." + pageNumber + "/" + totalCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalCount, request.getRequestURI(), paramSet), backupHistoryResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/currentBackup"}, method={RequestMethod.POST})
    @ResponseBody
    public ModelAndView getCurrentRunningBkp(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling load currentBkp notifications ... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName("jsonview");
            String token = request.getHeader("token");
            String backupType = request.getHeader("backupType");
            String searchValue = request.getHeader("searchValue");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return null;
            }
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            NotificationElementList notificationHistoryElement = this.reportService.getCurrentBkpNotificationHistoryElement(cloudId, reportQueryElement, searchValue, backupType);
            if (notificationHistoryElement == null) {
                notificationHistoryElement = new NotificationElementList();
            }
            modelAndView.addObject((Object)notificationHistoryElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY, (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/currentRestore"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getCurrentRunningRestore(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling load currentRestore ... ");
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setPageNo(pagNum);
            NotificationElementList notificationHistoryElement = this.reportService.getCurrentRestoreNotificationHistoryElement(cloudId, reportQueryElement);
            NotificationElementResponse elementResponse = new NotificationElementResponse();
            if (notificationHistoryElement == null) {
                notificationHistoryElement = new NotificationElementList();
            }
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = this.reportService.getAllRestoreCountForStatus(cloud.getCloudId(), reportQueryElement);
            elementResponse.setNotificationElementList(notificationHistoryElement);
            response.setStatus(200);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            return this.toJSON(400);
        }
    }

    private int getOffset(int pageNum, int rows) {
        int offset = 0;
        if (pageNum == 0 && rows > 0) {
            offset = 0;
        } else if (pageNum > 0 && rows > 0) {
            offset = rows * pageNum;
        }
        return offset;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/backupActivityHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getDeviceBackupActivityHistory(@PathVariable(value="cloudName") String cloudName1, @RequestBody ReportQueryElement reportQueryElement, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/report/backupActivityHistory ...");
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            List list = this.backupService.getAllBackupBatchForDeviceWthPagination(cloudId, cloudName, "", reportQueryElement.getDeviceUUID(), pagNum);
            BackupActivityHistoryResponse elementResponse = new BackupActivityHistoryResponse();
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = this.reportService.getCountOfBackupHistoryWithoutTime(cl.getCloud(), reportQueryElement);
            logger.debug(pagNum + ".... pagenumber..." + pageNumber);
            logger.debug(list.size() + "....total count for report ..." + totalRecordsCount);
            elementResponse.setBackupActivityHistoryElement(list);
            response.setStatus(200);
            logger.debug("....end of report calling versions/{versionNumber}/clouds/{cloudName}/report/backupActivityHistory ... ...");
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/report/backupAttemps"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getBackupAttemps(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/report/backupAttemps ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String batchId = request.getHeader("batchId");
            User user = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
                return this.toJSON(1201);
            }
            List list = this.backupService.getBackupAttemps(cloudId, batchId);
            BackupActivityHistoryResponse elementResponse = new BackupActivityHistoryResponse();
            elementResponse.setBackupAttemptElements(list);
            response.setStatus(200);
            return this.toJSON(200, elementResponse);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/reportScheduler/{schedulerName}"}, method={RequestMethod.GET})
    public ModelAndView getReportScheduler(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="schedulerName") String schedulerName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load getReportScheduler ..." + schedulerName);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String id = request.getHeader("id");
            User user = new User();
            if (!this.performAuthorization(cl.getCloud().getCloudId(), cloudName, token, user, response)) {
                return null;
            }
            List<Object> reportConfigBySchedulerName = this.reportService.getReportConfigBySchedulerName(cl.getCloud().getCloudId(), schedulerName, id);
            if (CollectionUtils.isEmpty((Collection)reportConfigBySchedulerName)) {
                reportConfigBySchedulerName = new ArrayList();
            }
            if (user != null && user.isReadOnlyAdmin()) {
                reportConfigBySchedulerName = reportConfigBySchedulerName.stream().filter(sch -> !org.springframework.util.StringUtils.isEmpty((Object)sch.getCreatedBy()) && sch.getCreatedBy().equalsIgnoreCase(user.getUserName())).collect(Collectors.toList());
            }
            modelAndView.addObject(reportConfigBySchedulerName);
            response.setStatus(200);
            return modelAndView;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load getUserInfoRestoreHistory ..." + (Object)((Object)e));
            logger.error("Error failed to load getUserInfoRestoreHistory ..." + e.getMessage());
            logger.debug("end of loading getUserInfoRestoreHistory ...");
            return modelAndView;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/reportScheduler/"}, method={RequestMethod.POST})
    public void saveReportScheduler(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportSchedulerElement reportSchedulerElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling saveReportScheduler...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            logger.debug("...reportSchedulerElement.." + reportSchedulerElement.getDisplayName());
            boolean saveReportConfigByScheduler = this.reportService.saveReportConfigByScheduler(cloudId, reportSchedulerElement, user);
            logger.debug("...saveReportConfigByScheduler.." + saveReportConfigByScheduler);
            if (saveReportConfigByScheduler) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/reportScheduler/{schedulerName}"}, method={RequestMethod.DELETE})
    public void deleteReportScheduler(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling deleteReportScheduler...");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            String id = request.getHeader("id");
            String schedulerName = request.getHeader("schedulerName");
            this.reportService.deleteReportSchedulerById(cloudId, id);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted schedule ", user.getUserName(), schedulerName, "Portal", System.currentTimeMillis(), PCActionTypes.DELETED_SCHEDULE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getRestoreProgressEvents(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/...  to get restoreEvents of " + deviceUUID);
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), user = new User(), response)) {
                return null;
            }
            RestoreProgressEvents restoreProgressEvents = this.reportService.getRestoreEventProgressByUUID(cloudId, deviceUUID);
            RestoreProgressEventsElement restoreProgressEventsElement = null;
            if (restoreProgressEvents == null) {
                logger.error("... restore not started ... ");
                RestoreEventsElement restoreEventByUUIDAndFolder = this.reportService.getRestoreEventByUUIDAndFolder(cloudId, deviceUUID, "");
                if (restoreEventByUUIDAndFolder == null) {
                    logger.debug(".......#$$#$#$..RestoreEventsElement is null.");
                    response.setStatus(204);
                    return modelAndView;
                }
                restoreProgressEventsElement = new RestoreProgressEventsElement();
                restoreProgressEventsElement.setDeviceUUID(deviceUUID);
                restoreProgressEventsElement.setRestoredFiles(0L);
                restoreProgressEventsElement.setRestoredFilesForFolder(0L);
                restoreProgressEventsElement.setRestoredPctForFolder(0L);
                restoreProgressEventsElement.setSize(0L);
                restoreProgressEventsElement.setSubject("");
                restoreProgressEventsElement.setTotalNoOfFilesForRestore(0L);
                restoreProgressEventsElement.setTotalNoOfRestoreFilesForFolder(0L);
                restoreProgressEventsElement.setTotalRestorePct(0L);
                restoreProgressEventsElement.setCurrentFolderPath(restoreEventByUUIDAndFolder.getFileElement().getFileCompletePath());
                if (restoreEventByUUIDAndFolder != null && restoreEventByUUIDAndFolder.getFileElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)restoreEventByUUIDAndFolder.getFileElement().getFileCompletePath())) {
                    restoreProgressEventsElement.setCurrentFolderPath(restoreEventByUUIDAndFolder.getFileElement().getFileCompletePath());
                } else if (restoreEventByUUIDAndFolder.isInPlaceRestore()) {
                    restoreProgressEventsElement.setCurrentFolderPath("In place restore");
                } else {
                    restoreProgressEventsElement.setCurrentFolderPath("All Drives");
                }
                restoreProgressEventsElement.setBatchId(restoreEventByUUIDAndFolder.getId().toString());
                modelAndView.addObject((Object)restoreProgressEventsElement);
                response.setStatus(206);
                return modelAndView;
            }
            restoreProgressEventsElement = new RestoreProgressEventsElement();
            BeanUtils.copyProperties((Object)restoreProgressEvents, (Object)restoreProgressEventsElement);
            RestoreEventsElement restoreEventByUUIDAndFolder = this.reportService.getRestoreEventByUUIDAndFolder(cloudId, deviceUUID, "");
            if (restoreEventByUUIDAndFolder != null && restoreEventByUUIDAndFolder.getFileElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)restoreEventByUUIDAndFolder.getFileElement().getFileCompletePath())) {
                restoreProgressEventsElement.setCurrentFolderPath(restoreEventByUUIDAndFolder.getFileElement().getFileCompletePath());
            } else if (restoreEventByUUIDAndFolder.isInPlaceRestore()) {
                restoreProgressEventsElement.setCurrentFolderPath("In place restore");
            } else {
                restoreProgressEventsElement.setCurrentFolderPath("All Drives");
            }
            if (restoreProgressEvents.getTotalsize() != 0L) {
                restoreProgressEventsElement.setTotalsizeInFormat(GroupPolicyReportController.formatFileSizeIncludeKB(restoreProgressEvents.getTotalsize() / 1024L));
            }
            if (restoreProgressEventsElement.getTotalNoOfFilesForRestore() == 0L || restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder() == 0L) {
                restoreProgressEventsElement.setTotalRestorePct(0L);
            } else {
                restoreProgressEventsElement.setTotalRestorePct(this.getPercentageCompleted(restoreProgressEventsElement.getTotalNoOfFilesForRestore(), restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder()));
            }
            logger.debug("....pct... " + restoreProgressEventsElement.getTotalNoOfFilesForRestore() + "...." + restoreProgressEventsElement.getRestoredFiles() + "...." + restoreProgressEventsElement.getTotalRestorePct());
            restoreProgressEventsElement.setBatchId(restoreEventByUUIDAndFolder.getId().toString());
            modelAndView.addObject((Object)restoreProgressEventsElement);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("" + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/mc/activities/excel/"}, method={RequestMethod.POST})
    public void createAuditHistoryExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String token;
        logger.debug("calling createAuditHistoryExcel...");
        String cloudName = cloudName1;
        AuditHistoryResponse ae = new AuditHistoryResponse();
        logger.debug("createAuditHistoryExcel..");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            response.setStatus(1202);
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
            response.setStatus(1201);
            return;
        }
        try {
            String mcName1 = request.getHeader("minicloudName");
            ArrayList<String> mcList = new ArrayList<String>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)mcName1)) {
                String[] mcNamesArr;
                for (String mcNames : mcNamesArr = mcName1.split(",")) {
                    String mcname = mcNames.trim();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)mcname) && mcname.startsWith("_mc_")) {
                        mcname = mcname.replaceFirst("_mc_", "");
                    }
                    mcList.add(mcname);
                }
            }
            String toDate = request.getHeader("toDate");
            String fromDate = request.getHeader("fromDate");
            logger.debug(mcList.size() + "...get all the mc audits.." + mcName1 + "..date.." + fromDate + ".." + toDate);
            boolean createRestoreHistoryElement = this.reportService.createAuditHistoryExcel(cloudId, mcList, fromDate, toDate);
            if (createRestoreHistoryElement) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("..exception inside ah create excel..." + e.getMessage());
            response.setStatus(400);
            response.setStatus(400);
        }
        logger.debug("end of calling createAuditHistoryExcel ...");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/mc/activities/pdf/"}, method={RequestMethod.POST})
    public void createPdfForAuditHistory(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String token;
        logger.debug("calling createPdfForAuditHistory...");
        String cloudName = cloudName1;
        logger.debug("createAuditHistoryExcel..");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            response.setStatus(1202);
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
            response.setStatus(1201);
            return;
        }
        try {
            String mcName1 = request.getHeader("minicloudName");
            ArrayList<String> mcList = new ArrayList<String>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)mcName1)) {
                String[] mcNamesArr;
                for (String mcNames : mcNamesArr = mcName1.split(",")) {
                    String mcname = mcNames.trim();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)mcname) && mcname.startsWith("_mc_")) {
                        mcname = mcname.replaceFirst("_mc_", "");
                    }
                    mcList.add(mcname);
                }
            }
            String toDate = request.getHeader("toDate");
            String fromDate = request.getHeader("fromDate");
            logger.debug(mcList.size() + "...get all the mc audits.." + mcName1 + "..date.." + fromDate + ".." + toDate);
            boolean createRestoreHistoryElement = this.reportService.createPdfForAuditHistory(cloudId, mcList, fromDate, toDate);
            if (createRestoreHistoryElement) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("..exception inside createPdfForAuditHistory..." + e.getMessage());
            response.setStatus(400);
            response.setStatus(400);
        }
        logger.debug("end of calling createPdfForAuditHistory ...");
    }

    private String getFormattedValue(long totalusers) {
        String formatedTotalUsers = "";
        NumberFormat myFormat = NumberFormat.getInstance();
        myFormat.setGroupingUsed(true);
        formatedTotalUsers = myFormat.format(totalusers);
        return formatedTotalUsers;
    }

    private long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        logger.debug("..calling getPercentageCompleted.." + totalNoOfFiles + "...." + noOfFilesRemaining);
        long percentage = 100L;
        percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        logger.debug("..percentage.." + percentage);
        return percentage;
    }

    public static String formatFileSizeIncludeKB(long size) {
        double k = size;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : dec.format(k).concat(" KB")));
        return hrSize;
    }
}

