/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.UserBackupPolicyMappingService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceBackupElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.UserBackupPolicyMappingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserBackupPolicyMappingServiceImpl
implements UserBackupPolicyMappingService {
    private static Logger logger = LogManager.getLogger(UserBackupPolicyMappingServiceImpl.class);
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private SyncPolicyDao syncPolicyDao;
    @Resource
    private UserDao userDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;
    private static final String EXCEPTION = " Exception  :";

    @Override
    public void saveUserBackupPolicyMapping(int cloudId, String cloudName, DeviceBackupElement deviceBackupElement) {
        String backupPolicyName = deviceBackupElement.getBackupPolicyName();
        String userName = deviceBackupElement.getUserName();
        this.savePolicyMapping(cloudId, cloudName, backupPolicyName, userName, "", "backupPolicy");
    }

    private String savePolicyMapping(int cloudId, String cloudName, String newpolicyName, String userName, String unAssignedUsers1, String policyType) {
        String unAssignedUsers = unAssignedUsers1;
        ArrayList<String> failedUserNames = new ArrayList<String>();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null) {
            userName = user.getUserName();
            BackupPolicy backupPolicy = null;
            SyncPolicy syncPolicy = null;
            logger.debug("policy type:" + policyType);
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, newpolicyName);
                if (backupPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                    user.setAdmin(false);
                    this.userDao.saveUser(cloudId, cloudName, user);
                    this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
                }
            } else {
                syncPolicy = this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, newpolicyName);
            }
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "backupPolicy", backupPolicy.getLastModifiedTimestamp());
                this.deviceDao.updatePolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
            } else {
                this.userDao.updateUserPolicy(cloudId, newpolicyName, user.getUserId(), "syncPolicy", syncPolicy.getLastModifiedTimestamp());
            }
        } else {
            logger.debug(" user does not exist .... " + userName);
            unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
        }
        if (!StringUtils.isEmpty((String)unAssignedUsers)) {
            System.out.println(unAssignedUsers);
            failedUserNames.addAll(Arrays.asList(unAssignedUsers.split(",")));
            logger.debug("failedUserNames.." + failedUserNames.size());
            this.createUsersExcelMappingFail(cloudId, failedUserNames);
        }
        return unAssignedUsers;
    }

    @Override
    public Boolean isPolicyModified(int cloudId, String cloudName, String userName, Long lastModifiedTimeVal) {
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getPolicyModifiedTime();
            BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
            if (bkpPolicy != null && (policyModifiedTime = bkpPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    @Override
    public boolean isUserPolicyMapped(int cloudId, String cloudName, String userName, String policyType) {
        logger.debug("policy type:" + policyType);
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
                long policyModifiedTime;
                long userPolicyModifiedTime = user.getPolicyModifiedTime();
                BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
                if (bkpPolicy != null && (policyModifiedTime = bkpPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                    isPolicyModified = true;
                    return isPolicyModified;
                }
            }
        } else if (user != null && !StringUtils.isEmpty((String)user.getSyncPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getSyncPolicyModifiedTime();
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
            if (syncPolicy != null && (policyModifiedTime = syncPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    @Override
    public List<UserBackupPolicyMappingElement> loadAllUserBackupPolicyMappingElements(int cloudId, String cloudName, String policyType) {
        String userName;
        UserBackupPolicyMappingElement element;
        List users = this.userDao.getAllUsers(cloudId, cloudName);
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : users) {
            element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                element.setBackupPolicyName(user.getPolicyName());
            } else {
                element.setSyncPolicyName(user.getSyncPolicyName());
            }
            userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
            this.removeAlreadyMappedUsers(users, userName);
        }
        for (User user : users) {
            element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                element.setBackupPolicyName("");
            } else {
                element.setSyncPolicyName("");
            }
            userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        return elements;
    }

    private void removeAlreadyMappedUsers(List<User> users, String userName) {
        boolean userAlreadyMapped = false;
        User alreadyMappedUser = null;
        for (User user : users) {
            if (!user.getUserName().equals(userName)) continue;
            userAlreadyMapped = true;
            alreadyMappedUser = user;
        }
        if (userAlreadyMapped) {
            users.remove(alreadyMappedUser);
        }
    }

    @Override
    public void saveUserPolicyMapping(int cloudId, String cloudName, String userName, String newPolicyName, String loginUserName, String policyType, int actionType) {
        this.savePolicyMapping(cloudId, cloudName, newPolicyName, userName, "", policyType);
        this.saveStatisticToDatabase(cloudId, cloudName, "assigned " + newPolicyName + " Policy to ", loginUserName, userName, actionType);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public EditUserBackupPolicyMappingElement getPolicyElements(int cloudId, int skipValue, int recordsCount, String policyType, User adminUser) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List userList = new ArrayList();
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        if (adminUser != null && adminUser.isReadOnlyAdmin()) {
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                userList = this.userDao.getAllUsersByPolicyNames(cloudId, adminUser.getBackupPoliciesAdmin(), false, skipValue, recordsCount);
            } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
                userList = this.userDao.getAllUsersBySyncPolicyNames(cloudId, adminUser.getSyncPoliciesAdmin(), skipValue, recordsCount);
            }
        } else if ("backupPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllUsers(cloudId, true, false, false, skipValue);
        } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
            userList = this.userDao.getAllActiveUsers(cloudId, skipValue);
        }
        logger.debug(" ....USER BP mapping size  ..." + userList.size());
        for (User user : userList) {
            if (user == null || !user.isActive()) continue;
            String policyName = "";
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                policyName = user.getPolicyName();
                element.setBackupPolicyName(policyName);
            } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
                policyName = user.getSyncPolicyName();
                element.setSyncPolicyName(policyName);
            }
            String userName = user.getUserName();
            element.setUserName(userName);
            logger.debug(policyName + " ....USER AND BP ..." + userName);
            elements.add(element);
        }
        List policyNamesList = "backupPolicy".equalsIgnoreCase(policyType) ? this.backupPolicyDao.getAllBackupPolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()) : ("syncPolicy".equalsIgnoreCase(policyType) ? this.syncPolicyDao.getAllSyncPolicy(cloudId, "").stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()) : this.backupPolicyDao.getAllOfficePolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public EditUserBackupPolicyMappingElement getBackupPolicyElements(int cloudId, List<String> userNames, String policyType, User adminUser) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List userList = this.userDao.getAllUsersForNames(cloudId, userNames);
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        for (User user : userList) {
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                element.setBackupPolicyName(user.getPolicyName());
            } else {
                element.setSyncPolicyName(user.getSyncPolicyName());
            }
            String userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List policyNamesList = "backupPolicy".equalsIgnoreCase(policyType) ? this.backupPolicyDao.getAllBackupPolicies(cloudId).stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList()) : this.syncPolicyDao.getAllSyncPolicy(cloudId, "").stream().filter(policy -> Objects.nonNull(policy.getPolicyName())).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(policyNamesList)) {
            policyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(policyNamesList);
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public String updateUserPolicys(int cloudId, List<String> list, String policyName, String loginUserName, String policyType, int actionType) {
        String unAssignedUsers = "";
        for (String userName : list) {
            unAssignedUsers = this.savePolicyMapping(cloudId, "", policyName, userName, unAssignedUsers, policyType);
            this.saveStatisticToDatabase(cloudId, "", "assigned " + policyName + " Policy to ", loginUserName, userName, actionType);
        }
        return unAssignedUsers;
    }

    @Override
    public EditUserBackupPolicyMappingElement getODBPolicyElements(int cloudId, int skipValue, int recordsCount, User logedInUser) {
        EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = new EditUserBackupPolicyMappingElement();
        List list = new ArrayList();
        list = logedInUser != null && logedInUser.isReadOnlyAdmin() ? this.userDao.getAllUsersByPolicyNames(cloudId, logedInUser.getOdbPoliciesAdmin(), true, skipValue, recordsCount) : this.userDao.getAllUsers(cloudId, false, false, true, skipValue);
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList();
        }
        ArrayList<UserBackupPolicyMappingElement> elements = new ArrayList<UserBackupPolicyMappingElement>();
        logger.debug(skipValue + " ....USER BP mapping size  ..." + list.size());
        for (User user : list) {
            logger.debug("......odb val ...");
            if (!user.isOnedriveBkpEnabled() && !user.isExchangeBkpEnabled()) continue;
            String policyName = "";
            if (!StringUtils.isEmpty((String)user.getOdbPolicyName())) {
                policyName = user.getOdbPolicyName();
            }
            UserBackupPolicyMappingElement element = new UserBackupPolicyMappingElement();
            element.setOdbPolicyName(policyName);
            String userName = user.getUserName();
            element.setUserName(userName);
            elements.add(element);
        }
        List allOneDriveBackupPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        List backupPolicyNamesList = allOneDriveBackupPolicies.stream().filter(odbPolicy -> Objects.nonNull(odbPolicy.getPolicyName())).map(odbPolicy -> odbPolicy.getPolicyName()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(backupPolicyNamesList)) {
            backupPolicyNamesList = new ArrayList();
        }
        editUserBackupPolicyMappingElement.setUserBackupPolicyMappingElements(elements);
        editUserBackupPolicyMappingElement.setExistingPolicies(backupPolicyNamesList);
        logger.debug(elements.size() + "....total odb policy list... " + backupPolicyNamesList.size());
        return editUserBackupPolicyMappingElement;
    }

    @Override
    public void saveODBUserPolicyMapping(int cloudId, String userName, String newPolicyName, String loginUserName, String backupPolicy, int actionTypeValue) {
        this.saveODBPolicyMapping(cloudId, newPolicyName, userName);
        this.saveStatisticToDatabase(cloudId, "", "assigned " + newPolicyName + " Policy to ", loginUserName, userName, actionTypeValue);
    }

    private String saveODBPolicyMapping(int cloudId, String newpolicyName, String userName) {
        User user = this.userDao.getUserInfoByName(cloudId, "", userName);
        if (user != null) {
            this.userDao.updateODBUserPolicy(cloudId, newpolicyName, userName);
            this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
        } else {
            logger.debug(" user does not exist .... " + userName);
        }
        return "";
    }

    @Override
    public String updateUserODBPolicys(int cloudId, List<String> list, String policyName, String loginUserName, String policyType, int actionType) {
        String unAssignedUsers = "";
        for (String userName : list) {
            unAssignedUsers = this.saveODBUserPolicyMapping(cloudId, "", policyName, userName, unAssignedUsers, policyType);
            this.saveStatisticToDatabase(cloudId, "", "assigned " + policyName + " Policy to ", loginUserName, userName, actionType);
        }
        return unAssignedUsers;
    }

    private String saveODBUserPolicyMapping(int cloudId, String cloudName, String newpolicyName, String userName, String unAssignedUsers1, String policyType) {
        String unAssignedUsers = unAssignedUsers1;
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null) {
            userName = user.getUserName();
            OfficeBackupPolicy odbPolicy = null;
            logger.debug("policy type:" + policyType);
            if ("o365BackupPolicy".equalsIgnoreCase(policyType)) {
                odbPolicy = this.oneDriveBackupPolicyDao.getOfficeBackupPolicy(cloudId, newpolicyName);
                if (odbPolicy.isLegalHoldEnabled() && user.isAdmin()) {
                    user.setAdmin(false);
                    this.userDao.saveUser(cloudId, cloudName, user);
                }
                this.userDao.updateODBUserPolicy(cloudId, newpolicyName, user.getUserId(), "o365BackupPolicy", odbPolicy.getLastModifiedTimestamp());
                this.deviceDao.updateODBPolicyNameInDeviceBkpOverview(cloudId, user.getUserName(), newpolicyName);
            }
        } else {
            logger.debug(" user does not exist .... " + userName);
            unAssignedUsers = StringUtils.isEmpty((String)unAssignedUsers) ? unAssignedUsers + userName : unAssignedUsers + "," + userName;
        }
        return unAssignedUsers;
    }

    private void createUsersExcelMappingFail(int cloudId, List<String> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForMappingFail(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    void writeExcelForUserXlsxForBlackFail(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Users_Policy_Mapping_Fail.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private List<List> updateUserElementValuesToExcelForMappingFail(List<String> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (String userElement : userList) {
            recordToAdd.add(this.loadDataOnRowForUserXlsxForMappingFail(userElement));
        }
        return recordToAdd;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    List<String> createHeaderRowForUserXlsxForBlockFail() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Reason");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsxForMappingFail(String userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement);
        firstRow.add("Invalid User");
        return firstRow;
    }

    private boolean isSyncEnabledForCloud(Cloud cloud) {
        boolean isSyncEnabled = false;
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"Sync Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSyncEnabled = true;
                break;
            }
        }
        return isSyncEnabled;
    }

    @Override
    public long getTotalMapping(Cloud cloud, String backupPolicy) {
        int cloudId = cloud.getCloudId();
        if (backupPolicy.equalsIgnoreCase("backupPolicy")) {
            return this.userDao.countOfPresentBackupUsers(cloudId, "", true);
        }
        if (backupPolicy.equalsIgnoreCase("syncPolicy")) {
            boolean isSyncEnabledForCloud = this.isSyncEnabledForCloud(cloud);
            long noOfUsers = isSyncEnabledForCloud ? this.userDao.countOfPresentUsers(cloudId, cloud.getCloudName(), true) : this.userDao.countOfPresentSyncUsers(1, "", true);
            return noOfUsers;
        }
        if (backupPolicy.equalsIgnoreCase("OFFICE_POLICY")) {
            return this.userDao.countOfPresentODBBackupUsers(cloudId, "", true);
        }
        return 0L;
    }

    @Override
    public long loadAllSyncPoliciesMappingCount(int cloudId, List<String> policyNames) {
        return this.userDao.loadAllSyncPoliciesMappingCount(cloudId, policyNames);
    }
}

