/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.PrivacyGatewayService;
import com.parablu.paracloud.element.MSAppBluKryptElement;
import com.parablu.paracloud.element.MongoPropertiesElement;
import com.parablu.paracloud.element.PrivacyGatewayElement;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.MongoPropertiesDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.MongoProperties;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Service
public class PrivacyGatewayServiceImpl
implements PrivacyGatewayService {
    private static Logger logger = LogManager.getLogger(PrivacyGatewayServiceImpl.class);
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 101, 66, 101, 115, 116, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    @Resource
    private PrivacyGateWayDao privacyGatewayDao;
    @Resource
    private MongoPropertiesDao mongoPropertiesDao;
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    BackupPolicyDao backupPolicyDao;
    @Resource
    OfficeBackupPolicyDao oneDriveBackupPolicyDao;
    @Resource
    UserDao userDao;

    @Override
    public List<PrivacyGatewayElement> getAllGateways(int cloudId) {
        List privacyGatewayList = this.privacyGatewayDao.getAllGateways(cloudId);
        ArrayList<PrivacyGatewayElement> elements = new ArrayList<PrivacyGatewayElement>();
        for (PrivacyGateway privacyGateway : privacyGatewayList) {
            PrivacyGatewayElement element = this.getPrivacyGatewayElement(privacyGateway);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<MongoPropertiesElement> getAllMongoProperties(int cloudId) {
        List elements = this.mongoPropertiesDao.getAllMongoProperties(cloudId);
        ArrayList<MongoPropertiesElement> list = new ArrayList<MongoPropertiesElement>();
        for (MongoProperties element : elements) {
            MongoPropertiesElement mongoPropertiesElement = new MongoPropertiesElement();
            try {
                BeanUtils.copyProperties((Object)mongoPropertiesElement, (Object)element);
                mongoPropertiesElement.setId(element.getId().toString());
                list.add(mongoPropertiesElement);
            }
            catch (Exception e) {
                logger.trace("Error failed to getAllMongoProperties ..." + e);
                logger.error("Error failed to getAllMongoProperties ..." + e.getMessage());
            }
        }
        return list;
    }

    private PrivacyGatewayElement getPrivacyGatewayElement(PrivacyGateway privacyGateway) {
        PrivacyGatewayElement element = null;
        if (privacyGateway != null) {
            element = new PrivacyGatewayElement();
            element.setGatewayName(privacyGateway.getGatewayName());
            element.setType(privacyGateway.getType());
            element.setProductType(privacyGateway.getProductType());
            element.setNoOfThreadsUsed(privacyGateway.getNoOfThreadsUsed());
            logger.debug(".................." + privacyGateway.isActive());
            element.setActive(privacyGateway.isActive());
        }
        return element;
    }

    @Override
    public boolean saveorUpdateGateway(int cloudId, PrivacyGatewayElement element, String cloudName) {
        this.privacyGatewayDao.saveorUpdateGateway(cloudId, element);
        logger.debug("......." + element.isActive());
        if (this.checkPrivacyGatewayIsMapped(element, cloudId, cloudName)) {
            if ("blusync".equalsIgnoreCase(element.getProductType()) || "both".equalsIgnoreCase(element.getProductType())) {
                List syncpolicyes = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
                for (SyncPolicy syncpolicy : syncpolicyes) {
                    syncpolicy.setLastModifiedTimestamp(System.currentTimeMillis());
                    this.syncPolicyDao.saveSyncPolicy(cloudId, cloudName, syncpolicy);
                }
                syncpolicyes.forEach(childSyncPolcies -> this.userDao.updateSyncPolicyModifiedTime(cloudId, childSyncPolcies.getPolicyName()));
            }
            if ("bluvault".equalsIgnoreCase(element.getProductType()) || "both".equalsIgnoreCase(element.getProductType())) {
                List backupPolicyes = this.backupPolicyDao.getAllBackupPolicies(cloudId);
                for (BackupPolicy backupPolicy : backupPolicyes) {
                    backupPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
                    this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, backupPolicy);
                }
                backupPolicyes.forEach(childBackupPolcies -> this.userDao.updateBackupPolicyModifiedTime(cloudId, childBackupPolcies.getPolicyName()));
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> deleteGateway(int cloudId, String gatewayName) {
        return this.privacyGatewayDao.deleteGateway(cloudId, gatewayName);
    }

    @Override
    public void saveorUpdateGateway(int cloudId, PrivacyGatewayElement element) {
        this.privacyGatewayDao.saveorUpdateGateway(cloudId, element);
    }

    private boolean checkPrivacyGatewayIsMapped(PrivacyGatewayElement element, int cloudID, String cloudName) {
        block5: {
            block4: {
                if (!"blusync".equalsIgnoreCase(element.getProductType())) break block4;
                List syncpolicyes = this.syncPolicyDao.getAllSyncPolicy(cloudID, cloudName);
                for (SyncPolicy syncpolicy : syncpolicyes) {
                    if (CollectionUtils.isEmpty((Collection)syncpolicy.getPrivacyGateways())) continue;
                    for (PrivacyGateway gateway : syncpolicy.getPrivacyGateways()) {
                        if (!gateway.getGatewayName().equalsIgnoreCase(element.getGatewayName())) continue;
                        return false;
                    }
                }
                break block5;
            }
            if (!"bluvault".equalsIgnoreCase(element.getProductType())) break block5;
            List backuppolicyes = this.backupPolicyDao.getAllBackupPolicies(cloudID);
            for (BackupPolicy backupPolicy : backuppolicyes) {
                if (CollectionUtils.isEmpty((Collection)backupPolicy.getPrivacyGateways())) continue;
                for (PrivacyGateway gateway : backupPolicy.getPrivacyGateways()) {
                    if (!gateway.getGatewayName().equalsIgnoreCase(element.getGatewayName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isGateWayNameExist(int cloudId, String gatewayName) {
        return this.privacyGatewayDao.isGateWayNameExist(cloudId, gatewayName);
    }

    @Override
    public boolean isMSAppBluKryptExist(int cloudId, String name) {
        return this.privacyGatewayDao.isMSAppBluKryptExist(cloudId, name);
    }

    @Override
    public boolean saveorUpdateMSAppBlukrypt(int cloudId, MSAppBluKryptElement msAppBluKryptElement, String cloudName) {
        this.privacyGatewayDao.saveorUpdateMSAppBlukrypt(cloudId, msAppBluKryptElement);
        List backupPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloudId);
        for (OfficeBackupPolicy backupPolicy : backupPolicies) {
            if (backupPolicy.getOdMsAppBluKrypt() != null && backupPolicy.getOdMsAppBluKrypt().equalsIgnoreCase(msAppBluKryptElement.getPrevhost())) {
                backupPolicy.setOdMsAppBluKrypt(msAppBluKryptElement.getHost());
            }
            if (backupPolicy.getMailMsAppBluKrypt() != null && backupPolicy.getMailMsAppBluKrypt().equalsIgnoreCase(msAppBluKryptElement.getPrevhost())) {
                backupPolicy.setMailMsAppBluKrypt(msAppBluKryptElement.getHost());
            }
            backupPolicy.setLastModifiedTimestamp(System.currentTimeMillis());
            this.oneDriveBackupPolicyDao.saveOfficeBackupPolicy(cloudId, backupPolicy);
        }
        return true;
    }

    @Override
    public void updateMongoProperties(int cloudId, MongoPropertiesElement mongoPropertiesElement) {
        MongoProperties mongoProperties = new MongoProperties();
        try {
            mongoProperties.setMongoIp(mongoPropertiesElement.getMongoIp());
            mongoProperties.setProxyHost(mongoPropertiesElement.getProxyHost());
            mongoProperties.setProxyPassword(mongoPropertiesElement.getProxyPassword());
            mongoProperties.setProxyPort(mongoPropertiesElement.getProxyPort());
            mongoProperties.setProxyUserName(mongoPropertiesElement.getProxyUserName());
            mongoProperties.setId(new ObjectId(mongoPropertiesElement.getId()));
            mongoProperties.setArchivedir(mongoPropertiesElement.getArchivedir());
            mongoProperties.setBackupdir(mongoPropertiesElement.getBackupdir());
            mongoProperties.setBackblaze_id(mongoPropertiesElement.getBackblaze_id());
            mongoProperties.setApplication_key(mongoPropertiesElement.getApplication_key());
            mongoProperties.setBackblaze_bucket(mongoPropertiesElement.getBackblaze_bucket());
            mongoProperties.setCustomer_name(mongoPropertiesElement.getCustomer_name());
            mongoProperties.setBackblaze_backup(mongoPropertiesElement.getBackblaze_backup());
            mongoProperties.setEncrypt_backup(mongoPropertiesElement.getEncrypt_backup());
        }
        catch (Exception e) {
            logger.trace("Error failed to updateMongoProperties ..." + e);
            logger.error("Error failed to updateMongoProperties ..." + e.getMessage());
        }
        this.mongoPropertiesDao.updateMongoProperties(cloudId, mongoProperties);
    }

    @Override
    public List<MSAppBluKryptElement> getAllMSAppBlukrypt(int cloudId) {
        List list = this.privacyGatewayDao.getAllMSAppBlukrypt(cloudId);
        ArrayList<MSAppBluKryptElement> elements = new ArrayList<MSAppBluKryptElement>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (MSAppBluKrypt privacyGateway : list) {
                MSAppBluKryptElement element = new MSAppBluKryptElement();
                element.setHost(privacyGateway.getHost());
                element.setPort(privacyGateway.getPort());
                elements.add(element);
            }
        }
        return elements;
    }

    @Override
    public List<String> deleteMSBluKrypt(int cloudId, String gatewayName) {
        return this.privacyGatewayDao.deleteMSBluKrypt(cloudId, gatewayName);
    }

    @Override
    public void saveorUpdateServerDetailsElement(int cloudId, PrivacyGatewayElement element) {
        try {
            BluVault bluVault;
            PrivacyGateway details = this.privacyGatewayDao.getPrivacyGateway(cloudId, element.getGatewayName());
            if (details != null) {
                details.getComponentsProperties().putAll(element.getComponentsProperties());
                String softwareUpdatePassword = (String)element.getComponentsProperties().get("softwareUpdatePassword");
                if (!StringUtils.isEmpty((String)softwareUpdatePassword)) {
                    details.getComponentsProperties().put("softwareUpdatePassword", PrivacyGatewayServiceImpl.encrypt(softwareUpdatePassword));
                    this.privacyGatewayDao.saveGateway(cloudId, details);
                }
            }
            if ((bluVault = this.privacyGatewayDao.getBluVault(cloudId, element.getGatewayName())) != null) {
                bluVault.getComponentsProperties().putAll(element.getComponentsProperties());
                String softwareUpdatePassword = (String)bluVault.getComponentsProperties().get("softwareUpdatePassword");
                if (!StringUtils.isEmpty((String)softwareUpdatePassword)) {
                    bluVault.getComponentsProperties().put("softwareUpdatePassword", PrivacyGatewayServiceImpl.encrypt(softwareUpdatePassword));
                    this.privacyGatewayDao.saveBluVault(cloudId, bluVault);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to saveorUpdateServerDetailsElement ..." + e);
            logger.error("Error failed to saveorUpdateServerDetailsElement ..." + e.getMessage());
        }
    }

    @Override
    public PrivacyGatewayElement getServerDetails(int cloudId, String gatewayName) {
        PrivacyGateway details = this.privacyGatewayDao.getPrivacyGateway(cloudId, gatewayName);
        PrivacyGatewayElement detailsElement = null;
        try {
            if (details != null) {
                detailsElement = new PrivacyGatewayElement();
                Map componentsProperties = details.getComponentsProperties();
                detailsElement.setComponentsProperties(componentsProperties);
                String softwareUpdatePassword = (String)detailsElement.getComponentsProperties().get("softwareUpdatePassword");
                if (!StringUtils.isEmpty((String)softwareUpdatePassword)) {
                    detailsElement.getComponentsProperties().put("softwareUpdatePassword", PrivacyGatewayServiceImpl.decrypt(softwareUpdatePassword));
                }
            } else {
                BluVault bluVault = this.privacyGatewayDao.getBluVault(cloudId, gatewayName);
                if (bluVault != null) {
                    detailsElement = new PrivacyGatewayElement();
                    detailsElement.setComponentsProperties(bluVault.getComponentsProperties());
                    detailsElement.setGatewayName(bluVault.getBluVaultName());
                    String softwareUpdatePassword = (String)detailsElement.getComponentsProperties().get("softwareUpdatePassword");
                    if (!StringUtils.isEmpty((String)softwareUpdatePassword)) {
                        detailsElement.getComponentsProperties().put("softwareUpdatePassword", PrivacyGatewayServiceImpl.decrypt(softwareUpdatePassword));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("Exception ", (Throwable)e);
        }
        return detailsElement;
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }

    public static String decrypt(String encryptedData) throws Exception {
        Key key = PrivacyGatewayServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(2, key);
        byte[] decordedValue = new BASE64Decoder().decodeBuffer(encryptedData);
        byte[] decValue = c.doFinal(decordedValue);
        return new String(decValue);
    }

    public static String encrypt(String data) throws Exception {
        Key key = PrivacyGatewayServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(1, key);
        byte[] encVal = c.doFinal(data.getBytes());
        return new BASE64Encoder().encode(encVal);
    }
}

