/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.BackupPolicyService;
import com.parablu.bp.service.DeviceBackupPolicyMappingService;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.BluSyncGroupPolicyElementList;
import com.parablu.paracloud.element.bp.DeviceBackupPolicyMappingElement;
import com.parablu.paracloud.element.bp.EditDeviceBackupPolicyMappingElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceBackupPolicyMappingDao;
import com.parablu.pcbd.dao.DeviceContainerDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupPolicyMapping;
import com.parablu.pcbd.domain.DeviceContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DeviceBackupPolicyMappingServiceImpl
implements DeviceBackupPolicyMappingService {
    private static Logger logger = LogManager.getLogger(DeviceBackupPolicyMappingServiceImpl.class);
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private DeviceBackupPolicyMappingDao deviceBackupPolicyMappingDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private BackupPolicyService backupPolicyService;
    @Resource
    private DeviceContainerDao deviceContainerDao;

    @Override
    public String saveDevicePolicies(int cloudId, String cloudName, List<String> devices, String policyName, String loggedinUserName) {
        logger.debug("updateDevicePolicies > BEGIN");
        for (String deviceUUID : devices) {
            this.saveDevicePolicy(deviceUUID, policyName, cloudId, cloudName, loggedinUserName);
        }
        logger.debug("updateDevicePolicies > END");
        return null;
    }

    private String saveDevicePolicy(String deviceUUID, String policyName, int cloudId, String cloudName, String userName) {
        logger.debug("saveDevicePolicy > BEGIN");
        String status = "Device/Policy Invalid";
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
        BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName);
        if (device != null && backupPolicy != null) {
            DeviceBackupPolicyMapping devicePolicyMap = this.deviceBackupPolicyMappingDao.getDevicePolicyMap(cloudId, device);
            if (devicePolicyMap == null) {
                devicePolicyMap = new DeviceBackupPolicyMapping();
            }
            devicePolicyMap.setBackupPolicy(backupPolicy);
            devicePolicyMap.setDevice(device);
            devicePolicyMap.setLastUpdatedTimeStamp(Long.valueOf(System.currentTimeMillis()));
            this.deviceBackupPolicyMappingDao.saveDeviceBackupPolicyMapping(cloudId, devicePolicyMap);
            this.saveStatisticToDatabase(cloudId, cloudName, "policy " + policyName + " assigned to ", userName, device.getDeviceName());
            status = "success";
        }
        logger.debug("saveDevicePolicy > Status : " + status);
        return status;
    }

    @Override
    public EditDeviceBackupPolicyMappingElement getAllDeviceBackupPolicyMapings(int cloudId, String cloudName, int skipValue, List<String> deviceNames) {
        logger.debug("getAllDeviceBackupPolicyMapings > BEGIN > cloudId : " + cloudId);
        EditDeviceBackupPolicyMappingElement edp = new EditDeviceBackupPolicyMappingElement();
        List devices = deviceNames == null ? this.deviceDao.getAllWithPagination(cloudId, skipValue) : this.deviceDao.findDeviceByNames(cloudId, deviceNames);
        edp.setDeviceBackupPolicyMappingElements(this.createDevicePolicyElementsFromDevices(devices, cloudId));
        edp.setExistingPolicies(this.getExistingPolicies(cloudId));
        logger.debug("getAllDeviceBackupPolicyMapings > BEFORE RETURN > cloudId : " + cloudId);
        return edp;
    }

    private List<DeviceBackupPolicyMappingElement> createDevicePolicyElementsFromDevices(List<Device> devices, int cloudId) {
        logger.debug("createDevicePolicyElements > BEGIN > ");
        ArrayList<DeviceBackupPolicyMappingElement> devicePolicyElements = new ArrayList<DeviceBackupPolicyMappingElement>();
        for (Device device : devices) {
            DeviceBackupPolicyMappingElement mapEle = new DeviceBackupPolicyMappingElement();
            mapEle.setDeviceName(device.getDeviceName());
            mapEle.setDeviceUUID(device.getDeviceUUID());
            DeviceBackupPolicyMapping dBpM = this.deviceBackupPolicyMappingDao.getDevicePolicyMap(cloudId, device);
            mapEle.setPolicyName(dBpM == null ? "" : dBpM.getBackupPolicy().getPolicyName());
            devicePolicyElements.add(mapEle);
        }
        logger.debug("createDevicePolicyElements > BEFORE RETURN > ");
        return devicePolicyElements;
    }

    private List<String> getExistingPolicies(int cloudId) {
        logger.debug("getExistingPolicies > BEGIN > CLOUDID : " + cloudId);
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        ArrayList<String> policies = new ArrayList<String>();
        for (BackupPolicy backupPolicy : backupPolicies) {
            policies.add(backupPolicy.getPolicyName());
        }
        logger.debug("getExistingPolicies > BEFORE RETURN > CLOUDID : " + cloudId);
        return policies;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public BackupPolicy getDeviceBackupPolicy(int cloudId, String cloudName, String deviceUUID, String userName) {
        logger.debug("getDeviceBackupPolicy > BEGIN > CLOUDID : " + cloudId + " DEVICEUUID : " + deviceUUID);
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, deviceUUID);
        DeviceBackupPolicyMapping policyMap = this.deviceBackupPolicyMappingDao.getDevicePolicyMap(cloudId, device);
        logger.debug("getDeviceBackupPolnull;icy > BEFOR RETURN");
        return policyMap.getBackupPolicy();
    }

    @Override
    public BluSyncGroupPolicyElementList getDeviceContainerGroupPolicyElement(int cloudId, String cloudName, String deviceUUID, String userName) {
        logger.debug("getDeviceBackupGroupPolicyElement > BEGIN > CLOUDID : " + cloudId + " DEVICEUUID : " + deviceUUID);
        BluSyncGroupPolicyElementList bluSynGpPElList = new BluSyncGroupPolicyElementList();
        List deviceContainer = this.deviceContainerDao.getAllDeviceContainers(deviceUUID, cloudId);
        Iterator list = deviceContainer.iterator();
        while (list.hasNext()) {
            BackupPolicy policyMap = ((DeviceContainer)list.next()).getBackupPolicy();
            if (policyMap == null) continue;
            BluSyncGroupBackupPolicyElement bluSynGpPEl = this.backupPolicyService.getBluSyncGroupPolicyElement(policyMap, cloudId, cloudName, deviceUUID, userName);
            bluSynGpPElList.getBluSyncGroupPolicyElement().add(bluSynGpPEl);
        }
        logger.debug("getDeviceBackupGroupPolicyElement > BEFOR RETURN");
        return bluSynGpPElList;
    }
}

