/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.BluVaultMappingService;
import com.parablu.paracloud.element.BluVaultMappingElement;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.domain.BluVault;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BluVaultMappingServiceImpl
implements BluVaultMappingService {
    @Resource
    private BluVaultDao bluVaultDao;

    public void setBluVaultDao(BluVaultDao bluVaultDao) {
        this.bluVaultDao = bluVaultDao;
    }

    @Override
    public void saveBluVault(int cloudId, String cloudName, BluVault bluvaultMapping) {
        this.bluVaultDao.saveBluVault(cloudId, cloudName, bluvaultMapping);
    }

    @Override
    public void deleteBluVault(int cloudId, String cloudName, String ebmsId) {
        this.bluVaultDao.deleteBluVault(cloudId, cloudName, ebmsId);
    }

    @Override
    public List<BluVaultMappingElement> getAllBluVaults(int cloudId, String cloudName) {
        List ebmsMappings = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
        ArrayList<BluVaultMappingElement> elements = new ArrayList<BluVaultMappingElement>();
        for (BluVault ebmsMapping : ebmsMappings) {
            BluVaultMappingElement element = this.getBluVaultMappingElement(ebmsMapping);
            elements.add(element);
        }
        return elements;
    }

    private BluVaultMappingElement getBluVaultMappingElement(BluVault bluvaultMapping) {
        BluVaultMappingElement element = null;
        if (bluvaultMapping != null) {
            element = new BluVaultMappingElement();
            element.setId(String.valueOf(bluvaultMapping.getId()));
            element.setBluVaultName(bluvaultMapping.getBluVaultName());
            element.setComponentsProperties(bluvaultMapping.getComponentsProperties());
        }
        return element;
    }

    @Override
    public boolean isBluVaultNameExist(int cloudId, String bluVaultName) {
        return this.bluVaultDao.isBluVaultNameExist(cloudId, bluVaultName);
    }
}

