/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility;

import com.sun.java.accessibility.AccessBridgeLoader;
import com.sun.java.accessibility.util.AWTEventMonitor;
import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.SwingEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jdk.Exported;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

@Exported(value=false)
public final class AccessBridge
extends AccessBridgeLoader {
    private final String AccessBridgeVersion = "AccessBridge 2.0.4";
    private static AccessBridge theAccessBridge;
    private ObjectReferences references;
    private EventHandler eventHandler;
    private boolean runningOnJDK1_4 = false;
    private boolean runningOnJDK1_5 = false;
    private ConcurrentHashMap<String, AccessibleRole> accessibleRoleMap = new ConcurrentHashMap();
    private ArrayList<AccessibleRole> extendedVirtualNameSearchRoles = new ArrayList();
    private ArrayList<AccessibleRole> noExtendedVirtualNameSearchParentRoles = new ArrayList();
    private Method javaGetComponentFromNativeWindowHandleMethod;
    private Method javaGetNativeWindowHandleFromComponentMethod;
    Toolkit toolkit;
    private static ConcurrentHashMap<Integer, AccessibleContext> windowHandleToContextMap;
    private static ConcurrentHashMap<AccessibleContext, Integer> contextToWindowHandleMap;
    private static Vector<NativeWindowHandler> nativeWindowHandlers;
    ConcurrentHashMap<AccessibleTable, AccessibleContext> hashtab = new ConcurrentHashMap();
    private Map<AccessibleHypertext, AccessibleContext> hyperTextContextMap = new WeakHashMap<AccessibleHypertext, AccessibleContext>();
    private Map<AccessibleHyperlink, AccessibleContext> hyperLinkContextMap = new WeakHashMap<AccessibleHyperlink, AccessibleContext>();
    private int _visibleChildrenCount;
    private AccessibleContext _visibleChild;
    private int _currentVisibleIndex;
    private boolean _foundVisibleChild;
    private static final long PROPERTY_CHANGE_EVENTS = 1L;
    private static final long FOCUS_GAINED_EVENTS = 2L;
    private static final long FOCUS_LOST_EVENTS = 4L;
    private static final long FOCUS_EVENTS = 6L;
    private static final long CARET_UPATE_EVENTS = 8L;
    private static final long CARET_EVENTS = 8L;
    private static final long MOUSE_CLICKED_EVENTS = 16L;
    private static final long MOUSE_ENTERED_EVENTS = 32L;
    private static final long MOUSE_EXITED_EVENTS = 64L;
    private static final long MOUSE_PRESSED_EVENTS = 128L;
    private static final long MOUSE_RELEASED_EVENTS = 256L;
    private static final long MOUSE_EVENTS = 496L;
    private static final long MENU_CANCELED_EVENTS = 512L;
    private static final long MENU_DESELECTED_EVENTS = 1024L;
    private static final long MENU_SELECTED_EVENTS = 2048L;
    private static final long MENU_EVENTS = 3584L;
    private static final long POPUPMENU_CANCELED_EVENTS = 4096L;
    private static final long POPUPMENU_WILL_BECOME_INVISIBLE_EVENTS = 8192L;
    private static final long POPUPMENU_WILL_BECOME_VISIBLE_EVENTS = 16384L;
    private static final long POPUPMENU_EVENTS = 28672L;
    private static final long PROPERTY_NAME_CHANGE_EVENTS = 1L;
    private static final long PROPERTY_DESCRIPTION_CHANGE_EVENTS = 2L;
    private static final long PROPERTY_STATE_CHANGE_EVENTS = 4L;
    private static final long PROPERTY_VALUE_CHANGE_EVENTS = 8L;
    private static final long PROPERTY_SELECTION_CHANGE_EVENTS = 16L;
    private static final long PROPERTY_TEXT_CHANGE_EVENTS = 32L;
    private static final long PROPERTY_CARET_CHANGE_EVENTS = 64L;
    private static final long PROPERTY_VISIBLEDATA_CHANGE_EVENTS = 128L;
    private static final long PROPERTY_CHILD_CHANGE_EVENTS = 256L;
    private static final long PROPERTY_ACTIVEDESCENDENT_CHANGE_EVENTS = 512L;
    private static final long PROPERTY_EVENTS = 1023L;
    private AccessibleRole[] allAccessibleRoles = new AccessibleRole[]{AccessibleRole.ALERT, AccessibleRole.COLUMN_HEADER, AccessibleRole.CANVAS, AccessibleRole.COMBO_BOX, AccessibleRole.DESKTOP_ICON, AccessibleRole.INTERNAL_FRAME, AccessibleRole.DESKTOP_PANE, AccessibleRole.OPTION_PANE, AccessibleRole.WINDOW, AccessibleRole.FRAME, AccessibleRole.DIALOG, AccessibleRole.COLOR_CHOOSER, AccessibleRole.DIRECTORY_PANE, AccessibleRole.FILE_CHOOSER, AccessibleRole.FILLER, AccessibleRole.ICON, AccessibleRole.LABEL, AccessibleRole.ROOT_PANE, AccessibleRole.GLASS_PANE, AccessibleRole.LAYERED_PANE, AccessibleRole.LIST, AccessibleRole.LIST_ITEM, AccessibleRole.MENU_BAR, AccessibleRole.POPUP_MENU, AccessibleRole.MENU, AccessibleRole.MENU_ITEM, AccessibleRole.SEPARATOR, AccessibleRole.PAGE_TAB_LIST, AccessibleRole.PAGE_TAB, AccessibleRole.PANEL, AccessibleRole.PROGRESS_BAR, AccessibleRole.PASSWORD_TEXT, AccessibleRole.PUSH_BUTTON, AccessibleRole.TOGGLE_BUTTON, AccessibleRole.CHECK_BOX, AccessibleRole.RADIO_BUTTON, AccessibleRole.ROW_HEADER, AccessibleRole.SCROLL_PANE, AccessibleRole.SCROLL_BAR, AccessibleRole.VIEWPORT, AccessibleRole.SLIDER, AccessibleRole.SPLIT_PANE, AccessibleRole.TABLE, AccessibleRole.TEXT, AccessibleRole.TREE, AccessibleRole.TOOL_BAR, AccessibleRole.TOOL_TIP, AccessibleRole.AWT_COMPONENT, AccessibleRole.SWING_COMPONENT, AccessibleRole.UNKNOWN};

    public AccessBridge() {
        theAccessBridge = this;
        this.references = new ObjectReferences();
        Runtime runtime = Runtime.getRuntime();
        shutdownHook shutdownHook2 = new shutdownHook();
        runtime.addShutdownHook(new Thread(shutdownHook2));
        this.initAccessibleRoleMap();
        String string = this.getJavaVersionProperty();
        this.debugString("JDK version = " + string);
        this.runningOnJDK1_4 = string.compareTo("1.4") >= 0;
        boolean bl = this.runningOnJDK1_5 = string.compareTo("1.5") >= 0;
        if (this.initHWNDcalls()) {
            EventQueueMonitor.isGUIInitialized();
            this.eventHandler = new EventHandler(this);
            if (this.runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this.eventHandler);
            }
            AccessBridge.addNativeWindowHandler(new DefaultNativeWindowHandler());
            Thread thread = new Thread(new dllRunner());
            thread.setDaemon(true);
            thread.start();
            this.debugString("AccessBridge started");
        }
    }

    private void initAccessibleRoleMap() {
        try {
            Class<?> clazz = Class.forName("javax.accessibility.AccessibleRole");
            if (null != clazz) {
                AccessibleRole accessibleRole = AccessibleRole.UNKNOWN;
                Field[] fieldArray = clazz.getFields();
                int n = 0;
                for (n = 0; n < fieldArray.length; ++n) {
                    Field field = fieldArray[n];
                    if (AccessibleRole.class != field.getType()) continue;
                    AccessibleRole accessibleRole2 = (AccessibleRole)field.get(accessibleRole);
                    String string = accessibleRole2.toDisplayString(Locale.US);
                    this.accessibleRoleMap.put(string, accessibleRole2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.COMBO_BOX);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.DATE_EDITOR);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.LIST);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.PASSWORD_TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.SLIDER);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.SPIN_BOX);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TABLE);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.UNKNOWN);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TABLE);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TOOL_BAR);
    }

    private native void runDLL();

    private native void sendDebugString(String var1);

    private void debugString(String string) {
        this.sendDebugString(string);
    }

    private void decrementReference(Object object) {
        this.references.decrement(object);
    }

    private String getJavaVersionProperty() {
        String string = System.getProperty("java.version");
        if (string != null) {
            this.references.increment(string);
            return string;
        }
        return null;
    }

    private String getAccessBridgeVersion() {
        String string = new String("AccessBridge 2.0.4");
        this.references.increment(string);
        return string;
    }

    private native int isJAWTInstalled();

    private native int jawtGetNativeWindowHandleFromComponent(Component var1);

    private native Component jawtGetComponentFromNativeWindowHandle(int var1);

    private boolean initHWNDcalls() {
        Class[] classArray = new Class[]{Integer.TYPE};
        Class[] classArray2 = new Class[1];
        try {
            classArray2[0] = Class.forName("java.awt.Component");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debugString("Exception: " + classNotFoundException.toString());
        }
        Object[] objectArray = new Object[1];
        boolean bl = false;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.useJAWT_DLL) {
            bl = true;
        } else {
            try {
                this.javaGetComponentFromNativeWindowHandleMethod = this.toolkit.getClass().getMethod("getComponentFromNativeWindowHandle", classArray);
                if (this.javaGetComponentFromNativeWindowHandleMethod != null) {
                    try {
                        objectArray[0] = new Integer(1);
                        Component component = (Component)this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)this.toolkit, objectArray);
                        bl = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.debugString("Exception: " + invocationTargetException.toString());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.debugString("Exception: " + illegalAccessException.toString());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.debugString("Exception: " + noSuchMethodException.toString());
            }
            catch (SecurityException securityException) {
                this.debugString("Exception: " + securityException.toString());
            }
            try {
                this.javaGetNativeWindowHandleFromComponentMethod = this.toolkit.getClass().getMethod("getNativeWindowHandleFromComponent", classArray2);
                if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
                    try {
                        objectArray[0] = new Button("OK");
                        Integer n = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, objectArray);
                        bl = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.debugString("Exception: " + invocationTargetException.toString());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.debugString("Exception: " + illegalAccessException.toString());
                    }
                    catch (Exception exception) {
                        this.debugString("Exception: " + exception.toString());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.debugString("Exception: " + noSuchMethodException.toString());
            }
            catch (SecurityException securityException) {
                this.debugString("Exception: " + securityException.toString());
            }
        }
        return bl;
    }

    private static void registerVirtualFrame(final Accessible accessible, Integer n) {
        if (accessible != null) {
            AccessibleContext accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return accessible.getAccessibleContext();
                }
            }, accessible);
            windowHandleToContextMap.put(n, accessibleContext);
            contextToWindowHandleMap.put(accessibleContext, n);
        }
    }

    private static void revokeVirtualFrame(final Accessible accessible, Integer n) {
        AccessibleContext accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return accessible.getAccessibleContext();
            }
        }, accessible);
        windowHandleToContextMap.remove(n);
        contextToWindowHandleMap.remove(accessibleContext);
    }

    private static void addNativeWindowHandler(NativeWindowHandler nativeWindowHandler) {
        if (nativeWindowHandler == null) {
            throw new IllegalArgumentException();
        }
        nativeWindowHandlers.addElement(nativeWindowHandler);
    }

    private static boolean removeNativeWindowHandler(NativeWindowHandler nativeWindowHandler) {
        if (nativeWindowHandler == null) {
            throw new IllegalArgumentException();
        }
        return nativeWindowHandlers.removeElement(nativeWindowHandler);
    }

    private boolean isJavaWindow(int n) {
        AccessibleContext accessibleContext = this.getContextFromNativeWindowHandle(n);
        if (accessibleContext != null) {
            this.saveContextToWindowHandleMapping(accessibleContext, n);
            return true;
        }
        return false;
    }

    private void saveContextToWindowHandleMapping(AccessibleContext accessibleContext, int n) {
        this.debugString("saveContextToWindowHandleMapping...");
        if (accessibleContext == null) {
            return;
        }
        if (!contextToWindowHandleMap.containsKey(accessibleContext)) {
            this.debugString("saveContextToWindowHandleMapping: ac = " + accessibleContext + "; handle = " + n);
            contextToWindowHandleMap.put(accessibleContext, n);
        }
    }

    private AccessibleContext getContextFromNativeWindowHandle(int n) {
        AccessibleContext accessibleContext = windowHandleToContextMap.get(n);
        if (accessibleContext != null) {
            this.saveContextToWindowHandleMapping(accessibleContext, n);
            return accessibleContext;
        }
        int n2 = nativeWindowHandlers.size();
        for (int i = 0; i < n2; ++i) {
            NativeWindowHandler nativeWindowHandler = nativeWindowHandlers.elementAt(i);
            final Accessible accessible = nativeWindowHandler.getAccessibleFromNativeWindowHandle(n);
            if (accessible == null) continue;
            accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return accessible.getAccessibleContext();
                }
            }, accessible);
            this.saveContextToWindowHandleMapping(accessibleContext, n);
            return accessibleContext;
        }
        return null;
    }

    private int getNativeWindowHandleFromContext(AccessibleContext accessibleContext) {
        this.debugString("getNativeWindowHandleFromContext: ac = " + accessibleContext);
        try {
            return contextToWindowHandleMap.get(accessibleContext);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int getNativeWindowHandleFromComponent(final Component component) {
        if (this.useJAWT_DLL) {
            this.debugString("*** calling jawtGetNativeWindowHandleFromComponent");
            return this.jawtGetNativeWindowHandleFromComponent(component);
        }
        Object[] objectArray = new Object[1];
        this.debugString("*** calling javaGetNativeWindowHandleFromComponent");
        if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
            try {
                objectArray[0] = component;
                Integer n = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, objectArray);
                AccessibleContext accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return component.getAccessibleContext();
                    }
                }, component);
                contextToWindowHandleMap.put(accessibleContext, n);
                return n;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.debugString("Exception: " + invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.debugString("Exception: " + illegalAccessException.toString());
            }
        }
        return -1;
    }

    private AccessibleContext getAccessibleContextAt(int n, int n2, AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        if (windowHandleToContextMap != null && windowHandleToContextMap.containsValue(this.getRootAccessibleContext(accessibleContext))) {
            return this.getAccessibleContextAt_1(n, n2, accessibleContext);
        }
        return this.getAccessibleContextAt_2(n, n2, accessibleContext);
    }

    private AccessibleContext getRootAccessibleContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible == null) {
                    return accessibleContext;
                }
                Accessible accessible2 = accessible.getAccessibleContext().getAccessibleParent();
                while (accessible2 != null) {
                    accessible = accessible2;
                    accessible2 = accessible.getAccessibleContext().getAccessibleParent();
                }
                return accessible.getAccessibleContext();
            }
        }, accessibleContext);
    }

    private AccessibleContext getAccessibleContextAt_1(final int n, int n2, final AccessibleContext accessibleContext) {
        AccessibleContext accessibleContext2;
        Point point;
        Accessible accessible;
        this.debugString(" : getAccessibleContextAt_1 called");
        this.debugString("   -> x = " + n + " y = " + n2 + " parent = " + accessibleContext);
        if (accessibleContext == null) {
            return null;
        }
        final AccessibleComponent accessibleComponent = InvocationUtils.invokeAndWait(new Callable<AccessibleComponent>(){

            @Override
            public AccessibleComponent call() throws Exception {
                return accessibleContext.getAccessibleComponent();
            }
        }, accessibleContext);
        if (accessibleComponent != null && (accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(point = InvocationUtils.invokeAndWait(new Callable<Point>(){

            @Override
            public Point call() throws Exception {
                return accessibleComponent.getLocation();
            }
        }, accessibleContext), n2){
            final /* synthetic */ Point val$loc;
            final /* synthetic */ int val$y;
            {
                this.val$loc = point;
                this.val$y = n2;
            }

            @Override
            public Accessible call() throws Exception {
                return accessibleComponent.getAccessibleAt(new Point(n - this.val$loc.x, this.val$y - this.val$loc.y));
            }
        }, accessibleContext)) != null && (accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return accessible.getAccessibleContext();
            }
        }, accessibleContext)) != null) {
            if (accessibleContext2 != accessibleContext) {
                return this.getAccessibleContextAt_1(n - point.x, n2 - point.y, accessibleContext2);
            }
            return accessibleContext2;
        }
        return accessibleContext;
    }

    private AccessibleContext getAccessibleContextAt_2(final int n, final int n2, AccessibleContext accessibleContext) {
        this.debugString("getAccessibleContextAt_2 called");
        this.debugString("   -> x = " + n + " y = " + n2 + " parent = " + accessibleContext);
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleContext accessibleContext;
                Accessible accessible = EventQueueMonitor.getAccessibleAt(new Point(n, n2));
                if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                    AccessBridge.this.debugString("   returning childAC = " + accessibleContext);
                    return accessibleContext;
                }
                return null;
            }
        }, accessibleContext);
    }

    private AccessibleContext getAccessibleContextWithFocus() {
        AccessibleContext accessibleContext;
        Accessible accessible;
        Component component = AWTEventMonitor.getComponentWithFocus();
        if (component != null && (accessible = Translator.getAccessible(component)) != null && (accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                return accessible.getAccessibleContext();
            }
        }, component)) != null) {
            return accessibleContext;
        }
        return null;
    }

    private String getAccessibleNameFromContext(final AccessibleContext accessibleContext) {
        this.debugString("***** ac = " + accessibleContext.getClass());
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return accessibleContext.getAccessibleName();
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleName from Context: " + string);
                return string;
            }
            return null;
        }
        this.debugString("getAccessibleNameFromContext; ac = null!");
        return null;
    }

    private String getVirtualAccessibleNameFromContext(final AccessibleContext accessibleContext) {
        if (null != accessibleContext) {
            AccessibleRole accessibleRole;
            AccessibleContext accessibleContext2;
            Accessible accessible;
            int n;
            AccessibleContext accessibleContext3;
            int n2;
            Object object;
            Object object2;
            Object object3;
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return accessibleContext.getAccessibleName();
                }
            }, accessibleContext);
            if (null != string && 0 != string.length()) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleName.");
                this.references.increment(string);
                return string;
            }
            String string2 = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return accessibleContext.getAccessibleDescription();
                }
            }, accessibleContext);
            if (null != string2 && 0 != string2.length()) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleDescription.");
                this.references.increment(string2);
                return string2;
            }
            this.debugString("The Virtual Accessible Name was not found using AccessibleContext::getAccessibleDescription. or getAccessibleName");
            boolean bl = false;
            AccessibleRole accessibleRole2 = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                @Override
                public AccessibleRole call() throws Exception {
                    return accessibleContext.getAccessibleRole();
                }
            }, accessibleContext);
            AccessibleContext accessibleContext4 = null;
            AccessibleRole accessibleRole3 = AccessibleRole.UNKNOWN;
            if (this.extendedVirtualNameSearchRoles.contains(accessibleRole2) && null != (accessibleContext4 = this.getAccessibleParentFromContext(accessibleContext)) && AccessibleRole.UNKNOWN != (accessibleRole3 = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>((AccessibleContext)(object3 = accessibleContext4)){
                final /* synthetic */ AccessibleContext val$parentContextInnerTemp;
                {
                    this.val$parentContextInnerTemp = accessibleContext;
                }

                @Override
                public AccessibleRole call() throws Exception {
                    return this.val$parentContextInnerTemp.getAccessibleRole();
                }
            }, accessibleContext))) {
                bl = true;
                if (this.noExtendedVirtualNameSearchParentRoles.contains(accessibleRole3)) {
                    bl = false;
                }
            }
            if (!bl) {
                this.debugString("bk -- getVirtualAccessibleNameFromContext will not use the extended name search algorithm.  role = " + accessibleRole2.toDisplayString(Locale.US));
                if (AccessibleRole.LABEL == accessibleRole2) {
                    int n3;
                    Object object4;
                    object3 = InvocationUtils.invokeAndWait(new Callable<AccessibleText>(){

                        @Override
                        public AccessibleText call() throws Exception {
                            return accessibleContext.getAccessibleText();
                        }
                    }, accessibleContext);
                    if (null != object3 && null != (object4 = this.getAccessibleTextRangeFromContext(accessibleContext, 0, n3 = InvocationUtils.invokeAndWait(new Callable<Integer>((AccessibleText)object3){
                        final /* synthetic */ AccessibleText val$at;
                        {
                            this.val$at = accessibleText;
                        }

                        @Override
                        public Integer call() throws Exception {
                            return this.val$at.getCharCount();
                        }
                    }, accessibleContext).intValue()))) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from the Accessible Text of the LABEL object.");
                        this.references.increment(object4);
                        return object4;
                    }
                    this.debugString("bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    final AccessibleIcon[] accessibleIconArray = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                        @Override
                        public AccessibleIcon[] call() throws Exception {
                            return accessibleContext.getAccessibleIcon();
                        }
                    }, accessibleContext);
                    if (null != accessibleIconArray && accessibleIconArray.length > 0) {
                        object4 = InvocationUtils.invokeAndWait(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return accessibleIconArray[0].getAccessibleIconDescription();
                            }
                        }, accessibleContext);
                        if (object4 != null) {
                            this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the LABEL object.");
                            this.references.increment(object4);
                            return object4;
                        }
                    } else {
                        accessibleContext4 = this.getAccessibleParentFromContext(accessibleContext);
                        if (null != accessibleContext4 && AccessibleRole.TABLE == (accessibleRole3 = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>((AccessibleContext)(object4 = accessibleContext4)){
                            final /* synthetic */ AccessibleContext val$parentContextInnerTemp;
                            {
                                this.val$parentContextInnerTemp = accessibleContext;
                            }

                            @Override
                            public AccessibleRole call() throws Exception {
                                return this.val$parentContextInnerTemp.getAccessibleRole();
                            }
                        }, accessibleContext))) {
                            String string3;
                            AccessibleIcon[] accessibleIconArray2;
                            int n4 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                                @Override
                                public Integer call() throws Exception {
                                    return accessibleContext.getAccessibleIndexInParent();
                                }
                            }, accessibleContext);
                            final AccessibleContext accessibleContext5 = this.getAccessibleChildFromContext(accessibleContext4, n4);
                            this.debugString("bk -- Making a second attempt to obtain the Virtual Accessible Name from the Accessible Icon information for the Table Cell.");
                            if (accessibleContext5 != null && null != (accessibleIconArray2 = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                                @Override
                                public AccessibleIcon[] call() throws Exception {
                                    return accessibleContext5.getAccessibleIcon();
                                }
                            }, accessibleContext)) && accessibleIconArray2.length > 0 && (string3 = InvocationUtils.invokeAndWait(new Callable<String>(){

                                @Override
                                public String call() {
                                    return accessibleIconArray2[0].getAccessibleIconDescription();
                                }
                            }, accessibleContext)) != null) {
                                this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the Table Cell object.");
                                this.references.increment(string3);
                                return string3;
                            }
                        }
                    }
                } else if (AccessibleRole.TOGGLE_BUTTON == accessibleRole2 || AccessibleRole.PUSH_BUTTON == accessibleRole2) {
                    String string4;
                    this.debugString("bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    object3 = InvocationUtils.invokeAndWait(new Callable<AccessibleIcon[]>(){

                        @Override
                        public AccessibleIcon[] call() {
                            return accessibleContext.getAccessibleIcon();
                        }
                    }, accessibleContext);
                    if (null != object3 && ((AccessibleIcon[])object3).length > 0 && (string4 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return object3[0].getAccessibleIconDescription();
                        }
                    }, accessibleContext)) != null) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the TOGGLE_BUTTON or PUSH_BUTTON object.");
                        this.references.increment(string4);
                        return string4;
                    }
                } else if (AccessibleRole.CHECK_BOX == accessibleRole2 && null != (object3 = InvocationUtils.invokeAndWait(new Callable<AccessibleValue>(){

                    @Override
                    public AccessibleValue call() throws Exception {
                        return accessibleContext.getAccessibleValue();
                    }
                }, accessibleContext))) {
                    string = null;
                    Number number = InvocationUtils.invokeAndWait(new Callable<Number>((AccessibleValue)object3){
                        final /* synthetic */ AccessibleValue val$av;
                        {
                            this.val$av = accessibleValue;
                        }

                        @Override
                        public Number call() throws Exception {
                            return this.val$av.getCurrentAccessibleValue();
                        }
                    }, accessibleContext);
                    if (null != number && null != (string = 1 == number.intValue() ? Boolean.TRUE.toString() : (0 == number.intValue() ? Boolean.FALSE.toString() : number.toString()))) {
                        this.references.increment(string);
                        return string;
                    }
                }
                return null;
            }
            object3 = accessibleContext4;
            String string5 = InvocationUtils.invokeAndWait(new Callable<String>((AccessibleContext)object3){
                final /* synthetic */ AccessibleContext val$parentContextOuterTemp;
                {
                    this.val$parentContextOuterTemp = accessibleContext;
                }

                @Override
                public String call() throws Exception {
                    return this.val$parentContextOuterTemp.getAccessibleName();
                }
            }, accessibleContext);
            String string6 = InvocationUtils.invokeAndWait(new Callable<String>((AccessibleContext)object3){
                final /* synthetic */ AccessibleContext val$parentContextOuterTemp;
                {
                    this.val$parentContextOuterTemp = accessibleContext;
                }

                @Override
                public String call() throws Exception {
                    return this.val$parentContextOuterTemp.getAccessibleDescription();
                }
            }, accessibleContext);
            if (AccessibleRole.SLIDER == accessibleRole2 && AccessibleRole.PANEL == accessibleRole3 && null != string5) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from the Accessible Name of the SLIDER object's parent object.");
                this.references.increment(string5);
                return string5;
            }
            boolean bl2 = false;
            AccessibleContext accessibleContext6 = accessibleContext;
            if (AccessibleRole.TEXT == accessibleRole2 && AccessibleRole.COMBO_BOX == accessibleRole3) {
                bl2 = true;
                if (null != string5) {
                    this.debugString("bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Name of the object's parent object.");
                    this.references.increment(string5);
                    return string5;
                }
                if (null != string6) {
                    this.debugString("bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Description of the object's parent object.");
                    this.references.increment(string6);
                    return string6;
                }
                accessibleContext6 = accessibleContext4;
                accessibleRole3 = AccessibleRole.UNKNOWN;
                accessibleContext4 = this.getAccessibleParentFromContext(accessibleContext6);
                if (null != accessibleContext4) {
                    object2 = accessibleContext4;
                    accessibleRole3 = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>((AccessibleContext)object2){
                        final /* synthetic */ AccessibleContext val$parentContextInnerTemp;
                        {
                            this.val$parentContextInnerTemp = accessibleContext;
                        }

                        @Override
                        public AccessibleRole call() throws Exception {
                            return this.val$parentContextInnerTemp.getAccessibleRole();
                        }
                    }, accessibleContext);
                }
            }
            if (null != (object2 = this.getJavaVersionProperty()) && ((String)object2).compareTo("1.3") >= 0) {
                AccessibleContext accessibleContext7;
                Object[] objectArray;
                Object object5;
                AccessibleRelation accessibleRelation;
                final AccessibleContext accessibleContext8 = accessibleContext4;
                AccessibleRelationSet accessibleRelationSet = InvocationUtils.invokeAndWait(new Callable<AccessibleRelationSet>(){

                    @Override
                    public AccessibleRelationSet call() throws Exception {
                        return accessibleContext8.getAccessibleRelationSet();
                    }
                }, accessibleContext);
                if (accessibleRelationSet != null && accessibleRelationSet.size() > 0 && accessibleRelationSet.contains(AccessibleRelation.LABELED_BY) && (accessibleRelation = accessibleRelationSet.get(AccessibleRelation.LABELED_BY)) != null && (object5 = (objectArray = accessibleRelation.getTarget())[0]) instanceof Accessible && (accessibleContext7 = ((Accessible)object5).getAccessibleContext()) != null) {
                    String string7 = accessibleContext7.getAccessibleName();
                    object = accessibleContext7.getAccessibleDescription();
                    if (null != string7) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Name Case.");
                        this.references.increment(string7);
                        return string7;
                    }
                    if (null != object) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Description Case.");
                        this.references.increment(object);
                        return object;
                    }
                }
            } else {
                this.debugString("bk -- This version of Java does not support AccessibleContext::getAccessibleRelationSet.");
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            object = accessibleContext6;
            int n12 = InvocationUtils.invokeAndWait(new Callable<Integer>((AccessibleContext)object){
                final /* synthetic */ AccessibleContext val$tempContext;
                {
                    this.val$tempContext = accessibleContext;
                }

                @Override
                public Integer call() throws Exception {
                    return this.val$tempContext.getAccessibleIndexInParent();
                }
            }, accessibleContext);
            if (null != accessibleContext4) {
                final AccessibleContext accessibleContext9 = accessibleContext4;
                n5 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return accessibleContext9.getAccessibleChildrenCount() - 1;
                    }
                }, accessibleContext);
            }
            n6 = this.getAccessibleXcoordFromContext(accessibleContext6);
            n7 = this.getAccessibleYcoordFromContext(accessibleContext6);
            n8 = this.getAccessibleWidthFromContext(accessibleContext6);
            n9 = this.getAccessibleHeightFromContext(accessibleContext6);
            n10 = n6 + 2;
            n11 = n7 + 2;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            String string8 = null;
            String string9 = null;
            for (n2 = n12 - 1; n2 >= 0; --n2) {
                accessibleContext3 = accessibleContext4;
                n = n2;
                accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                    @Override
                    public Accessible call() throws Exception {
                        return accessibleContext3.getAccessibleChild(n);
                    }
                }, accessibleContext);
                if (null == accessible || null == (accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return accessible.getAccessibleContext();
                    }
                }, accessibleContext)) || AccessibleRole.LABEL != (accessibleRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                    @Override
                    public AccessibleRole call() throws Exception {
                        return accessibleContext2.getAccessibleRole();
                    }
                }, accessibleContext))) continue;
                n13 = this.getAccessibleXcoordFromContext(accessibleContext2);
                n14 = this.getAccessibleYcoordFromContext(accessibleContext2);
                n15 = this.getAccessibleWidthFromContext(accessibleContext2);
                n16 = this.getAccessibleHeightFromContext(accessibleContext2);
                if (n13 < n6 && n14 <= n11 && n11 <= n14 + n16) {
                    string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleName();
                        }
                    }, accessibleContext);
                    if (null != string8) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(string8);
                        return string8;
                    }
                    string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleDescription();
                        }
                    }, accessibleContext);
                    if (null == string9) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(string9);
                    return string9;
                }
                if (n14 >= n11 || n13 > n10 || n10 > n13 + n15) continue;
                string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return accessibleContext2.getAccessibleName();
                    }
                }, accessibleContext);
                if (null != string8) {
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(string8);
                    return string8;
                }
                string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return accessibleContext2.getAccessibleDescription();
                    }
                }, accessibleContext);
                if (null == string9) continue;
                this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(string9);
                return string9;
            }
            for (n2 = n12 + 1; n2 <= n5; ++n2) {
                accessibleContext3 = accessibleContext4;
                n = n2;
                accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                    @Override
                    public Accessible call() throws Exception {
                        return accessibleContext3.getAccessibleChild(n);
                    }
                }, accessibleContext);
                if (null == accessible || null == (accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return accessible.getAccessibleContext();
                    }
                }, accessibleContext)) || AccessibleRole.LABEL != (accessibleRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                    @Override
                    public AccessibleRole call() throws Exception {
                        return accessibleContext2.getAccessibleRole();
                    }
                }, accessibleContext))) continue;
                n13 = this.getAccessibleXcoordFromContext(accessibleContext2);
                n14 = this.getAccessibleYcoordFromContext(accessibleContext2);
                n15 = this.getAccessibleWidthFromContext(accessibleContext2);
                n16 = this.getAccessibleHeightFromContext(accessibleContext2);
                if (n13 < n6 && n14 <= n11 && n11 <= n14 + n16) {
                    string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleName();
                        }
                    }, accessibleContext);
                    if (null != string8) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(string8);
                        return string8;
                    }
                    string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleDescription();
                        }
                    }, accessibleContext);
                    if (null == string9) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(string9);
                    return string9;
                }
                if (n14 >= n11 || n13 > n10 || n10 > n13 + n15) continue;
                string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return accessibleContext2.getAccessibleName();
                    }
                }, accessibleContext);
                if (null != string8) {
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(string8);
                    return string8;
                }
                string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                    @Override
                    public String call() {
                        return accessibleContext2.getAccessibleDescription();
                    }
                }, accessibleContext);
                if (null == string9) continue;
                this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(string9);
                return string9;
            }
            if (AccessibleRole.TEXT == accessibleRole2 || AccessibleRole.COMBO_BOX == accessibleRole2 || bl2) {
                for (n2 = n12 - 1; n2 >= 0; --n2) {
                    accessibleContext3 = accessibleContext4;
                    n = n2;
                    accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                        @Override
                        public Accessible call() throws Exception {
                            return accessibleContext3.getAccessibleChild(n);
                        }
                    }, accessibleContext);
                    if (null == accessible || null == (accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                        @Override
                        public AccessibleContext call() throws Exception {
                            return accessible.getAccessibleContext();
                        }
                    }, accessibleContext)) || AccessibleRole.PUSH_BUTTON != (accessibleRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                        @Override
                        public AccessibleRole call() throws Exception {
                            return accessibleContext2.getAccessibleRole();
                        }
                    }, accessibleContext)) && AccessibleRole.TOGGLE_BUTTON != accessibleRole) continue;
                    n13 = this.getAccessibleXcoordFromContext(accessibleContext2);
                    n14 = this.getAccessibleYcoordFromContext(accessibleContext2);
                    n15 = this.getAccessibleWidthFromContext(accessibleContext2);
                    n16 = this.getAccessibleHeightFromContext(accessibleContext2);
                    if (n13 >= n6 || n14 > n11 || n11 > n14 + n16) continue;
                    string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleName();
                        }
                    }, accessibleContext);
                    if (null != string8) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(string8);
                        return string8;
                    }
                    string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleDescription();
                        }
                    }, accessibleContext);
                    if (null == string9) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(string9);
                    return string9;
                }
                for (n2 = n12 + 1; n2 <= n5; ++n2) {
                    accessibleContext3 = accessibleContext4;
                    n = n2;
                    accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

                        @Override
                        public Accessible call() throws Exception {
                            return accessibleContext3.getAccessibleChild(n);
                        }
                    }, accessibleContext);
                    if (null == accessible || null == (accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                        @Override
                        public AccessibleContext call() throws Exception {
                            return accessible.getAccessibleContext();
                        }
                    }, accessibleContext)) || AccessibleRole.PUSH_BUTTON != (accessibleRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                        @Override
                        public AccessibleRole call() throws Exception {
                            return accessibleContext2.getAccessibleRole();
                        }
                    }, accessibleContext)) && AccessibleRole.TOGGLE_BUTTON != accessibleRole) continue;
                    n13 = this.getAccessibleXcoordFromContext(accessibleContext2);
                    n14 = this.getAccessibleYcoordFromContext(accessibleContext2);
                    n15 = this.getAccessibleWidthFromContext(accessibleContext2);
                    n16 = this.getAccessibleHeightFromContext(accessibleContext2);
                    if (n13 >= n6 || n14 > n11 || n11 > n14 + n16) continue;
                    string8 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleName();
                        }
                    }, accessibleContext);
                    if (null != string8) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(string8);
                        return string8;
                    }
                    string9 = InvocationUtils.invokeAndWait(new Callable<String>(){

                        @Override
                        public String call() {
                            return accessibleContext2.getAccessibleDescription();
                        }
                    }, accessibleContext);
                    if (null == string9) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(string9);
                    return string9;
                }
            }
            return null;
        }
        this.debugString("AccessBridge::getVirtualAccessibleNameFromContext error - ac == null.");
        return null;
    }

    private String getAccessibleDescriptionFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return accessibleContext.getAccessibleDescription();
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleDescription from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleDescriptionFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleRoleStringFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleRole accessibleRole = InvocationUtils.invokeAndWait(new Callable<AccessibleRole>(){

                @Override
                public AccessibleRole call() throws Exception {
                    return accessibleContext.getAccessibleRole();
                }
            }, accessibleContext);
            if (accessibleRole != null && (string = accessibleRole.toDisplayString(Locale.US)) != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleRole from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleRoleStringFromContext_en_US(AccessibleContext accessibleContext) {
        return this.getAccessibleRoleStringFromContext(accessibleContext);
    }

    private String getAccessibleStatesStringFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleStateSet accessibleStateSet = InvocationUtils.invokeAndWait(new Callable<AccessibleStateSet>(){

                @Override
                public AccessibleStateSet call() throws Exception {
                    return accessibleContext.getAccessibleStateSet();
                }
            }, accessibleContext);
            if (accessibleStateSet != null && (string = accessibleStateSet.toString()) != null && string.indexOf(AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US)) == -1) {
                AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                if (accessibleRole == AccessibleRole.LIST || accessibleRole == AccessibleRole.TABLE || accessibleRole == AccessibleRole.TREE) {
                    string = string + ",";
                    string = string + AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US);
                }
                this.references.increment(string);
                this.debugString("Returning AccessibleStateSet from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleStatesStringFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleStatesStringFromContext_en_US(final AccessibleContext accessibleContext) {
        AccessibleStateSet accessibleStateSet;
        if (accessibleContext != null && (accessibleStateSet = InvocationUtils.invokeAndWait(new Callable<AccessibleStateSet>(){

            @Override
            public AccessibleStateSet call() throws Exception {
                return accessibleContext.getAccessibleStateSet();
            }
        }, accessibleContext)) != null) {
            String string = "";
            AccessibleState[] accessibleStateArray = accessibleStateSet.toArray();
            if (accessibleStateArray != null && accessibleStateArray.length > 0) {
                string = accessibleStateArray[0].toDisplayString(Locale.US);
                for (int i = 1; i < accessibleStateArray.length; ++i) {
                    string = string + "," + accessibleStateArray[i].toDisplayString(Locale.US);
                }
            }
            this.references.increment(string);
            this.debugString("Returning AccessibleStateSet en_US from Context: " + string);
            return string;
        }
        this.debugString("getAccessibleStatesStringFromContext; ac = null");
        return null;
    }

    private AccessibleContext getAccessibleParentFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleContext accessibleContext2;
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible != null && (accessibleContext2 = accessible.getAccessibleContext()) != null) {
                    return accessibleContext2;
                }
                return null;
            }
        }, accessibleContext);
    }

    private int getAccessibleIndexInParentFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleContext.getAccessibleIndexInParent();
            }
        }, accessibleContext);
    }

    private int getAccessibleChildrenCountFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleContext.getAccessibleChildrenCount();
            }
        }, accessibleContext);
    }

    private AccessibleContext getAccessibleChildFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext == null) {
            return null;
        }
        final JTable jTable = InvocationUtils.invokeAndWait(new Callable<JTable>(){

            @Override
            public JTable call() throws Exception {
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible != null) {
                    int n = accessibleContext.getAccessibleIndexInParent();
                    Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                    if (accessible2 instanceof JTable) {
                        return (JTable)accessible2;
                    }
                }
                return null;
            }
        }, accessibleContext);
        if (jTable == null) {
            return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    if (accessible != null) {
                        return accessible.getAccessibleContext();
                    }
                    return null;
                }
            }, accessibleContext);
        }
        AccessibleTable accessibleTable = this.getAccessibleTableFromContext(accessibleContext);
        final int n2 = this.getAccessibleTableRow(accessibleTable, n);
        final int n3 = this.getAccessibleTableColumn(accessibleTable, n);
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Serializable serializable;
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n2, n3);
                if (tableCellRenderer == null) {
                    serializable = jTable.getColumnClass(n3);
                    tableCellRenderer = jTable.getDefaultRenderer((Class<?>)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n2, n3), false, false, n2, n3)) instanceof Accessible) {
                    return ((Component)serializable).getAccessibleContext();
                }
                return null;
            }
        }, accessibleContext);
    }

    private Rectangle getAccessibleBoundsOnScreenFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle rectangle;
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null && (rectangle = accessibleComponent.getBounds()) != null) {
                    try {
                        Point point = accessibleComponent.getLocationOnScreen();
                        if (point != null) {
                            rectangle.x = point.x;
                            rectangle.y = point.y;
                            return rectangle;
                        }
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return null;
            }
        }, accessibleContext);
    }

    private int getAccessibleXcoordFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                this.debugString(" - Returning Accessible x coord from Context: " + rectangle.x);
                return rectangle.x;
            }
        } else {
            this.debugString("getAccessibleXcoordFromContext ac = null");
        }
        return -1;
    }

    private int getAccessibleYcoordFromContext(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleYcoordFromContext() called");
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.y;
            }
        } else {
            this.debugString("getAccessibleYcoordFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleHeightFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.height;
            }
        } else {
            this.debugString("getAccessibleHeightFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleWidthFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.width;
            }
        } else {
            this.debugString("getAccessibleWidthFromContext; ac = null");
        }
        return -1;
    }

    private AccessibleComponent getAccessibleComponentFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent != null) {
                this.debugString("Returning AccessibleComponent Context");
                return accessibleComponent;
            }
        } else {
            this.debugString("getAccessibleComponentFromContext; ac = null");
        }
        return null;
    }

    private AccessibleAction getAccessibleActionFromContext(final AccessibleContext accessibleContext) {
        this.debugString("Returning AccessibleAction Context");
        return accessibleContext == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleAction>(){

            @Override
            public AccessibleAction call() throws Exception {
                return accessibleContext.getAccessibleAction();
            }
        }, accessibleContext);
    }

    private AccessibleSelection getAccessibleSelectionFromContext(final AccessibleContext accessibleContext) {
        return accessibleContext == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleSelection>(){

            @Override
            public AccessibleSelection call() throws Exception {
                return accessibleContext.getAccessibleSelection();
            }
        }, accessibleContext);
    }

    private AccessibleText getAccessibleTextFromContext(final AccessibleContext accessibleContext) {
        return accessibleContext == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleText>(){

            @Override
            public AccessibleText call() throws Exception {
                return accessibleContext.getAccessibleText();
            }
        }, accessibleContext);
    }

    private AccessibleValue getAccessibleValueFromContext(final AccessibleContext accessibleContext) {
        return accessibleContext == null ? null : InvocationUtils.invokeAndWait(new Callable<AccessibleValue>(){

            @Override
            public AccessibleValue call() throws Exception {
                return accessibleContext.getAccessibleValue();
            }
        }, accessibleContext);
    }

    private Rectangle getCaretLocation(final AccessibleContext accessibleContext) {
        this.debugString("getCaretLocation");
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle rectangle = null;
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible instanceof Accessible) {
                    int n = accessibleContext.getAccessibleIndexInParent();
                    Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                    if (accessible2 instanceof JTextComponent) {
                        JTextComponent jTextComponent = (JTextComponent)accessible2;
                        try {
                            rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                            if (rectangle != null) {
                                Point point = jTextComponent.getLocationOnScreen();
                                rectangle.translate(point.x, point.y);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                return rectangle;
            }
        }, accessibleContext);
    }

    private int getCaretLocationX(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.x;
        }
        return -1;
    }

    private int getCaretLocationY(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.y;
        }
        return -1;
    }

    private int getCaretLocationHeight(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.height;
        }
        return -1;
    }

    private int getCaretLocationWidth(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.width;
        }
        return -1;
    }

    private int getAccessibleCharCountFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    return accessibleText.getCharCount();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private int getAccessibleCaretPositionFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    return accessibleText.getCaretPosition();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private int getAccessibleIndexAtPointFromContext(final AccessibleContext accessibleContext, final int n, final int n2) {
        this.debugString("getAccessibleIndexAtPointFromContext: x = " + n + "; y = " + n2);
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleText != null && accessibleComponent != null) {
                    try {
                        Point point = accessibleComponent.getLocationOnScreen();
                        if (point != null) {
                            int n4;
                            int n22 = n - point.x;
                            if (n22 < 0) {
                                n22 = 0;
                            }
                            if ((n4 = n2 - point.y) < 0) {
                                n4 = 0;
                            }
                            Point point2 = new Point(n22, n4);
                            int n3 = accessibleText.getIndexAtPoint(new Point(n22, n4));
                            return n3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return -1;
            }
        }, accessibleContext);
    }

    private String getAccessibleLetterAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    if (accessibleText == null) {
                        return null;
                    }
                    return accessibleText.getAtIndex(1, n);
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleLetterAtIndexFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleWordAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    if (accessibleText == null) {
                        return null;
                    }
                    return accessibleText.getAtIndex(2, n);
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleWordAtIndexFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleSentenceAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    if (accessibleText == null) {
                        return null;
                    }
                    return accessibleText.getAtIndex(3, n);
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleSentenceAtIndexFromContext; ac = null");
        }
        return null;
    }

    private int getAccessibleTextSelectionStartFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    return accessibleText.getSelectionStart();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private int getAccessibleTextSelectionEndFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    return accessibleText.getSelectionEnd();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private String getAccessibleTextSelectedTextFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string = InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    if (accessibleText == null) {
                        return null;
                    }
                    return accessibleText.getSelectedText();
                }
            }, accessibleContext);
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleTextSelectedTextFromContext; ac = null");
        }
        return null;
    }

    private String getAccessibleAttributesAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext == null) {
            return null;
        }
        AttributeSet attributeSet = InvocationUtils.invokeAndWait(new Callable<AttributeSet>(){

            @Override
            public AttributeSet call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    return accessibleText.getCharacterAttribute(n);
                }
                return null;
            }
        }, accessibleContext);
        String string = this.expandStyleConstants(attributeSet);
        if (string != null) {
            this.references.increment(string);
            return string;
        }
        return null;
    }

    private int getAccessibleTextLineLeftBoundsFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    Rectangle rectangle = accessibleText.getCharacterBounds(n);
                    int n4 = accessibleText.getCharCount();
                    if (rectangle == null) {
                        return -1;
                    }
                    int n2 = 1;
                    int n3 = n - n2 < 0 ? 0 : n - n2;
                    Rectangle rectangle2 = accessibleText.getCharacterBounds(n3);
                    while (rectangle2 != null && rectangle2.y >= rectangle.y && n3 > 0) {
                        n3 = n - (n2 <<= 1) < 0 ? 0 : n - n2;
                        rectangle2 = accessibleText.getCharacterBounds(n3);
                    }
                    if (n3 != 0) {
                        n2 >>= 1;
                        while (n2 > 0) {
                            rectangle2 = accessibleText.getCharacterBounds(n3 + n2);
                            if (rectangle2.y < rectangle.y) {
                                n3 += n2;
                            }
                            n2 >>= 1;
                        }
                        ++n3;
                    }
                    return n3;
                }
                return -1;
            }
        }, accessibleContext);
    }

    private int getAccessibleTextLineRightBoundsFromContext(final AccessibleContext accessibleContext, final int n) {
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText != null) {
                    Rectangle rectangle = accessibleText.getCharacterBounds(n);
                    int n4 = accessibleText.getCharCount();
                    if (rectangle == null) {
                        return -1;
                    }
                    int n2 = 1;
                    int n3 = n + n2 > n4 - 1 ? n4 - 1 : n + n2;
                    Rectangle rectangle2 = accessibleText.getCharacterBounds(n3);
                    while (rectangle2 != null && rectangle2.y <= rectangle.y && n3 < n4 - 1) {
                        n3 = n + (n2 <<= 1) > n4 - 1 ? n4 - 1 : n + n2;
                        rectangle2 = accessibleText.getCharacterBounds(n3);
                    }
                    if (n3 != n4 - 1) {
                        n2 >>= 1;
                        while (n2 > 0) {
                            rectangle2 = accessibleText.getCharacterBounds(n3 - n2);
                            if (rectangle2.y > rectangle.y) {
                                n3 -= n2;
                            }
                            n2 >>= 1;
                        }
                        --n3;
                    }
                    return n3;
                }
                return -1;
            }
        }, accessibleContext);
    }

    private String getAccessibleTextRangeFromContext(final AccessibleContext accessibleContext, final int n, final int n2) {
        String string = InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleText accessibleText;
                if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null) {
                    if (n > n2) {
                        return null;
                    }
                    if (n2 >= accessibleText.getCharCount()) {
                        return null;
                    }
                    StringBuffer stringBuffer = new StringBuffer(n2 - n + 1);
                    for (int i = n; i <= n2; ++i) {
                        stringBuffer.append(accessibleText.getAtIndex(1, i));
                    }
                    return stringBuffer.toString();
                }
                return null;
            }
        }, accessibleContext);
        if (string != null) {
            this.references.increment(string);
            return string;
        }
        return null;
    }

    private AttributeSet getAccessibleAttributeSetAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<AttributeSet>(){

            @Override
            public AttributeSet call() throws Exception {
                AttributeSet attributeSet;
                AccessibleText accessibleText;
                if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null && (attributeSet = accessibleText.getCharacterAttribute(n)) != null) {
                    AccessBridge.this.references.increment(attributeSet);
                    return attributeSet;
                }
                return null;
            }
        }, accessibleContext);
    }

    private Rectangle getAccessibleTextRectAtIndexFromContext(final AccessibleContext accessibleContext, final int n) {
        Rectangle rectangle = InvocationUtils.invokeAndWait(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle rectangle;
                AccessibleText accessibleText;
                if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null && (rectangle = accessibleText.getCharacterBounds(n)) != null) {
                    String string = accessibleText.getAtIndex(1, n);
                    if (string != null && string.equals("\n")) {
                        rectangle.width = 0;
                    }
                    return rectangle;
                }
                return null;
            }
        }, accessibleContext);
        Rectangle rectangle2 = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
        if (rectangle != null && rectangle2 != null) {
            rectangle.translate(rectangle2.x, rectangle2.y);
            return rectangle;
        }
        return null;
    }

    private int getAccessibleXcoordTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.x;
            }
        } else {
            this.debugString("getAccessibleXcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleYcoordTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.y;
            }
        } else {
            this.debugString("getAccessibleYcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleHeightTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.height;
            }
        } else {
            this.debugString("getAccessibleHeightTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private int getAccessibleWidthTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.width;
            }
        } else {
            this.debugString("getAccessibleWidthTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    private boolean getBoldFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isBold(attributeSet);
        }
        this.debugString("getBoldFromAttributeSet; as = null");
        return false;
    }

    private boolean getItalicFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isItalic(attributeSet);
        }
        this.debugString("getItalicFromAttributeSet; as = null");
        return false;
    }

    private boolean getUnderlineFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isUnderline(attributeSet);
        }
        this.debugString("getUnderlineFromAttributeSet; as = null");
        return false;
    }

    private boolean getStrikethroughFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isStrikeThrough(attributeSet);
        }
        this.debugString("getStrikethroughFromAttributeSet; as = null");
        return false;
    }

    private boolean getSuperscriptFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isSuperscript(attributeSet);
        }
        this.debugString("getSuperscriptFromAttributeSet; as = null");
        return false;
    }

    private boolean getSubscriptFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isSubscript(attributeSet);
        }
        this.debugString("getSubscriptFromAttributeSet; as = null");
        return false;
    }

    private String getBackgroundColorFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getBackground(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getBackgroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    private String getForegroundColorFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getForeground(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getForegroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    private String getFontFamilyFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getFontFamily(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getFontFamilyFromAttributeSet; as = null");
        }
        return null;
    }

    private int getFontSizeFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getFontSize(attributeSet);
        }
        this.debugString("getFontSizeFromAttributeSet; as = null");
        return -1;
    }

    private int getAlignmentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getAlignment(attributeSet);
        }
        this.debugString("getAlignmentFromAttributeSet; as = null");
        return -1;
    }

    private int getBidiLevelFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getBidiLevel(attributeSet);
        }
        this.debugString("getBidiLevelFromAttributeSet; as = null");
        return -1;
    }

    private float getFirstLineIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getFirstLineIndent(attributeSet);
        }
        this.debugString("getFirstLineIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getLeftIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getLeftIndent(attributeSet);
        }
        this.debugString("getLeftIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getRightIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getRightIndent(attributeSet);
        }
        this.debugString("getRightIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getLineSpacingFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getLineSpacing(attributeSet);
        }
        this.debugString("getLineSpacingFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getSpaceAboveFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getSpaceAbove(attributeSet);
        }
        this.debugString("getSpaceAboveFromAttributeSet; as = null");
        return -1.0f;
    }

    private float getSpaceBelowFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getSpaceBelow(attributeSet);
        }
        this.debugString("getSpaceBelowFromAttributeSet; as = null");
        return -1.0f;
    }

    private String expandStyleConstants(AttributeSet attributeSet) {
        Color color;
        Object object;
        String string = "";
        string = string + "BidiLevel = " + StyleConstants.getBidiLevel(attributeSet);
        final Component component = StyleConstants.getComponent(attributeSet);
        if (component != null) {
            string = component instanceof Accessible ? ((object = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return component.getAccessibleContext();
                }
            }, component)) != null ? string + "; Accessible Component = " + InvocationUtils.invokeAndWait(new Callable<String>((AccessibleContext)object){
                final /* synthetic */ AccessibleContext val$ac;
                {
                    this.val$ac = accessibleContext;
                }

                @Override
                public String call() throws Exception {
                    return this.val$ac.getAccessibleName();
                }
            }, (AccessibleContext)object) : string + "; Innaccessible Component = " + component) : string + "; Innaccessible Component = " + component;
        }
        if ((object = StyleConstants.getIcon(attributeSet)) != null) {
            string = object instanceof ImageIcon ? string + "; ImageIcon = " + ((ImageIcon)object).getDescription() : string + "; Icon = " + object;
        }
        string = string + "; FontFamily = " + StyleConstants.getFontFamily(attributeSet);
        string = string + "; FontSize = " + StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isBold(attributeSet)) {
            string = string + "; bold";
        }
        if (StyleConstants.isItalic(attributeSet)) {
            string = string + "; italic";
        }
        if (StyleConstants.isUnderline(attributeSet)) {
            string = string + "; underline";
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            string = string + "; strikethrough";
        }
        if (StyleConstants.isSuperscript(attributeSet)) {
            string = string + "; superscript";
        }
        if (StyleConstants.isSubscript(attributeSet)) {
            string = string + "; subscript";
        }
        if ((color = StyleConstants.getForeground(attributeSet)) != null) {
            string = string + "; Foreground = " + color;
        }
        if ((color = StyleConstants.getBackground(attributeSet)) != null) {
            string = string + "; Background = " + color;
        }
        string = string + "; FirstLineIndent = " + StyleConstants.getFirstLineIndent(attributeSet);
        string = string + "; RightIndent = " + StyleConstants.getRightIndent(attributeSet);
        string = string + "; LeftIndent = " + StyleConstants.getLeftIndent(attributeSet);
        string = string + "; LineSpacing = " + StyleConstants.getLineSpacing(attributeSet);
        string = string + "; SpaceAbove = " + StyleConstants.getSpaceAbove(attributeSet);
        string = string + "; SpaceBelow = " + StyleConstants.getSpaceBelow(attributeSet);
        string = string + "; Alignment = " + StyleConstants.getAlignment(attributeSet);
        TabSet tabSet = StyleConstants.getTabSet(attributeSet);
        if (tabSet != null) {
            string = string + "; TabSet = " + tabSet;
        }
        return string;
    }

    private String getCurrentAccessibleValueFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                    if (accessibleValue == null) {
                        return null;
                    }
                    return accessibleValue.getCurrentAccessibleValue();
                }
            }, accessibleContext);
            if (number != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getCurrentAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private String getMaximumAccessibleValueFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                    if (accessibleValue == null) {
                        return null;
                    }
                    return accessibleValue.getMaximumAccessibleValue();
                }
            }, accessibleContext);
            if (number != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getMaximumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private String getMinimumAccessibleValueFromContext(final AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number = InvocationUtils.invokeAndWait(new Callable<Number>(){

                @Override
                public Number call() throws Exception {
                    AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                    if (accessibleValue == null) {
                        return null;
                    }
                    return accessibleValue.getMinimumAccessibleValue();
                }
            }, accessibleContext);
            if (number != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getMinimumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    private void addAccessibleSelectionFromContext(final AccessibleContext accessibleContext, final int n) {
        try {
            InvocationUtils.invokeAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AccessibleSelection accessibleSelection;
                    if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                        accessibleSelection.addAccessibleSelection(n);
                    }
                    return null;
                }
            }, accessibleContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearAccessibleSelectionFromContext(final AccessibleContext accessibleContext) {
        try {
            InvocationUtils.invokeAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                    if (accessibleSelection != null) {
                        accessibleSelection.clearAccessibleSelection();
                    }
                    return null;
                }
            }, accessibleContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AccessibleContext getAccessibleSelectionFromContext(final AccessibleContext accessibleContext, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleSelection accessibleSelection;
                if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                    Accessible accessible = accessibleSelection.getAccessibleSelection(n);
                    if (accessible == null) {
                        return null;
                    }
                    return accessible.getAccessibleContext();
                }
                return null;
            }
        }, accessibleContext);
    }

    private int getAccessibleSelectionCountFromContext(final AccessibleContext accessibleContext) {
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleSelection accessibleSelection;
                if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                    return accessibleSelection.getAccessibleSelectionCount();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private boolean isAccessibleChildSelectedFromContext(final AccessibleContext accessibleContext, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleSelection accessibleSelection;
                if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                    return accessibleSelection.isAccessibleChildSelected(n);
                }
                return false;
            }
        }, accessibleContext);
    }

    private void removeAccessibleSelectionFromContext(final AccessibleContext accessibleContext, final int n) {
        InvocationUtils.invokeAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AccessibleSelection accessibleSelection;
                if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                    accessibleSelection.removeAccessibleSelection(n);
                }
                return null;
            }
        }, accessibleContext);
    }

    private void selectAllAccessibleSelectionFromContext(final AccessibleContext accessibleContext) {
        InvocationUtils.invokeAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AccessibleSelection accessibleSelection;
                if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                    accessibleSelection.selectAllAccessibleSelection();
                }
                return null;
            }
        }, accessibleContext);
    }

    private AccessibleTable getAccessibleTableFromContext(final AccessibleContext accessibleContext) {
        String string = this.getJavaVersionProperty();
        if (string != null && string.compareTo("1.3") >= 0) {
            return InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

                @Override
                public AccessibleTable call() throws Exception {
                    AccessibleTable accessibleTable;
                    if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                        AccessBridge.this.hashtab.put(accessibleTable, accessibleContext);
                        return accessibleTable;
                    }
                    return null;
                }
            }, accessibleContext);
        }
        return null;
    }

    private AccessibleContext getContextFromAccessibleTable(AccessibleTable accessibleTable) {
        return this.hashtab.get(accessibleTable);
    }

    private int getAccessibleTableRowCount(final AccessibleContext accessibleContext) {
        this.debugString("##### getAccessibleTableRowCount");
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleTable accessibleTable;
                if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                    return accessibleTable.getAccessibleRowCount();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private int getAccessibleTableColumnCount(final AccessibleContext accessibleContext) {
        this.debugString("##### getAccessibleTableColumnCount");
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleTable accessibleTable;
                if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                    return accessibleTable.getAccessibleColumnCount();
                }
                return -1;
            }
        }, accessibleContext);
    }

    private AccessibleContext getAccessibleTableCellAccessibleContext(final AccessibleTable accessibleTable, final int n, final int n2) {
        this.debugString("getAccessibleTableCellAccessibleContext: at = " + accessibleTable.getClass());
        if (accessibleTable == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                if (!(accessibleTable instanceof AccessibleContext)) {
                    Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
                    if (accessible != null) {
                        return accessible.getAccessibleContext();
                    }
                } else {
                    AccessibleContext accessibleContext = (AccessibleContext)((Object)accessibleTable);
                    Accessible accessible = accessibleContext.getAccessibleParent();
                    if (accessible != null) {
                        int n3 = accessibleContext.getAccessibleIndexInParent();
                        Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n3);
                        if (accessible2 instanceof JTable) {
                            Serializable serializable;
                            JTable jTable = (JTable)accessible2;
                            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
                            if (tableCellRenderer == null) {
                                serializable = jTable.getColumnClass(n2);
                                tableCellRenderer = jTable.getDefaultRenderer((Class<?>)serializable);
                            }
                            if ((serializable = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n, n2), false, false, n, n2)) instanceof Accessible) {
                                return ((Component)serializable).getAccessibleContext();
                            }
                        }
                    }
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private int getAccessibleTableCellIndex(final AccessibleTable accessibleTable, int n, int n2) {
        this.debugString("##### getAccessibleTableCellIndex: at=" + accessibleTable);
        if (accessibleTable != null) {
            int n3 = n * InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return accessibleTable.getAccessibleColumnCount();
                }
            }, this.getContextFromAccessibleTable(accessibleTable)) + n2;
            this.debugString("   ##### getAccessibleTableCellIndex=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellIndex FAILED");
        return -1;
    }

    private int getAccessibleTableCellRowExtent(final AccessibleTable accessibleTable, final int n, final int n2) {
        this.debugString("##### getAccessibleTableCellRowExtent");
        if (accessibleTable != null) {
            int n3 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return accessibleTable.getAccessibleRowExtentAt(n, n2);
                }
            }, this.getContextFromAccessibleTable(accessibleTable));
            this.debugString("   ##### getAccessibleTableCellRowExtent=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellRowExtent FAILED");
        return -1;
    }

    private int getAccessibleTableCellColumnExtent(final AccessibleTable accessibleTable, final int n, final int n2) {
        this.debugString("##### getAccessibleTableCellColumnExtent");
        if (accessibleTable != null) {
            int n3 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return accessibleTable.getAccessibleColumnExtentAt(n, n2);
                }
            }, this.getContextFromAccessibleTable(accessibleTable));
            this.debugString("   ##### getAccessibleTableCellColumnExtent=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellColumnExtent FAILED");
        return -1;
    }

    private boolean isAccessibleTableCellSelected(final AccessibleTable accessibleTable, final int n, final int n2) {
        this.debugString("##### isAccessibleTableCellSelected: [" + n + "][" + n2 + "]");
        if (accessibleTable == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl = false;
                Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
                if (accessible != null) {
                    AccessibleContext accessibleContext = accessible.getAccessibleContext();
                    if (accessibleContext == null) {
                        return false;
                    }
                    AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                    if (accessibleStateSet != null) {
                        bl = accessibleStateSet.contains(AccessibleState.SELECTED);
                    }
                }
                return bl;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private AccessibleTable getAccessibleTableRowHeader(final AccessibleContext accessibleContext) {
        this.debugString(" #####  getAccessibleTableRowHeader called");
        AccessibleTable accessibleTable = InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

            @Override
            public AccessibleTable call() throws Exception {
                AccessibleTable accessibleTable;
                if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                    return accessibleTable.getAccessibleRowHeader();
                }
                return null;
            }
        }, accessibleContext);
        if (accessibleTable != null) {
            this.hashtab.put(accessibleTable, accessibleContext);
        }
        return accessibleTable;
    }

    private AccessibleTable getAccessibleTableColumnHeader(final AccessibleContext accessibleContext) {
        this.debugString("##### getAccessibleTableColumnHeader");
        if (accessibleContext == null) {
            return null;
        }
        AccessibleTable accessibleTable = InvocationUtils.invokeAndWait(new Callable<AccessibleTable>(){

            @Override
            public AccessibleTable call() throws Exception {
                AccessibleTable accessibleTable;
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible != null) {
                    JTable jTable;
                    int n = accessibleContext.getAccessibleIndexInParent();
                    Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                    if (accessible2 instanceof JTable && (jTable = (JTable)accessible2).getTableHeader() == null) {
                        return null;
                    }
                }
                if ((accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                    return accessibleTable.getAccessibleColumnHeader();
                }
                return null;
            }
        }, accessibleContext);
        if (accessibleTable != null) {
            this.hashtab.put(accessibleTable, accessibleContext);
        }
        return accessibleTable;
    }

    private int getAccessibleTableRowHeaderRowCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString(" #####  getAccessibleTableRowHeaderRowCount called");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableRowHeader(accessibleContext)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (accessibleTable != null) {
                        return accessibleTable.getAccessibleRowCount();
                    }
                    return -1;
                }
            }, accessibleContext);
        }
        return -1;
    }

    private int getAccessibleTableRowHeaderColumnCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString(" #####  getAccessibleTableRowHeaderColumnCount called");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableRowHeader(accessibleContext)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (accessibleTable != null) {
                        return accessibleTable.getAccessibleColumnCount();
                    }
                    return -1;
                }
            }, accessibleContext);
        }
        this.debugString(" ##### getAccessibleTableRowHeaderColumnCount FAILED");
        return -1;
    }

    private int getAccessibleTableColumnHeaderRowCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("##### getAccessibleTableColumnHeaderRowCount");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableColumnHeader(accessibleContext)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (accessibleTable != null) {
                        return accessibleTable.getAccessibleRowCount();
                    }
                    return -1;
                }
            }, accessibleContext);
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderRowCount FAILED");
        return -1;
    }

    private int getAccessibleTableColumnHeaderColumnCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("#####  getAccessibleTableColumnHeaderColumnCount");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableColumnHeader(accessibleContext)) != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (accessibleTable != null) {
                        return accessibleTable.getAccessibleColumnCount();
                    }
                    return -1;
                }
            }, accessibleContext);
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderColumnCount FAILED");
        return -1;
    }

    private AccessibleContext getAccessibleTableRowDescription(final AccessibleTable accessibleTable, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible accessible;
                if (accessibleTable != null && (accessible = accessibleTable.getAccessibleRowDescription(n)) != null) {
                    return accessible.getAccessibleContext();
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private AccessibleContext getAccessibleTableColumnDescription(final AccessibleTable accessibleTable, final int n) {
        if (accessibleTable == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Accessible accessible = accessibleTable.getAccessibleColumnDescription(n);
                if (accessible != null) {
                    return accessible.getAccessibleContext();
                }
                return null;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private int getAccessibleTableRowSelectionCount(final AccessibleTable accessibleTable) {
        if (accessibleTable != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int[] nArray = accessibleTable.getSelectedAccessibleRows();
                    if (nArray != null) {
                        return nArray.length;
                    }
                    return -1;
                }
            }, this.getContextFromAccessibleTable(accessibleTable));
        }
        return -1;
    }

    private int getAccessibleTableRowSelections(final AccessibleTable accessibleTable, final int n) {
        if (accessibleTable != null) {
            return InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int[] nArray = accessibleTable.getSelectedAccessibleRows();
                    if (nArray.length > n) {
                        return nArray[n];
                    }
                    return -1;
                }
            }, this.getContextFromAccessibleTable(accessibleTable));
        }
        return -1;
    }

    private boolean isAccessibleTableRowSelected(final AccessibleTable accessibleTable, final int n) {
        if (accessibleTable == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return accessibleTable.isAccessibleRowSelected(n);
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private boolean isAccessibleTableColumnSelected(final AccessibleTable accessibleTable, final int n) {
        if (accessibleTable == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return accessibleTable.isAccessibleColumnSelected(n);
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private int getAccessibleTableColumnSelectionCount(final AccessibleTable accessibleTable) {
        if (accessibleTable == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int[] nArray = accessibleTable.getSelectedAccessibleColumns();
                if (nArray != null) {
                    return nArray.length;
                }
                return -1;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private int getAccessibleTableColumnSelections(final AccessibleTable accessibleTable, final int n) {
        if (accessibleTable == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int[] nArray = accessibleTable.getSelectedAccessibleColumns();
                if (nArray != null && nArray.length > n) {
                    return nArray[n];
                }
                return -1;
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
    }

    private int getAccessibleTableRow(final AccessibleTable accessibleTable, int n) {
        if (accessibleTable == null) {
            return -1;
        }
        int n2 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleTable.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
        return n / n2;
    }

    private int getAccessibleTableColumn(final AccessibleTable accessibleTable, int n) {
        if (accessibleTable == null) {
            return -1;
        }
        int n2 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleTable.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
        return n % n2;
    }

    private int getAccessibleTableIndex(final AccessibleTable accessibleTable, int n, int n2) {
        if (accessibleTable == null) {
            return -1;
        }
        int n3 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleTable.getAccessibleColumnCount();
            }
        }, this.getContextFromAccessibleTable(accessibleTable));
        return n * n3 + n2;
    }

    private int getAccessibleRelationCount(final AccessibleContext accessibleContext) {
        AccessibleRelationSet accessibleRelationSet;
        String string = this.getJavaVersionProperty();
        if (string != null && string.compareTo("1.3") >= 0 && accessibleContext != null && (accessibleRelationSet = InvocationUtils.invokeAndWait(new Callable<AccessibleRelationSet>(){

            @Override
            public AccessibleRelationSet call() throws Exception {
                return accessibleContext.getAccessibleRelationSet();
            }
        }, accessibleContext)) != null) {
            return accessibleRelationSet.size();
        }
        return 0;
    }

    private String getAccessibleRelationKey(final AccessibleContext accessibleContext, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleRelation[] accessibleRelationArray;
                AccessibleRelationSet accessibleRelationSet;
                if (accessibleContext != null && (accessibleRelationSet = accessibleContext.getAccessibleRelationSet()) != null && (accessibleRelationArray = accessibleRelationSet.toArray()) != null && n >= 0 && n < accessibleRelationArray.length) {
                    return accessibleRelationArray[n].getKey();
                }
                return null;
            }
        }, accessibleContext);
    }

    private int getAccessibleRelationTargetCount(final AccessibleContext accessibleContext, final int n) {
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleRelation[] accessibleRelationArray;
                AccessibleRelationSet accessibleRelationSet;
                if (accessibleContext != null && (accessibleRelationSet = accessibleContext.getAccessibleRelationSet()) != null && (accessibleRelationArray = accessibleRelationSet.toArray()) != null && n >= 0 && n < accessibleRelationArray.length) {
                    Object[] objectArray = accessibleRelationArray[n].getTarget();
                    return objectArray.length;
                }
                return -1;
            }
        }, accessibleContext);
    }

    private AccessibleContext getAccessibleRelationTarget(final AccessibleContext accessibleContext, final int n, final int n2) {
        this.debugString("***** getAccessibleRelationTarget");
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                Object object;
                Object[] objectArray;
                AccessibleRelation[] accessibleRelationArray;
                AccessibleRelationSet accessibleRelationSet;
                if (accessibleContext != null && (accessibleRelationSet = accessibleContext.getAccessibleRelationSet()) != null && (accessibleRelationArray = accessibleRelationSet.toArray()) != null && n >= 0 && n < accessibleRelationArray.length && (objectArray = accessibleRelationArray[n].getTarget()) != null && n2 >= 0 & n2 < objectArray.length && (object = objectArray[n2]) instanceof Accessible) {
                    return ((Accessible)object).getAccessibleContext();
                }
                return null;
            }
        }, accessibleContext);
    }

    private AccessibleHypertext getAccessibleHypertext(final AccessibleContext accessibleContext) {
        this.debugString("getAccessibleHyperlink");
        if (accessibleContext == null) {
            return null;
        }
        AccessibleHypertext accessibleHypertext = InvocationUtils.invokeAndWait(new Callable<AccessibleHypertext>(){

            @Override
            public AccessibleHypertext call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (!(accessibleText instanceof AccessibleHypertext)) {
                    return null;
                }
                return (AccessibleHypertext)accessibleText;
            }
        }, accessibleContext);
        this.hyperTextContextMap.put(accessibleHypertext, accessibleContext);
        return accessibleHypertext;
    }

    private int getAccessibleHyperlinkCount(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleHyperlinkCount");
        if (accessibleContext == null) {
            return 0;
        }
        final AccessibleHypertext accessibleHypertext = this.getAccessibleHypertext(accessibleContext);
        if (accessibleHypertext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleHypertext.getLinkCount();
            }
        }, accessibleContext);
    }

    private AccessibleHyperlink getAccessibleHyperlink(final AccessibleHypertext accessibleHypertext, final int n) {
        this.debugString("getAccessibleHyperlink");
        if (accessibleHypertext == null) {
            return null;
        }
        AccessibleContext accessibleContext = this.hyperTextContextMap.get(accessibleHypertext);
        if (n < 0 || n >= InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleHypertext.getLinkCount();
            }
        }, accessibleContext)) {
            return null;
        }
        AccessibleHyperlink accessibleHyperlink = InvocationUtils.invokeAndWait(new Callable<AccessibleHyperlink>(){

            @Override
            public AccessibleHyperlink call() throws Exception {
                AccessibleHyperlink accessibleHyperlink = accessibleHypertext.getLink(n);
                if (accessibleHyperlink == null || !accessibleHyperlink.isValid()) {
                    return null;
                }
                return accessibleHyperlink;
            }
        }, accessibleContext);
        this.hyperLinkContextMap.put(accessibleHyperlink, accessibleContext);
        return accessibleHyperlink;
    }

    private String getAccessibleHyperlinkText(final AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkText");
        if (accessibleHyperlink == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string = accessibleHyperlink.getAccessibleActionDescription(0);
                if (string != null) {
                    return string.toString();
                }
                return null;
            }
        }, this.hyperLinkContextMap.get(accessibleHyperlink));
    }

    private String getAccessibleHyperlinkURL(final AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkURL");
        if (accessibleHyperlink == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object object = accessibleHyperlink.getAccessibleActionObject(0);
                if (object != null) {
                    return object.toString();
                }
                return null;
            }
        }, this.hyperLinkContextMap.get(accessibleHyperlink));
    }

    private int getAccessibleHyperlinkStartIndex(final AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkStartIndex");
        if (accessibleHyperlink == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleHyperlink.getStartIndex();
            }
        }, this.hyperLinkContextMap.get(accessibleHyperlink));
    }

    private int getAccessibleHyperlinkEndIndex(final AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkEndIndex");
        if (accessibleHyperlink == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleHyperlink.getEndIndex();
            }
        }, this.hyperLinkContextMap.get(accessibleHyperlink));
    }

    private int getAccessibleHypertextLinkIndex(final AccessibleHypertext accessibleHypertext, final int n) {
        this.debugString("getAccessibleHypertextLinkIndex: charIndex = " + n);
        if (accessibleHypertext == null) {
            return -1;
        }
        int n2 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleHypertext.getLinkIndex(n);
            }
        }, this.hyperTextContextMap.get(accessibleHypertext));
        this.debugString("getAccessibleHypertextLinkIndex returning " + n2);
        return n2;
    }

    private boolean activateAccessibleHyperlink(AccessibleContext accessibleContext, final AccessibleHyperlink accessibleHyperlink) {
        if (accessibleHyperlink == null) {
            return false;
        }
        boolean bl = InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return accessibleHyperlink.doAccessibleAction(0);
            }
        }, accessibleContext);
        this.debugString("activateAccessibleHyperlink: returning = " + bl);
        return bl;
    }

    private KeyStroke getMnemonic(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<KeyStroke>(){

            @Override
            public KeyStroke call() throws Exception {
                Object object;
                AccessibleKeyBinding accessibleKeyBinding;
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (!(accessibleComponent instanceof AccessibleExtendedComponent)) {
                    return null;
                }
                AccessibleExtendedComponent accessibleExtendedComponent = (AccessibleExtendedComponent)accessibleComponent;
                if (accessibleExtendedComponent != null && (accessibleKeyBinding = accessibleExtendedComponent.getAccessibleKeyBinding()) != null && (object = accessibleKeyBinding.getAccessibleKeyBinding(0)) instanceof KeyStroke) {
                    return (KeyStroke)object;
                }
                return null;
            }
        }, accessibleContext);
    }

    private KeyStroke getAccelerator(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<KeyStroke>(){

            @Override
            public KeyStroke call() throws Exception {
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible instanceof Accessible) {
                    int n = accessibleContext.getAccessibleIndexInParent();
                    Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                    if (accessible2 instanceof JMenuItem) {
                        JMenuItem jMenuItem = (JMenuItem)accessible2;
                        if (jMenuItem == null) {
                            return null;
                        }
                        KeyStroke keyStroke = jMenuItem.getAccelerator();
                        return keyStroke;
                    }
                }
                return null;
            }
        }, accessibleContext);
    }

    private int fKeyNumber(KeyStroke keyStroke) {
        String string;
        if (keyStroke == null) {
            return 0;
        }
        int n = 0;
        String string2 = KeyEvent.getKeyText(keyStroke.getKeyCode());
        if (string2 != null && (string2.length() == 2 || string2.length() == 3) && (string = string2.substring(0, 1)).equals("F")) {
            try {
                int n2 = Integer.parseInt(string2.substring(1));
                if (n2 >= 1 && n2 <= 24) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private int controlCode(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return 0;
        }
        int n = keyStroke.getKeyCode();
        switch (n) {
            case 8: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 127: 
            case 155: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private char getKeyChar(KeyStroke keyStroke) {
        CharSequence charSequence;
        if (keyStroke == null) {
            return '\u0000';
        }
        int n = this.fKeyNumber(keyStroke);
        if (n != 0) {
            this.debugString("   Shortcut is: F" + n);
            return (char)n;
        }
        int n2 = this.controlCode(keyStroke);
        if (n2 != 0) {
            this.debugString("   Shortcut is control character: " + Integer.toHexString(n2));
            return (char)n2;
        }
        String string = KeyEvent.getKeyText(keyStroke.getKeyCode());
        this.debugString("   Shortcut is: " + string);
        if (!(string == null && string.length() <= 0 || (charSequence = string.subSequence(0, 1)) == null && charSequence.length() <= 0)) {
            return charSequence.charAt(0);
        }
        return '\u0000';
    }

    private int getModifiers(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return 0;
        }
        this.debugString("In AccessBridge.getModifiers");
        int n = 0;
        if (this.fKeyNumber(keyStroke) != 0) {
            n |= 0x100;
        }
        if (this.controlCode(keyStroke) != 0) {
            n |= 0x200;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(keyStroke.toString());
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("met")) {
                this.debugString("   found meta");
                n |= 4;
            }
            if (string.startsWith("ctr")) {
                this.debugString("   found ctrl");
                n |= 2;
            }
            if (string.startsWith("alt")) {
                this.debugString("   found alt");
                n |= 8;
            }
            if (!string.startsWith("shi")) continue;
            this.debugString("   found shift");
            n |= 1;
        }
        this.debugString("   returning modifiers: 0x" + Integer.toHexString(n));
        return n;
    }

    private int getAccessibleKeyBindingsCount(AccessibleContext accessibleContext) {
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return 0;
        }
        int n = 0;
        if (this.getMnemonic(accessibleContext) != null) {
            ++n;
        }
        if (this.getAccelerator(accessibleContext) != null) {
            ++n;
        }
        return n;
    }

    private char getAccessibleKeyBindingChar(AccessibleContext accessibleContext, int n) {
        KeyStroke keyStroke;
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return '\u0000';
        }
        if (n == 0 && this.getMnemonic(accessibleContext) == null && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getKeyChar(keyStroke);
        }
        if (n == 0 ? (keyStroke = this.getMnemonic(accessibleContext)) != null : n == 1 && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getKeyChar(keyStroke);
        }
        return '\u0000';
    }

    private int getAccessibleKeyBindingModifiers(AccessibleContext accessibleContext, int n) {
        KeyStroke keyStroke;
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return 0;
        }
        if (n == 0 && this.getMnemonic(accessibleContext) == null && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getModifiers(keyStroke);
        }
        if (n == 0 ? (keyStroke = this.getMnemonic(accessibleContext)) != null : n == 1 && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getModifiers(keyStroke);
        }
        return 0;
    }

    private int getAccessibleIconsCount(final AccessibleContext accessibleContext) {
        this.debugString("getAccessibleIconsCount");
        if (accessibleContext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                if (accessibleIconArray == null) {
                    return 0;
                }
                return accessibleIconArray.length;
            }
        }, accessibleContext);
    }

    private String getAccessibleIconDescription(final AccessibleContext accessibleContext, final int n) {
        this.debugString("getAccessibleIconDescription: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
                    return null;
                }
                return accessibleIconArray[n].getAccessibleIconDescription();
            }
        }, accessibleContext);
    }

    private int getAccessibleIconHeight(final AccessibleContext accessibleContext, final int n) {
        this.debugString("getAccessibleIconHeight: index = " + n);
        if (accessibleContext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
                    return 0;
                }
                return accessibleIconArray[n].getAccessibleIconHeight();
            }
        }, accessibleContext);
    }

    private int getAccessibleIconWidth(final AccessibleContext accessibleContext, final int n) {
        this.debugString("getAccessibleIconWidth: index = " + n);
        if (accessibleContext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
                    return 0;
                }
                return accessibleIconArray[n].getAccessibleIconWidth();
            }
        }, accessibleContext);
    }

    private int getAccessibleActionsCount(final AccessibleContext accessibleContext) {
        this.debugString("getAccessibleActionsCount");
        if (accessibleContext == null) {
            return 0;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
                if (accessibleAction == null) {
                    return 0;
                }
                return accessibleAction.getAccessibleActionCount();
            }
        }, accessibleContext);
    }

    private String getAccessibleActionName(final AccessibleContext accessibleContext, final int n) {
        this.debugString("getAccessibleActionName: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
                if (accessibleAction == null) {
                    return null;
                }
                return accessibleAction.getAccessibleActionDescription(n);
            }
        }, accessibleContext);
    }

    private boolean doAccessibleActions(final AccessibleContext accessibleContext, final String string) {
        this.debugString("doAccessibleActions: action name = " + string);
        if (accessibleContext == null || string == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int n;
                AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
                if (accessibleAction == null) {
                    return false;
                }
                int n2 = -1;
                int n3 = accessibleAction.getAccessibleActionCount();
                for (n = 0; n < n3; ++n) {
                    String string2 = accessibleAction.getAccessibleActionDescription(n);
                    if (!string.equals(string2)) continue;
                    n2 = n;
                    break;
                }
                if (n2 == -1) {
                    return false;
                }
                n = accessibleAction.doAccessibleAction(n2) ? 1 : 0;
                return n != 0;
            }
        }, accessibleContext);
    }

    private boolean setTextContents(final AccessibleContext accessibleContext, final String string) {
        this.debugString("setTextContents: ac = " + accessibleContext + "; text = " + string);
        if (!(accessibleContext instanceof AccessibleEditableText)) {
            this.debugString("   ac not instanceof AccessibleEditableText: " + accessibleContext);
            return false;
        }
        if (string == null) {
            this.debugString("   text is null");
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                if (!accessibleStateSet.contains(AccessibleState.ENABLED)) {
                    return false;
                }
                ((AccessibleEditableText)((Object)accessibleContext)).setTextContents(string);
                return true;
            }
        }, accessibleContext);
    }

    private AccessibleContext getInternalFrame(AccessibleContext accessibleContext) {
        return this.getParentWithRole(accessibleContext, AccessibleRole.INTERNAL_FRAME.toString());
    }

    private AccessibleContext getTopLevelObject(final AccessibleContext accessibleContext) {
        this.debugString("getTopLevelObject; ac = " + accessibleContext);
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                if (accessibleContext.getAccessibleRole() == AccessibleRole.DIALOG) {
                    return accessibleContext;
                }
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible == null) {
                    return accessibleContext;
                }
                Accessible accessible2 = accessible;
                while (accessible2 != null && accessible2.getAccessibleContext() != null) {
                    AccessibleContext accessibleContext2 = accessible2.getAccessibleContext();
                    if (accessibleContext2 != null && accessibleContext2.getAccessibleRole() == AccessibleRole.DIALOG) {
                        return accessibleContext2;
                    }
                    accessible = accessible2;
                    accessible2 = accessible.getAccessibleContext().getAccessibleParent();
                }
                return accessible.getAccessibleContext();
            }
        }, accessibleContext);
    }

    private AccessibleContext getParentWithRole(final AccessibleContext accessibleContext, final String string) {
        this.debugString("getParentWithRole; ac = " + accessibleContext);
        this.debugString("role = " + string);
        if (accessibleContext == null || string == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleRole accessibleRole = (AccessibleRole)AccessBridge.this.accessibleRoleMap.get(string);
                if (accessibleRole == null) {
                    return accessibleContext;
                }
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible == null && accessibleContext.getAccessibleRole() == accessibleRole) {
                    return accessibleContext;
                }
                Accessible accessible2 = accessible;
                AccessibleContext accessibleContext2 = null;
                while (accessible2 != null && (accessibleContext2 = accessible2.getAccessibleContext()) != null) {
                    AccessibleRole accessibleRole2 = accessibleContext2.getAccessibleRole();
                    if (accessibleRole2 == accessibleRole) {
                        return accessibleContext2;
                    }
                    accessible = accessible2;
                    accessible2 = accessible.getAccessibleContext().getAccessibleParent();
                }
                return null;
            }
        }, accessibleContext);
    }

    private AccessibleContext getParentWithRoleElseRoot(AccessibleContext accessibleContext, String string) {
        AccessibleContext accessibleContext2 = this.getParentWithRole(accessibleContext, string);
        if (accessibleContext2 == null) {
            accessibleContext2 = this.getTopLevelObject(accessibleContext);
        }
        return accessibleContext2;
    }

    private int getObjectDepth(final AccessibleContext accessibleContext) {
        this.debugString("getObjectDepth: ac = " + accessibleContext);
        if (accessibleContext == null) {
            return -1;
        }
        return InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int n = 0;
                Accessible accessible = accessibleContext.getAccessibleParent();
                if (accessible == null) {
                    return n;
                }
                Accessible accessible2 = accessible;
                while (accessible2 != null && accessible2.getAccessibleContext() != null) {
                    accessible = accessible2;
                    accessible2 = accessible.getAccessibleContext().getAccessibleParent();
                    ++n;
                }
                return n;
            }
        }, accessibleContext);
    }

    private AccessibleContext getActiveDescendent(final AccessibleContext accessibleContext) {
        Accessible accessible;
        this.debugString("getActiveDescendent: ac = " + accessibleContext);
        if (accessibleContext == null) {
            return null;
        }
        final Accessible accessible2 = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                return accessibleContext.getAccessibleParent();
            }
        }, accessibleContext);
        if (accessible2 != null && (accessible = InvocationUtils.invokeAndWait(new Callable<Accessible>(){

            @Override
            public Accessible call() throws Exception {
                int n = accessibleContext.getAccessibleIndexInParent();
                return accessible2.getAccessibleContext().getAccessibleChild(n);
            }
        }, accessibleContext)) instanceof JTree) {
            final JTree jTree = (JTree)accessible;
            return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    return new AccessibleJTreeNode(jTree, jTree.getSelectionPath(), null);
                }
            }, accessible);
        }
        return InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

            @Override
            public AccessibleContext call() throws Exception {
                AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return null;
                }
                if (accessibleSelection.getAccessibleSelectionCount() != 1) {
                    return null;
                }
                Accessible accessible = accessibleSelection.getAccessibleSelection(0);
                if (accessible == null) {
                    return null;
                }
                return accessible.getAccessibleContext();
            }
        }, accessibleContext);
    }

    private String getJAWSAccessibleName(final AccessibleContext accessibleContext) {
        this.debugString("getJAWSAccessibleName");
        if (accessibleContext == null) {
            return null;
        }
        return InvocationUtils.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return accessibleContext.getAccessibleName();
            }
        }, accessibleContext);
    }

    private boolean requestFocus(final AccessibleContext accessibleContext) {
        this.debugString("requestFocus");
        if (accessibleContext == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return false;
                }
                accessibleComponent.requestFocus();
                return accessibleContext.getAccessibleStateSet().contains(AccessibleState.FOCUSED);
            }
        }, accessibleContext);
    }

    private boolean selectTextRange(final AccessibleContext accessibleContext, final int n, final int n2) {
        this.debugString("selectTextRange: start = " + n + "; end = " + n2);
        if (accessibleContext == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (!(accessibleText instanceof AccessibleEditableText)) {
                    return false;
                }
                ((AccessibleEditableText)accessibleText).selectText(n, n2);
                boolean bl = accessibleText.getSelectionStart() == n && accessibleText.getSelectionEnd() == n2;
                return bl;
            }
        }, accessibleContext);
    }

    private boolean setCaretPosition(final AccessibleContext accessibleContext, final int n) {
        this.debugString("setCaretPosition: position = " + n);
        if (accessibleContext == null) {
            return false;
        }
        return InvocationUtils.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (!(accessibleText instanceof AccessibleEditableText)) {
                    return false;
                }
                ((AccessibleEditableText)accessibleText).selectText(n, n);
                return accessibleText.getCaretPosition() == n;
            }
        }, accessibleContext);
    }

    private int getVisibleChildrenCount(AccessibleContext accessibleContext) {
        this.debugString("getVisibleChildrenCount");
        if (accessibleContext == null) {
            return -1;
        }
        this._visibleChildrenCount = 0;
        this._getVisibleChildrenCount(accessibleContext);
        this.debugString("  _visibleChildrenCount = " + this._visibleChildrenCount);
        return this._visibleChildrenCount;
    }

    private void _getVisibleChildrenCount(final AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return;
        }
        int n = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleContext.getAccessibleChildrenCount();
            }
        }, accessibleContext);
        for (int i = 0; i < n; ++i) {
            final int n2 = i;
            final AccessibleContext accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    if (accessible != null) {
                        return accessible.getAccessibleContext();
                    }
                    return null;
                }
            }, accessibleContext);
            if (accessibleContext2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return accessibleContext2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                }
            }, accessibleContext).booleanValue()) continue;
            ++this._visibleChildrenCount;
            if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return accessibleContext2.getAccessibleChildrenCount();
                }
            }, accessibleContext) <= 0) continue;
            this._getVisibleChildrenCount(accessibleContext2);
        }
    }

    private AccessibleContext getVisibleChild(AccessibleContext accessibleContext, int n) {
        this.debugString("getVisibleChild: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        this._visibleChild = null;
        this._currentVisibleIndex = 0;
        this._foundVisibleChild = false;
        this._getVisibleChild(accessibleContext, n);
        if (this._visibleChild != null) {
            this.debugString("    getVisibleChild: found child = " + InvocationUtils.invokeAndWait(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return AccessBridge.this._visibleChild.getAccessibleName();
                }
            }, accessibleContext));
        }
        return this._visibleChild;
    }

    private void _getVisibleChild(final AccessibleContext accessibleContext, int n) {
        if (this._visibleChild != null) {
            return;
        }
        int n2 = InvocationUtils.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return accessibleContext.getAccessibleChildrenCount();
            }
        }, accessibleContext);
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            final AccessibleContext accessibleContext2 = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                @Override
                public AccessibleContext call() throws Exception {
                    Accessible accessible = accessibleContext.getAccessibleChild(n3);
                    if (accessible == null) {
                        return null;
                    }
                    return accessible.getAccessibleContext();
                }
            }, accessibleContext);
            if (accessibleContext2 == null || !InvocationUtils.invokeAndWait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return accessibleContext2.getAccessibleStateSet().contains(AccessibleState.SHOWING);
                }
            }, accessibleContext).booleanValue()) continue;
            if (!this._foundVisibleChild && this._currentVisibleIndex == n) {
                this._visibleChild = accessibleContext2;
                this._foundVisibleChild = true;
                return;
            }
            ++this._currentVisibleIndex;
            if (InvocationUtils.invokeAndWait(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return accessibleContext2.getAccessibleChildrenCount();
                }
            }, accessibleContext) <= 0) continue;
            this._getVisibleChild(accessibleContext2, n);
        }
    }

    private native void propertyCaretChange(PropertyChangeEvent var1, AccessibleContext var2, int var3, int var4);

    private native void propertyDescriptionChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyNameChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertySelectionChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyStateChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyTextChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyValueChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    private native void propertyVisibleDataChange(PropertyChangeEvent var1, AccessibleContext var2);

    private native void propertyChildChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    private native void propertyActiveDescendentChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    private native void javaShutdown();

    private native void focusGained(FocusEvent var1, AccessibleContext var2);

    private native void focusLost(FocusEvent var1, AccessibleContext var2);

    private native void caretUpdate(CaretEvent var1, AccessibleContext var2);

    private native void mouseClicked(MouseEvent var1, AccessibleContext var2);

    private native void mouseEntered(MouseEvent var1, AccessibleContext var2);

    private native void mouseExited(MouseEvent var1, AccessibleContext var2);

    private native void mousePressed(MouseEvent var1, AccessibleContext var2);

    private native void mouseReleased(MouseEvent var1, AccessibleContext var2);

    private native void menuCanceled(MenuEvent var1, AccessibleContext var2);

    private native void menuDeselected(MenuEvent var1, AccessibleContext var2);

    private native void menuSelected(MenuEvent var1, AccessibleContext var2);

    private native void popupMenuCanceled(PopupMenuEvent var1, AccessibleContext var2);

    private native void popupMenuWillBecomeInvisible(PopupMenuEvent var1, AccessibleContext var2);

    private native void popupMenuWillBecomeVisible(PopupMenuEvent var1, AccessibleContext var2);

    private void addJavaEventNotification(final long l) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.addJavaEventNotification(l);
            }
        });
    }

    private void removeJavaEventNotification(final long l) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.removeJavaEventNotification(l);
            }
        });
    }

    private void addAccessibilityEventNotification(final long l) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.addAccessibilityEventNotification(l);
            }
        });
    }

    private void removeAccessibilityEventNotification(final long l) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessBridge.this.eventHandler.removeAccessibilityEventNotification(l);
            }
        });
    }

    static {
        windowHandleToContextMap = new ConcurrentHashMap();
        contextToWindowHandleMap = new ConcurrentHashMap();
        nativeWindowHandlers = new Vector();
    }

    private static class InvocationUtils {
        private InvocationUtils() {
        }

        public static <T> T invokeAndWait(Callable<T> callable, Accessible accessible) {
            if (accessible instanceof Component) {
                return InvocationUtils.invokeAndWait(callable, (Component)((Object)accessible));
            }
            if (accessible instanceof AccessibleContext) {
                return InvocationUtils.invokeAndWait(callable, (AccessibleContext)((Object)accessible));
            }
            throw new RuntimeException("Unmapped Accessible used to dispatch event: " + accessible);
        }

        public static <T> T invokeAndWait(Callable<T> callable, Component component) {
            return InvocationUtils.invokeAndWait(callable, SunToolkit.targetToAppContext(component));
        }

        public static <T> T invokeAndWait(Callable<T> callable, AccessibleContext accessibleContext) {
            Object object;
            AppContext appContext = AWTAccessor.getAccessibleContextAccessor().getAppContext(accessibleContext);
            if (appContext != null) {
                return InvocationUtils.invokeAndWait(callable, appContext);
            }
            if (accessibleContext instanceof Translator && (object = ((Translator)accessibleContext).getSource()) instanceof Component) {
                return InvocationUtils.invokeAndWait(callable, (Component)object);
            }
            throw new RuntimeException("Unmapped AccessibleContext used to dispatch event: " + accessibleContext);
        }

        private static <T> T invokeAndWait(Callable<T> callable, AppContext appContext) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            CallableWrapper<T> callableWrapper = new CallableWrapper<T>(callable, countDownLatch);
            InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), callableWrapper, new Runnable(){

                @Override
                public void run() {
                    countDownLatch.countDown();
                }
            }, false);
            try {
                SunToolkit.postEvent(appContext, invocationEvent);
                countDownLatch.await();
                T t = callableWrapper.getResult();
                InvocationUtils.updateAppContextMap(t, appContext);
                return t;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public static void registerAccessibleContext(AccessibleContext accessibleContext, AppContext appContext) {
            if (accessibleContext != null) {
                AWTAccessor.getAccessibleContextAccessor().setAppContext(accessibleContext, appContext);
            }
        }

        private static <T> void updateAppContextMap(T t, AppContext appContext) {
            if (t instanceof AccessibleContext) {
                InvocationUtils.registerAccessibleContext((AccessibleContext)t, appContext);
            }
        }

        private static class CallableWrapper<T>
        implements Runnable {
            private final Callable<T> callable;
            private final CountDownLatch invokeLatch;
            private T object;
            private Exception e;

            CallableWrapper(Callable<T> callable, CountDownLatch countDownLatch) {
                this.callable = callable;
                this.invokeLatch = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    if (this.callable != null) {
                        this.object = this.callable.call();
                    }
                }
                catch (Exception exception) {
                    this.e = exception;
                }
                finally {
                    this.invokeLatch.countDown();
                }
            }

            T getResult() throws Exception {
                if (this.e != null) {
                    throw this.e;
                }
                return this.object;
            }
        }
    }

    private class AccessibleJTreeNode
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleSelection,
    AccessibleAction {
        private JTree tree = null;
        private TreeModel treeModel = null;
        private Object obj = null;
        private TreePath path = null;
        private Accessible accessibleParent = null;
        private int index = 0;
        private boolean isLeaf = false;

        AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
            this.tree = jTree;
            this.path = treePath;
            this.accessibleParent = accessible;
            if (jTree != null) {
                this.treeModel = jTree.getModel();
            }
            if (treePath != null) {
                this.obj = treePath.getLastPathComponent();
                if (this.treeModel != null && this.obj != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }
            AccessBridge.this.debugString("AccessibleJTreeNode: name = " + this.getAccessibleName() + "; TreePath = " + treePath + "; parent = " + accessible);
        }

        private TreePath getChildTreePath(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount() || this.path == null || this.treeModel == null) {
                return null;
            }
            Object object = this.treeModel.getChild(this.obj, n);
            Object[] objectArray = this.path.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
            return new TreePath(objectArray2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return component.getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            AccessBridge.this.debugString("AccessibleJTreeNode: getCurrentComponent");
            if (this.tree != null && this.tree.isVisible(this.path)) {
                TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                if (treeCellRenderer == null) {
                    AccessBridge.this.debugString("  returning null 1");
                    return null;
                }
                TreeUI treeUI = this.tree.getUI();
                if (treeUI != null) {
                    int n = treeUI.getRowForPath(this.tree, this.path);
                    boolean bl = this.tree.isPathSelected(this.path);
                    boolean bl2 = this.tree.isExpanded(this.path);
                    boolean bl3 = false;
                    Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl, bl2, this.isLeaf, n, bl3);
                    AccessBridge.this.debugString("  returning = " + component.getClass());
                    return component;
                }
            }
            AccessBridge.this.debugString("  returning null 2");
            return null;
        }

        @Override
        public String getAccessibleName() {
            AccessBridge.this.debugString("AccessibleJTreeNode: getAccessibleName");
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                String string = accessibleContext.getAccessibleName();
                if (string != null && !string.isEmpty()) {
                    String string2 = accessibleContext.getAccessibleName();
                    AccessBridge.this.debugString("    returning " + string2);
                    return string2;
                }
                return null;
            }
            if (this.accessibleName != null && this.accessibleName.isEmpty()) {
                return this.accessibleName;
            }
            return null;
        }

        @Override
        public void setAccessibleName(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleName(string);
            } else {
                super.setAccessibleName(string);
            }
        }

        @Override
        public String getAccessibleDescription() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        @Override
        public void setAccessibleDescription(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleDescription(string);
            } else {
                super.setAccessibleDescription(string);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleRole();
            }
            return AccessibleRole.UNKNOWN;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (this.tree == null) {
                return null;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            int n = this.tree.getUI().getRowForPath(this.tree, this.path);
            int n2 = this.tree.getLeadSelectionRow();
            AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
            }
            if (this.tree.isPathSelected(this.path)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            if (n2 == n) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (!this.isLeaf) {
                accessibleStateSet.add(AccessibleState.EXPANDABLE);
            }
            if (this.tree.isExpanded(this.path)) {
                accessibleStateSet.add(AccessibleState.EXPANDED);
            } else {
                accessibleStateSet.add(AccessibleState.COLLAPSED);
            }
            if (this.tree.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null && this.path != null) {
                Object[] objectArray = this.path.getPath();
                if (objectArray.length > 1) {
                    Object object = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(object, this.obj);
                    }
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                    TreePath treePath = new TreePath(objectArray2);
                    this.accessibleParent = new AccessibleJTreeNode(this.tree, treePath, null);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.accessibleParent = this.tree;
                    this.index = 0;
                    this.setAccessibleParent(this.accessibleParent);
                }
            }
            return this.accessibleParent;
        }

        @Override
        public int getAccessibleIndexInParent() {
            Object[] objectArray;
            if (this.accessibleParent == null) {
                this.getAccessibleParent();
            }
            if (this.path != null && (objectArray = this.path.getPath()).length > 1) {
                Object object = objectArray[objectArray.length - 2];
                if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(object, this.obj);
                }
            }
            return this.index;
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (this.obj != null && this.treeModel != null) {
                return this.treeModel.getChildCount(this.obj);
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount() || this.path == null || this.treeModel == null) {
                return null;
            }
            Object object = this.treeModel.getChild(this.obj, n);
            Object[] objectArray = this.path.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
            TreePath treePath = new TreePath(objectArray2);
            return new AccessibleJTreeNode(this.tree, treePath, this);
        }

        @Override
        public Locale getLocale() {
            if (this.tree == null) {
                return null;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getLocale();
            }
            return this.tree.getLocale();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.addPropertyChangeListener(propertyChangeListener);
            } else {
                super.addPropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.removePropertyChangeListener(propertyChangeListener);
            } else {
                super.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && this.isLeaf) {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }
            return this;
        }

        @Override
        public AccessibleText getAccessibleText() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public Color getBackground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getBackground();
            }
            return null;
        }

        @Override
        public void setBackground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }
        }

        @Override
        public Color getForeground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getForeground();
            }
            return null;
        }

        @Override
        public void setForeground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }
        }

        @Override
        public Cursor getCursor() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getCursor();
            }
            Accessible accessible = this.getAccessibleParent();
            if (accessible instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessible)).getCursor();
            }
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }
        }

        @Override
        public Font getFont() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFont();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFont();
            }
            return null;
        }

        @Override
        public void setFont(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFontMetrics(font);
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isEnabled();
            }
            return false;
        }

        @Override
        public void setEnabled(boolean bl) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }
        }

        @Override
        public boolean isVisible() {
            if (this.tree == null) {
                return false;
            }
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            Rectangle rectangle2 = this.tree.getVisibleRect();
            return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return this.tree.isShowing() && this.isVisible();
        }

        @Override
        public boolean contains(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                return rectangle.contains(point);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                return rectangle.contains(point);
            }
            return this.getBounds().contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            if (this.tree != null) {
                Point point = this.tree.getLocationOnScreen();
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (point != null && rectangle != null) {
                    Point point2 = new Point(rectangle.x, rectangle.y);
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }
            return null;
        }

        private Point getLocationInJTree() {
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            if (rectangle != null) {
                return rectangle.getLocation();
            }
            return null;
        }

        @Override
        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return rectangle.getLocation();
            }
            return null;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            if (this.tree == null) {
                return null;
            }
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            Accessible accessible = this.getAccessibleParent();
            if (accessible instanceof AccessibleJTreeNode) {
                Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                if (point != null && rectangle != null) {
                    rectangle.translate(-point.x, -point.y);
                } else {
                    return null;
                }
            }
            return rectangle;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }
        }

        @Override
        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        @Override
        public void setSize(Dimension dimension) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isFocusable();
            }
            return false;
        }

        @Override
        public void requestFocus() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }

        @Override
        public int getAccessibleSelectionCount() {
            int n = 0;
            int n2 = this.getAccessibleChildrenCount();
            for (int i = 0; i < n2; ++i) {
                TreePath treePath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(treePath)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            int n3 = 0;
            for (int i = 0; i < n2 && n >= n3; ++i) {
                TreePath treePath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(treePath)) continue;
                if (n3 == n) {
                    return new AccessibleJTreeNode(this.tree, treePath, this);
                }
                ++n3;
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return false;
            }
            TreePath treePath = this.getChildTreePath(n);
            return this.tree.isPathSelected(treePath);
        }

        @Override
        public void addAccessibleSelection(int n) {
            if (this.tree == null) {
                return;
            }
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                TreePath treePath = this.getChildTreePath(n);
                this.tree.addSelectionPath(treePath);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (this.tree == null) {
                return;
            }
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                TreePath treePath = this.getChildTreePath(n);
                this.tree.removeSelectionPath(treePath);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            if (this.tree == null) {
                return;
            }
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null) {
                int n = this.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    TreePath treePath = this.getChildTreePath(i);
                    this.tree.addSelectionPath(treePath);
                }
            }
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction;
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
            }
            return this.isLeaf ? 0 : 1;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            AccessibleAction accessibleAction;
            if (n < 0 || n >= this.getAccessibleActionCount()) {
                return null;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (n == 0) {
                return "toggle expand";
            }
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.getAccessibleActionDescription(n - 1);
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            AccessibleAction accessibleAction;
            if (n < 0 || n >= this.getAccessibleActionCount()) {
                return false;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (n == 0) {
                if (this.tree.isExpanded(this.path)) {
                    this.tree.collapsePath(this.path);
                } else {
                    this.tree.expandPath(this.path);
                }
                return true;
            }
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.doAccessibleAction(n - 1);
            }
            return false;
        }
    }

    private class EventHandler
    implements PropertyChangeListener,
    FocusListener,
    CaretListener,
    MenuListener,
    PopupMenuListener,
    MouseListener,
    WindowListener,
    ChangeListener {
        private AccessBridge accessBridge;
        private long javaEventMask = 0L;
        private long accessibilityEventMask = 0L;
        private AccessibleContext prevAC = null;
        private boolean stateChangeListenerAdded = false;

        EventHandler(AccessBridge accessBridge2) {
            this.accessBridge = accessBridge2;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            Object object = null;
            if (windowEvent != null) {
                object = windowEvent.getSource();
            }
            if (object instanceof NativeWindowHandler) {
                AccessBridge.addNativeWindowHandler((NativeWindowHandler)object);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            Object object = null;
            if (windowEvent != null) {
                object = windowEvent.getSource();
            }
            if (object instanceof NativeWindowHandler) {
                AccessBridge.removeNativeWindowHandler((NativeWindowHandler)object);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        void addJavaEventNotification(long l) {
            long l2 = this.javaEventMask | l;
            if ((this.javaEventMask & 6L) == 0L && (l2 & 6L) != 0L) {
                SwingEventMonitor.addFocusListener(this);
            }
            if ((this.javaEventMask & 8L) == 0L && (l2 & 8L) != 0L) {
                SwingEventMonitor.addCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (l2 & 0x1F0L) != 0L) {
                SwingEventMonitor.addMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (l2 & 0xE00L) != 0L) {
                SwingEventMonitor.addMenuListener(this);
                SwingEventMonitor.addPopupMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (l2 & 0x7000L) != 0L) {
                SwingEventMonitor.addPopupMenuListener(this);
            }
            this.javaEventMask = l2;
        }

        void removeJavaEventNotification(long l) {
            long l2 = this.javaEventMask & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.javaEventMask & 6L) != 0L && (l2 & 6L) == 0L) {
                SwingEventMonitor.removeFocusListener(this);
            }
            if ((this.javaEventMask & 8L) != 0L && (l2 & 8L) == 0L) {
                SwingEventMonitor.removeCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (l2 & 0x1F0L) != 0L) {
                SwingEventMonitor.removeMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (l2 & 0xE00L) != 0L) {
                SwingEventMonitor.removeMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (l2 & 0x7000L) != 0L) {
                SwingEventMonitor.removePopupMenuListener(this);
            }
            this.javaEventMask = l2;
        }

        void addAccessibilityEventNotification(long l) {
            long l2 = this.accessibilityEventMask | l;
            if ((this.accessibilityEventMask & 0x3FFL) == 0L && (l2 & 0x3FFL) != 0L) {
                AccessibilityEventMonitor.addPropertyChangeListener(this);
            }
            this.accessibilityEventMask = l2;
        }

        void removeAccessibilityEventNotification(long l) {
            long l2 = this.accessibilityEventMask & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.accessibilityEventMask & 0x3FFL) != 0L && (l2 & 0x3FFL) == 0L) {
                AccessibilityEventMonitor.removePropertyChangeListener(this);
            }
            this.accessibilityEventMask = l2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.accessBridge.debugString("propertyChange(" + propertyChangeEvent.toString() + ") called");
            if (propertyChangeEvent != null && (this.accessibilityEventMask & 0x3FFL) != 0L) {
                Object object;
                AccessibleContext accessibleContext;
                Object object2 = propertyChangeEvent.getSource();
                if (object2 instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object2;
                } else {
                    object = Translator.getAccessible(propertyChangeEvent.getSource());
                    if (object == null) {
                        return;
                    }
                    accessibleContext = object.getAccessibleContext();
                }
                if (accessibleContext != null) {
                    InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                    this.accessBridge.debugString("AccessibleContext: " + accessibleContext);
                    object = propertyChangeEvent.getPropertyName();
                    if (((String)object).compareTo("AccessibleCaret") == 0) {
                        int n = 0;
                        int n2 = 0;
                        if (propertyChangeEvent.getOldValue() instanceof Integer) {
                            n = (Integer)propertyChangeEvent.getOldValue();
                        }
                        if (propertyChangeEvent.getNewValue() instanceof Integer) {
                            n2 = (Integer)propertyChangeEvent.getNewValue();
                        }
                        this.accessBridge.debugString(" - about to call propertyCaretChange()");
                        this.accessBridge.debugString("   old value: " + n + "new value: " + n2);
                        this.accessBridge.propertyCaretChange(propertyChangeEvent, accessibleContext, n, n2);
                    } else if (((String)object).compareTo("AccessibleDescription") == 0) {
                        String string = null;
                        String string2 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string2 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.debugString("   old value: " + string + "new value: " + string2);
                        this.accessBridge.propertyDescriptionChange(propertyChangeEvent, accessibleContext, string, string2);
                    } else if (((String)object).compareTo("AccessibleName") == 0) {
                        String string = null;
                        String string3 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string3 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyNameChange()");
                        this.accessBridge.debugString("   old value: " + string + " new value: " + string3);
                        this.accessBridge.propertyNameChange(propertyChangeEvent, accessibleContext, string, string3);
                    } else if (((String)object).compareTo("AccessibleSelection") == 0) {
                        this.accessBridge.debugString(" - about to call propertySelectionChange() " + accessibleContext + "   " + Thread.currentThread() + "   " + propertyChangeEvent.getSource());
                        this.accessBridge.propertySelectionChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleState") == 0) {
                        AccessibleState accessibleState;
                        String string = null;
                        String string4 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            accessibleState = (AccessibleState)propertyChangeEvent.getOldValue();
                            string = accessibleState.toDisplayString(Locale.US);
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            accessibleState = (AccessibleState)propertyChangeEvent.getNewValue();
                            string4 = accessibleState.toDisplayString(Locale.US);
                        }
                        this.accessBridge.debugString(" - about to call propertyStateChange()");
                        this.accessBridge.propertyStateChange(propertyChangeEvent, accessibleContext, string, string4);
                    } else if (((String)object).compareTo("AccessibleText") == 0) {
                        this.accessBridge.debugString(" - about to call propertyTextChange()");
                        this.accessBridge.propertyTextChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleValue") == 0) {
                        String string = null;
                        String string5 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string5 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyValueChange(propertyChangeEvent, accessibleContext, string, string5);
                    } else if (((String)object).compareTo("AccessibleVisibleData") == 0) {
                        this.accessBridge.propertyVisibleDataChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleChild") == 0) {
                        AccessibleContext accessibleContext2 = null;
                        AccessibleContext accessibleContext3 = null;
                        if (propertyChangeEvent.getOldValue() instanceof AccessibleContext) {
                            accessibleContext2 = (AccessibleContext)propertyChangeEvent.getOldValue();
                            InvocationUtils.registerAccessibleContext(accessibleContext2, AppContext.getAppContext());
                        }
                        if (propertyChangeEvent.getNewValue() instanceof AccessibleContext) {
                            accessibleContext3 = (AccessibleContext)propertyChangeEvent.getNewValue();
                            InvocationUtils.registerAccessibleContext(accessibleContext3, AppContext.getAppContext());
                        }
                        this.accessBridge.debugString(" - about to call propertyChildChange()");
                        this.accessBridge.debugString("   old AC: " + accessibleContext2 + "new AC: " + accessibleContext3);
                        this.accessBridge.propertyChildChange(propertyChangeEvent, accessibleContext, accessibleContext2, accessibleContext3);
                    } else if (((String)object).compareTo("AccessibleActiveDescendant") == 0) {
                        this.handleActiveDescendentEvent(propertyChangeEvent, accessibleContext);
                    }
                }
            }
        }

        private void handleActiveDescendentEvent(PropertyChangeEvent propertyChangeEvent, AccessibleContext accessibleContext) {
            Accessible accessible;
            Accessible accessible2;
            if (propertyChangeEvent == null || accessibleContext == null) {
                return;
            }
            AccessibleContext accessibleContext2 = null;
            AccessibleContext accessibleContext3 = null;
            if (propertyChangeEvent.getOldValue() instanceof Accessible) {
                accessibleContext2 = ((Accessible)propertyChangeEvent.getOldValue()).getAccessibleContext();
            } else if (propertyChangeEvent.getOldValue() instanceof Component && (accessible2 = Translator.getAccessible(propertyChangeEvent.getOldValue())) != null) {
                accessibleContext2 = accessible2.getAccessibleContext();
            }
            if (accessibleContext2 != null && (accessible = accessibleContext2.getAccessibleParent()) instanceof JTree) {
                accessibleContext2 = this.prevAC;
            }
            if (propertyChangeEvent.getNewValue() instanceof Accessible) {
                accessibleContext3 = ((Accessible)propertyChangeEvent.getNewValue()).getAccessibleContext();
            } else if (propertyChangeEvent.getNewValue() instanceof Component && (accessible2 = Translator.getAccessible(propertyChangeEvent.getNewValue())) != null) {
                accessibleContext3 = accessible2.getAccessibleContext();
            }
            if (accessibleContext3 != null && (accessible = accessibleContext3.getAccessibleParent()) instanceof JTree) {
                JTree jTree = (JTree)accessible;
                accessibleContext3 = new AccessibleJTreeNode(jTree, jTree.getSelectionPath(), null);
            }
            this.prevAC = accessibleContext3;
            this.accessBridge.debugString("  - about to call propertyActiveDescendentChange()");
            this.accessBridge.debugString("   AC: " + accessibleContext);
            this.accessBridge.debugString("   old AC: " + accessibleContext2 + "new AC: " + accessibleContext3);
            InvocationUtils.registerAccessibleContext(accessibleContext2, AppContext.getAppContext());
            InvocationUtils.registerAccessibleContext(accessibleContext3, AppContext.getAppContext());
            this.accessBridge.propertyActiveDescendentChange(propertyChangeEvent, accessibleContext, accessibleContext2, accessibleContext3);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Accessible accessible;
            if (AccessBridge.this.runningOnJDK1_4) {
                this.processFocusGained();
            } else if ((this.javaEventMask & 2L) != 0L && (accessible = Translator.getAccessible(focusEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, SunToolkit.targetToAppContext(focusEvent.getSource()));
                this.accessBridge.focusGained(focusEvent, accessibleContext);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            if (component instanceof JRootPane) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    Component component2 = menuElementArray[menuElementArray.length - 2].getComponent();
                    Component component3 = menuElementArray[menuElementArray.length - 1].getComponent();
                    if (component3 instanceof JPopupMenu) {
                        FocusEvent focusEvent = new FocusEvent(component2, 1004);
                        AccessibleContext accessibleContext = component2.getAccessibleContext();
                        InvocationUtils.registerAccessibleContext(accessibleContext, SunToolkit.targetToAppContext(component2));
                        this.accessBridge.focusGained(focusEvent, accessibleContext);
                    } else if (component2 instanceof JPopupMenu) {
                        FocusEvent focusEvent = new FocusEvent(component3, 1004);
                        this.accessBridge.debugString(" - about to call focusGained()");
                        AccessibleContext accessibleContext = component3.getAccessibleContext();
                        InvocationUtils.registerAccessibleContext(accessibleContext, SunToolkit.targetToAppContext(component3));
                        this.accessBridge.debugString("   AC: " + accessibleContext);
                        this.accessBridge.focusGained(focusEvent, accessibleContext);
                    }
                }
            } else if (component instanceof Accessible) {
                FocusEvent focusEvent = new FocusEvent(component, 1004);
                this.accessBridge.debugString(" - about to call focusGained()");
                AccessibleContext accessibleContext = component.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, SunToolkit.targetToAppContext(component));
                this.accessBridge.debugString("   AC: " + accessibleContext);
                this.accessBridge.focusGained(focusEvent, accessibleContext);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Accessible accessible;
            if (focusEvent != null && (this.javaEventMask & 4L) != 0L && (accessible = Translator.getAccessible(focusEvent.getSource())) != null) {
                this.accessBridge.debugString(" - about to call focusLost()");
                this.accessBridge.debugString("   AC: " + accessible.getAccessibleContext());
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.focusLost(focusEvent, accessibleContext);
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            Accessible accessible;
            if (caretEvent != null && (this.javaEventMask & 8L) != 0L && (accessible = Translator.getAccessible(caretEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.caretUpdate(caretEvent, accessibleContext);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Accessible accessible;
            if (mouseEvent != null && (this.javaEventMask & 0x10L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.mouseClicked(mouseEvent, accessibleContext);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Accessible accessible;
            if (mouseEvent != null && (this.javaEventMask & 0x20L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.mouseEntered(mouseEvent, accessibleContext);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Accessible accessible;
            if (mouseEvent != null && (this.javaEventMask & 0x40L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.mouseExited(mouseEvent, accessibleContext);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Accessible accessible;
            if (mouseEvent != null && (this.javaEventMask & 0x80L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.mousePressed(mouseEvent, accessibleContext);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Accessible accessible;
            if (mouseEvent != null && (this.javaEventMask & 0x100L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.mouseReleased(mouseEvent, accessibleContext);
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            Accessible accessible;
            if (menuEvent != null && (this.javaEventMask & 0x200L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.menuCanceled(menuEvent, accessibleContext);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            Accessible accessible;
            if (menuEvent != null && (this.javaEventMask & 0x400L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.menuDeselected(menuEvent, accessibleContext);
            }
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            Accessible accessible;
            if (menuEvent != null && (this.javaEventMask & 0x800L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.menuSelected(menuEvent, accessibleContext);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if (popupMenuEvent != null && (this.javaEventMask & 0x1000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.popupMenuCanceled(popupMenuEvent, accessibleContext);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if (popupMenuEvent != null && (this.javaEventMask & 0x2000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.popupMenuWillBecomeInvisible(popupMenuEvent, accessibleContext);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if (popupMenuEvent != null && (this.javaEventMask & 0x4000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                InvocationUtils.registerAccessibleContext(accessibleContext, AppContext.getAppContext());
                this.accessBridge.popupMenuWillBecomeVisible(popupMenuEvent, accessibleContext);
            }
        }
    }

    private class ObjectReferences {
        private ConcurrentHashMap<Object, Reference> refs = new ConcurrentHashMap(4);

        ObjectReferences() {
        }

        String dump() {
            return this.refs.toString();
        }

        void increment(Object object) {
            if (object == null) {
                AccessBridge.this.debugString("ObjectReferences::increment - Passed in object is null");
                return;
            }
            if (this.refs.containsKey(object)) {
                this.refs.get(object).value++;
            } else {
                this.refs.put(object, new Reference(1));
            }
        }

        void decrement(Object object) {
            Reference reference = this.refs.get(object);
            if (reference != null) {
                reference.value--;
                if (reference.value == 0) {
                    this.refs.remove(object);
                } else if (reference.value < 0) {
                    AccessBridge.this.debugString("ERROR: decrementing reference count below 0");
                }
            } else {
                AccessBridge.this.debugString("ERROR: object to decrement not in ObjectReferences table");
            }
        }

        private class Reference {
            private int value;

            Reference(int n) {
                this.value = n;
            }

            public String toString() {
                return "refCount: " + this.value;
            }
        }
    }

    private class DefaultNativeWindowHandler
    implements NativeWindowHandler {
        private DefaultNativeWindowHandler() {
        }

        @Override
        public Accessible getAccessibleFromNativeWindowHandle(int n) {
            final Component component = this.getComponentFromNativeWindowHandle(n);
            if (component instanceof Accessible) {
                AccessibleContext accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                    @Override
                    public AccessibleContext call() throws Exception {
                        return component.getAccessibleContext();
                    }
                }, component);
                AccessBridge.this.saveContextToWindowHandleMapping(accessibleContext, n);
                return (Accessible)((Object)component);
            }
            return null;
        }

        private Component getComponentFromNativeWindowHandle(int n) {
            if (AccessBridge.this.useJAWT_DLL) {
                AccessBridge.this.debugString("*** calling jawtGetComponentFromNativeWindowHandle");
                return AccessBridge.this.jawtGetComponentFromNativeWindowHandle(n);
            }
            AccessBridge.this.debugString("*** calling javaGetComponentFromNativeWindowHandle");
            Object[] objectArray = new Object[1];
            if (AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod != null) {
                try {
                    objectArray[0] = n;
                    Object object = AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)AccessBridge.this.toolkit, objectArray);
                    if (object instanceof Accessible) {
                        final Accessible accessible = (Accessible)object;
                        AccessibleContext accessibleContext = InvocationUtils.invokeAndWait(new Callable<AccessibleContext>(){

                            @Override
                            public AccessibleContext call() throws Exception {
                                return accessible.getAccessibleContext();
                            }
                        }, (Component)object);
                        AccessBridge.this.saveContextToWindowHandleMapping(accessibleContext, n);
                    }
                    return (Component)object;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    AccessBridge.this.debugString("Exception: " + reflectiveOperationException.toString());
                }
            }
            return null;
        }
    }

    private static interface NativeWindowHandler {
        public Accessible getAccessibleFromNativeWindowHandle(int var1);
    }

    private class shutdownHook
    implements Runnable {
        private shutdownHook() {
        }

        @Override
        public void run() {
            AccessBridge.this.debugString("***** shutdownHook: shutting down...");
            AccessBridge.this.javaShutdown();
        }
    }

    private class dllRunner
    implements Runnable {
        private dllRunner() {
        }

        @Override
        public void run() {
            AccessBridge.this.runDLL();
        }
    }
}

