/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OTPEncryptionService1 {
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final String SECRET_KEY_STRING = "0123456789abcdef0123456789abcdef";
    private static final SecretKey SECRET_KEY = new SecretKeySpec("0123456789abcdef0123456789abcdef".getBytes(), "AES");

    public static String encryptOTP(String otp) throws Exception {
        SecretKey key = SECRET_KEY;
        byte[] iv = OTPEncryptionService1.generateIV();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)key, spec);
        byte[] encrypted = cipher.doFinal(otp.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedWithIv = new byte[12 + encrypted.length];
        System.arraycopy(iv, 0, encryptedWithIv, 0, 12);
        System.arraycopy(encrypted, 0, encryptedWithIv, 12, encrypted.length);
        return Base64.getEncoder().encodeToString(encryptedWithIv);
    }

    public static String decryptOTP(String encryptedData) throws Exception {
        byte[] encryptedWithIv = Base64.getDecoder().decode(encryptedData);
        SecretKey key = SECRET_KEY;
        byte[] iv = new byte[12];
        System.arraycopy(encryptedWithIv, 0, iv, 0, 12);
        int encryptedSize = encryptedWithIv.length - 12;
        byte[] encryptedOTP = new byte[encryptedSize];
        System.arraycopy(encryptedWithIv, 12, encryptedOTP, 0, encryptedSize);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)key, spec);
        byte[] decrypted = cipher.doFinal(encryptedOTP);
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[12];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return iv;
    }

    public static void main(String[] args) {
        try {
            String otp = "987654@!#";
            byte[] iv = OTPEncryptionService1.generateIV();
            System.out.println("OTP: " + otp);
            String encryptedOTP = OTPEncryptionService1.encryptOTP(otp);
            System.out.println("Encrypted OTP: " + encryptedOTP);
            String decryptedOTP = OTPEncryptionService1.decryptOTP(encryptedOTP);
            System.out.println("Decrypted OTP: " + decryptedOTP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

