/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OTPEncryptionService {
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final String SECRET_KEY_STRING = "0123456789abcdef0123456789abcdef";
    private static final SecretKey SECRET_KEY = new SecretKeySpec("0123456789abcdef0123456789abcdef".getBytes(), "AES");

    public static String encryptOTP(String otp, SecretKey key, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)key, spec);
        byte[] encrypted = cipher.doFinal(otp.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedWithIv = new byte[12 + encrypted.length];
        System.arraycopy(iv, 0, encryptedWithIv, 0, 12);
        System.arraycopy(encrypted, 0, encryptedWithIv, 12, encrypted.length);
        return Base64.getEncoder().encodeToString(encryptedWithIv);
    }

    public static String decryptOTP(String encryptedData, SecretKey key) throws Exception {
        byte[] encryptedWithIv = Base64.getDecoder().decode(encryptedData);
        byte[] iv = new byte[12];
        System.arraycopy(encryptedWithIv, 0, iv, 0, 12);
        int encryptedSize = encryptedWithIv.length - 12;
        byte[] encryptedOTP = new byte[encryptedSize];
        System.arraycopy(encryptedWithIv, 12, encryptedOTP, 0, encryptedSize);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)key, spec);
        byte[] decrypted = cipher.doFinal(encryptedOTP);
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public static SecretKey generateKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        return keyGen.generateKey();
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[12];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return iv;
    }

    public static void main(String[] args) {
        try {
            String otp = "987654";
            SecretKey key = OTPEncryptionService.generateKey();
            byte[] iv = OTPEncryptionService.generateIV();
            System.out.println(" Key: " + key);
            System.out.println(" OTP: " + otp);
            String encryptedOTP = OTPEncryptionService.encryptOTP(otp, key, iv);
            System.out.println("Encrypted OTP: " + encryptedOTP);
            SecretKey key1 = OTPEncryptionService.generateKey();
            System.out.println(" Key: " + key1);
            String decryptedOTP = OTPEncryptionService.decryptOTP(encryptedOTP, key1);
            System.out.println("Decrypted OTP: " + decryptedOTP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

