/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class EmptyFolderFinderWithRealTimeProgress {
    public static void main(String[] args) throws IOException {
        try {
            if (args.length < 1) {
                System.out.println("Usage: java -jar EmptyFolderFinderWithRealTimeProgress.jar <DirectoryPathToScan>");
                System.exit(1);
            }
            Path startPath = Paths.get(args[0], new String[0]);
            EmptyFolderVisitor visitor = new EmptyFolderVisitor();
            System.out.println("Starting directory scan...");
            Files.walkFileTree(startPath, visitor);
            System.out.println("\nScan completed!");
            System.out.println("Total directories scanned: " + visitor.getTotalScanned());
            System.out.println("Empty folders found: " + visitor.getEmptyFolders().size());
            System.out.println("\nEmpty folders:");
            visitor.getEmptyFolders().forEach(System.out::println);
        }
        catch (Exception e) {
            System.out.println("Error running the program" + e);
            e.printStackTrace();
        }
    }

    static class EmptyFolderVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> emptyFolders = new ArrayList<Path>();
        private final AtomicInteger totalScanned = new AtomicInteger(0);
        private long lastUpdateTime = System.currentTimeMillis();
        private static final long UPDATE_INTERVAL = 100L;

        EmptyFolderVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            int current = this.totalScanned.incrementAndGet();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime >= 100L) {
                System.out.print("\rScanning: " + current + " directories | Current: " + dir.getFileName());
                System.out.flush();
                this.lastUpdateTime = currentTime;
            }
            try {
                if (Files.isHidden(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
            catch (IOException e) {
                System.err.println("\nError accessing directory: " + dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (exc != null) {
                System.err.println("\nError processing directory: " + dir + " - " + exc);
                return FileVisitResult.CONTINUE;
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
                    if (!dirStream.iterator().hasNext()) {
                        this.emptyFolders.add(dir);
                        System.out.print("\rScanning: " + this.totalScanned.get() + " directories | Empty folders found: " + this.emptyFolders.size() + " | Current: " + dir.getFileName());
                        System.out.flush();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (AccessDeniedException e) {
                System.err.println("\nAccess denied to: " + dir);
            }
            catch (IOException e) {
                System.err.println("\nError checking directory: " + dir);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            System.err.println("\nFailed to access file: " + file + " - " + exc);
            return FileVisitResult.CONTINUE;
        }

        public List<Path> getEmptyFolders() {
            return this.emptyFolders;
        }

        public int getTotalScanned() {
            return this.totalScanned.get();
        }
    }
}

