/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DNSResolverDao;
import com.parablu.pcbd.domain.DNSProxyServer;
import com.pg.service.DNSResolverService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;

public class DNSResolverServiceImpl
implements DNSResolverService {
    private static Logger logger = LogManager.getLogger(DNSResolverServiceImpl.class);
    @Autowired
    private CloudDao cloudDao;
    @Autowired
    private DNSResolverDao dnsResolverDao;

    @Override
    public String getPublicIp(String hostname, int cloudId) {
        String publicIp = hostname;
        try {
            List dnsProxyServer = this.dnsResolverDao.getPublicIp(cloudId);
            String dnsServer = null;
            if (!CollectionUtils.isEmpty((Collection)dnsProxyServer) && dnsProxyServer.get(0) != null) {
                dnsServer = ((DNSProxyServer)dnsProxyServer.get(0)).getPublicIp();
            }
            if (StringUtils.isEmpty(dnsServer)) {
                dnsServer = "20.33.60.146";
            }
            SimpleResolver resolver = new SimpleResolver(dnsServer);
            Lookup lookup = new Lookup(hostname, 1);
            lookup.setResolver((Resolver)resolver);
            Record[] records = lookup.run();
            if (lookup.getResult() == 0) {
                for (Record record : records) {
                    if (!(record instanceof ARecord)) continue;
                    ARecord aRecord = (ARecord)record;
                    publicIp = aRecord.getAddress().getHostAddress();
                    logger.debug("IP Address: " + publicIp);
                }
            } else {
                logger.error("Lookup failed: " + lookup.getErrorString());
            }
        }
        catch (Exception e) {
            logger.error("Exception in getting the public ip", (Throwable)e);
            e.printStackTrace();
        }
        return publicIp;
    }

    public void setDnsResolverDao(DNSResolverDao dnsResolverDao) {
        this.dnsResolverDao = dnsResolverDao;
    }
}

