/*
 * Decompiled with CFR 0.152.
 */
package com.pg.pst;

import com.aspose.email.FolderInfo;
import com.pg.pst.MapiMessageCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileWalker
implements FileVisitor<Path> {
    private static Logger logger = LogManager.getLogger(FileWalker.class);
    private AtomicInteger addedFiles;
    private FolderInfo rootFolder;
    private Map<Path, FolderInfo> folderStack;
    private Map<String, Queue<String>> queueStack;
    private File parent;

    public FileWalker(AtomicInteger addedFiles, FolderInfo rootFolder, File parent) {
        this.addedFiles = addedFiles;
        this.rootFolder = rootFolder;
        this.parent = parent;
        this.folderStack = new HashMap<Path, FolderInfo>();
        this.queueStack = new HashMap<String, Queue<String>>();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        try {
            Queue<String> queue = this.queueStack.get(dir.toFile().getAbsolutePath());
            FolderInfo subFolder = this.folderStack.get(dir);
            if (queue == null || subFolder == null) {
                return FileVisitResult.CONTINUE;
            }
            logger.debug("adding files for folder:" + subFolder.getDisplayName() + "..queue size:" + queue.size());
            logger.debug("total number of files added:" + this.addedFiles.get());
            subFolder.addMessages((Iterable)new MapiMessageCollection(queue));
            this.queueStack.remove(dir.toFile().getAbsolutePath());
            this.folderStack.remove(dir);
        }
        catch (Exception e) {
            logger.error("error adding mails into folder bulk:", (Throwable)e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        File currentDir = dir.toFile();
        try {
            if (currentDir.getName().equalsIgnoreCase("merge") || currentDir.getName().equalsIgnoreCase("decrypted")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (currentDir.getName().equalsIgnoreCase(this.parent.getName())) {
                return FileVisitResult.CONTINUE;
            }
            logger.debug("FOLDER TO BE PROCESSED:" + currentDir.getAbsolutePath());
            String subFolderPath = currentDir.getAbsolutePath().substring(this.parent.getAbsolutePath().length() + 1);
            List<String> subFolders = Arrays.asList(subFolderPath.split("/"));
            FolderInfo info = this.rootFolder;
            for (String path : subFolders) {
                try {
                    logger.debug(info.getDisplayName() + "....path:" + path);
                    info = info.addSubFolder(path);
                }
                catch (Exception e) {
                    info = info.getSubFolder(path);
                    logger.error("Error adding the subfoledr:" + e.getMessage() + "subfolder:" + info.getDisplayName());
                }
            }
            this.folderStack.put(dir, info);
            LinkedList currentqueue = new LinkedList();
            this.queueStack.put(currentDir.getAbsolutePath(), currentqueue);
            return FileVisitResult.CONTINUE;
        }
        catch (Exception e) {
            logger.error("Adding folder throws:", (Throwable)e);
            return FileVisitResult.SKIP_SUBTREE;
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        File currentProcessingFile = file.toFile();
        this.queueStack.get(currentProcessingFile.getParent()).offer(currentProcessingFile.getAbsolutePath());
        this.addedFiles.incrementAndGet();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.error("Error adding into pst:" + file.toFile().getAbsolutePath() + "..Error:", (Throwable)exc);
        return FileVisitResult.CONTINUE;
    }
}

