/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML_FORMAT = "HTML Format";
    static final int HTML_FORMATID = HTMLTransfer.registerType("HTML Format");
    static final String NUMBER = "00000000";
    static final String HEADER = "Version:0.9\r\nStartHTML:00000000\r\nEndHTML:00000000\r\nStartFragment:00000000\r\nEndFragment:00000000\r\n";
    static final String PREFIX = "<html><body><!--StartFragment-->";
    static final String SUFFIX = "<!--EndFragment--></body></html>";
    static final String StartFragment = "StartFragment:";
    static final String EndFragment = "EndFragment:";

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        if (n2 == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int n3 = HEADER.length();
        int n4 = n3 + PREFIX.length();
        int n5 = n4 + n2 - 1;
        int n6 = n5 + SUFFIX.length();
        StringBuffer stringBuffer = new StringBuffer(HEADER);
        int n7 = NUMBER.length();
        int n8 = stringBuffer.toString().indexOf(NUMBER);
        String string2 = Integer.toString(n3);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n6);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n4);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        n8 = stringBuffer.toString().indexOf(NUMBER, n8);
        string2 = Integer.toString(n5);
        stringBuffer.replace(n8 + n7 - string2.length(), n8 + n7, string2);
        stringBuffer.append(PREFIX);
        stringBuffer.append(string);
        stringBuffer.append(SUFFIX);
        n = stringBuffer.length();
        cArray = new char[n + 1];
        stringBuffer.getChars(0, n, cArray, 0);
        n2 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        int n9 = OS.GlobalAlloc(64, n2);
        OS.WideCharToMultiByte(65001, 0, cArray, -1, n9, n2, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n9;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n = sTGMEDIUM.unionField;
        try {
            String string;
            char[] cArray;
            int n2;
            block25: {
                int n3;
                int n4;
                int n5;
                block24: {
                    block23: {
                        n5 = OS.GlobalLock(n);
                        if (n5 == 0) {
                            Object var7_7 = null;
                            return var7_7;
                        }
                        n2 = OS.MultiByteToWideChar(65001, 0, n5, -1, null, 0);
                        if (n2 != 0) break block23;
                        Object var8_9 = null;
                        OS.GlobalUnlock(n);
                        return var8_9;
                    }
                    try {
                        int n6;
                        cArray = new char[n2 - 1];
                        OS.MultiByteToWideChar(65001, 0, n5, -1, cArray, cArray.length);
                        String string2 = new String(cArray);
                        n4 = 0;
                        n3 = 0;
                        int n7 = string2.indexOf(StartFragment) + StartFragment.length();
                        for (n6 = n7 + 1; n6 < string2.length(); ++n6) {
                            string = string2.substring(n7, n6);
                            try {
                                n4 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        n7 = string2.indexOf(EndFragment) + EndFragment.length();
                        for (n6 = n7 + 1; n6 < string2.length(); ++n6) {
                            string = string2.substring(n7, n6);
                            try {
                                n3 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        if (n3 > n4 && n3 <= OS.strlen(n5)) break block24;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        OS.GlobalUnlock(n);
                        throw throwable;
                    }
                    OS.GlobalUnlock(n);
                    return string;
                }
                n2 = OS.MultiByteToWideChar(65001, 0, n5 + n4, n3 - n4, cArray, cArray.length);
                if (n2 != 0) break block25;
                string = null;
                OS.GlobalUnlock(n);
                return string;
            }
            string = new String(cArray, 0, n2);
            String string3 = "<!--StartFragment -->\r\n";
            int n8 = string.indexOf(string3);
            if (n8 != -1) {
                string = string.substring(n8 += string3.length());
            }
            String string4 = string;
            OS.GlobalUnlock(n);
            return string4;
        }
        finally {
            OS.GlobalFree(n);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{HTML_FORMATID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{HTML_FORMAT};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

