/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.to.BackupTO;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(ChunkRunnable.class);
    private AtomicInteger chunkedFiles;
    private FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue;
    private BlockingQueue<BackupTO> chunkFileQueue;
    private AtomicBoolean loopFinished;
    private static final String EXCEPTION_OCCURED = "Exception occured: ";

    public ChunkRunnable(AtomicInteger chunkedFiles, FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue, BlockingQueue<BackupTO> chunkFileQueue, AtomicBoolean loopFinished) {
        this.chunkedFiles = chunkedFiles;
        this.fileSizeBlockingQueue = fileSizeBlockingQueue;
        this.chunkFileQueue = chunkFileQueue;
        this.loopFinished = loopFinished;
    }

    @Override
    public void run() {
        int retries = 10;
        int processedFiles = 0;
        while (retries >= 0) {
            block10: {
                if (processedFiles <= this.chunkedFiles.get()) {
                    try {
                        BackupTO backupTO = this.fileSizeBlockingQueue.poll(2L, TimeUnit.SECONDS);
                        if (backupTO != null) {
                            this.chunkFileQueue.put(backupTO);
                            ++processedFiles;
                            retries = 10;
                        } else if (this.loopFinished.get()) {
                            --retries;
                        }
                        break block10;
                    }
                    catch (InterruptedException e) {
                        this.logger.error(EXCEPTION_OCCURED, (Throwable)e);
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error(EXCEPTION_OCCURED, (Throwable)e);
                        break block10;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Interrupted Exception" + e.getMessage());
                }
                --retries;
            }
            this.logger.debug("WAITING FOR BACKUP TO FINISH !loopFinished " + !this.loopFinished.get());
        }
    }
}

