/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ContentEncryptionAlgorithmIdentifier
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public ContentEncryptionAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public ContentEncryptionAlgorithmIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public ContentEncryptionAlgorithmIdentifier(ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier) {
        this.alg = contentEncryptionAlgorithmIdentifier.alg;
    }

    public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public ContentEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static ContentEncryptionAlgorithmIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentEncryptionAlgorithmIdentifier) {
            return (ContentEncryptionAlgorithmIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new ContentEncryptionAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentEncryptionAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentEncryptionAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentEncryptionAlgorithmIdentifier");
    }

    public static ContentEncryptionAlgorithmIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentEncryptionAlgorithmIdentifier) {
            return new ContentEncryptionAlgorithmIdentifier((ContentEncryptionAlgorithmIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new ContentEncryptionAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentEncryptionAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentEncryptionAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentEncryptionAlgorithmIdentifier");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

