; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "ParaBlu BluSync"
#define MyAppVersion "2.3.4.9"
#define MyAppPublisher "ParaBlu"
#define MyAppURL "http://www.parablu.com/"
#define MyAppExeName "BluSync.exe"
#define Mainclass "com/parablu/epa/view/BluSyncLauncher"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
SetupLogging=yes
AppId={{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
;DefaultDirName={code:GetApplicationInstallationPath}
DefaultDirName={%UserProfile}\AppData\Roaming\ParaBlu
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
OutputDir=bin
OutputBaseFilename=combo
Compression=lzma
SolidCompression=no
PrivilegesRequired=admin
DisableDirPage=yes
VersionInfoVersion={#MyAppVersion}
VersionInfoCompany=ParaBlu
VersionInfoDescription=ParaBlu BluSync
VersionInfoProductName=BluSync
VersionInfoProductVersion={#MyAppVersion}
MinVersion=0,5.01sp1
DisableWelcomePage=True
DisableReadyPage=True
DisableReadyMemo=True
DisableFinishedPage=True
Uninstallable=no

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]
Source: "installinfo\Debug\installinfo.exe";Flags: dontcopy;
Source: "bin\Parablu_EPA.exe";Flags: dontcopy; 
Source: "bin\bsupdate.exe";Flags: dontcopy; 

[Messages]
english.SetupWindowTitle=Parablu BluSync Setup Wizard

[Run]
;Filename: "{tmp}\Parablu_EPA.exe"; Parameters: /isSilent={param:isSilent} /cloudName={param:cloudName} /certName={param:certName} /verysilent; WorkingDir: "{tmp}"; Flags: postinstall; Check: getInstallAgent and IsNormalUser;
Filename: "{tmp}\Parablu_EPA.exe"; Parameters:/start={param:start} /exePath={param:exePath} /paraLibName={param:paraLibName} /isSilent={param:isSilent} /cloudName={param:cloudName} /certName={param:certName} /verysilent; WorkingDir: "{tmp}"; Flags: runascurrentuser postinstall; Check: getInstallAgent;
Filename: "{tmp}\bsupdate.exe";  Parameters: /verysilent ;WorkingDir: "{tmp}"; Flags: runascurrentuser postinstall; Check: getInstallUpdate; BeforeInstall: TaskKill('BluSync.exe');
;Filename: "{code:GetApplicationInstallationPath}\BluSync.exe"; Parameters:{param:start} {param:exePath} {param:paraLibName} {#Mainclass} {param:isSilent} {param:cloudName} {param:certName}; WorkingDir: "{code:GetApplicationInstallationPath}"; Flags: nowait postinstall; Check: (Not getInstallAgent) and (Not IsNormalUser);
;Filename: "{code:GetApplicationInstallationPath}\BluSync.exe"; Parameters:{#Mainclass} {param:isSilent} {param:cloudName} {param:certName}; WorkingDir: "{code:GetApplicationInstallationPath}"; Flags: nowait postinstall; Check: Not getInstallAgent and (isInstallationPathContainsUserProfile); 
Filename: "{code:GetApplicationInstallationPath}\BluSync.exe"; Parameters:{param:start} {param:exePath} {param:paraLibName} {#Mainclass} {param:isSilent} {param:cloudName} {param:certName}; WorkingDir: "{code:GetApplicationInstallationPath}"; Flags: nowait postinstall; Check: Not getInstallAgent
;Check: IsNormalUser();

;Filename: "{tmp}\Parablu_EPA.exe"; WorkingDir: "{app}"; Flags: postinstall; Check: getInstallAgent;
;Filename: "{tmp}\bsupdate.exe"; WorkingDir: "{app}"; Flags: postinstall; Check: getInstallUpdate;
;Filename: "{app}\BluSync.exe"; Parameters:{param:start} {param:exePath} {param:paraLibName} {#Mainclass} {param:isSilent} {param:cloudName} {param:cloudIP} {param:certName}; WorkingDir: "{app}"; Flags: nowait postinstall

[code]

Var
  installAgent: boolean;
  installUpdate: boolean;

function isInstallationPathContainsUserProfile(): Boolean;
var
userProfile: String;
installationPath: String;
begin
     userProfile := ExpandConstant('{code:MyConst|UserProfileDirectory }');
     installationPath :=  ExpandConstant('{code:GetApplicationInstallationPath}');
     if Pos(userProfile,installationPath) > 0  then
      begin
        Result:=True;
      end
     else 
      begin
        Result:= False;
      end
end;

function IsNormalUser(): Boolean;
begin
    Result := not (IsAdminLoggedOn or IsPowerUserLoggedOn);
    Log('Parablu_EPA normal user:##'+IntToStr(Integer(Result)));
end;

function IsNormalUserAndWin64(): Boolean;
begin
    Result := not (IsAdminLoggedOn or IsPowerUserLoggedOn);
    if Result then begin
      Result := IsWin64;
    end;
    Log('Parablu_EPA IsNormalUserAndWin64:##'+IntToStr(Integer(Result)));
end;

function IsPowerUserAndWin64(): Boolean;
begin
    Result := (IsAdminLoggedOn or IsPowerUserLoggedOn);

    if Result then begin
        Result := IsWin64;
    end;
     Log('Parablu_EPA IsPowerUserAndWin64:##'+IntToStr(Integer(Result)));
end;

function IsPowerUserAndWin32(): Boolean;
begin
    Result := (IsAdminLoggedOn or IsPowerUserLoggedOn);

    if Result then begin
        Result := not IsWin64;
    end;
     Log('Parablu_EPA IsPowerUserAndWin64:##'+IntToStr(Integer(Result)));
end;



function getInstallAgent(): Boolean;
var
SID: String;
userName: String;
uninstallPath: String;
begin
  Result:=false;
  if not  IsNormalUser() then 
  begin
    SID:= ExpandConstant('{code:MyConst|SID }');
    userName:= ExpandConstant('{code:MyConst|UserName }');
    Log('Combined Installer Admin user SID:#### # '+ SID +' userName:#### # '+userName);

    if IsWin64 and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
    begin
      if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
          'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('Parablu_EPA Installer admin Inastallation found #');
          Result:= false;
        end
      end
    end
    else if (not IsWin64) and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
    begin
      if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
          'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('Parablu_EPA Installer admin Inastallation found #');
          Result:= false;
        end
      end
    end
    else if RegKeyExists(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1') then 
    begin
      if RegQueryStringValue(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1',
         'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('Parablu_EPA Installer Normal Inastallation found #');  
          Result:=false; 
        end
        else
        begin
          Result:=true;
        end
      end
    end
    else
    begin
      Result:=true;
    end
  end
  else
  begin
    Log('Parablu_EPA Installer Normal User #');  
    if RegKeyExists(HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1') then 
    begin
      if RegQueryStringValue(HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1',
         'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Result:=false; 
        end
        else
        begin
          Result:=true;
        end
      end
    end
    else
    begin
      Result:=true;
    end
  end;
  //MsgBox('Install Agent ? :: '+IntToStr(Integer(result)),mbInformation,MB_OK);
  Log('Install Agent ? :: '+IntToStr(Integer(result)));
end;

function getInstallUpdate(): Boolean;
var
SID: String;
userName: String;
installedVersion: String;
currentVersion: String;
begin
  Result:=false;
  currentVersion:='{#SetupSetting("AppVersion")}';
  if not  getInstallAgent() then 
  begin
    if not  IsNormalUser() then 
    begin
      SID:= ExpandConstant('{code:MyConst|SID }');
      userName:= ExpandConstant('{code:MyConst|UserName }');
      Log('Combined update Admin user SID:#### # '+ SID +' userName:#### # '+userName);
    
      if RegKeyExists(HKEY_USERS,SID+'\Software\ParaBlu\BluSync') then 
      begin
        if RegQueryStringValue(HKEY_USERS,SID+'\Software\ParaBlu\BluSync',
        'Version', installedVersion) then
        begin
          if not (installedVersion = currentVersion) then
          begin
            Result:=true;
          end
          else 
          begin
            Result:=false;
          end
        end
      end
    end
    else
    begin
      Log('Parablu_EPA Update Normal User #');
      if RegKeyExists(HKCU,'Software\ParaBlu\BluSync') then 
      begin
        if RegQueryStringValue(HKCU,'Software\ParaBlu\BluSync',
        'Version', installedVersion) then
        begin
          if not (installedVersion = currentVersion) then
          begin
            Result:=true;
          end
          else 
          begin
            Result:=false;
          end
        end
      end
    end
  end;
  //MsgBox('Install Update ? :: '+IntToStr(Integer(Result)),mbInformation,MB_OK);
  Log('Install Update ? :: '+IntToStr(Integer(Result)));
end;

procedure TaskKill(FileName: String);
var
  ResultCode: Integer;
begin
    Exec(ExpandConstant('taskkill.exe'), '/f /t /im ' + '"' + 'ParaLib.exe' + '"', '', SW_HIDE,
     ewWaitUntilTerminated, ResultCode);
    Exec(ExpandConstant('taskkill.exe'), '/f /t /im ' + '"' + FileName + '"', '', SW_HIDE,
     ewWaitUntilTerminated, ResultCode);
      
     Sleep(1000);
end;

function InitializeSetup(): Boolean;
var

installPath: String;
resultCode: Integer;
ErrorCode: Integer;
reInstallExt: Boolean;
infofilePath: String;


begin
  Log('Initialize Setup Parablu_EPA version:# {#MyAppVersion} #');
  result:=true;  
 
  ExtractTemporaryFile('installinfo.exe');
  ExtractTemporaryFile('Parablu_EPA.exe');
  ExtractTemporaryFile('bsupdate.exe');
  infofilePath:= '"'+expandconstant('{tmp}\ParabluInstallationInfo.properties')+'"';
  Log('Parablu_EPA infofilePath:#### #'+infofilePath);

  if not  IsNormalUser() then 
  begin
    if ShellExec('runas', '"'+ExpandConstant('{tmp}\installinfo.exe')+'"', infofilePath, '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then begin
    end;
  end
  else
  begin
    Log('Parablu_EPA Normal User #');
    MsgBox('Admin privilege is required to run this setup.'+#13#10+'Please elevate to admin and try again.',mbInformation,MB_OK);
    result:=false;
  end;
end;

procedure InitializeWizard();
begin
Log('InitializeWizard Parablu_EPA version:# {#MyAppVersion} #');
{WizardForm.BorderStyle := bsNone;
  WizardForm.Width := 0;
  WizardForm.Height := 0;}
 end;

 

// Called just before Setup terminates. Note that this function is called even if the user exits Setup before anything is installed.
procedure DeinitializeSetup();
var
  logfilepathname, logfilename, newfilepathname: string;

begin
  logfilepathname := expandconstant('{log}');
  logfilename := ExtractFileName(logfilepathname);
  // Set the new target path as the directory where the installer is being run from
  newfilepathname := expandconstant('{%UserProfile}\AppData\Local\Temp\ParabluInstallation')+logfilename;
  filecopy(logfilepathname, newfilepathname, false);
end; 


{
  called to uninstall service
}
procedure DeletePbluService();
var
ErrorCode: Integer;
UninsServiceFilePath: String;
reInstallExt: Boolean;
begin
   // Allows webdav basic authentication 
    UninsServiceFilePath:=ExpandConstant('{app}')+'\DeletePbluService.bat';
    reInstallExt:=true;
    while reInstallExt do begin
 // ExtractTemporaryFile('DeletePbluService.bat');
 if ShellExec('runas', UninsServiceFilePath, '', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then begin
 reInstallExt:=false;
 end
  else begin
    if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then begin 
    WizardForm.Close;
    reInstallExt:=false;
    end
    
   end
  end;
end;


{
  called to uninstall service
}
procedure InstallPbluService();
var
resultCode: Integer;
InstallServiceFilePath: String;
reInstallExt: Boolean;
begin
   // Allows webdav basic authentication 
    InstallServiceFilePath:=ExpandConstant('{app}')+'\InstallParaBluSvc.bat';
    reInstallExt:=true;
    while reInstallExt do begin
 // ExtractTemporaryFile('DeletePbluService.bat');
 if ShellExec('runas',InstallServiceFilePath,ExpandConstant('{app}'),'', SW_HIDE, ewWaitUntilTerminated, resultCode) then begin
 reInstallExt:=false;
 end
  else begin
    if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then begin 
    WizardForm.Close;
    reInstallExt:=false;
    end
    
   end
  end;
end;


function GetApplicationInstallationPath(Param: string): string;
var
  installPath: string;
  SID: string;
  regQuery: string;
begin


if IsNormalUser() then 
begin
  if IsWin64 then begin
     if RegQueryStringValue(
       HKCU64,'Software\ParaBlu\BluSync',
         'Path', installPath) then
       begin
        Result := installPath;
        Log('Parablu_EPA installPath from registry as normal user:#  #'+Result);
       end
  end
  else 
  if RegQueryStringValue(
       HKCU,'Software\ParaBlu\BluSync',
         'Path', installPath) then
       begin
        Result := installPath;
        Log('Parablu_EPA installPath from registry as normal user:#  #'+Result);
       end
 end
else begin
SID:= ExpandConstant('{code:MyConst|SID }');
if IsWin64 then
    begin
  if RegQueryStringValue(
       HKU64,SID + '\Software\ParaBlu\BluSync',
         'Path', installPath) then
  begin
    Result := installPath;
    Log('Parablu_EPA installPath from registry:#  #'+Result);
  end
    else
  begin
    Result := ExpandConstant('{code:MyConst|UserProfileDirectory }')+'\AppData\Roaming\ParaBlu';
  end
 end

 else begin
        if RegQueryStringValue(
       HKU,SID + '\Software\ParaBlu\BluSync',
         'Path', installPath) then
  begin
    Result := installPath;
    Log('Parablu_EPA installPath from registry:#  #'+Result);
  end
    else
  begin
    Result := ExpandConstant('{code:MyConst|UserProfileDirectory }')+'\AppData\Roaming\ParaBlu';
  end

  end
 end;
end;

function MyConst(Param: String): String;
var  
  I: Integer;
  KeyPos: Integer;
  KeyFull: string;
  FileLines: TArrayOfString;
  infofilePath: string;
begin
  Result := Param;
  infofilePath:= expandconstant('{tmp}\ParabluInstallationInfo.properties');
  Log('Parablu_EPA install info file path while reading:#  #'+infofilePath);
  if LoadStringsFromFile(infofilePath, FileLines) then
  begin
    Log('Parablu_EPA install info file path:#  #'+FileLines[0]);
    KeyFull := Param + '= ';
    
    for I := 0 to GetArrayLength(FileLines) - 1 do
    begin
      FileLines[I] := TrimLeft(FileLines[I]);
      KeyPos := Pos(KeyFull, FileLines[I]);
      Log('Parablu_EPA install info file path:#1111#'+FileLines[I]+'Key position:'+IntToStr(KeyPos));
      if KeyPos > 0 then
      begin
        Result := Copy(FileLines[I], Length(KeyFull) + 1, MaxInt);
        Result := Trim(Result);
        Log('Parablu_EPA install info file key value:#  #'+Result);
        Break;
      end;
    end;
  end;
end;




