; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "ParaBlu BluSync"
;#define MyAppVersion "2.3.4.9"
#define MyAppVersion version
#define MyAppPublisher "ParaBlu"
#define MyAppURL "http://www.parablu.com/"
#define MyAppExeName "BluSync.exe"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
SetupLogging=yes
AppId={{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}
;AppMutex=ParaBlu
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={code:GetApplicationInstallationPath}
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes
;LicenseFile=Parablu EULA v1.5.rtf
OutputDir=bin
OutputBaseFilename=bsupdate
Compression=lzma
SolidCompression=no
PrivilegesRequired=lowest
DisableDirPage=yes
VersionInfoVersion={#MyAppVersion}
VersionInfoCompany=ParaBlu
VersionInfoDescription=ParaBlu BluSync
VersionInfoProductName=BluSync
VersionInfoProductVersion={#MyAppVersion}
MinVersion=0,5.01sp1
DisableWelcomePage=True
DisableReadyPage=True
DisableReadyMemo=True
DisableFinishedPage=True
Uninstallable=no

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]
Source: "SyncWindows\resource\*"; DestDir: "{code:GetApplicationInstallationPath}\resource"; Flags: ignoreversion createallsubdirs recursesubdirs;Check: Not IsNormalUser
Source: "SyncWindows\resource\*"; DestDir: "{%UserProfile}\AppData\Roaming\ParaBlu\resource"; Flags: ignoreversion createallsubdirs recursesubdirs;Check: IsNormalUser
Source: "ParaLib.exe"; DestDir: "{app}"; Flags: ignoreversion;
Source: "installinfo\Debug\installinfo.exe";Flags: dontcopy;
;Source: "ParaBlu-BluSync-Extensions.exe"; DestDir: "{app}\bin"; Flags: ignoreversion;
;Source: "ParaBluSvc.exe"; DestDir: "{app}"; Flags: ignoreversion;
;Source: "SyncWindows.jar"; DestDir: "{app}"; Flags: ignoreversion
;Source: "splash.jar"; DestDir: "{%UserProfile}\AppData\Roaming\Parablu"; Flags: ignoreversion
;Source: "Parablu_EULA.txt"; DestDir: "{%UserProfile}\AppData\Roaming\Parablu"; Flags: ignoreversion

;Source: "Parablu-log4j.properties"; DestDir: "{userappdata}\ParaBlu\Blusync"
;Source: "SyncWindows\lib\*"; DestDir: "{%UserProfile}\AppData\Roaming\ParaBlu\lib"; Flags: ignoreversion recursesubdirs
;Source: "MVC1032\*"; DestDir: "{app}"; Flags:  recursesubdirs createallsubdirs uninsrestartdelete;
;Source: "shellExtension.jar"; DestDir: "{app}"; Flags: ignoreversion;

;Source: "BluSync.ico"; DestDir: "{app}"; Flags: ignoreversion;
;Source: "folder_icon.ico"; DestDir: "{app}"; Flags: ignoreversion;
;Source: "Parablu.ico"; DestDir: "{app}"; Flags: ignoreversion;
;Source: "try.bat"; DestDir: "{app}"; Flags: ignoreversion;

;Source: "wlForUpdate\WL.properties"; DestDir: "{code:MyConst|UserProfileDirectory }\AppData\Roaming\ParaBlu\BluSync";Flags: ignoreversion;Check: Not IsNormalUser
;Source: "wlForUpdate\WL.properties"; DestDir: "{code:GetApplicationInstallationPath}\Blusync";Flags: ignoreversion;Check: IsNormalUser
Source: "BluSync.exe"; DestDir: "{code:GetApplicationInstallationPath}";Flags: ignoreversion; Check: Not IsNormalUser
Source: "BluSync.exe"; DestDir: "{%UserProfile}\AppData\Roaming\ParaBlu";Flags: ignoreversion; Check: IsNormalUser
Source: "rt\*"; DestDir: "{code:GetApplicationInstallationPath}\rt"; Flags: ignoreversion  onlyifdoesntexist recursesubdirs createallsubdirs;
Source: "Parablu-log4j.properties"; DestDir: "{code:MyConst|UserProfileDirectory }\AppData\Roaming\ParaBlu\Blusync"; Flags: ignoreversion;Check: Not IsNormalUser
Source: "Parablu-log4j.properties"; DestDir: "{code:GetApplicationInstallationPath}\Blusync"; Flags: ignoreversion;Check: IsNormalUser
;Source: "{app}\rt\*"; DestDir: "{code:GetApplicationInstallationPath}\bin\rt"; Flags: ignoreversion  onlyifdoesntexist recursesubdirs createallsubdirs external;

[UninstallDelete]
Type: filesandordirs; Name: "{app}"; 
;Type: filesandordirs; Name: "{code:MyConst|UserProfileDirectory }\AppData\Roaming\ParaBlu"; 


[Messages]
english.SetupWindowTitle=Parablu BluSync Setup Wizard



[Registry]
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; Flags: uninsdeletekey;  Check: IsPowerUserAndWin32;
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: IsPowerUserAndWin32; 
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin32;
Root: HKU; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "UserProfile"; ValueType: "string"; ValueData: "{code:MyConst|UserProfileDirectory }"; Flags: preservestringtype; Check:IsPowerUserAndWin32;
Root: HKU; Subkey: "{code:MyConst|SID }\Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin32 and isUninstallPathUserLevel;
Root: HKLM; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_{code:MyConst|UserName }_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin32 and isUninstallPathMachineLevel;


Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; Flags: uninsdeletekey; Check: IsPowerUserAndWin64; 
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: IsPowerUserAndWin64;
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin64;
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\ParaBlu\BluSync"; ValueName: "UserProfile"; ValueType: "string"; ValueData: "{code:MyConst|UserProfileDirectory }"; Flags: preservestringtype; Check: IsPowerUserAndWin64;
Root: HKU64; Subkey: "{code:MyConst|SID }\Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin64 and isUninstallPathUserLevel;
Root: HKLM; Subkey: "SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_{code:MyConst|UserName }_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsPowerUserAndWin64 and isUninstallPathMachineLevel;

Root: HKCU; Subkey: "Software\ParaBlu\BluSync"; Flags: uninsdeletekey;  Check: Not IsPowerUserAndWin64;
Root: HKCU; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: Not IsPowerUserAndWin64; 
Root: HKCU; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsPowerUserAndWin64;
Root: HKCU; Subkey: "Software\ParaBlu\BluSync"; ValueName: "UserProfile"; ValueType: "string"; ValueData: "{%UserProfile}"; Flags: preservestringtype; Check: Not IsPowerUserAndWin64;
Root: HKCU; Subkey: "Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: Not IsPowerUserAndWin64;

Root: HKCU64; Subkey: "Software\ParaBlu\BluSync"; Flags: uninsdeletekey; Check: IsNormalUserAndWin64; 
Root: HKCU64; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Path"; ValueType: "string"; ValueData: "{app}"; Flags: preservestringtype; Check: IsNormalUserAndWin64;
Root: HKCU64; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Version"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsNormalUserAndWin64;
Root: HKCU64; Subkey: "Software\ParaBlu\BluSync"; ValueName: "UserProfile"; ValueType: "string"; ValueData: "{%UserProfile}"; Flags: preservestringtype; Check: IsNormalUserAndWin64;
Root: HKCU64; Subkey: "Software\Microsoft\Windows\CurrentVersion\Uninstall\{{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1"; ValueName: "DisplayVersion"; ValueType: "string"; ValueData: "{#MyAppVersion}"; Flags: preservestringtype; Check: IsNormalUserAndWin64;

[code]

function IsNormalUser(): Boolean;
begin
    Result := not (IsAdminLoggedOn or IsPowerUserLoggedOn);
    Log('Parablu_EPA normal user:##'+IntToStr(Integer(Result)));
end;

function IsNormalUserAndWin64(): Boolean;
begin
    Result := not (IsAdminLoggedOn or IsPowerUserLoggedOn);
    if Result then begin
      Result := IsWin64;
    end;
    Log('Parablu_EPA IsNormalUserAndWin64:##'+IntToStr(Integer(Result)));
end;

function IsPowerUserAndWin64(): Boolean;
begin
    Result := (IsAdminLoggedOn or IsPowerUserLoggedOn);

    if Result then begin
        Result := IsWin64;
    end;
     Log('Parablu_EPA IsPowerUserAndWin64:##'+IntToStr(Integer(Result)));
end;

function IsPowerUserAndWin32(): Boolean;
begin
    Result := (IsAdminLoggedOn or IsPowerUserLoggedOn);

    if Result then begin
        Result := not IsWin64;
    end;
     Log('Parablu_EPA IsPowerUserAndWin64:##'+IntToStr(Integer(Result)));
end;

function isUninstallPathMachineLevel() : Boolean;
var
uninstallPath: String;
userName: String;
begin
  result:=false;
  userName:= ExpandConstant('{code:MyConst|UserName }');
   if IsWin64 and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
    begin
      if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
         'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('Machine Level');
          result:=true;
        end
      end
    end
    else if (not IsWin64) and RegKeyExists(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1') then 
    begin
      if RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_'+userName+'_is1',
         'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('Machine Level');
          result:=true;
        end
      end
    end
end;

function isUninstallPathUserLevel(): Boolean;
var
uninstallPath: String;
SID: String;
begin
  result:=false;  
  SID:= ExpandConstant('{code:MyConst|SID }');
  if RegKeyExists(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1') then 
    begin
      if RegQueryStringValue(HKU, SID+'\Software\Microsoft\Windows\CurrentVersion\Uninstall\'+'{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_is1',
         'UninstallString', uninstallPath) then
      begin
        if uninstallPath<>'' then
        begin
          Log('User Level');
          result:=true;
        end
      end
    end
end;

function InitializeSetup(): Boolean;
var
installPath: String;
resultCode: Integer;
ErrorCode: Integer;
reInstallExt: Boolean;
infofilePath: String;
SID: String;
userName: String;
begin
  Log('Parablu_EPA version:# {#MyAppVersion} #');
  result:=true;  
  ExtractTemporaryFile('installinfo.exe');
  infofilePath:= '"'+expandconstant('{tmp}\ParabluInstallationInfo.properties')+'"';
  Log('Parablu_EPA infofilePath:#### #'+infofilePath);
  Log('Parablu_EPA Tmp info exe file path:#### #'+infofilePath);
  if not  IsNormalUser() then 
  begin
  if ShellExec('runas', '"'+ExpandConstant('{tmp}\installinfo.exe')+'"', infofilePath, '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then begin
  end;

       SID:= ExpandConstant('{code:MyConst|SID }');
  userName:= ExpandConstant('{code:MyConst|UserName }');

  Log('Parablu_EPA SID:#### #'+SID);
  Log('Parablu_EPA userName:#### #'+userName);
  end;
end;

procedure InitializeWizard();
begin
Log('Parablu_EPA version:# {#MyAppVersion} #');
{WizardForm.BorderStyle := bsNone;
  WizardForm.Width := 0;
  WizardForm.Height := 0;}
 end;

 procedure InsertDomainNames();
var
confFilePath: String;
S: AnsiString;
domainsFilePath: String;

begin

confFilePath:=ExpandConstant('{app}')+'\Blusync\WL.properties';
domainsFilePath:= ExpandConstant('{app}')+'\domains.conf';

  //ExtractTemporaryFile('testing.conf');
  if FileExists(domainsFilePath) then
  if LoadStringFromFile(ExpandConstant('{app}\domains.conf'), S) then
  begin
    //MsgBox(S, mbInformation, MB_OK);
    SaveStringToFile(confFilePath, S + #13#10, True);
  end;

end;

// Called just before Setup terminates. Note that this function is called even if the user exits Setup before anything is installed.
procedure DeinitializeSetup();
var
  logfilepathname, logfilename, newfilepathname: string;

begin
  logfilepathname := expandconstant('{log}');
  logfilename := ExtractFileName(logfilepathname);
  // Set the new target path as the directory where the installer is being run from
  newfilepathname := expandconstant('{%UserProfile}\AppData\Local\Temp\ParabluInstallation')+logfilename;
  filecopy(logfilepathname, newfilepathname, false);
end; 


{
  called to uninstall service
}
procedure DeletePbluService();
var
ErrorCode: Integer;
UninsServiceFilePath: String;
reInstallExt: Boolean;
begin
   // Allows webdav basic authentication 
    UninsServiceFilePath:=ExpandConstant('{app}')+'\DeletePbluService.bat';
    reInstallExt:=true;
    while reInstallExt do begin
 // ExtractTemporaryFile('DeletePbluService.bat');
 if ShellExec('runas', UninsServiceFilePath, '', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then begin
 reInstallExt:=false;
 end
  else begin
    if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then begin 
    WizardForm.Close;
    reInstallExt:=false;
    end
    
   end
  end;
end;


{
  called to install service
}
procedure InstallPbluService();
var
resultCode: Integer;
InstallServiceFilePath: String;
reInstallExt: Boolean;
begin
   // Allows webdav basic authentication 
    InstallServiceFilePath:=ExpandConstant('{app}')+'\InstallParaBluSvc.bat';
    reInstallExt:=true;
    while reInstallExt do begin
 // ExtractTemporaryFile('DeletePbluService.bat');
 if ShellExec('runas',InstallServiceFilePath,ExpandConstant('{app}'),'"'+ExpandConstant('{code:MyConst|UserProfileDirectory }')+'"','', SW_HIDE, ewWaitUntilTerminated, resultCode) then begin
 reInstallExt:=false;
 end
  else begin
    if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then begin 
    WizardForm.Close;
    reInstallExt:=false;
    end
    
   end
  end;
end;


function GetApplicationInstallationPath(Param: string): string;
var
  installPath: string;
  SID: string;
  regQuery: string;
begin


if IsNormalUser() then 
begin
  if IsWin64 then begin
     if RegQueryStringValue(
       HKCU64,'Software\ParaBlu\BluSync',
         'Path', installPath) then
       begin
        Result := installPath;
        Log('Parablu_EPA installPath from registry as normal user:#  #'+Result);
       end
  end
  else 
  if RegQueryStringValue(
       HKCU,'Software\ParaBlu\BluSync',
         'Path', installPath) then
       begin
        Result := installPath;
        Log('Parablu_EPA installPath from registry as normal user:#  #'+Result);
       end
 end
else begin
SID:= ExpandConstant('{code:MyConst|SID }');
if IsWin64 then
    begin
  if RegQueryStringValue(
       HKU64,SID + '\Software\ParaBlu\BluSync',
         'Path', installPath) then
  begin
    Result := installPath;
    Log('Parablu_EPA installPath from registry:#  #'+Result);
  end
    else
  begin
    Result := ExpandConstant('{code:MyConst|UserProfileDirectory }')+'\AppData\Roaming\ParaBlu';
  end
 end

 else begin
        if RegQueryStringValue(
       HKU,SID + '\Software\ParaBlu\BluSync',
         'Path', installPath) then
  begin
    Result := installPath;
    Log('Parablu_EPA installPath from registry:#  #'+Result);
  end
    else
  begin
    Result := ExpandConstant('{code:MyConst|UserProfileDirectory }')+'\AppData\Roaming\ParaBlu';
  end

  end
 end;
end;

function MyConst(Param: String): String;
var  
  I: Integer;
  KeyPos: Integer;
  KeyFull: string;
  FileLines: TArrayOfString;
  infofilePath: string;
begin
  Result := Param;
  infofilePath:= expandconstant('{tmp}\ParabluInstallationInfo.properties');
   Log('Parablu_EPA install info file path while reading:#  #'+infofilePath);
  if LoadStringsFromFile(infofilePath, FileLines) then
  begin
  Log('Parablu_EPA install info file path:#  #'+FileLines[0]);
    KeyFull := Param + '= ';
    
    for I := 0 to GetArrayLength(FileLines) - 1 do
    begin
      FileLines[I] := TrimLeft(FileLines[I]);
      KeyPos := Pos(KeyFull, FileLines[I]);
      Log('Parablu_EPA install info file path:#1111#'+FileLines[I]+'Key position:'+IntToStr(KeyPos));
      if KeyPos > 0 then
      begin
        Result := Copy(FileLines[I], Length(KeyFull) + 1, MaxInt);
        Result := Trim(Result);
        Log('Parablu_EPA install info file key value:#  #'+Result);
        Break;
      end;
    end;
  end;
end;




