/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.ImageTableImpl;
import com.parablu.epa.common.dao.UploadTableImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.runnables.ChunkRunnable;
import com.parablu.epa.common.service.runnables.DelegateRunnable;
import com.parablu.epa.common.service.runnables.RestartRunnable;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.GetPrivacyGateway;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.RenamedTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadSyncUploadJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(MultiThreadSyncUploadJob.class);
    private static final String TMP_UPLOAD_NAME = ".pbsup.tmp";
    private List<FileTO> uploadList;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String uploadTableURL;
    private final String fullDevicePath;
    private final String basePathForImageTables;
    private final String currentImageTablePath;
    private final String currentImageTableName;
    private final String token;
    private SyncAdapter uploadAdapter = null;
    private AtomicInteger uploadCount = new AtomicInteger(0);
    private int totalsize = 0;
    private int sizeFor5MB = 0x500000;
    private String uploadIPForGateway;
    private String requestURL = "/sync/upload/files/all";
    private ActivityHistoryImpl activityHistory = null;
    private String batchId = "";
    final FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue = new FileSizeBlockingQueue(100, 0x40000000L);
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$");
    ExecutorService multiPartUploadService = Executors.newFixedThreadPool(3, this.factoryBuilder.build());
    ExecutorService chunkService = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$").build());
    final BlockingQueue<BackupTO> chunkFileQueue = new LinkedBlockingQueue<BackupTO>(10000);
    final BlockingQueue<Future<BackupTO>> finishedBatchesQueue = new LinkedBlockingQueue<Future<BackupTO>>();
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    final AtomicInteger chunkedFiles = new AtomicInteger(0);
    private AtomicBoolean loopFinished = new AtomicBoolean(false);
    private volatile boolean intrupted = false;
    ParabluFileSystemUtils fileSystemUtils = new ParabluFileSystemUtils();

    public MultiThreadSyncUploadJob(String iP, Integer port, String cn, String setTableURL, String devicePath, String currentImageTablePath, String baseURlForImageTables, String currentImageTableName, String token, String keyStorePath, String gatewayIp) {
        this.uploadIP = iP;
        this.cloudName = cn;
        this.uploadTableURL = setTableURL;
        this.fullDevicePath = devicePath;
        this.uploadAdapter = new SyncAdapter(this.cloudName, keyStorePath);
        this.basePathForImageTables = baseURlForImageTables;
        this.currentImageTablePath = currentImageTablePath;
        this.currentImageTableName = currentImageTableName;
        this.token = token;
        this.port = port;
        this.activityHistory = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        this.uploadIPForGateway = gatewayIp;
    }

    public void run() {
        try {
            this.uploadCount.set(0);
            this.uploadList = new ArrayList<FileTO>();
            SettingHelper.setErrorOccuredDuringSync(false);
            boolean readFromTable = this.readFromUploadTable();
            if (!readFromTable) {
                this.logger.debug("No records in Upload Table");
                this.updateUI(0, null);
                Thread.sleep(150L);
                return;
            }
            this.logger.debug("upload  Gateway IP: " + this.uploadIPForGateway);
            if (this.uploadIPForGateway == null) {
                SettingHelper.setErrorOccuredDuringSync(true);
                this.updateUI(0, null);
                return;
            }
            this.totalsize = this.uploadList.size();
            this.batchId = this.getBatchId(this.activityHistory);
            BackupPolicyTO backupPolicyTO = new BackupPolicyTO();
            backupPolicyTO.setCompressionEnabled(false);
            backupPolicyTO.setPolicyGroupName("SYNC");
            CleanupInterface<FileTO> cleanupInterface = new CleanupInterface<FileTO>(){

                @Override
                public void runCleanup(FileTO fileToUpload, int status) {
                    Logger loger = LoggerFactory.getLogger(CleanupInterface.class);
                    if (status == 200) {
                        loger.debug("uploadTable URL" + MultiThreadSyncUploadJob.this.uploadTableURL);
                        MultiThreadSyncUploadJob.this.removeFromUploadTable(fileToUpload, MultiThreadSyncUploadJob.this.uploadTableURL);
                    } else {
                        loger.debug("status is not ok:" + status);
                        MultiThreadSyncUploadJob.this.removeFromCurrentImageTable(fileToUpload);
                        SettingHelper.setErrorOccuredDuringSync(true);
                    }
                }

                @Override
                public void updateUIWrapper(FileTO backupTO, int uploadCount) {
                    MultiThreadSyncUploadJob.this.updateUI(uploadCount, backupTO.getFileName());
                }

                @Override
                public void updateTooltipNotification(int failCode) {
                }
            };
            Thread delegateThread = new Thread(new DelegateRunnable(this.chunkFileQueue, this.multiPartUploadService, this.uploadIPForGateway, backupPolicyTO, this.uploadCount, this.batchId, this.finishedBatchesQueue, this.noOfBatches, this.loopFinished, cleanupInterface, this.requestURL, null));
            delegateThread.start();
            Thread chunkDelegateThread = new Thread(new ChunkRunnable(this.chunkedFiles, this.fileSizeBlockingQueue, this.chunkFileQueue, this.loopFinished));
            chunkDelegateThread.start();
            Thread restartDelegateThread = new Thread(new RestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.uploadIPForGateway, this.batchId, backupPolicyTO));
            restartDelegateThread.start();
            for (FileTO tempUploadFileTO : this.uploadList) {
                this.logger.debug("Current thread name for Sync>>>>>>>>" + Thread.currentThread().getName());
                if (Thread.currentThread().isInterrupted() || this.intrupted) {
                    this.logger.debug("Backup upload thread interupted>>>>>>>");
                    delegateThread.interrupt();
                    chunkDelegateThread.interrupt();
                    break;
                }
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.debug("Time before uploading file :" + timeBeforeUpload);
                if (this.isTerminated) {
                    this.logger.debug("Terminated");
                    break;
                }
                File file = new File(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getFileName());
                if (file.exists()) {
                    tempUploadFileTO.setFileSize(file.length());
                }
                this.logger.debug("File to be uploaded :" + tempUploadFileTO.getFileName() + "  fileSize: " + tempUploadFileTO.getFileSize());
                if (tempUploadFileTO.getFileSize() <= (long)this.sizeFor5MB) {
                    if (!tempUploadFileTO.isFolder()) {
                        this.putInSizeQueue(tempUploadFileTO);
                    } else {
                        this.uploadFile(tempUploadFileTO);
                    }
                } else {
                    this.uploadFileAsChunks(tempUploadFileTO);
                }
                this.logger.debug("Total time taken to upload : " + (System.currentTimeMillis() - timeBeforeUpload));
            }
            this.updateUI(this.uploadCount.get(), null);
            this.uploadList = null;
            this.shutDownAllServices(delegateThread, chunkDelegateThread, restartDelegateThread);
        }
        catch (BaseException e) {
            this.logger.error("BaseException" + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupted probably cause of disconnection of account");
        }
        catch (Exception e) {
            this.logger.error("Exception Occurred" + e.getMessage());
            this.logger.trace("" + e);
        }
    }

    private void shutDownAllServices(Thread delegateThread, Thread chunkDelegateThread, Thread restartDelegateThread) {
        try {
            this.chunkService.shutdown();
            this.chunkService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            this.loopFinished.set(true);
            this.logger.debug("Loop finished for sync");
            delegateThread.join();
            chunkDelegateThread.join();
            restartDelegateThread.join();
        }
        catch (InterruptedException e) {
            this.logger.debug(" delegate Thread and chunk INTERUPTED");
            delegateThread.interrupt();
            chunkDelegateThread.interrupt();
            this.multiPartUploadService.shutdownNow();
            this.shutDownMultiPartUploadService();
        }
    }

    private void shutDownMultiPartUploadService() {
        try {
            this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Interrupted thread", (Throwable)e1);
        }
    }

    private String getBatchId(ActivityHistoryImpl activityHistory2) {
        String currentBatchId = "";
        ActivityTO activityTO = activityHistory2.getCurrentStatusFromActivityHistoryTable();
        if (activityTO != null) {
            currentBatchId = activityTO.getBatchId();
        }
        return currentBatchId;
    }

    private void putInSizeQueue(FileTO fileTO) {
        String uploadFilePath = this.copyFileToTempFile(fileTO);
        BackupTO tempUploadFileTO = new BackupTO();
        this.copyPropertiesFromFileTOtoBackupTo(fileTO, tempUploadFileTO);
        tempUploadFileTO.setClientData(uploadFilePath);
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted = true;
        }
    }

    private void copyPropertiesFromFileTOtoBackupTo(FileTO fileTO, BackupTO tempUploadFileTO) {
        tempUploadFileTO.setFileName(fileTO.getFileName());
        tempUploadFileTO.setFileSize(fileTO.getFileSize());
        tempUploadFileTO.setAbstractFilePath(fileTO.getAbstractFilePath());
        tempUploadFileTO.setExists(fileTO.isExists());
        tempUploadFileTO.setMd5checksum(fileTO.getMd5checksum());
        tempUploadFileTO.setFolder(fileTO.isFolder());
        tempUploadFileTO.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
    }

    private boolean readFromUploadTable() {
        try {
            UploadTableImpl upload = new UploadTableImpl(this.uploadTableURL);
            this.uploadList.addAll(upload.selectSortedListFromTable());
            if (!this.uploadList.isEmpty()) {
                return true;
            }
            this.logger.debug("Upload List is empty");
            return false;
        }
        catch (DatabaseException e) {
            this.logger.error("DatabaseException: " + (Object)((Object)e));
            return false;
        }
    }

    private boolean uploadFile(FileTO fileToUpload) {
        this.updateUI(this.uploadCount.get(), fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.logger.debug("File modified");
            if (!this.isMD5Equal(absPath, fileToUpload.getMd5checksum())) {
                this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
                return false;
            }
        }
        long asda1 = System.currentTimeMillis();
        if (this.handleHttpRequests(fileToUpload)) {
            this.uploadCount.incrementAndGet();
            this.updateUI(this.uploadCount.get(), fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
            long asda = System.currentTimeMillis();
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            this.logger.debug("DB time: " + (System.currentTimeMillis() - asda));
        } else {
            this.removeFromCurrentImageTable(fileToUpload);
            SettingHelper.setErrorOccuredDuringSync(true);
            this.logger.debug("Error occured during sync");
        }
        this.logger.debug("Total upload and db time: " + (System.currentTimeMillis() - asda1));
        return true;
    }

    private void removeFromCurrentImageTable(FileTO fileToUpload) {
        ImageTableImpl imageTableHandler = new ImageTableImpl(SettingHelper.getBaseDBUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, SettingHelper.getBaseDBUrl());
        imageTableHandler.removeFilTOFromTable(fileToUpload, this.currentImageTableName);
    }

    public boolean updateUI(int count, String fileName) {
        NotificationHelper.setTotalUploadCount(count);
        NotificationHelper.setUploadCount(String.valueOf(count) + "/" + this.totalsize);
        if (fileName != null) {
            NotificationHelper.setFileBeingUploaded(fileName);
        }
        return false;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        return file.exists();
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        return file.lastModified() <= lastModifiedTimestamp;
    }

    private boolean isMD5Equal(String filePath, String md5checksum) {
        File fileToCheckMD5 = new File(filePath);
        if (fileToCheckMD5.isDirectory()) {
            return true;
        }
        return md5checksum.equals(MD5Generator.generateMD5OfFile((File)fileToCheckMD5));
    }

    private boolean handleHttpRequests(FileTO fileToUpload) {
        int response = 0;
        int retrycount = 0;
        boolean copyUploadFile = false;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        this.logger.debug("Trying to upload file:" + fileToUpload.getFileName());
        String originalFileName = fileToUpload.getFileName();
        String uploadFilePath = null;
        StringBuilder conflictedFileName = new StringBuilder();
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                copyUploadFile = true;
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + TMP_UPLOAD_NAME;
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        if (uploadFilePath == null) {
            return false;
        }
        while (true) {
            boolean retry = false;
            try {
                this.logger.trace("Uploading file from temp folder");
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.trace("time before upload==" + timeBeforeUpload);
                if (fileToUpload.isFolder()) {
                    response = this.uploadAdapter.uploadFile(fileToUpload, currentUploadIPToUse, this.port, uploadFilePath, conflictedFileName, this.token);
                }
                this.logger.trace("Time after upload==" + (System.currentTimeMillis() - timeBeforeUpload));
                this.logger.trace("Response after trying to upload:" + response);
                this.logger.trace(" Time for function  hannle http Requests ");
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", " Your cloud has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1010) {
                        this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + " could not be uploaded due to space restrictions.");
                    }
                    this.deleteTempFile(uploadFilePath, copyUploadFile);
                    return false;
                }
                if (response == 4) {
                    this.handleConflictDuringUpload(fileToUpload.getAbstractFilePath(), conflictedFileName, originalFileName);
                }
                NotificationHelper.cloudSpaceExceeded = false;
                this.deleteTempFile(uploadFilePath, copyUploadFile);
                this.logger.debug("Time Before Upload: " + (System.currentTimeMillis() - timeBeforeUpload));
                if (!currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception occurred  CrawlAdapterException: " + e.getMessage());
                try {
                    retry = true;
                    ++retrycount;
                    Thread.sleep(60000L);
                    int responseForPing = this.uploadAdapter.pingGatewayIP(currentUploadIPToUse);
                    if (responseForPing != 200) {
                        String ipForPrivacyGateway = GetPrivacyGateway.getPrivacyGatewayIP();
                        this.logger.debug("the PG Gateway IP in catch" + ipForPrivacyGateway);
                    }
                }
                catch (InterruptedException ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("Exception in upload file via gateway" + ex.getMessage());
                }
                catch (Exception ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("exception" + ex.getMessage());
                }
                currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse);
                if (currentUploadIPToUse != null) continue;
                return false;
                if (retry && retrycount < 2) continue;
                return false;
            }
            break;
        }
    }

    private String copyFileToTempFile(FileTO fileToUpload) {
        String uploadFilePath = null;
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + this.fileSystemUtils.convertStringTOBase64(fileToUpload.getFileName());
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        return uploadFilePath;
    }

    private boolean checkIfFileIsEditable(String fileName, boolean isFolder) {
        if (isFolder) {
            return false;
        }
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        if (tokens.length != 2) {
            return false;
        }
        return false;
    }

    private void deleteTempFile(String tempraryFilePath, boolean copyUploadFile) {
        if (!copyUploadFile) {
            return;
        }
        File newFile = new File(tempraryFilePath);
        if (newFile.exists()) {
            newFile.delete();
        }
    }

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToBeUsed = currentUploadIPToUse;
        boolean isIpFound = NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)SettingHelper.getKeystorePath(), (String[])ipToUse, (String[])ports);
        if (!isIpFound) {
            if (!PropertyHelper.MAIN_EBMS_DOMAIN.isEmpty()) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                }
                currentUploadIPToBeUsed = SettingHelper.getCurrentCloudIpAddress();
            }
            return currentUploadIPToBeUsed;
        }
        if (ipToUse[0] == null && ports[0] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToBeUsed)) {
            currentUploadIPToBeUsed = ipToUse[gaeLocal];
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToBeUsed = ipToUse[gaePublic];
        }
        return currentUploadIPToBeUsed;
    }

    private void handleConflictDuringUpload(String filePath, StringBuilder conflictedFileName, String oldUploadedFileName) {
        File oldUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + oldUploadedFileName);
        File renamedUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + conflictedFileName.toString());
        oldUploadedFile.renameTo(renamedUploadedFile);
        ImageTableImpl imtble = new ImageTableImpl(this.currentImageTablePath, this.basePathForImageTables);
        ArrayList<RenamedTO> listOfRenamedFiles = new ArrayList<RenamedTO>();
        RenamedTO rn = new RenamedTO();
        rn.setAbstractFilePath(filePath);
        rn.setOldFileName(oldUploadedFileName);
        rn.setNewfileName(conflictedFileName.toString());
        listOfRenamedFiles.add(rn);
        imtble.updateTable(listOfRenamedFiles, this.currentImageTableName);
    }

    private String copyFileToTempFolder(FileTO fileToUpload, File tempUploadFile) throws IOException {
        String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug("The temprary upload folder for this file is: " + tempUploadFile);
        File makeTempFolder = new File(tempUploadFile.getParent());
        if (!makeTempFolder.exists()) {
            boolean success = makeTempFolder.mkdirs();
            this.logger.debug("Trying to make temp folder structure (did it succeed?)-> :" + success);
        }
        if (fileToUpload.isFolder()) {
            this.logger.debug("Whether uploaded file is folder -> " + fileToUpload.isFolder());
            return tempUploadFile.getAbsolutePath();
        }
        File actualFile = new File(path);
        if (tempUploadFile.exists()) {
            tempUploadFile.delete();
        }
        FileUtils.copyFile((File)actualFile, (File)tempUploadFile);
        tempUploadFile.deleteOnExit();
        return tempUploadFile.getAbsolutePath();
    }

    private boolean uploadFileAsChunks(FileTO fileToUpload) {
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.logger.debug("File modified");
            if (!this.isMD5Equal(absPath, fileToUpload.getMd5checksum())) {
                this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
                return false;
            }
        }
        this.handleHttpRequestsForUploadChunks(fileToUpload);
        return true;
    }

    private boolean removeFromUploadTable(FileTO fileToRemove, String uploadTableURL) {
        boolean success = false;
        UploadTableImpl upload = new UploadTableImpl(uploadTableURL);
        upload.removeFromTable(fileToRemove);
        return success;
    }

    public void abortUploadProcesses() {
        if (this.uploadAdapter != null) {
            this.uploadAdapter.cancelHttpPut();
        }
    }

    private boolean handleHttpRequestsForUploadChunks(FileTO fileToUpload) {
        String chunkPath = this.createPreRequisiteForChunk(fileToUpload);
        String sourcePath = SettingHelper.getParabluSyncFolder() + File.separator + fileToUpload.getAbstractFilePath() + File.separator + fileToUpload.getFileName();
        this.logger.debug("FilePath " + sourcePath);
        String destinationPath = chunkPath + File.separator;
        File file = new File(destinationPath);
        BackupTO tempUploadFileTO = new BackupTO();
        if (file.list().length == 0) {
            try {
                this.splitAndWrite(sourcePath, destinationPath);
                this.copyPropertiesFromFileTOtoBackupTo(fileToUpload, tempUploadFileTO);
                List<String> listOfChunkFiles = MultiThreadSyncUploadJob.getExistingFileNames(destinationPath, tempUploadFileTO);
                if (listOfChunkFiles.isEmpty()) {
                    this.logger.debug("List of chunksBackupTO  batch size is zero");
                    FileUtils.cleanDirectory((File)file);
                    this.deleteChunkFolder(file);
                }
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("IOException" + e.getMessage());
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception" + e.getMessage());
            }
        }
        this.logger.debug("Queue size: " + this.fileSizeBlockingQueue.size() + " upload filesize: " + fileToUpload.getFileSize());
        try {
            String uploadFilePath = this.copyFileToTempFile(fileToUpload);
            tempUploadFileTO.setClientData(uploadFilePath);
            this.fileSizeBlockingQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
        this.chunkedFiles.incrementAndGet();
        return true;
    }

    private String createPreRequisiteForChunk(FileTO fileToUpload) {
        String chunkPath;
        String osType = System.getProperty("os.name");
        String hash32Value = this.fileSystemUtils.convertStringTOBase64(fileToUpload.getFileName());
        if (osType.toLowerCase().contains("win")) {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("pbchnkz").append(hash32Value).toString();
            this.createChunkFolderAndHideIt(chunkPath);
        } else {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".pbchnkz").append(hash32Value).toString();
            this.createChunkFolder(chunkPath);
        }
        return chunkPath;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = this.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            this.logger.trace("" + t);
            this.logger.error("Make Hidden Folder exception" + t.getMessage());
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            this.createFolder(chunkPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Error in create folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    public void splitAndWrite(String sourceFilePath, String destinationPath) throws IOException, NoSuchAlgorithmException {
        this.fileSystemUtils.splitAndWrite(sourceFilePath, destinationPath, 4, false);
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        ((OutputStream)output).close();
    }

    public static List<String> getExistingFileNames(String path, BackupTO backupTO) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(path).listFiles();
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            ChunkFileTO chunkFileTO = new ChunkFileTO();
            results.add(file.getName());
            String md5 = MD5Generator.generateMD5OfFile((File)file);
            chunkFileTO.setFileName(file.getName());
            chunkFileTO.setFilePath(path.substring(0, path.length() - 1));
            chunkFileTO.setMd5Checksum(md5);
            chunkFileTO.setChunkFileNames(results);
            chunkFileTOs.add(chunkFileTO);
        }
        backupTO.setChunkFileList(chunkFileTOs);
        for (ChunkFileTO chunkFileTO : chunkFileTOs) {
            chunkFileTO.setChunkFileNames(results);
        }
        return results;
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory() && file.list().length == 0) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Chunk folder deletion Failed" + e.getMessage());
            }
            this.logger.debug("chunk folder deleted successfully");
        }
    }

    private void checkChunkFolderExistsAndDelete(FileTO fileToUpload) {
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        } else {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        }
    }
}

