/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.support;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.api.SupportAdapter;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.LogFileElementList;
import com.parablu.epa.core.element.LogFileInfoElement;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.to.DeviceTo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SupportHelper {
    private static SupportAdapter supportAdapter = new SupportAdapter(SettingHelper.getKeystorePath());
    private static boolean supportRequestInitiated = false;
    private static String supportRequestId = null;
    private static Logger logger = LoggerFactory.getLogger(SupportHelper.class);

    private SupportHelper() {
    }

    public static int sendNewSupportLogs(String cloudName, String userName, String deviceName, boolean sendLogs) {
        supportRequestInitiated = true;
        String requestId = null;
        NewSupportElement supportElement = new NewSupportElement();
        LogFileElementList logFileElementList = new LogFileElementList();
        List<LogFileInfoElement> fileInfoElementList = SupportHelper.getLogFileInfo();
        logFileElementList.setLogFiles(fileInfoElementList);
        supportElement.setId(String.valueOf(System.currentTimeMillis()));
        supportElement.setCloudName(cloudName);
        supportElement.setDeviceName(deviceName);
        supportElement.setTimestamp(String.valueOf(System.currentTimeMillis()));
        supportElement.setUserName(userName);
        supportElement.setFileElementList(logFileElementList);
        logger.debug("Sending prelim request");
        if (supportAdapter.sendSupportMessage(cloudName, supportElement, SettingHelper.getCurrentCloudIpAddress())) {
            requestId = supportAdapter.getRequestID();
        }
        if (requestId == null) {
            logger.debug("Support Request ID is null");
            supportRequestInitiated = false;
            return 1;
        }
        supportRequestId = requestId;
        if (!sendLogs) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Compressing Files");
        File file = SupportHelper.compressLogs();
        if (file == null) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Sending Support File");
        if (supportAdapter.sendSupportLogsNew(file, cloudName, userName, SettingHelper.getCurrentCloudIpAddress())) {
            file.delete();
            supportRequestInitiated = false;
            return 2;
        }
        file.delete();
        supportRequestInitiated = false;
        return 1;
    }

    private static List<LogFileInfoElement> getLogFileInfo() {
        ArrayList<LogFileInfoElement> logFilesList = new ArrayList<LogFileInfoElement>();
        File debugFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
        File warnFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
        File errorFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.error");
        File infoFile = new File(SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + "BluSync.info");
        ArrayList<File> files = new ArrayList<File>();
        files.add(debugFile);
        files.add(warnFile);
        files.add(errorFile);
        files.add(infoFile);
        for (File file : files) {
            LogFileInfoElement fileInfoElement = new LogFileInfoElement();
            fileInfoElement.setFilename(file.getName());
            fileInfoElement.setSize(String.valueOf(file.length()));
            fileInfoElement.setLastModified(String.valueOf(file.lastModified()));
            logFilesList.add(fileInfoElement);
        }
        return logFilesList;
    }

    /*
     * Exception decompiling
     */
    public static File compressLogs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream, FileInputStream fileInputStream) throws IOException {
        if (logFile.exists()) {
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            fileInputStream = new FileInputStream(logFile);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isSupportRequestInitiated() {
        return supportRequestInitiated;
    }

    public static void setSupportRequestInitiated(boolean supportRequestInitiated) {
        SupportHelper.supportRequestInitiated = supportRequestInitiated;
    }

    public static String getSupportRequestId() {
        return supportRequestId;
    }

    public static boolean checkDeviceBlocked() {
        logger.debug("check the selected device to restore is blocked or not");
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        try {
            List listDevices = backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
            Iterator deviceList = listDevices.iterator();
            if (deviceList != null) {
                while (deviceList.hasNext()) {
                    if (!SettingHelper.getDeviceUUId().equalsIgnoreCase(((DeviceTo)deviceList.next()).getDeviceUid())) continue;
                    logger.debug("device is not blocked");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.toString());
            logger.trace("" + e);
            logger.error("exception" + e.getMessage());
        }
        return false;
    }
}

