/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RestartRunnable.class);
    BackupAdapter backUpAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    private AtomicInteger noOfBatches;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private String uploadIPForGateway;
    private String batchIdForBackup;
    private BackupPolicyTO currentPolicy;

    public RestartRunnable(AtomicInteger noOfBatches, BlockingQueue<Future<BackupTO>> finishedBatchesQueue, String uploadIPForGateway, String batchIdForBackup, BackupPolicyTO currentPolicy) {
        this.noOfBatches = noOfBatches;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.uploadIPForGateway = uploadIPForGateway;
        this.batchIdForBackup = batchIdForBackup;
        this.currentPolicy = currentPolicy;
    }

    @Override
    public void run() {
        int batchId = 0;
        while (!Thread.interrupted()) {
            try {
                this.logger.debug("No of batches > i value > : " + batchId + "batch size>" + this.noOfBatches.get());
                BackupTO lastFile = this.finishedBatchesQueue.take().get();
                if (lastFile != null) {
                    int response;
                    if (!"SYNC".equalsIgnoreCase(this.currentPolicy.getPolicyGroupName()) && (response = this.sendRestartId(lastFile)) != 200) {
                        PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                        break;
                    }
                    ++batchId;
                    continue;
                }
                if ("SYNC".equalsIgnoreCase(this.currentPolicy.getPolicyGroupName())) break;
                this.logger.debug("Last backup batch file is null finished que size is:" + this.finishedBatchesQueue.size());
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.trace("" + e);
                this.logger.error("interrupted or excetution exception" + e.getMessage());
            }
        }
    }

    private int sendRestartId(BackupTO lastFile) {
        int res = 0;
        try {
            res = this.backUpAdapter.sendRestartID(lastFile, this.uploadIPForGateway, this.batchIdForBackup, SettingHelper.getDeviceUUId());
            this.logger.debug("Response code " + res + "currentPolicy : " + this.currentPolicy.getPolicyGroupName());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in send restart ID" + e.getMessage());
        }
        return res;
    }
}

