/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadCallable
implements Callable<BackupTO> {
    private Logger logger = LoggerFactory.getLogger(MultipartUploadCallable.class);
    private long restartId;
    List<BackupTO> chunkFileBatch;
    String uploadIPForGateway;
    String requestURL;
    String backupBatchID;
    AtomicInteger uploadCount;
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    BackupActivityTO backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
    BackupPolicyTO backupPolicyTO;
    CleanupInterface<BackupTO> cleanupInterface;
    int priority;
    MultiPartBackupAdapter multiPartBackupAdapter = null;
    private RateLimiter rateLimiter;
    private static final String EXCEPTION_OCCURED = "Exception Occured";
    private static final String FALSE = "false";

    public MultipartUploadCallable(List<BackupTO> chuckFileBatch, String uploadIPForGateway, String backupBatchID, AtomicInteger uploadCount, BackupPolicyTO currentPolicyTO, CleanupInterface<BackupTO> cleanupInterface, String requestURL, RateLimiter rateLimiter, int priority) {
        this.restartId = NotificationHelper.getBackupRestartId();
        this.chunkFileBatch = chuckFileBatch;
        this.uploadIPForGateway = uploadIPForGateway;
        this.backupBatchID = backupBatchID;
        this.uploadCount = uploadCount;
        this.backupPolicyTO = currentPolicyTO;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = requestURL;
        this.rateLimiter = rateLimiter;
        this.priority = priority;
    }

    @Override
    public BackupTO call() {
        Thread.currentThread().setPriority(this.priority);
        try {
            this.multiPartBackupAdapter = new MultiPartBackupAdapter(this.uploadIPForGateway, null, this.requestURL, SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            this.logger.info("rate limiter>>" + this.rateLimiter);
        }
        catch (IOException e1) {
            this.logger.trace("" + e1);
            this.logger.error("error in multipart backup adapter call" + e1.getMessage());
        }
        for (BackupTO backupTO : this.chunkFileBatch) {
            if (backupTO.getChunkFileList() == null) {
                try {
                    this.multiPartBackupAdapter.addFormField();
                    File fileToUpload = new File(backupTO.getClientData());
                    MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadIPForGateway, fileToUpload, this.restartId, this.backupBatchID);
                    File md5File = new File(ObjectUtils.getFileSnapshotPath((String)fileToUpload.getAbsolutePath()));
                    this.multiPartBackupAdapter.addFilePart(md5File);
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                }
            } else {
                try {
                    this.logger.debug("Backup chunk list size>>>>" + backupTO.getChunkFileList().size());
                    for (ChunkFileTO chunk : backupTO.getChunkFileList()) {
                        File fileToUpload = new File(chunk.getFilePath() + StringLiterals.FILE_SEPARATOR + chunk.getFileName());
                        this.multiPartBackupAdapter.addFormField();
                        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadIPForGateway, new File(backupTO.getClientData()), this.restartId, this.backupBatchID);
                        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, chunk);
                        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
                        this.multiPartBackupAdapter.addFilePart(fileToUpload);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        PolicyManagementServerHelper.updateFailCodeToActivityHistory(911);
                        return null;
                    }
                    this.sendChunkValues(this.multiPartBackupAdapter, backupTO, (ChunkFileTO)backupTO.getChunkFileList().get(backupTO.getChunkFileList().size() - 1), this.uploadIPForGateway);
                    File chunkDirectory = new File(((ChunkFileTO)backupTO.getChunkFileList().get(0)).getFilePath());
                    FileUtils.cleanDirectory((File)chunkDirectory);
                    this.deleteChunkFolder(chunkDirectory);
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                    break;
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            PolicyManagementServerHelper.updateFailCodeToActivityHistory(911);
            return null;
        }
        int status = this.multiPartBackupAdapter.finish();
        this.logger.debug("Batch finished and status is : " + status);
        for (BackupTO backupTO : this.chunkFileBatch) {
            this.cleanupInterface.updateUIWrapper(backupTO, this.uploadCount.addAndGet(1));
            this.cleanupInterface.runCleanup(backupTO, status);
        }
        if (status == 200) {
            BackupTO backupTO = this.chunkFileBatch.get(this.chunkFileBatch.size() - 1);
            this.updateTotalUploadSize();
            return backupTO;
        }
        PolicyManagementServerHelper.updateFailCodeToActivityHistory(2304);
        return null;
    }

    private void updateTotalUploadSize() {
        if (this.backupActivityTO != null) {
            this.backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp());
            this.backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(this.backupActivityTO);
        }
    }

    private void addHeaderToMultipartforChunks(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, ChunkFileTO chunkFileElement) {
        multiPartBackupAdapter.addHeaderField("fileChunkNamesa", "");
        multiPartBackupAdapter.addHeaderField("prevBackupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("chunkFileMD5", chunkFileElement.getMd5Checksum());
        multiPartBackupAdapter.addHeaderField("chunkFileName", chunkFileElement.getFileName());
        multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE);
        multiPartBackupAdapter.addHeaderField("isCompressed", String.valueOf(this.backupPolicyTO.isCompressionEnabled()));
    }

    private static void addHeaderToMultipart(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, String currentUploadIPToUse, File file, long restartId, String batchIdForBackup) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadIPToUse);
        multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        multiPartBackupAdapter.addHeaderField("dedupifiedBackupId", "");
        multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(fileToUpload.isBaseFolder()));
        multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        multiPartBackupAdapter.addHeaderField("backupBatchId", batchIdForBackup);
        multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE);
        multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        multiPartBackupAdapter.addHeaderField("cloudName", SettingHelper.getCloudName());
        multiPartBackupAdapter.addHeaderField("prevGatewayName", "");
        multiPartBackupAdapter.addHeaderField("token", SettingHelper.readTokenFromFile());
        multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(file.length()));
        multiPartBackupAdapter.addHeaderField("restartId", String.valueOf(restartId));
        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
            multiPartBackupAdapter.addHeaderField("containerName", NotificationHelper.getCurrentContainerName());
            multiPartBackupAdapter.addHeaderField("containerType", NotificationHelper.getCurrentContainerType());
            multiPartBackupAdapter.addHeaderField("JobId", NotificationHelper.getCurrentContainerJobId());
        }
    }

    private void sendChunkValues(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO tempUploadFileTO, ChunkFileTO chunkFileElement, String nearestGatewayIP) {
        File chunkValuefile = null;
        try {
            multiPartBackupAdapter.addFormField();
            MultipartUploadCallable.addHeaderToMultipart(multiPartBackupAdapter, tempUploadFileTO, nearestGatewayIP, new File(tempUploadFileTO.getClientData()), this.restartId, this.backupBatchID);
            this.addHeaderToMultipartforChunks(multiPartBackupAdapter, tempUploadFileTO, chunkFileElement);
            multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE);
            chunkValuefile = new File(chunkFileElement.getFilePath() + StringLiterals.FILE_SEPARATOR + "chunkvalues");
            if (!chunkValuefile.exists()) {
                chunkValuefile.createNewFile();
            }
            String fileChunks = this.getChunkNames(chunkFileElement);
            FileWriter fileWriter = new FileWriter(chunkValuefile);
            fileWriter.write(fileChunks);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
        }
        multiPartBackupAdapter.addFilePart(chunkValuefile);
    }

    public void cancelUpload() {
        if (this.multiPartBackupAdapter != null) {
            this.logger.debug("Canceling upload>>>>>>>>");
            this.multiPartBackupAdapter.cancelUpload();
        } else {
            this.logger.debug("multiThreadBackupAdapter is null>>>>>>>>>>>>");
        }
    }

    private String getChunkNames(ChunkFileTO chunkFileElement) {
        return StringUtils.join((Collection)chunkFileElement.getChunkFileNames(), (char)',');
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Chunk folder deletion Failed" + e.getMessage());
                }
                this.logger.debug("Chunk folder deleted successfully");
            } else {
                try {
                    FileUtils.cleanDirectory((File)file);
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.debug(EXCEPTION_OCCURED + e.getMessage());
                }
            }
        }
    }
}

