/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.runnables.ChunkRunnable;
import com.parablu.epa.common.service.runnables.DelegateRunnable;
import com.parablu.epa.common.service.runnables.RestartRunnable;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.about.SystemInfo;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadBackupUpload
extends Thread {
    private Logger logger = LoggerFactory.getLogger(MultiThreadBackupUpload.class);
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private BackupAdapter backUpAdapter = null;
    private boolean isTerminated = false;
    private AtomicInteger uploadCount = new AtomicInteger(0);
    private String uploadIPForGateway = null;
    private String prevIPForGateway = null;
    private String isFileDedup = "";
    private final Set<DedupTO> dedupSet;
    private HashMap<String, String> dedupHashMap = new HashMap();
    private NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = null;
    private BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = null;
    private boolean restart;
    private static String batchIdForBackup = "";
    BackupActivityTO backupActivityTO = null;
    BackupPolicyTO currentPolicy = null;
    private long restartId = 1L;
    private String requestURL = "/upload/files/all";
    private String backupType = null;
    private int pftSize = 1;
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private static final String FAILED = "FAILED";
    private static final String PBCHNKZ = "pbchnkz";
    final FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue = new FileSizeBlockingQueue(100, 0x40000000L);
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$");
    ExecutorService multiPartUploadService = Executors.newFixedThreadPool(3, this.factoryBuilder.build());
    ExecutorService chunkService = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$").build());
    final BlockingQueue<BackupTO> chunkFileQueue = new LinkedBlockingQueue<BackupTO>(10000);
    final BlockingQueue<Future<BackupTO>> finishedBatchesQueue = new LinkedBlockingQueue<Future<BackupTO>>();
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    final AtomicInteger chunkedFiles = new AtomicInteger(0);
    private AtomicBoolean loopFinished = new AtomicBoolean(false);
    private volatile boolean intrupted = false;
    ParabluFileSystemUtils fileSystemUtils = new ParabluFileSystemUtils();

    public MultiThreadBackupUpload(String iP, Integer port, String cn, String token, String keyStorePath, Set<DedupTO> dedupTOs, boolean restartValue, long restartID, String backupType) {
        this.keyStorePath = keyStorePath;
        this.newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
        this.backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.uploadIP = iP;
        this.cloudName = cn;
        this.backUpAdapter = new BackupAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
        this.dedupSet = dedupTOs;
        this.restart = restartValue;
        this.restartId = restartID + 1L;
        this.backupType = backupType;
    }

    @Override
    public void run() {
        this.logger.debug("MULTI THREAD BACKUP UPLOAD STARTED");
        this.logger.info("token inside multithreadbackup upload" + this.token);
        this.logger.info("port inside multithreadbackup upload" + this.port);
        this.logger.info("uploadIP inside multithreadbackup upload" + this.uploadIP);
        this.logger.info("keystorepath inside multithreadbackup upload" + this.keyStorePath);
        this.logger.info("backupadapter inside multithreadbackup upload" + this.backUpAdapter);
        this.logger.info("backupFolderDaoimpl inside multithreadbackup upload" + this.backUpFolderDAOImpl);
        this.loadCurrentBackupActivityAndBackupPolicy();
        ArrayList<BackupTO> backupTOs = new ArrayList<BackupTO>();
        String currentIP = null;
        if (("true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy()) || "true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) && "true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
            try {
                this.uploadIPForGateway = PolicyManagementServerHelper.getPrivacyGatewayIP(this.backupType);
                if (this.uploadIPForGateway == null) {
                    this.logger.error("Error in get privacy gateway");
                    this.updateFailReasonInActivityTable(2304);
                    this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Server could not connect to privacy gateway");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Error in get privacy gateway", (Throwable)e);
                this.updateFailReasonInActivityTable(2304);
                this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Server could not connect to privacy gateway");
                return;
            }
            currentIP = this.uploadIPForGateway;
            if (this.prevIPForGateway == null) {
                this.prevIPForGateway = this.uploadIPForGateway;
            }
            if (this.dedupSet != null && !this.dedupSet.isEmpty()) {
                for (DedupTO dedupTO : this.dedupSet) {
                    this.dedupHashMap.put(dedupTO.getMd5Value(), dedupTO.getBackupId());
                }
                this.logger.debug("SIZE OF DEDUP HASHMAP " + this.dedupHashMap.size());
            }
        }
        int crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(true);
        if (this.restart) {
            this.logger.debug("INSIDE RESTART > ID IS : " + this.restartId);
        } else {
            this.restartId = 1L;
            this.logger.debug("FRESH BACKUP > ID IS : " + this.restartId);
        }
        CleanupInterface<BackupTO> cleanupInterface = new CleanupInterface<BackupTO>(){

            @Override
            public void runCleanup(BackupTO backupTO, int status) {
            }

            @Override
            public void updateUIWrapper(BackupTO backupTO, int uploadCount) {
                MultiThreadBackupUpload.this.updateUI(backupTO.getClientData(), uploadCount);
            }

            @Override
            public void updateTooltipNotification(int failCode) {
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(failCode);
                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(MultiThreadBackupUpload.FAILED);
                if (failCode == 912) {
                    MultiThreadBackupUpload.this.updateSystrayToolTipNotification("Machine Utils Exceeded", "Your machine utilization exceeded the policy");
                }
            }
        };
        RateLimiter rateLimiter = RateLimiter.create((double)(1024.0 * (double)this.currentPolicy.getNetworkThrottleSpeed()));
        Thread delegateThread = new Thread(new DelegateRunnable(this.chunkFileQueue, this.multiPartUploadService, currentIP, this.currentPolicy, this.uploadCount, currentIP, this.finishedBatchesQueue, this.noOfBatches, this.loopFinished, cleanupInterface, this.requestURL, rateLimiter));
        delegateThread.start();
        Thread chunkDelegateThread = new Thread(new ChunkRunnable(this.chunkedFiles, this.fileSizeBlockingQueue, this.chunkFileQueue, this.loopFinished));
        chunkDelegateThread.start();
        Thread restartDelegateThread = new Thread(new RestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.uploadIPForGateway, batchIdForBackup, this.currentPolicy));
        restartDelegateThread.start();
        while (this.restartId <= (long)crawlFileCount) {
            block30: {
                if (Thread.currentThread().isInterrupted() || this.intrupted) {
                    this.logger.debug("Backup upload thread interupted>>>>>>>");
                    delegateThread.interrupt();
                    chunkDelegateThread.interrupt();
                    break;
                }
                boolean currentFileChunkable = false;
                BackupTO tempUploadFileTO = this.newBackUpCrawlDAOImpl.getBackupFileFromTableWithID(this.restartId);
                if (tempUploadFileTO != null) {
                    try {
                        this.updateRestartId();
                        tempUploadFileTO.setClientData(this.checkForMacBasePath(tempUploadFileTO.getClientData()));
                        tempUploadFileTO.setRestartId(this.restartId);
                        if (tempUploadFileTO.isFolder()) break block30;
                        if (!this.handleFileExist(tempUploadFileTO.getClientData())) {
                            this.updateUI("", this.uploadCount.get());
                            backupTOs.add(tempUploadFileTO);
                            tempUploadFileTO.setBkupStatus(FAILED);
                            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                            break block30;
                        }
                        if (this.isTerminated) break;
                        this.pftSize = this.currentPolicy.getPftSize();
                        if (this.pftSize != 0) {
                            currentFileChunkable = this.isFileChunkable(tempUploadFileTO, this.pftSize);
                        }
                        if (currentFileChunkable = this.checkDedup(tempUploadFileTO, currentFileChunkable)) {
                            currentFileChunkable = this.checkFreeSpace(tempUploadFileTO, currentFileChunkable);
                        }
                        if (currentFileChunkable) {
                            File file;
                            String chunkPath;
                            String hash32Value = this.fileSystemUtils.convertStringTOBase64(tempUploadFileTO.getFileName());
                            this.logger.debug("Hash valuse For the folder>>>>>" + hash32Value);
                            String osType = System.getProperty("os.name");
                            if (osType.toLowerCase().contains("win")) {
                                chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(PBCHNKZ).append(hash32Value).toString();
                                this.createChunkFolderAndHideIt(chunkPath);
                            } else if (osType.toLowerCase().contains("lin")) {
                                chunkPath = new StringBuffer().append(tempUploadFileTO.getClientData().substring(0, tempUploadFileTO.getClientData().lastIndexOf(47))).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".pbchnkz" + hash32Value).toString();
                                this.createChunkFolder(chunkPath);
                            } else {
                                chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".pbchnkz" + hash32Value).toString();
                                this.createChunkFolder(chunkPath);
                            }
                            this.logger.debug(" chunkPath : " + chunkPath);
                            String sourcePath = tempUploadFileTO.getClientData();
                            String destinationPath = chunkPath + File.separator;
                            try {
                                file = new File(destinationPath);
                            }
                            catch (Exception e) {
                                this.logger.trace("" + e);
                                this.logger.error("File not accessible" + e.getMessage());
                                backupTOs.add(tempUploadFileTO);
                                tempUploadFileTO.setBkupStatus(FAILED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                break block30;
                            }
                            if (file != null) {
                                this.splitAndWriteAsChunks(sourcePath, destinationPath);
                                List<String> listOfChunkFiles = MultiThreadBackupUpload.getExistingFileNames(destinationPath, tempUploadFileTO);
                                if (listOfChunkFiles.isEmpty()) {
                                    this.logger.debug("List of chunksBackupTO  batch size is zero");
                                    backupTOs.add(tempUploadFileTO);
                                    this.deleteDirectory(file);
                                    this.deleteChunkFolder(file);
                                    tempUploadFileTO.setBkupStatus(FAILED);
                                    this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                    return;
                                }
                                this.logger.debug("list of chunk files is not zero......");
                                this.logger.debug("Queue size: " + this.fileSizeBlockingQueue.size() + " upload filesize: " + tempUploadFileTO.getFileSize());
                                this.putInFileSizeBlockingQueue(tempUploadFileTO);
                                this.chunkedFiles.incrementAndGet();
                                this.logger.debug("chunks: " + tempUploadFileTO.getChunkFileList().size());
                            }
                            break block30;
                        }
                        this.putInSizeQueue(tempUploadFileTO);
                    }
                    catch (Exception e) {
                        this.logger.error("Exception Occurred while backing up  file: ", (Throwable)e);
                    }
                }
            }
            ++this.restartId;
        }
        try {
            this.chunkService.shutdown();
            this.chunkService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            this.loopFinished.set(true);
            this.logger.debug("LOOP FINISHED");
            delegateThread.join();
            chunkDelegateThread.join();
            restartDelegateThread.join();
        }
        catch (InterruptedException e) {
            this.logger.debug(" Delegate Thread and chunk INTERUPTED");
            delegateThread.interrupt();
            chunkDelegateThread.interrupt();
            this.chunkService.shutdownNow();
            this.multiPartUploadService.shutdownNow();
            boolean isTerminated1 = true;
            try {
                isTerminated1 = this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                this.logger.debug("Interrupted thread is TERMINATED : " + isTerminated1, (Object)e1.getMessage());
            }
        }
    }

    private void putInFileSizeBlockingQueue(BackupTO tempUploadFileTO) {
        try {
            this.fileSizeBlockingQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("error while adding file to filesize block queue" + e.getMessage());
        }
    }

    private void deleteDirectory(File file) {
        try {
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("error while cleaning the directory" + e.getMessage());
        }
    }

    public static List<String> getExistingFileNames(String path, BackupTO backupTO) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(path).listFiles();
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            ChunkFileTO chunkFileTO = new ChunkFileTO();
            results.add(file.getName());
            String md5 = MD5Generator.generateMD5OfFile((File)file);
            chunkFileTO.setFileName(file.getName());
            chunkFileTO.setFilePath(path.substring(0, path.length() - 1));
            chunkFileTO.setMd5Checksum(md5);
            chunkFileTO.setChunkFileNames(results);
            chunkFileTOs.add(chunkFileTO);
        }
        backupTO.setChunkFileList(chunkFileTOs);
        for (ChunkFileTO chunkFileTO : chunkFileTOs) {
            chunkFileTO.setChunkFileNames(results);
        }
        return results;
    }

    private boolean checkFreeSpace(BackupTO tempUploadFileTO, boolean recivedCurrentFileChunkable) {
        boolean currentFileChunkable = recivedCurrentFileChunkable;
        try {
            double freeDiskSpace = System.getProperty("os.name").toLowerCase().contains("lin") ? (double)FileSystemUtils.freeSpaceKb((String)tempUploadFileTO.getClientData().substring(0, tempUploadFileTO.getClientData().lastIndexOf(47))) : (double)FileSystemUtils.freeSpaceKb((String)tempUploadFileTO.getAbstractFilePath());
            double fileSizeInkb = tempUploadFileTO.getFileSize() / 1024L;
            if (freeDiskSpace <= fileSizeInkb) {
                currentFileChunkable = false;
            }
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("error while calculating the free disk space" + e.getMessage());
        }
        return currentFileChunkable;
    }

    private void splitAndWriteAsChunks(String recivedSourcePath, String destinationPath) throws IOException {
        String sourcePath = recivedSourcePath;
        try {
            sourcePath = ObjectUtils.getFileSnapshotPath((String)sourcePath);
            this.logger.debug("Source Path :> " + sourcePath);
            this.fileSystemUtils.splitAndWrite(sourcePath, destinationPath, this.currentPolicy.getChunkSize(), this.currentPolicy.isCompressionEnabled());
        }
        catch (Exception ex) {
            this.logger.error("Inside split and write catch skipping chunk file " + ex);
            ex.getMessage();
        }
    }

    private void updateUI(String fileName, int uploadCount2) {
        NotificationHelper.setFileBeingBackedup(fileName);
        NotificationHelper.setTotalBackupCount(uploadCount2);
    }

    private boolean checkDedup(BackupTO tempUploadFileTO, boolean recivedCurrentFileChunkable) {
        boolean currentFileChunkable = recivedCurrentFileChunkable;
        if (!tempUploadFileTO.isFolder()) {
            this.isFileDedup = "";
            this.isFileDedup = this.checkDedupOfFile(tempUploadFileTO);
            if (!this.isFileDedup.isEmpty()) {
                this.logger.debug("File Dedup value:" + this.isFileDedup);
                currentFileChunkable = false;
            }
        }
        return currentFileChunkable;
    }

    private String checkDedupOfFile(BackupTO tempUploadFileTO) {
        String fileDedupFlag = "";
        String backupId = this.dedupHashMap.get(tempUploadFileTO.getMd5checksum());
        if (backupId != null) {
            fileDedupFlag = backupId;
        }
        return fileDedupFlag;
    }

    private boolean isFileChunkable(BackupTO tempUploadFileTO, int pftSize) {
        boolean isChunkable = false;
        int chunkableSizeFromPolicy = this.getChunkableSize();
        File file = new File(tempUploadFileTO.getClientData());
        if (file.isDirectory()) {
            return isChunkable;
        }
        long fileSizeinBytes = file.length();
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if (fileSizeinMb >= (float)pftSize && fileSizeinMb > (float)chunkableSizeFromPolicy) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getChunkableSize() {
        int chunkableSizeFromPolicy = 4;
        if (this.currentPolicy != null) {
            chunkableSizeFromPolicy = this.currentPolicy.getChunkSize();
        }
        return chunkableSizeFromPolicy;
    }

    public double checkSystemUsage() {
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getSystemMemory();
            this.logger.debug("System memory percentage is:" + percentage);
            return percentage;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error while checking the sytem usage" + e.getMessage());
            return 0.0;
        }
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        if (completeParentPath.startsWith("ROOT" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(4);
        }
        return completeParentPath;
    }

    private void updateRestartId() {
        NotificationHelper.setBackupRestartId(this.restartId);
        this.backupActivityTO.setRestartID(this.restartId);
        this.backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(this.backupActivityTO);
    }

    private void loadCurrentBackupActivityAndBackupPolicy() {
        BackupPolicyDAOImpl backupPolicyDAOImpl;
        List<BackupPolicyTO> currentDetails;
        this.backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (this.backupActivityTO != null) {
            batchIdForBackup = this.backupActivityTO.getBatchId();
            this.logger.debug("Backup batch ID:" + batchIdForBackup);
        }
        if ((currentDetails = (backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl())).getBackupPolicyDetails()) != null && !currentDetails.isEmpty()) {
            if (!"".equals(NotificationHelper.getCurrentPolicyName())) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    this.currentPolicy = bkpPolicy;
                }
            } else {
                this.currentPolicy = currentDetails.get(0);
            }
            this.logger.debug("CHUNK SIZE TO KEEP " + this.currentPolicy.getChunkSize());
            this.logger.debug("COMPRESSION ENABLED " + this.currentPolicy.isCompressionEnabled());
            this.logger.debug("NETWORK THROTTLE SPEED :" + this.currentPolicy.getNetworkThrottleSpeed());
            SettingHelper.setMaxVersionsToKeep(this.currentPolicy.getMaxVersions());
            if (this.currentPolicy.getChunkSize() == 0) {
                this.currentPolicy.setChunkSize(4);
            }
        }
    }

    private void updateFailReasonInActivityTable(int statusCode) {
        this.backupActivityTO.setFailCode(statusCode);
        this.backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(this.backupActivityTO);
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private BackupTO putInSizeQueue(BackupTO tempUploadFileTO) {
        ArrayList<ChunkFileTO> chunkFileList = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(tempUploadFileTO.getFileName());
        chunkFileTO.setFilePath(tempUploadFileTO.getAbstractFilePath());
        chunkFileTO.setMd5Checksum(tempUploadFileTO.getMd5checksum());
        chunkFileList.add(chunkFileTO);
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted = true;
        }
        return tempUploadFileTO;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            this.logger.debug("File doesnt exist: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = this.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            this.logger.error("Make Hidden Folder exception" + t);
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            this.createFolder(chunkPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Error in create chunk folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Chunk folder deletion Failed" + e.getMessage());
                }
                this.logger.debug("Chunk folder deleted successfully");
            } else {
                try {
                    FileUtils.cleanDirectory((File)file);
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("error cleaning the directory" + e.getMessage());
                }
            }
        }
    }
}

