/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackupCheckTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.view.FontsManager;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManagerView
extends Shell {
    FontsManager fontsManager;
    String token = null;
    File currentParentFile = null;
    Text lblNewLabel = null;
    org.eclipse.swt.widgets.List list1 = null;
    private Table table;
    private Image shellImage = null;
    private ImageData shellImageData = null;
    private Image img = null;
    private Image imageBack = null;
    private BackupAdapter backupAdapter;
    private List<File> filesAddedToBackup;
    private List<BackupFolderTO> filesToRemove;
    private static String backImageLocation = "resource\\img\\glyphicons_221_unshare.png";
    private Set<BackupFolderTO> backupFolderTOsExistingFolderPaths;
    private Set<String> rootFilesList;
    private final BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    private Logger logger = LoggerFactory.getLogger(BackupManagerView.class);
    private Button btnNewButton;
    private static final String DEVICE_CREDENTIALS_WARNING = "Device credentials has expired, please login to your cloud.";
    private static final String AUTHORIZTION_FAILED = "Authoriztion failed";
    private Button btnCancelButton;

    public BackupManagerView(Shell shell) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        super(shell, 65568);
        Listener listener = e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        };
        this.getShell().addListener(31, listener);
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.filesAddedToBackup = new ArrayList<File>();
        this.filesToRemove = new ArrayList<BackupFolderTO>();
        this.fontsManager = new FontsManager(shell.getDisplay());
        this.readExistingBackupFiles();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 2;
        this.setLayout((Layout)gridLayout);
        this.setLocation(shell.getLocation());
        this.shellImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.img = new Image((Device)shell.getDisplay(), new ImageData(SyncConstants.PARABLU_FOLDER_ICON).scaledTo(16, 16));
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(20, 20));
        Listener listnr = arg0 -> this.disposeImagesAndFonts();
        this.addListener(21, listnr);
        Label lblNewLabel3 = new Label((Composite)this, 64);
        GridData gdlblNewLabel3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdlblNewLabel3.widthHint = 425;
        gdlblNewLabel3.heightHint = 30;
        lblNewLabel3.setLayoutData((Object)gdlblNewLabel3);
        lblNewLabel3.setText("Select a folder and click add to include the folder for backup. Double click any folder to view its subfolders.");
        lblNewLabel3.setFont(this.fontsManager.getSmallNormalFont());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout glComposite = new GridLayout(3, false);
        glComposite.horizontalSpacing = 0;
        glComposite.marginHeight = 0;
        glComposite.marginWidth = 0;
        composite.setLayout((Layout)glComposite);
        GridData gdComposite = new GridData(4, 4, false, false, 1, 1);
        gdComposite.widthHint = 435;
        gdComposite.heightHint = 225;
        composite.setLayoutData((Object)gdComposite);
        Composite composite1 = new Composite(composite, 0);
        GridLayout glComposite1 = new GridLayout(1, false);
        glComposite1.verticalSpacing = 0;
        glComposite1.marginWidth = 0;
        glComposite1.marginHeight = 0;
        composite1.setLayout((Layout)glComposite1);
        GridData gdComposite1 = new GridData(4, 4, false, true, 1, 1);
        gdComposite1.widthHint = 177;
        gdComposite1.heightHint = 223;
        composite1.setLayoutData((Object)gdComposite1);
        Composite composite5 = new Composite(composite1, 2048);
        GridLayout glComposite5 = new GridLayout(3, false);
        glComposite5.horizontalSpacing = 1;
        glComposite5.marginWidth = 0;
        glComposite5.marginHeight = 0;
        composite5.setLayout((Layout)glComposite5);
        GridData gdComposite5 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdComposite5.widthHint = 173;
        gdComposite5.heightHint = 27;
        composite5.setLayoutData((Object)gdComposite5);
        Button backLabel = new Button(composite5, 0);
        backLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (BackupManagerView.this.currentParentFile == null) {
                    BackupManagerView.this.logger.debug("Current Parent File is null");
                    return;
                }
                BackupManagerView.this.currentParentFile = BackupManagerView.this.currentParentFile.getParentFile();
                if (BackupManagerView.this.currentParentFile == null) {
                    BackupManagerView.this.table.removeAll();
                    BackupManagerView.this.addDefaultItemsToTable();
                    BackupManagerView.this.lblNewLabel.setText("My Computer");
                    BackupManagerView.this.lblNewLabel.setFont(BackupManagerView.this.fontsManager.getSmallNormalFont());
                    BackupManagerView.this.lblNewLabel.getParent().layout();
                } else {
                    BackupManagerView.this.lblNewLabel.setText(BackupManagerView.this.currentParentFile.getAbsolutePath());
                    File[] allFilesInSubFolder = BackupManagerView.this.currentParentFile.listFiles();
                    BackupManagerView.this.table.removeAll();
                    if (allFilesInSubFolder == null) {
                        return;
                    }
                    for (File file : allFilesInSubFolder) {
                        if (!file.isDirectory()) continue;
                        TableItem tableItem = new TableItem(BackupManagerView.this.table, 0);
                        tableItem.setData((Object)file);
                        tableItem.setImage(BackupManagerView.this.img);
                        tableItem.setText(file.getName());
                    }
                }
            }
        });
        GridData gdBtnNewButton3 = new GridData(4, 4, false, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 24;
        backLabel.setLayoutData((Object)gdBtnNewButton3);
        backLabel.setText("");
        backLabel.setImage(this.imageBack);
        Label lblNewLabel2 = new Label(composite5, 0);
        lblNewLabel2.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 2));
        this.lblNewLabel = new Text(composite5, 8);
        GridData gdLblNewLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblNewLabel.heightHint = 17;
        gdLblNewLabel.widthHint = 131;
        this.lblNewLabel.setLayoutData((Object)gdLblNewLabel);
        if (this.currentParentFile == null) {
            this.lblNewLabel.setText("My Computer");
            this.lblNewLabel.setFont(this.fontsManager.getSmallNormalFont());
        } else {
            this.lblNewLabel.setText(this.currentParentFile.getAbsolutePath());
        }
        new Label(composite5, 0);
        new Label(composite5, 0);
        this.table = new Table(composite1, 67584);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(false);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                TableItem[] items = BackupManagerView.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                BackupManagerView.this.currentParentFile = (File)items[0].getData();
                BackupManagerView.this.lblNewLabel.setText(BackupManagerView.this.currentParentFile.getAbsolutePath());
                BackupManagerView.this.lblNewLabel.getParent().layout();
                File[] files = BackupManagerView.this.currentParentFile.listFiles();
                BackupManagerView.this.table.removeAll();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    TableItem tableItem = new TableItem(BackupManagerView.this.table, 0);
                    tableItem.setData((Object)file);
                    tableItem.setImage(BackupManagerView.this.img);
                    tableItem.setText(file.getName());
                }
            }
        });
        TableColumn tblclmnNewColumn = new TableColumn(this.table, 0);
        tblclmnNewColumn.setImage(null);
        tblclmnNewColumn.setWidth(173);
        tblclmnNewColumn.setText("New Column");
        this.addDefaultItemsToTable();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gdComposite2 = new GridData(4, 4, false, true, 1, 1);
        gdComposite2.widthHint = 80;
        composite2.setLayoutData((Object)gdComposite2);
        new Label(composite2, 0);
        new Label(composite2, 0);
        new Label(composite2, 0);
        Button imageRightLabel = new Button(composite2, 0);
        imageRightLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] tableItems = BackupManagerView.this.table.getSelection();
                if (tableItems == null || tableItems.length == 0) {
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Please select a folder and try again");
                    messageBox.setText("No folder selected");
                    messageBox.open();
                    return;
                }
                File selectedItem = (File)tableItems[0].getData();
                if (BackupManagerView.this.rootFilesList.contains(selectedItem.getAbsolutePath())) {
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Root folders are not allowed for backup.");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                for (BackupFolderTO backupFolderTO : BackupManagerView.this.backupFolderTOsExistingFolderPaths) {
                    boolean isParentFolder = backupFolderTO.getFolderPath().contains(selectedItem.getAbsolutePath() + StringLiterals.FILE_SEPARATOR);
                    boolean isSameFolder = backupFolderTO.getFolderPath().equalsIgnoreCase(selectedItem.getAbsolutePath());
                    boolean isChildFolder = selectedItem.getAbsolutePath().equalsIgnoreCase(backupFolderTO.getFolderPath());
                    boolean isChildFolder2 = selectedItem.getAbsolutePath().contains(backupFolderTO.getFolderPath() + StringLiterals.FILE_SEPARATOR);
                    if (isParentFolder && !isSameFolder) {
                        MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                        messageBox.setMessage("Sub-folder of " + selectedItem.getName() + " already exists, remove the folder(" + new File(backupFolderTO.getFolderPath()).getName() + ") first.");
                        messageBox.setText("Invalid selection");
                        messageBox.open();
                        return;
                    }
                    if (isSameFolder) {
                        MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                        messageBox.setMessage("Folder already added for Backup");
                        messageBox.setText("Folder already exists");
                        messageBox.open();
                        return;
                    }
                    if (!isChildFolder && !isChildFolder2) continue;
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Parent folder already added for Backup (current folder already selected).");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                BackupManagerView.this.filesAddedToBackup.add(selectedItem);
                BackupFolderTO backupFolderTO = new BackupFolderTO();
                backupFolderTO.setFolderPath(selectedItem.getAbsolutePath());
                BackupManagerView.this.logger.debug("" + selectedItem.getAbsolutePath());
                backupFolderTO.setLastSyncTime(0L);
                BackupManagerView.this.backupFolderTOsExistingFolderPaths.add(backupFolderTO);
                BackupManagerView.this.list1.add(selectedItem.getAbsolutePath());
                BackupManagerView.this.list1.getParent().layout();
            }
        });
        GridData imageRightLabelGrid = new GridData(16384, 0x1000000, false, false, 1, 1);
        imageRightLabelGrid.heightHint = 23;
        imageRightLabelGrid.widthHint = 69;
        imageRightLabelGrid.horizontalIndent = 0;
        imageRightLabel.setLayoutData((Object)imageRightLabelGrid);
        imageRightLabel.setText("Add");
        imageRightLabel.setFont(this.fontsManager.getSmallNormalFont());
        new Label(composite2, 0);
        Button imageLeftLabel = new Button(composite2, 0);
        imageLeftLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String[] strings = BackupManagerView.this.list1.getSelection();
                if (strings == null || strings.length == 0) {
                    BackupManagerView.this.logger.debug("List of selected folders is empty");
                    return;
                }
                BackupFolderTO file = new BackupFolderTO();
                file.setFolderPath(strings[0]);
                for (BackupFolderTO backupFolderTO : BackupManagerView.this.backupFolderTOsExistingFolderPaths) {
                    if (backupFolderTO.getCreateBy() == null || !"IA".equalsIgnoreCase(backupFolderTO.getCreateBy()) || !backupFolderTO.getFolderPath().equalsIgnoreCase(file.getFolderPath())) continue;
                    BackupManagerView.this.logger.debug("Folder Policy From added by admin can't be remove");
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Default Folder added by admin cannot be removed.");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                BackupManagerView.this.logger.debug(file.getFolderPath());
                BackupManagerView.this.list1.remove(strings[0]);
                BackupManagerView.this.backupFolderTOsExistingFolderPaths.remove(file);
                BackupManagerView.this.filesAddedToBackup.remove(new File(file.getFolderPath()));
                BackupManagerView.this.filesToRemove.add(file);
            }
        });
        GridData imageLeftLabelGrid = new GridData(0x1000000, 4, false, false, 1, 1);
        imageLeftLabelGrid.heightHint = 26;
        imageLeftLabelGrid.widthHint = 69;
        imageLeftLabelGrid.horizontalIndent = 0;
        imageLeftLabel.setLayoutData((Object)imageLeftLabelGrid);
        imageLeftLabel.setToolTipText("Click here to remove the selected folder from your backup list.");
        imageLeftLabel.setText("Remove");
        imageLeftLabel.setFont(this.fontsManager.getSmallNormalFont());
        Composite composite3 = new Composite(composite, 0);
        GridLayout glComposite3 = new GridLayout(1, false);
        glComposite3.marginHeight = 0;
        glComposite3.marginWidth = 0;
        glComposite3.verticalSpacing = 0;
        composite3.setLayout((Layout)glComposite3);
        GridData gdComposite3 = new GridData(4, 4, false, true, 1, 1);
        gdComposite3.widthHint = 175;
        composite3.setLayoutData((Object)gdComposite3);
        Composite composite6 = new Composite(composite3, 2048);
        GridLayout glComposite6 = new GridLayout(1, false);
        glComposite6.marginLeft = 5;
        composite6.setLayout((Layout)glComposite6);
        GridData gdComposite6 = new GridData(4, 4, true, false, 1, 1);
        gdComposite6.widthHint = 151;
        gdComposite6.heightHint = 27;
        composite6.setLayoutData((Object)gdComposite6);
        Label lblNewLabel1 = new Label(composite6, 0);
        lblNewLabel1.setToolTipText("The list of folders selected for Backup");
        GridData gdLblNewLabel1 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdLblNewLabel1.heightHint = 16;
        gdLblNewLabel1.widthHint = 121;
        lblNewLabel1.setLayoutData((Object)gdLblNewLabel1);
        lblNewLabel1.setText("Selected Folders");
        lblNewLabel1.setFont(this.fontsManager.getSmallNormalFont());
        this.list1 = new org.eclipse.swt.widgets.List(composite3, 2816);
        GridData gdList1 = new GridData(4, 4, false, true, 1, 1);
        gdList1.widthHint = 150;
        gdList1.heightHint = 101;
        this.list1.setLayoutData((Object)gdList1);
        this.addDefaultItemsToList();
        Composite composite4 = new Composite((Composite)this, 0);
        composite4.setLayout(null);
        GridData gdComposite4 = new GridData(4, 4, false, false, 1, 1);
        gdComposite4.heightHint = 49;
        composite4.setLayoutData((Object)gdComposite4);
        this.btnNewButton = new Button(composite4, 0);
        this.btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackupManagerView.this.saveSettings();
            }
        });
        this.btnNewButton.setBounds(275, 10, 60, 25);
        this.btnNewButton.setText(" Save ");
        this.btnNewButton.setFont(this.fontsManager.getMediumNormalFont());
        this.btnCancelButton = new Button(composite4, 0);
        this.btnCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackupManagerView.this.cancelSettings();
            }
        });
        this.btnCancelButton.setBounds(345, 10, 60, 25);
        this.btnCancelButton.setText(" Cancel ");
        this.btnCancelButton.setFont(this.fontsManager.getMediumNormalFont());
        this.createContents();
    }

    protected void saveSettings() {
        this.btnNewButton.setText("Saving..");
        this.btnNewButton.setEnabled(false);
        Runnable runnable = () -> {
            this.removeAllFoldersNotToBeBackedup();
            this.addSelectedBackedupFolder();
            Runnable runable = () -> this.getShell().close();
            this.getDisplay().asyncExec(runable);
        };
        new Thread(runnable).start();
    }

    private void showMessage(String text, String message) {
        if (this.getDisplay() == null || this.getDisplay().isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            MessageBox messageBox = new MessageBox(this.getShell(), 8);
            messageBox.setText(text);
            messageBox.setMessage(message);
            messageBox.open();
        };
        this.getDisplay().syncExec(runnable);
    }

    private void removeAllFoldersNotToBeBackedup() {
        for (BackupFolderTO file : this.filesToRemove) {
            if (this.backUpFolderDAOImpl.removeAParentFolder(file)) {
                this.logger.debug("removed parent folder");
                continue;
            }
            this.logger.debug("remove parent folder failed");
        }
    }

    private void addSelectedBackedupFolder() {
        ArrayList<String> partialFolderUploadFailure = new ArrayList<String>();
        boolean status = true;
        for (File file : this.filesAddedToBackup) {
            BackupCheckTO backupCheckTO = this.saveBackupConfigurationSettings(file);
            if (backupCheckTO == null) {
                this.showMessage("Failed to add folders", "Cannot connect to Backup Server. Please check network connection and try again. For more details, contact administrator.");
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 417) {
                this.showMessage("User Limit Exceeded", "The cloud space limit for backup has reached");
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 421) {
                this.showMessage(AUTHORIZTION_FAILED, DEVICE_CREDENTIALS_WARNING);
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 401) {
                this.showMessage(AUTHORIZTION_FAILED, DEVICE_CREDENTIALS_WARNING);
                status = false;
                break;
            }
            if (backupCheckTO.isConflict()) {
                BackupElement backupElement2 = Xmlparser.parseBackupElementResponse((String)backupCheckTO.getBackupElementXml());
                partialFolderUploadFailure.add(backupElement2.getFileName());
                continue;
            }
            BackupFolderTO backupFolderTO = new BackupFolderTO();
            backupFolderTO.setFolderPath(file.getAbsolutePath());
            this.logger.debug("" + file.getAbsolutePath());
            backupFolderTO.setLastSyncTime(0L);
            if (this.backUpFolderDAOImpl.insertAParentFolder(backupFolderTO)) continue;
            this.logger.debug("couldnt insert parent folder");
        }
        if (status && !partialFolderUploadFailure.isEmpty()) {
            this.showMessage("Conflict detected", "Folder conflict detected while adding selected folders.\nPlease ensure that selected folder names are unique.");
        }
    }

    private void addDefaultItemsToList() {
        this.list1.removeAll();
        for (BackupFolderTO backupFolderTO : this.backupFolderTOsExistingFolderPaths) {
            this.list1.add(backupFolderTO.getFolderPath());
        }
    }

    private void readExistingBackupFiles() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.token = SettingHelper.readTokenFromFile();
        this.backupFolderTOsExistingFolderPaths = new HashSet<BackupFolderTO>();
        List backupFolderList = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        if (backupFolderList == null || backupFolderList.isEmpty()) {
            this.logger.debug("backupFolderList is empty");
            return;
        }
        for (BackupFolderTO backupFolderTO : backupFolderList) {
            this.backupFolderTOsExistingFolderPaths.add(backupFolderTO);
        }
    }

    private void addDefaultItemsToTable() {
        if (this.rootFilesList != null) {
            this.rootFilesList.clear();
        } else {
            this.rootFilesList = new HashSet<String>();
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] files = File.listRoots();
        this.currentParentFile = null;
        for (File file : files) {
            TableItem tableItem;
            if (!(fsv.isDrive(file) && file.canRead() && file.canWrite())) {
                this.logger.debug("error reeading root files");
                continue;
            }
            this.rootFilesList.add(file.getAbsolutePath());
            String rootName = fsv.getSystemDisplayName(file);
            if (rootName.isEmpty()) {
                tableItem = new TableItem(this.table, 0);
                tableItem.setData((Object)file);
                tableItem.setImage(this.img);
                tableItem.setText(file.getAbsolutePath());
                continue;
            }
            tableItem = new TableItem(this.table, 0);
            tableItem.setData((Object)file);
            tableItem.setImage(this.img);
            tableItem.setText(rootName);
        }
    }

    private BackupCheckTO saveBackupConfigurationSettings(File selectedItem) {
        BackupElement backupElement = this.createBackupElement(selectedItem);
        BackupCheckTO backupCheckTO = null;
        try {
            backupCheckTO = this.backupAdapter.addFolderToBackup(SettingHelper.getCurrentCloudIpAddress(), null, CreateXmlObject.createBackupElementXml((BackupElement)backupElement), this.token);
            if (SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && backupCheckTO == null && SettingHelper.getHttpsPort() != null) {
                backupCheckTO = this.backupAdapter.addFolderToBackup(SettingHelper.getCurrentCloudIpAddress(), Integer.valueOf(SettingHelper.getHttpsPort()), CreateXmlObject.createBackupElementXml((BackupElement)backupElement), this.token);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in addFolderToBackup, backupAdapter: ", e);
        }
        return backupCheckTO;
    }

    private BackupElement createBackupElement(File file) {
        this.logger.info("creating backup element: " + file.getName());
        BackupElement backupElement = new BackupElement();
        backupElement.setBaseFolder(true);
        backupElement.setClientData(file.getAbsolutePath());
        backupElement.setFileName(file.getName());
        backupElement.setFileCompletePath(file.getParentFile().getAbsolutePath());
        backupElement.setExists(true);
        backupElement.setFolder(true);
        backupElement.setLastModifiedTimestamp(file.lastModified());
        backupElement.setMd5checksum("null");
        backupElement.setSize("0");
        return backupElement;
    }

    protected void createContents() {
        this.setText("Backup Manager");
        this.setFont(this.fontsManager.getMediumNormalFont());
        this.setImage(this.shellImage);
        this.pack();
    }

    protected void disposeImagesAndFonts() {
        if (this.img != null) {
            this.img.dispose();
            this.img = null;
        }
        if (this.imageBack != null) {
            this.imageBack.dispose();
            this.imageBack = null;
        }
        if (this.shellImage != null) {
            this.shellImage.dispose();
            this.shellImage = null;
        }
    }

    protected void cancelSettings() {
        this.btnCancelButton.setEnabled(false);
        Runnable runnable = () -> {
            Runnable runbl = () -> this.getShell().close();
            this.getDisplay().asyncExec(runbl);
        };
        new Thread(runnable).start();
    }
}

