/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.alarm;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsPolicyRefreshHelper {
    private static Logger logger = LoggerFactory.getLogger(WindowsPolicyRefreshHelper.class);
    private static Timer policyRefreshTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;

    private WindowsPolicyRefreshHelper() {
    }

    public static synchronized void initiatePolicyTimer() {
        logger.debug("Initiating policy refresh timer STARTED");
        policyRefreshTimer = new Timer();
        try {
            policyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WindowsCheckBackupPolicy.checkGroupPolicy();
                    BlusyncThreadHelper.initiateBackup();
                }
            }, 5000L, 3L * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating backup timer...." + e.getMessage());
        }
        logger.debug("Initiating policy refresh timer COMPLETED");
    }

    public static synchronized void initiatePolicyTimerAfterDelay() {
        policyRefreshTimer = new Timer();
        try {
            policyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WindowsCheckBackupPolicy.checkGroupPolicy();
                    BlusyncThreadHelper.initiateBackup();
                }
            }, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating timer......" + e.getMessage());
        }
        logger.debug("Initiating policy refresh timer after delay ");
    }

    public static synchronized void resetPolicyTimer() {
        if (policyRefreshTimer != null) {
            policyRefreshTimer.cancel();
        }
        WindowsPolicyRefreshHelper.initiatePolicyTimerAfterDelay();
    }

    public static void cancelSyncTimer() {
        policyRefreshTimer.cancel();
    }
}

