/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.windows;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.helper.windows.PowerShell;
import com.parablu.epa.helper.windows.PowerShellNotAvailableException;
import com.parablu.epa.helper.windows.PowerShellResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteCalloutScript {
    private static Logger logger = LoggerFactory.getLogger(ExecuteCalloutScript.class);
    private static PowerShell powerShell;

    private ExecuteCalloutScript() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeScript(String name, List<String> arguments) {
        int exitVal = 0;
        StringBuilder command = new StringBuilder(SettingHelper.getParabluScriptsFolder()).append(StringLiterals.FILE_SEPARATOR).append(name);
        if (arguments != null) {
            for (String args : arguments) {
                command.append(" ").append(args);
            }
        }
        logger.debug("command  >>>>  " + command);
        try {
            powerShell = PowerShell.openSession();
            PowerShellResponse response = powerShell.executeCommand(command.toString());
            logger.debug("Response:" + response.isError() + " Output" + response.getCommandOutput());
            if (response.isError()) {
                logger.debug("Error executing script");
            } else {
                logger.debug("Executed script ");
            }
        }
        catch (PowerShellNotAvailableException e) {
            logger.trace("" + e);
            logger.error("power shell not available exception" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (powerShell != null) {
                exitVal = powerShell.close(false);
            }
            logger.debug("Exiit value of script " + exitVal);
        }
        return exitVal == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeScript(String name, List<String> arguments, Map<String, String> env) {
        int exitVal = 0;
        StringBuilder command = new StringBuilder(SettingHelper.getParabluScriptsFolder()).append(StringLiterals.FILE_SEPARATOR).append(name);
        if (!env.isEmpty()) {
            for (Map.Entry entry : env.entrySet()) {
                command.append(" ").append((String)entry.getKey());
                command.append(" ").append((String)entry.getValue());
            }
        }
        if (arguments != null) {
            for (String string : arguments) {
                command.append(" ").append(string);
            }
        }
        logger.debug("command  >>>>  " + command);
        try {
            powerShell = PowerShell.openSession();
            PowerShellResponse response = powerShell.executeCommand(command.toString());
            logger.debug("Response:" + response.isError() + " Output" + response.getCommandOutput());
            if (response.isError()) {
                logger.debug("Error executing script");
            } else {
                logger.debug("Executed script ");
            }
        }
        catch (PowerShellNotAvailableException e) {
            logger.trace("" + e);
            logger.error("power shell not available Exception" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (powerShell != null) {
                exitVal = powerShell.close(false);
            }
            logger.debug("Exiit value of script " + exitVal);
        }
        return exitVal == 0;
    }

    public static void terminateScripts() {
        try {
            powerShell.close(true);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception" + e.getMessage());
        }
    }
}

