/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.view.FontsManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncPreferencesView
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(SyncPreferencesView.class);
    FontsManager fontsManager;
    public boolean enableBlusyncToggle;
    public int syncFrequency = 5;
    public boolean flag = false;
    private Composite settingsPanel = null;
    private Group syncPanelSubGroup = null;
    private Label syncEnableDisableLabel = null;
    private Label syncEnableDisableInfoLabel = null;
    public Button syncEnableButton = null;
    public Button mediaEnableButton = null;
    public Button mediaPicturesCheckBox = null;
    public Button mediaVideosCheckBox = null;
    public Button mediaMusicCheckBox = null;
    public Text mediaMusicLabel = null;
    public Text mediaPicturesLabel = null;
    public Text mediaVideosLabel = null;
    public Button mediaPicturesConfigButton = null;
    public Button mediaMusicConfigButton = null;
    public Button mediaVideosConfigButton = null;
    private Label syncFrequencyLbl = null;
    public Spinner syncFrequencySpinner = null;
    public CCombo syncFrequencyHoursCombo = null;
    private Label syncFrequencyHoursLabel = null;
    public CCombo syncFrequencyMinutesCombo = null;
    private Label syncFrequencyMinutesLabel = null;
    private Composite applyButtonToolBar = null;
    private Button syncFrequencyApplyButton = null;
    MediaFolderDAOImpl mediaFolderDAOImpl = new MediaFolderDAOImpl(SettingHelper.getMediaDbUrl());

    public SyncPreferencesView(Composite composite) {
        this.mainParentComposite = composite;
        if (SettingHelper.getSyncLicenced().equals("true")) {
            this.generateUI();
        } else {
            this.generateDefaultSyncPreferencesUI();
        }
    }

    private void generateDefaultSyncPreferencesUI() {
        Display display = Display.getCurrent();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout baseGroupGridLayout = new GridLayout();
        baseGroupGridLayout.marginWidth = 5;
        baseGroupGridLayout.marginHeight = 10;
        baseGroupGridLayout.marginTop = 10;
        baseGroupGridLayout.marginLeft = 10;
        baseGroupGridLayout.marginRight = 10;
        baseGroupGridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.baseGroup.setLayout((Layout)baseGroupGridLayout);
        this.baseGroup.setLayoutData((Object)gridData);
        Composite syncNotificationsComposite = new Composite(this.baseGroup, 2048);
        GridLayout syncNotificationsCompositeLayout = new GridLayout();
        syncNotificationsCompositeLayout.marginWidth = 5;
        syncNotificationsCompositeLayout.marginTop = 5;
        syncNotificationsCompositeLayout.marginLeft = 5;
        syncNotificationsCompositeLayout.marginRight = 5;
        syncNotificationsCompositeLayout.marginBottom = 5;
        syncNotificationsCompositeLayout.numColumns = 1;
        syncNotificationsComposite.setLayout((Layout)syncNotificationsCompositeLayout);
        syncNotificationsComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(syncNotificationsComposite, 64);
        label.setText("File sync is not enabled for this user.\nPlease contact your cloud administrator.");
        label.setFont(this.fontsManager.getMediumNormalFont());
        GridData gridData1 = new GridData(1808);
        gridData1.widthHint = 300;
        label.setLayoutData((Object)gridData1);
    }

    private void generateUI() {
        GridLayout settingsPanelSubGroupGridLayout = new GridLayout();
        GridData gridData = new GridData(4, 4, false, true);
        this.enableBlusyncToggle = SettingHelper.isEnableBlusync();
        this.syncFrequency = SettingHelper.getCheckParacloudForUpdateTimerInMins();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout settingGroupLayout = new GridLayout();
        settingGroupLayout.verticalSpacing = 6;
        this.baseGroup.setLayout((Layout)settingGroupLayout);
        this.baseGroup.setLayoutData((Object)gridData);
        GridLayout settingsPanelCompositeLayout = new GridLayout();
        settingsPanelCompositeLayout.numColumns = 2;
        settingsPanelCompositeLayout.marginWidth = 5;
        settingsPanelCompositeLayout.marginRight = 5;
        settingsPanelCompositeLayout.marginLeft = 5;
        settingsPanelCompositeLayout.marginTop = 15;
        settingsPanelCompositeLayout.marginHeight = 0;
        settingsPanelCompositeLayout.makeColumnsEqualWidth = false;
        settingsPanelCompositeLayout.horizontalSpacing = 20;
        GridData settingsPanelCompositeData = new GridData(1808);
        settingsPanelCompositeData.grabExcessHorizontalSpace = true;
        this.settingsPanel = new Composite(this.baseGroup, 4);
        this.settingsPanel.setLayout((Layout)settingsPanelCompositeLayout);
        this.settingsPanel.setLayoutData((Object)settingsPanelCompositeData);
        GridData settingsComponentsGridData = new GridData();
        GridData syncFrequencyLblLabelData = new GridData();
        this.syncPanelSubGroup = new Group(this.settingsPanel, 0);
        settingsPanelSubGroupGridLayout.makeColumnsEqualWidth = false;
        settingsPanelSubGroupGridLayout.numColumns = 2;
        settingsPanelSubGroupGridLayout.horizontalSpacing = 0;
        settingsPanelSubGroupGridLayout.marginWidth = 0;
        settingsPanelSubGroupGridLayout.marginRight = 0;
        settingsPanelSubGroupGridLayout.marginLeft = 5;
        settingsPanelSubGroupGridLayout.verticalSpacing = 8;
        settingsPanelSubGroupGridLayout.marginBottom = 0;
        this.syncPanelSubGroup.setLayout((Layout)settingsPanelSubGroupGridLayout);
        this.syncPanelSubGroup.setText("Sync Settings");
        this.syncPanelSubGroup.setFont(this.fontsManager.getSmallNormalFont());
        GridData settingsPanelSubGroupGridData = new GridData(768);
        settingsPanelSubGroupGridData.horizontalSpan = 2;
        this.syncPanelSubGroup.setLayoutData((Object)settingsPanelSubGroupGridData);
        this.syncEnableDisableLabel = new Label((Composite)this.syncPanelSubGroup, 0);
        if (this.enableBlusyncToggle) {
            this.syncEnableDisableLabel.setText("Automatic Sync is Enabled");
        } else {
            this.syncEnableDisableLabel.setText("Automatic Sync is Disabled");
        }
        this.syncEnableDisableLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.syncEnableDisableLabel.setLayoutData((Object)settingsComponentsGridData);
        this.syncEnableButton = new Button((Composite)this.syncPanelSubGroup, 8);
        GridData syncEnableButtonGridLayout = new GridData();
        syncEnableButtonGridLayout.horizontalIndent = 30;
        this.syncEnableButton.setLayoutData((Object)syncEnableButtonGridLayout);
        this.syncEnableButton.setSelection(this.enableBlusyncToggle);
        this.syncEnableButton.setFont(this.fontsManager.getMediumNormalFont());
        this.syncEnableButton.setEnabled(true);
        this.syncEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                logger.debug("Enable or Disable Blusync - Selected");
                if (SyncPreferencesView.this.enableBlusyncToggle) {
                    SyncPreferencesView.this.disabeAutomaticSync();
                } else {
                    SyncPreferencesView.this.enableAutomaticSync();
                }
            }
        });
        this.syncEnableDisableInfoLabel = new Label((Composite)this.syncPanelSubGroup, 64);
        GridData settingsComponentInfoLabelData = new GridData(512);
        settingsComponentInfoLabelData.widthHint = 260;
        settingsComponentInfoLabelData.horizontalSpan = 2;
        this.syncEnableDisableInfoLabel.setText("(Turns on automatic Sync)");
        this.syncEnableDisableInfoLabel.setFont(this.fontsManager.getSmallItalicFont());
        this.syncEnableDisableInfoLabel.setLayoutData((Object)settingsComponentInfoLabelData);
        syncFrequencyLblLabelData.verticalSpan = 1;
        this.syncFrequencyLbl = new Label((Composite)this.syncPanelSubGroup, 64);
        this.syncFrequencyLbl.setText("Sync Interval:");
        this.syncFrequencyLbl.setFont(this.fontsManager.getMediumNormalFont());
        this.syncFrequencyLbl.setLayoutData((Object)syncFrequencyLblLabelData);
        Composite syncTimerComposite = new Composite((Composite)this.syncPanelSubGroup, 0);
        GridLayout syncTimerGridLayout = new GridLayout();
        syncTimerGridLayout.numColumns = 4;
        GridData data = new GridData();
        data.horizontalIndent = 30;
        syncTimerComposite.setLayoutData((Object)data);
        syncTimerComposite.setLayout((Layout)syncTimerGridLayout);
        this.syncFrequencyHoursLabel = new Label(syncTimerComposite, 0);
        this.syncFrequencyHoursLabel.setText("   Hrs  ");
        this.syncFrequencyHoursLabel.setFont(this.fontsManager.getExtraSmallNormalFont());
        this.syncFrequencyHoursCombo = new CCombo(syncTimerComposite, 782);
        this.syncFrequencyHoursCombo.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
        this.syncFrequencyHoursCombo.setText(String.valueOf(this.syncFrequency / 60));
        this.syncFrequencyHoursCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncPreferencesView.this.flag = true;
                SyncPreferencesView.this.syncFrequencyApplyButton.setEnabled(true);
            }
        });
        this.syncFrequencyMinutesLabel = new Label(syncTimerComposite, 0);
        this.syncFrequencyMinutesLabel.setText("   Mins");
        this.syncFrequencyMinutesLabel.setFont(this.fontsManager.getExtraSmallNormalFont());
        this.syncFrequencyMinutesCombo = new CCombo(syncTimerComposite, 520);
        this.syncFrequencyMinutesCombo.setItems(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"});
        this.syncFrequencyMinutesCombo.setText(String.valueOf(this.syncFrequency % 60));
        this.syncFrequencyMinutesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncPreferencesView.this.syncFrequencyApplyButton.setEnabled(true);
            }
        });
        GridData syncFrequencyToolBarData = new GridData();
        syncFrequencyToolBarData.horizontalSpan = 2;
        this.syncFrequencyApplyButton = new Button((Composite)this.syncPanelSubGroup, 8);
        GridData syncFrequencyApplyButtonGridLayout = new GridData();
        syncFrequencyApplyButtonGridLayout.horizontalIndent = 185;
        syncFrequencyApplyButtonGridLayout.horizontalSpan = 2;
        this.syncFrequencyApplyButton.setLayoutData((Object)syncFrequencyApplyButtonGridLayout);
        this.syncFrequencyApplyButton.setText("Apply Interval");
        this.syncFrequencyApplyButton.setFont(this.fontsManager.getMediumNormalFont());
        this.syncFrequencyApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncPreferencesView.this.syncFrequencyApplyButton.setEnabled(false);
                SyncPreferencesView.this.flag = false;
                this.changeSyncFrequency();
                logger.debug("Clicked");
            }

            private void changeSyncFrequency() {
                int syncingFrequency;
                int syncFrequencyHours = 0;
                int syncFrequencyMinutes = 1;
                int change = 0;
                if (SyncPreferencesView.this.syncFrequencyHoursCombo.getSelectionIndex() != -1) {
                    syncFrequencyHours = Integer.parseInt(SyncPreferencesView.this.syncFrequencyHoursCombo.getItem(SyncPreferencesView.this.syncFrequencyHoursCombo.getSelectionIndex())) * 60;
                    ++change;
                }
                if (SyncPreferencesView.this.syncFrequencyMinutesCombo.getSelectionIndex() != -1) {
                    syncFrequencyMinutes = Integer.parseInt(SyncPreferencesView.this.syncFrequencyMinutesCombo.getItem(SyncPreferencesView.this.syncFrequencyMinutesCombo.getSelectionIndex()));
                    ++change;
                }
                if ((syncingFrequency = !SyncPreferencesView.this.syncFrequencyMinutesCombo.isEnabled() || change == 0 ? -1 : syncFrequencyHours + syncFrequencyMinutes) == 0) {
                    MessageBox msg = new MessageBox(SyncPreferencesView.this.mainParentComposite.getShell(), 34);
                    msg.setText("Invalid Choice");
                    msg.setMessage("You cannot have a sync interval of zero. Please select a different value");
                    msg.open();
                } else {
                    SyncPreferencesView.this.applySyncSettingChanges(syncingFrequency, SyncPreferencesView.this.enableBlusyncToggle);
                }
            }
        });
        if (this.enableBlusyncToggle) {
            this.changeImageAndTextOfEnableBluSyncButton(true);
            this.diableOtherSyncOptions(this.enableBlusyncToggle);
        } else {
            this.changeImageAndTextOfEnableBluSyncButton(false);
            this.diableOtherSyncOptions(this.enableBlusyncToggle);
        }
    }

    private void enableAutomaticSync() {
        this.changeImageAndTextOfEnableBluSyncButton(true);
        this.enableBlusyncToggle = true;
        SettingHelper.setTempEnableBlusync((boolean)true);
        this.diableOtherSyncOptions(this.enableBlusyncToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.syncEnableDisableLabel.setText("Automatic Sync is Enabled");
        this.syncEnableDisableLabel.getParent().layout();
    }

    private void disabeAutomaticSync() {
        this.changeImageAndTextOfEnableBluSyncButton(false);
        this.enableBlusyncToggle = false;
        SettingHelper.setTempEnableBlusync((boolean)false);
        this.diableOtherSyncOptions(this.enableBlusyncToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.syncEnableDisableLabel.setText("Automatic Sync is Disabled");
        this.syncEnableDisableLabel.getParent().layout();
    }

    protected synchronized void diableOtherSyncOptions(boolean enableBlusyncToggle2) {
        if (!this.syncFrequencyHoursLabel.isDisposed() && !this.syncFrequencyHoursLabel.getParent().isDisposed()) {
            this.syncFrequencyHoursLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyMinutesLabel.isDisposed() && !this.syncFrequencyMinutesLabel.getParent().isDisposed()) {
            this.syncFrequencyMinutesLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyHoursCombo.isDisposed() && !this.syncFrequencyHoursCombo.getParent().isDisposed()) {
            this.syncFrequencyHoursCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyMinutesCombo.isDisposed() && !this.syncFrequencyMinutesCombo.getParent().isDisposed()) {
            this.syncFrequencyMinutesCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyLbl.isDisposed() && !this.syncFrequencyLbl.getParent().isDisposed()) {
            this.syncFrequencyLbl.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyApplyButton.isDisposed() && !this.syncFrequencyApplyButton.getParent().isDisposed()) {
            this.syncFrequencyApplyButton.setEnabled(enableBlusyncToggle2);
        }
    }

    protected synchronized void applySyncSettingChanges(int syncFrequency, boolean syncEnableBlusyncToggle2) {
        boolean appliedSuccessfully;
        if (syncFrequency != -1) {
            SettingHelper.setTempCheckParacloudForUpdateTimerInMins((int)syncFrequency);
        }
        if (appliedSuccessfully = SettingHelper.applyChangesToSharedPreferences((boolean)true)) {
            SyncPreferencesView.updateUIBasedOnChoice(syncEnableBlusyncToggle2);
            BlusyncThreadHelper.resetSyncTimer();
        }
        if (this.mainParentComposite.getShell() == null) {
            return;
        }
        MessageBox msg = new MessageBox(this.mainParentComposite.getShell(), 34);
        msg.setText("Settings Saved");
        msg.setMessage("Sync settings updated");
        msg.open();
    }

    public static void updateUIBasedOnChoice(boolean enableBlusyncToggle2) {
        if (enableBlusyncToggle2 && NotificationHelper.getMainStatus() == 100) {
            NotificationHelper.setCurrentActivityState((int)12);
        }
    }

    public void changeImageAndTextOfEnableBluSyncButton(boolean state) {
        this.syncEnableButton.setFont(this.fontsManager.getMediumNormalFont());
        if (state) {
            this.syncEnableButton.setText("Disable");
        } else {
            this.syncEnableButton.setText("Enable");
        }
        this.syncEnableButton.getParent().layout();
    }

    public void changeImageAndTextOfEnableMediaButton(boolean state) {
        this.mediaEnableButton.setFont(this.fontsManager.getMediumNormalFont());
        if (state) {
            this.mediaEnableButton.setText("Disable");
        } else {
            this.mediaEnableButton.setText("Enable");
        }
        this.mediaEnableButton.getParent().layout();
    }

    public void disposeAllSettings() {
        this.fontsManager.disposeFonts();
        this.disposeEnableBlusyncButtonsAndLabels();
        this.disposeSyncFrequencyButtonsAndLabels();
        if (this.syncPanelSubGroup != null && !this.syncPanelSubGroup.isDisposed()) {
            this.syncPanelSubGroup.dispose();
        }
        if (this.settingsPanel != null && !this.settingsPanel.isDisposed()) {
            this.settingsPanel.dispose();
        }
    }

    private void disposeEnableBlusyncButtonsAndLabels() {
        if (this.syncEnableDisableLabel != null) {
            this.syncEnableDisableLabel.dispose();
        }
        if (this.syncEnableDisableInfoLabel != null) {
            this.syncEnableDisableInfoLabel.dispose();
        }
        if (this.syncEnableButton != null) {
            if (this.syncEnableButton.getImage() != null && !this.syncEnableButton.getImage().isDisposed()) {
                this.syncEnableButton.getImage().dispose();
            }
            this.syncEnableButton.dispose();
        }
    }

    private void disposeSyncFrequencyButtonsAndLabels() {
        if (this.syncFrequencyLbl != null) {
            this.syncFrequencyLbl.dispose();
        }
        if (this.syncFrequencyMinutesLabel != null) {
            this.syncFrequencyMinutesLabel.dispose();
        }
        if (this.syncFrequencyHoursLabel != null) {
            this.syncFrequencyHoursLabel.dispose();
        }
        if (this.syncFrequencyMinutesCombo != null) {
            this.syncFrequencyMinutesCombo.dispose();
        }
        if (this.syncFrequencyHoursCombo != null) {
            this.syncFrequencyHoursCombo.dispose();
        }
        if (this.syncFrequencyApplyButton != null) {
            if (this.syncFrequencyApplyButton.getImage() != null && !this.syncFrequencyApplyButton.getImage().isDisposed()) {
                this.syncFrequencyApplyButton.getImage().dispose();
            }
            this.syncFrequencyApplyButton.dispose();
        }
        if (this.applyButtonToolBar != null) {
            this.applyButtonToolBar.dispose();
        }
    }
}

