/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import com.parablu.epa.service.settings.VersionHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExtensionUpgrader {
    private static String version;
    private static Logger logger;

    private ShellExtensionUpgrader() {
    }

    public static void upgradeShellExtensions() {
        try {
            version = VersionHelper.getProductVersion();
            if (!ShellExtensionUpgrader.shellUpgradeCheck()) {
                return;
            }
            ShellExtensionUpgrader.unregisterAndMoveOldExtensionsIfPresent();
            ShellExtensionUpgrader.moveNewExtensionsToDestinationFolderAndRegister();
        }
        catch (Exception exception) {
            logger.debug("Exception", (Throwable)exception);
        }
    }

    private static void moveNewExtensionsToDestinationFolderAndRegister() throws IOException {
        File destinationFile = new File("lib\\shell");
        File sourceFile = new File("bin\\shell\\" + version);
        FileUtils.moveDirectory((File)sourceFile, (File)destinationFile);
    }

    private static void unregisterAndMoveOldExtensionsIfPresent() throws IOException {
        File sourceFile = new File("lib\\shell");
        if (!sourceFile.exists()) {
            return;
        }
        File destinationFile = new File("bin\\backup");
        if (destinationFile.exists()) {
            FileUtils.forceDelete((File)destinationFile);
        }
        FileUtils.moveDirectory((File)sourceFile, (File)destinationFile);
    }

    private static boolean shellUpgradeCheck() {
        File file = new File("bin\\shell\\" + version);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        String[] fileList = file.list();
        return fileList != null && fileList.length != 0;
    }

    static {
        logger = LoggerFactory.getLogger(ShellExtensionUpgrader.class);
    }
}

