/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.alarm.StatisticsCollectorHelper;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.service.alarm.WindowsPolicyRefreshHelper;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsCheckBackupPolicy {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public static BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Logger logger = LoggerFactory.getLogger(WindowsCheckBackupPolicy.class);
    static int policyRefreshIntervalInHrs = -1;
    static int statisticsRefreshIntervalInHrs = -1;

    private WindowsCheckBackupPolicy() {
    }

    public static void checkGroupPolicy() {
        if (NotificationHelper.policyRefreshStarted || NotificationHelper.backUpStarted) {
            logger.debug("policy refresh finished:" + NotificationHelper.policyRefreshStarted);
            policyRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentPolicyRefereshInterval();
            statisticsRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentStatisticsRefereshInterval();
            if (policyRefreshIntervalInHrs != -1 && policyRefreshIntervalInHrs != 0) {
                SettingHelper.setTempPolicyRefreshIntervalInMins((int)policyRefreshIntervalInHrs);
                WindowsPolicyRefreshHelper.resetPolicyTimer();
            } else {
                SettingHelper.setTempPolicyRefreshIntervalInMins((int)60);
                WindowsPolicyRefreshHelper.resetPolicyTimer();
                StatisticsCollectorHelper.resetStatisticsTimer();
            }
            if (statisticsRefreshIntervalInHrs != -1 && statisticsRefreshIntervalInHrs != 0) {
                SettingHelper.setStatisticsRefreshIntervalInMins((int)statisticsRefreshIntervalInHrs);
                StatisticsCollectorHelper.resetStatisticsTimer();
            } else {
                SettingHelper.setStatisticsRefreshIntervalInMins((int)120);
                StatisticsCollectorHelper.resetStatisticsTimer();
            }
            return;
        }
        NotificationHelper.policyRefreshStarted = true;
        List currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (!NotificationHelper.getCurrentPolicyName().equals("")) {
            for (BackupPolicyTO backupPolicyTO : currentDetails) {
                if (!backupPolicyTO.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                currentPolicy = backupPolicyTO;
            }
        } else {
            Iterator iterator = currentDetails.iterator();
            while (iterator.hasNext()) {
                BackupPolicyTO backupPolicyTO;
                currentPolicy = backupPolicyTO = (BackupPolicyTO)iterator.next();
            }
        }
        if (currentPolicy != null) {
            boolean isLatestVersion = false;
            String productVersion = SettingHelper.getProductVersion();
            try {
                isLatestVersion = backUpAdapter.isBackupPolicyLatest(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), currentPolicy.getLastModifiedTime(), SettingHelper.readTokenFromFile(), SettingHelper.getUserName(), productVersion);
            }
            catch (Exception e) {
                logger.error("Error in check policy is latest:" + e);
            }
            if (!isLatestVersion) {
                BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
                GroupPolicyElementList groupPolicyElementList = null;
                try {
                    if (SettingHelper.getServerBackupLicensed().equals("true")) {
                        List deviceContainerElements = backUpAdapter.getContainerDetails(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName()).getDeviceContainerElement();
                        PolicyManagementServerHelper.createContainerDetalis((BackupPolicyDAOImpl)backupPolicyDAOImpl, (List)deviceContainerElements);
                    }
                    if ((groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed())).getGroupPolicyElement().isEmpty()) {
                        groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
                    }
                }
                catch (CrawlAdapterException protocolException) {
                    logger.error("Client protocol exception...." + (Object)((Object)protocolException));
                    groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
                }
                catch (Exception e) {
                    logger.error("Error in get latest policy:" + e);
                }
                if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                    try {
                        PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)backupPolicyTo, (GroupPolicyElementList)groupPolicyElementList);
                    }
                    catch (Exception e) {
                        logger.error("Error in cfreate group  policy:" + e);
                    }
                }
                WindowsCheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
            }
        } else if (currentPolicy == null) {
            logger.debug("Due to some connection error previous policy may null so get latest policy");
            PolicyManagementServerHelper.loadBackupPolicyElement((String)SettingHelper.getDeviceName());
            WindowsCheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
        }
        policyRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentPolicyRefereshInterval();
        statisticsRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentStatisticsRefereshInterval();
        if (policyRefreshIntervalInHrs != -1 && policyRefreshIntervalInHrs != 0) {
            SettingHelper.setTempPolicyRefreshIntervalInMins((int)policyRefreshIntervalInHrs);
            WindowsPolicyRefreshHelper.resetPolicyTimer();
        } else {
            SettingHelper.setTempPolicyRefreshIntervalInMins((int)60);
            WindowsPolicyRefreshHelper.resetPolicyTimer();
        }
        if (statisticsRefreshIntervalInHrs != -1 && statisticsRefreshIntervalInHrs != 0) {
            SettingHelper.setStatisticsRefreshIntervalInMins((int)statisticsRefreshIntervalInHrs);
            StatisticsCollectorHelper.resetStatisticsTimer();
        } else {
            SettingHelper.setStatisticsRefreshIntervalInMins((int)120);
            StatisticsCollectorHelper.resetStatisticsTimer();
        }
        NotificationHelper.policyRefreshStarted = false;
    }

    public static void loadBackupPolicyElement(String deviceName) {
        GroupPolicyElementList groupPolicyElementList = null;
        BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
        try {
            if (SettingHelper.getServerBackupLicensed().equals("true")) {
                List deviceContainerElements = backUpAdapter.getContainerDetails(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName()).getDeviceContainerElement();
                PolicyManagementServerHelper.createContainerDetalis((BackupPolicyDAOImpl)backupPolicyDAOImpl, (List)deviceContainerElements);
            }
            groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
        }
        catch (CrawlAdapterException protocolException) {
            logger.error("Client protocol exception." + (Object)((Object)protocolException));
            groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
        }
        catch (Exception e) {
            logger.debug("Exception in load backup policy so retrying it" + e);
            groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
        }
        if (!groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            try {
                PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)backupPolicyTo, (GroupPolicyElementList)groupPolicyElementList);
            }
            catch (Exception e) {
                logger.error("Error in adding policy details....." + e);
            }
        }
    }

    private static int getCurrentPolicyRefereshInterval() {
        int policyInterval = -1;
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            if (!NotificationHelper.getCurrentPolicyName().equals("")) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    currentPolicy = bkpPolicy;
                }
            } else {
                currentPolicy = (BackupPolicyTO)currentDetails.get(0);
            }
            if (currentPolicy != null) {
                policyInterval = currentPolicy.getPolicyRefreshInterval();
            }
        }
        return policyInterval;
    }

    private static int getCurrentStatisticsRefereshInterval() {
        int statisticsInterval = -1;
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            if (!NotificationHelper.getCurrentPolicyName().equals("")) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    currentPolicy = bkpPolicy;
                }
            } else {
                currentPolicy = (BackupPolicyTO)currentDetails.get(0);
            }
            if (currentPolicy != null) {
                statisticsInterval = currentPolicy.getStatisticsRefreshInterval();
            }
        }
        logger.info("Current statistics interval from policy:" + statisticsInterval);
        return statisticsInterval;
    }

    private static GroupPolicyElementList retryUsingUpdatedIp() {
        logger.debug("Retrying to get policy information.");
        SettingHelper.checkAndUpdateIpAddress();
        String currentIP = SettingHelper.getPublicIpAddress();
        GroupPolicyElementList groupPolicyElementList = null;
        try {
            groupPolicyElementList = backUpAdapter.getGroupPolicyElement(currentIP, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
        }
        catch (CrawlAdapterException protocolException) {
            logger.error("client protocol exception...." + (Object)((Object)protocolException));
            currentIP = SettingHelper.getGaeLocalIpAddress();
            groupPolicyElementList = WindowsCheckBackupPolicy.checkWithGaeLocalIp(currentIP);
        }
        catch (Exception e) {
            logger.error("Error in retrying  to get policy:" + e);
        }
        if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            SettingHelper.setCurrentCloudIpAddress((String)currentIP);
            SettingHelper.applyChangesToSharedPreferences((boolean)false);
            return groupPolicyElementList;
        }
        return null;
    }

    private static GroupPolicyElementList checkWithGaeLocalIp(String currentIP) {
        GroupPolicyElementList groupPolicyElementList = null;
        try {
            groupPolicyElementList = backUpAdapter.getGroupPolicyElement(currentIP, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
        }
        catch (Exception exception) {
            logger.error("exception while get policy....." + exception);
        }
        if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            return groupPolicyElementList;
        }
        return null;
    }

    private static void checkPolicyNameAndDeleteBackupDb() {
        if (SettingHelper.getIsEnableBackupPolicy().equalsIgnoreCase("true")) {
            BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
            List currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
            BackupPolicyTO currentPolicy = null;
            if (currentDetails != null && !currentDetails.isEmpty()) {
                if (!NotificationHelper.getCurrentPolicyName().equals("")) {
                    for (BackupPolicyTO bkpPolicy : currentDetails) {
                        if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                        currentPolicy = bkpPolicy;
                    }
                } else {
                    currentPolicy = (BackupPolicyTO)currentDetails.get(0);
                }
                String policyName = "";
                if (currentPolicy != null) {
                    policyName = currentPolicy.getPolicyGroupName();
                }
                logger.debug("Policy Name: " + policyName);
                if (!StringUtils.isEmpty((String)policyName) && policyName.contentEquals("RESTART")) {
                    BackUpImageDAOImpl backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
                    backUpImageDAOImpl.deleteEntireTable();
                }
            }
        }
    }
}

