/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.windows;

import com.parablu.epa.helper.windows.PowerShellCommandProcessor;
import com.parablu.epa.helper.windows.PowerShellNotAvailableException;
import com.parablu.epa.helper.windows.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShell {
    private Process p;
    private PrintWriter commandWriter;
    private Logger logger = LoggerFactory.getLogger(PowerShell.class);
    private boolean closed = false;
    private ExecutorService threadpool;
    private static final int MAX_THREADS = 3;
    static final int WAIT_PAUSE = 3;
    static final int MAX_WAIT_IN_MIN = 60000;
    static final int MAX_WAIT = 86400000;
    private static int exitValue = 1;

    private PowerShell() {
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        return powerShell;
    }

    public PowerShellResponse executeCommand(String command) {
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-ExecutionPolicy", "ByPass", "-NonInteractive", "-Command ", command + "; Write-Output \"endofvss\"; exit $LastExitCode");
        try {
            this.p = pb.start();
        }
        catch (IOException ex) {
            try {
                throw new PowerShellNotAvailableException("Cannot execute PowerShell.exe. Please make sure that it is installed in your system", ex);
            }
            catch (PowerShellNotAvailableException e) {
                this.logger.trace("" + e);
                this.logger.error("power shell not available Exception" + e.getMessage());
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception" + e.getMessage());
            }
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor(this.p.getInputStream(), true);
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor(this.p.getErrorStream(), false);
        String commandOutput = "";
        boolean isError = false;
        this.threadpool = Executors.newFixedThreadPool(3);
        Future result = this.threadpool.submit(commandProcessor);
        Future resultError = this.threadpool.submit(commandProcessorError);
        try {
            while (!result.isDone()) {
                Thread.sleep(3L);
            }
            commandOutput = result.isDone() ? (String)result.get() : (String)resultError.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            this.logger.trace("" + ex);
            this.logger.error("Unexpected error when processing PowerShell command", (Throwable)ex);
        }
        return new PowerShellResponse(isError, commandOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(boolean isManual) {
        if (!this.closed) {
            try {
                Callable<Integer> callable = () -> {
                    this.logger.debug("started closeTask");
                    this.commandWriter.close();
                    this.p.getInputStream().close();
                    this.p.getErrorStream().close();
                    exitValue = this.p.waitFor();
                    return exitValue;
                };
                Future<Integer> closeTask = this.threadpool.submit(callable);
                int closingTime = 0;
                while (!closeTask.isDone()) {
                    if (isManual || closingTime > 86400000) {
                        this.logger.error("Unexpected error when closing PowerShell: TIMEOUT!");
                        break;
                    }
                    Thread.sleep(3L);
                    closingTime += 3;
                }
            }
            catch (InterruptedException ex) {
                this.logger.trace("" + ex);
                this.logger.error("Unexpected error when processing PowerShell command", (Throwable)ex);
            }
            finally {
                if (this.threadpool != null) {
                    this.threadpool.shutdownNow();
                    try {
                        this.threadpool.awaitTermination(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        this.logger.trace("" + e);
                        this.logger.error("Interrupted exception", (Object)e.getMessage());
                    }
                    this.logger.debug(">>>> Threadpool shutdown");
                    while (!this.threadpool.isTerminated()) {
                        this.logger.debug("Threadpool active");
                        try {
                            this.logger.debug("********Sleeping when trad pol not terminated");
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            this.logger.trace("" + e);
                            this.logger.error("Interrupted exception", (Object)e.getMessage());
                        }
                    }
                }
                this.closed = true;
            }
        }
        return exitValue;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.logger.debug("Finalize executed because Powershell session was not properly closed!");
            this.close(false);
        }
        super.finalize();
    }
}

