/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.parablu.epa.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParabluFileSystemUtils {
    private Logger logger = LoggerFactory.getLogger(ParabluFileSystemUtils.class);

    public void splitAndWrite(String sourceFilePath, String destinationPath, int chunkSize, boolean isCompressionEnabled) throws IOException, NoSuchAlgorithmException {
        this.logger.debug("Inside chunk file split and write");
        int chunkableSizeFromPolicy = chunkSize;
        int policyChunkSize = chunkableSizeFromPolicy * 0x100000;
        this.logger.debug("CHUNK_SIZE =" + policyChunkSize + " orig=" + chunkableSizeFromPolicy);
        int bufferSize = 524288;
        File willBeRead = new File(sourceFilePath);
        if (!willBeRead.exists()) {
            return;
        }
        long fileSize = willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            this.logger.debug("Inside split and write function");
            while (totalBytesRead < fileSize) {
                GZIPOutputStream gzOutputStream;
                String partName = Integer.toString(numberOfChunks);
                long bytesWritten = 0L;
                this.logger.debug("Starting new chunk");
                CountingOutputStream compressedStream = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destinationPath + partName)));
                if (isCompressionEnabled) {
                    gzOutputStream = new GZIPOutputStream((OutputStream)compressedStream);
                } else {
                    this.logger.debug("compression not enabled>>>>>");
                    gzOutputStream = compressedStream;
                }
                CountingOutputStream output = new CountingOutputStream((OutputStream)gzOutputStream);
                while (bytesWritten < (long)policyChunkSize) {
                    int bytesRead;
                    long bytesRemaining = fileSize - totalBytesRead;
                    if (bytesRemaining < (long)bufferSize) {
                        bufferSize = Integer.parseInt(Long.toString(bytesRemaining));
                        this.logger.debug("BUFFER SIZE: " + bufferSize);
                    }
                    if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[bufferSize], 0, bufferSize)) > 0) {
                        totalBytesRead += (long)bytesRead;
                    }
                    output.write(temporary);
                    bytesWritten = compressedStream.getByteCount();
                    this.logger.debug("compressed =" + compressedStream.getByteCount() + " uncompressed =" + output.getByteCount());
                    this.logger.debug("bytesWritten: " + bytesWritten + " bytesRemaining: " + bytesRemaining);
                    if (totalBytesRead == fileSize) {
                        this.logger.debug("finished writing file");
                        break;
                    }
                    this.logger.trace("Writing Process Was Performed");
                }
                output.close();
                File tempFile = new File(destinationPath + partName);
                String tempFileMd5 = MD5Generator.generateMD5OfFile(tempFile);
                String newName = String.format("part%09d.%s", ++numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, tempFile.getPath());
                this.logger.trace(tempFileMd5 + "Total Bytes Read: " + tempFile.getPath());
            }
            this.logger.debug("End of split and write function");
        }
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        this.logger.trace("Writing Process Was Performed");
        ((OutputStream)output).close();
    }

    public String convertStringTOBase64(String name) {
        String retValue = "";
        if (!StringUtils.isEmpty((String)name)) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            String base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            this.logger.debug("encoded value for given file is " + base64EncodeString);
            retValue = base64EncodeString.replaceAll("/", "_");
        }
        return retValue;
    }
}

