/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.transformer;

import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupPolicyElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.element.CloudInfoElement;
import com.parablu.epa.core.element.ContainerListElement;
import com.parablu.epa.core.element.CrawlResponseElement;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.DeviceListElement;
import com.parablu.epa.core.element.DeviceRegistrationElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.FolderDeviceListElement;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.MediaListResponseElement;
import com.parablu.epa.core.element.MediaSyncResponseElement;
import com.parablu.epa.core.element.MiniCloudCompleteElementList;
import com.parablu.epa.core.element.SearchResultElement;
import com.parablu.epa.core.to.ResponseTO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.GZIPInputStream;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Xmlparser {
    private static final String EXCEPTION = "Exception :";
    private static Logger logger = LoggerFactory.getLogger(Xmlparser.class);

    private Xmlparser() {
    }

    public static MiniCloudCompleteElementList parseinitiateCrawlXml(String xml) {
        MiniCloudCompleteElementList miniCloudElementList = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            miniCloudElementList = (MiniCloudCompleteElementList)serializer.read(MiniCloudCompleteElementList.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return miniCloudElementList;
    }

    public static BackupElement parseBackupElementResponse(String xml) {
        BackupElement backupElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            backupElement = (BackupElement)serializer.read(BackupElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return backupElement;
    }

    public static CrawlResponseElement parseCrawlXml(String xml) {
        CrawlResponseElement crawlResponseElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            crawlResponseElement = (CrawlResponseElement)serializer.read(CrawlResponseElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseElement;
    }

    public static CrawlResponseElement parseCrawlXml(ResponseTO xml) {
        if (xml == null) {
            return null;
        }
        CrawlResponseElement crawlResponseElement = null;
        try (FileInputStream fs = new FileInputStream(new File(xml.getResponse()));
             GZIPInputStream gzipInputStream = new GZIPInputStream(fs);){
            Persister serializer = new Persister();
            crawlResponseElement = (CrawlResponseElement)serializer.read(CrawlResponseElement.class, (InputStream)gzipInputStream, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseElement;
    }

    public static CrawlResponseElement parseCrawlGzip(byte[] bs) {
        if (bs == null) {
            return null;
        }
        CrawlResponseElement crawlResponseElement = null;
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bs);
             GZIPInputStream gzipInputStream = new GZIPInputStream(byteStream);){
            Persister serializer = new Persister();
            crawlResponseElement = (CrawlResponseElement)serializer.read(CrawlResponseElement.class, (InputStream)gzipInputStream, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return crawlResponseElement;
    }

    public static BackupListResponseElement parseBackupListResponse(byte[] bs) {
        if (bs == null) {
            return null;
        }
        BackupListResponseElement backupListResponseElement = null;
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bs);
             GZIPInputStream gzipInputStream = new GZIPInputStream(byteStream);){
            Persister serializer = new Persister();
            backupListResponseElement = (BackupListResponseElement)serializer.read(BackupListResponseElement.class, (InputStream)gzipInputStream);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return backupListResponseElement;
    }

    public static MediaListResponseElement parseMediaListResponse(byte[] bs) {
        if (bs == null) {
            return null;
        }
        MediaListResponseElement mediaListResponseElement = null;
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bs);
             GZIPInputStream gzipInputStream = new GZIPInputStream(byteStream);){
            Persister serializer = new Persister();
            mediaListResponseElement = (MediaListResponseElement)serializer.read(MediaListResponseElement.class, (InputStream)gzipInputStream);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return mediaListResponseElement;
    }

    public static MediaSyncResponseElement parseMediaSyncResponse(byte[] bs) {
        if (bs == null) {
            return null;
        }
        MediaSyncResponseElement mediaSyncResponseElement = null;
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bs);
             GZIPInputStream gzipInputStream = new GZIPInputStream(byteStream);){
            Persister serializer = new Persister();
            mediaSyncResponseElement = (MediaSyncResponseElement)serializer.read(MediaSyncResponseElement.class, (InputStream)gzipInputStream);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return mediaSyncResponseElement;
    }

    public static DeviceRegistrationElement parseDeviceRegistrationResponse(String xml) {
        DeviceRegistrationElement deviceElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            deviceElement = (DeviceRegistrationElement)serializer.read(DeviceRegistrationElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return deviceElement;
    }

    public static SearchResultElement parsesearchResultResponse(String xml) {
        SearchResultElement searchResultElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            searchResultElement = (SearchResultElement)serializer.read(SearchResultElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return searchResultElement;
    }

    public static CloudInfoElement parseCloudInformation(String xml) {
        CloudInfoElement cloudElement = null;
        Persister serializer = new Persister();
        StringReader xmlReader = new StringReader(xml);
        try {
            cloudElement = (CloudInfoElement)serializer.read(CloudInfoElement.class, (Reader)xmlReader, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return cloudElement;
    }

    public static DeviceListElement parseDeviceListResponse(String xml) {
        DeviceListElement deviceListElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            deviceListElement = (DeviceListElement)serializer.read(DeviceListElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return deviceListElement;
    }

    public static FolderDeviceListElement parseFolderDeviceListResponse(String xml) {
        FolderDeviceListElement folderdeviceListElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            folderdeviceListElement = (FolderDeviceListElement)serializer.read(FolderDeviceListElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return folderdeviceListElement;
    }

    public static FolderDeviceListElement parseFolderFileListElementResponse(String xml) {
        FolderDeviceListElement folderListElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            folderListElement = (FolderDeviceListElement)serializer.read(FolderDeviceListElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return folderListElement;
    }

    public static FileListElement parseFileListElementResponse(String xml) {
        FileListElement fileListElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            fileListElement = (FileListElement)serializer.read(FileListElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return fileListElement;
    }

    public static BackupPolicyElement parseBackupPolicyElementResponse(String xml) {
        BackupPolicyElement backupPolicyElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            backupPolicyElement = (BackupPolicyElement)serializer.read(BackupPolicyElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return backupPolicyElement;
    }

    public static GroupPolicyElement parseGroupPolicyElementResponse(String xml) {
        GroupPolicyElement groupPolicyElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            groupPolicyElement = (GroupPolicyElement)serializer.read(GroupPolicyElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return groupPolicyElement;
    }

    public static void printGzipString(GZIPInputStream bais) {
        try (InputStreamReader reader = new InputStreamReader(bais);
             BufferedReader in = new BufferedReader(reader);){
            String readed;
            while ((readed = in.readLine()) != null) {
                logger.debug("GZIP RESPONSE:");
                logger.debug(readed);
            }
        }
        catch (Exception e) {
            logger.error("Exception happened in printGzip string>>>>" + e);
        }
    }

    public static BackupStatusElement parseBackupStatusElementResponse(String xml) {
        BackupStatusElement backupStatusElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            backupStatusElement = (BackupStatusElement)serializer.read(BackupStatusElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
        }
        return backupStatusElement;
    }

    public static ContainerListElement parseContainerListElementResponse(String xml) {
        ContainerListElement cotainerListElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            cotainerListElement = (ContainerListElement)serializer.read(ContainerListElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return cotainerListElement;
    }

    public static GroupPolicyElementList parseGroupPolicyElementListResponse(String xml) {
        GroupPolicyElementList groupPolicyElementList = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            groupPolicyElementList = (GroupPolicyElementList)serializer.read(GroupPolicyElementList.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return groupPolicyElementList;
    }

    public static DeviceElement parseDeviceResponse(String xml) {
        DeviceElement deviceElement = null;
        try {
            Persister serializer = new Persister();
            StringReader r = new StringReader(xml);
            deviceElement = (DeviceElement)serializer.read(DeviceElement.class, (Reader)r, false);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
        }
        return deviceElement;
    }
}

