/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.network;

import com.parablu.epa.core.adapter.api.ApiAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.helper.utils.MD5Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkHelper {
    static Logger logger = LoggerFactory.getLogger(NetworkHelper.class);

    private NetworkHelper() {
    }

    public static synchronized boolean updateGaeIpFromServer(String cloudName, String keyStore, String[] port, String[] ipList) {
        logger.debug("Starting the publicIp Search");
        ApiAdapter gae = new ApiAdapter(keyStore);
        String cloudNameHash = MD5Generator.generateMD5OfString((String)(cloudName + "-:-"));
        logger.debug("The CloudNameHash IS" + cloudNameHash);
        if (cloudNameHash == null) {
            return false;
        }
        try {
            logger.debug("Making the call to Gae");
            gae.getCloudIPFromAmazon(cloudName, ipList, port);
            return ipList[0] != null && ipList[0] != "" || ipList[1] != null && ipList[1] != "";
        }
        catch (CrawlAdapterException e) {
            logger.error("Exception in CloudRegistrationService :" + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            return false;
        }
    }
}

