/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.helper.ExtIOFilter;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtility {
    private Logger logger = LoggerFactory.getLogger(FileSystemUtility.class);
    private int lengthOfParablu = "ParaBlu".length();
    private static final String PARENT_DIR = "The parent directory is :";
    private static final String CHUNK = "CHUNK";
    private static final String DOT_PBS = ".pbsdn";
    private int lastSuccessfulCrawledTime = 0;
    private int count = 1;

    public List<FileTO> crawlFolder(String folderPath, String devicePath, long lastSuccessfulCrawlTimeStamp, String miniCloudId) {
        ArrayList<FileTO> crawledfilesTOList = null;
        File currentFolder = new File(folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        this.logger.debug("Count of sub directories and files in the parent directory (crawlFolder) :" + childFileAndFolderNames.length);
        this.logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<FileTO> fileTOList;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            String completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + completePath;
            String fileName = currentProcessingFile.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, completePath, fileName);
            if (!isFileADirectory || (fileTOList = this.crawlFolder(currentProcessingFile.getAbsolutePath(), devicePath, lastSuccessfulCrawlTimeStamp, miniCloudId)) == null) continue;
            crawledfilesTOList.addAll(fileTOList);
        }
        return crawledfilesTOList;
    }

    public List<FileTO> crawlFolderEfficient(String folderPath, String devicePath, Map<String, FileTO> fileHashMap, String miniCloudId) {
        ArrayList<FileTO> crawledfilesTOList = null;
        Boolean checkList = true;
        File currentFolder = new File(folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        this.logger.debug("The number of sub directories and files in the parent directory (crawlFolderEfficient) :" + childFileAndFolderNames.length);
        this.logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<FileTO> curFileTOList;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(DOT_PBS)) {
                currentProcessingFile.delete();
            }
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory) {
                Long prevModifiedValue = null;
                FileTO fileTo = fileHashMap.get(absPath);
                Boolean isexists = null;
                if (fileTo != null) {
                    prevModifiedValue = fileTo.getLastModifiedTimestamp();
                    isexists = fileTo.isExists();
                }
                if (prevModifiedValue != null && prevModifiedValue.equals(currentProcessingFile.lastModified()) && isexists.booleanValue()) continue;
            }
            String completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + completePath;
            String fileName = currentProcessingFile.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, completePath, fileName);
            if (!isFileADirectory || (curFileTOList = this.crawlFolderEfficient(currentProcessingFile.getAbsolutePath(), devicePath, fileHashMap, miniCloudId)) == null) continue;
            crawledfilesTOList.addAll(curFileTOList);
        }
        return crawledfilesTOList;
    }

    public List<FileTO> crawlFolderEfficientExcludingMiniClouds(String folderPath, String devicePath, Map<String, FileTO> fileHashMap, String miniCloudId, List<String> minicloudNameList) {
        ArrayList<FileTO> crawledfilesTOList = null;
        Boolean checkList = true;
        File currentFolder = new File(folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        this.logger.debug("The number of sub directories and files in the parent directory :" + childFileAndFolderNames.length);
        this.logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<FileTO> curFileTOList;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(DOT_PBS)) {
                currentProcessingFile.delete();
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (minicloudNameList.contains(currentProcessingFile.getName())) continue;
            if (checkList.booleanValue() && !isFileADirectory) {
                FileTO fileTo = fileHashMap.get(absPath);
                Long prevModifiedValue = null;
                Boolean fileExists = null;
                if (fileTo != null) {
                    prevModifiedValue = fileTo.getLastModifiedTimestamp();
                    fileExists = fileTo.isExists();
                }
                if (prevModifiedValue != null && prevModifiedValue.equals(currentProcessingFile.lastModified()) && fileExists.booleanValue()) continue;
            }
            String fileName = currentProcessingFile.getName();
            String completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + completePath;
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, completePath, fileName);
            if (!isFileADirectory || (curFileTOList = this.crawlFolderEfficient(currentProcessingFile.getAbsolutePath(), devicePath, fileHashMap, miniCloudId)) == null) continue;
            crawledfilesTOList.addAll(curFileTOList);
        }
        return crawledfilesTOList;
    }

    private FileTO createFileToAndAddDetailsToList(String miniCloudId, List<FileTO> crawledfilesTOList, String md5Value, File currentProcessingFile, boolean isFileADirectory, String completePath, String fileName) {
        FileTO tempFileTO = new FileTO();
        tempFileTO.setExists(true);
        tempFileTO.setAbstractFilePath(completePath);
        tempFileTO.setFileName(fileName);
        tempFileTO.setFolder(isFileADirectory);
        tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
        tempFileTO.setMd5checksum(md5Value);
        tempFileTO.setMetaData("null");
        tempFileTO.setMiniCloudId(miniCloudId);
        crawledfilesTOList.add(tempFileTO);
        return tempFileTO;
    }

    public List<MediaTO> crawlFolderEfficientStoringFullPathsForMedia(String completeParentPath, Map<String, Long> fileHashMap, String[] extensions, String mediaType) {
        ArrayList<MediaTO> crawledfilesTOList = new ArrayList<MediaTO>();
        this.logger.debug("Extensions: " + extensions);
        this.logger.debug("Complete Parent Path: " + completeParentPath);
        File currentFolder = new File(completeParentPath);
        Boolean checkList = true;
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        ExtIOFilter extIOFilter = new ExtIOFilter(extensions);
        Iterator itr = FileUtils.iterateFiles((File)currentFolder, (IOFileFilter)extIOFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (itr.hasNext()) {
            Long prevModifiedValue;
            boolean isfileHidden;
            File currentProcessingFile = (File)itr.next();
            this.logger.debug("Current processing file for media: " + currentProcessingFile + " ");
            if (currentProcessingFile.getName().startsWith(DOT_PBS)) {
                currentProcessingFile.delete();
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) {
                this.logger.debug("Skipping file " + absPath);
                continue;
            }
            String completePath = absPath;
            String fileName = currentProcessingFile.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            MediaTO tempFileTO = new MediaTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(completePath);
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            tempFileTO.setExtension(FilenameUtils.getExtension((String)currentProcessingFile.getAbsolutePath()));
            tempFileTO.setMediaType(mediaType);
            crawledfilesTOList.add(tempFileTO);
        }
        return crawledfilesTOList;
    }

    public List<BackupTO> crawlFolderEfficientStoringFullPaths(String completeParentPath, Map<String, Long> fileHashMap) {
        ArrayList<BackupTO> crawledfilesTOList = null;
        Boolean checkList = true;
        boolean fileToBeSkipped = false;
        File currentFolder = new File(completeParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        crawledfilesTOList = new ArrayList<BackupTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            Long prevModifiedValue;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.isDirectory()) {
                fileToBeSkipped = this.fileSkip(currentProcessingFile.getName());
            }
            if (isfileHidden || fileToBeSkipped) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            String completePath = absPath;
            String fileName = currentProcessingFile.getName().replaceAll("[*!@^&{}<>|]", "~");
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : MD5Generator.generateMD5OfFile((File)currentProcessingFile);
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(completePath);
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
            tempFileTO.setMd5checksum(md5Value);
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            crawledfilesTOList.add(tempFileTO);
            if (!isFileADirectory) continue;
            List<BackupTO> curFileTOList = this.crawlFolderEfficientStoringFullPaths(currentProcessingFile.getAbsolutePath(), fileHashMap);
            if (curFileTOList != null) {
                crawledfilesTOList.addAll(curFileTOList);
            }
            if (crawledfilesTOList.size() <= 5) continue;
            this.logger.debug("BACKUPLIST >5000 so write in new file");
            crawledfilesTOList = new ArrayList();
            ++this.count;
        }
        return crawledfilesTOList;
    }

    private boolean fileSkip(String fileName) {
        for (BackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.values()) {
            if (!beSkipped.name().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith("Program Files")) continue;
            this.logger.debug("LIST OF FILES FROM ENUM SKIPPING FILE " + fileName);
            return true;
        }
        return false;
    }

    public List<FileTO> showFolderContent(String folderName) {
        List<FileTO> fileToList = null;
        this.logger.debug("FolderName in show folder content:" + folderName);
        return fileToList;
    }

    public int getLastSuccessfulCrawledTime() {
        return this.lastSuccessfulCrawledTime;
    }
}

