/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.annotation.AnnotationType;

public final class AnnotationSupport {
    private static final JavaLangAccess LANG_ACCESS = SharedSecrets.getJavaLangAccess();

    public static <A extends Annotation> A[] getDirectlyAndIndirectlyPresent(Map<Class<? extends Annotation>, Annotation> map, Class<A> clazz) {
        Annotation[] annotationArray;
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        Annotation annotation = map.get(clazz);
        if (annotation != null) {
            arrayList.add(annotation);
        }
        if ((annotationArray = AnnotationSupport.getIndirectlyPresent(map, clazz)) != null && annotationArray.length != 0) {
            boolean bl = annotation == null || AnnotationSupport.containerBeforeContainee(map, clazz);
            arrayList.addAll(bl ? 0 : 1, Arrays.asList(annotationArray));
        }
        Annotation[] annotationArray2 = (Annotation[])Array.newInstance(clazz, arrayList.size());
        return arrayList.toArray(annotationArray2);
    }

    private static <A extends Annotation> A[] getIndirectlyPresent(Map<Class<? extends Annotation>, Annotation> map, Class<A> clazz) {
        Repeatable repeatable = clazz.getDeclaredAnnotation(Repeatable.class);
        if (repeatable == null) {
            return null;
        }
        Class<? extends Annotation> clazz2 = repeatable.value();
        Annotation annotation = map.get(clazz2);
        if (annotation == null) {
            return null;
        }
        Annotation[] annotationArray = AnnotationSupport.getValueArray((Annotation)annotation);
        AnnotationSupport.checkTypes((Annotation[])annotationArray, (Annotation)annotation, clazz);
        return annotationArray;
    }

    private static <A extends Annotation> boolean containerBeforeContainee(Map<Class<? extends Annotation>, Annotation> map, Class<A> clazz) {
        Class<? extends Annotation> clazz2 = clazz.getDeclaredAnnotation(Repeatable.class).value();
        for (Class<? extends Annotation> clazz3 : map.keySet()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (clazz3 != clazz) continue;
            return false;
        }
        return false;
    }

    public static <A extends Annotation> A[] getAssociatedAnnotations(Map<Class<? extends Annotation>, Annotation> map, Class<?> clazz, Class<A> clazz2) {
        Objects.requireNonNull(clazz);
        Annotation[] annotationArray = AnnotationSupport.getDirectlyAndIndirectlyPresent(map, clazz2);
        if (AnnotationType.getInstance(clazz2).isInherited()) {
            for (Class<?> clazz3 = clazz.getSuperclass(); annotationArray.length == 0 && clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                annotationArray = AnnotationSupport.getDirectlyAndIndirectlyPresent((Map)LANG_ACCESS.getDeclaredAnnotationMap(clazz3), clazz2);
            }
        }
        return annotationArray;
    }

    private static <A extends Annotation> A[] getValueArray(Annotation annotation) {
        try {
            Class<? extends Annotation> clazz = annotation.annotationType();
            AnnotationType annotationType = AnnotationType.getInstance(clazz);
            if (annotationType == null) {
                throw AnnotationSupport.invalidContainerException(annotation, null);
            }
            Method method = annotationType.members().get("value");
            if (method == null) {
                throw AnnotationSupport.invalidContainerException(annotation, null);
            }
            method.setAccessible(true);
            Annotation[] annotationArray = (Annotation[])method.invoke((Object)annotation, new Object[0]);
            return annotationArray;
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw AnnotationSupport.invalidContainerException(annotation, exception);
        }
    }

    private static AnnotationFormatError invalidContainerException(Annotation annotation, Throwable throwable) {
        return new AnnotationFormatError(annotation + " is an invalid container for repeating annotations", throwable);
    }

    private static <A extends Annotation> void checkTypes(A[] AArray, Annotation annotation, Class<A> clazz) {
        for (A a : AArray) {
            if (clazz.isInstance(a)) continue;
            throw new AnnotationFormatError(String.format("%s is an invalid container for repeating annotations of type: %s", annotation, clazz));
        }
    }
}

