/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsUserPrincipals;

class WindowsUserPrincipals {
    private WindowsUserPrincipals() {
    }

    static UserPrincipal fromSid(long l) throws IOException {
        int n;
        String string;
        String string2;
        try {
            string2 = WindowsNativeDispatcher.ConvertSidToStringSid((long)l);
            if (string2 == null) {
                throw new AssertionError();
            }
        }
        catch (WindowsException windowsException) {
            throw new IOException("Unable to convert SID to String: " + windowsException.errorString());
        }
        WindowsNativeDispatcher.Account account = null;
        try {
            account = WindowsNativeDispatcher.LookupAccountSid((long)l);
            string = account.domain() + "\\" + account.name();
        }
        catch (WindowsException windowsException) {
            string = string2;
        }
        int n2 = n = account == null ? 8 : account.use();
        if (n == 2 || n == 5 || n == 4) {
            return new Group(string2, n, string);
        }
        return new User(string2, n, string);
    }

    static UserPrincipal lookup(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("lookupUserInformation"));
        }
        int n = 0;
        try {
            n = WindowsNativeDispatcher.LookupAccountName((String)string, (long)0L, (int)0);
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 1332) {
                throw new UserPrincipalNotFoundException(string);
            }
            throw new IOException(string + ": " + windowsException.errorString());
        }
        assert (n > 0);
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n);
        try {
            int n2 = WindowsNativeDispatcher.LookupAccountName((String)string, (long)nativeBuffer.address(), (int)n);
            if (n2 != n) {
                throw new AssertionError((Object)"SID change during lookup");
            }
            UserPrincipal userPrincipal = WindowsUserPrincipals.fromSid(nativeBuffer.address());
            return userPrincipal;
        }
        catch (WindowsException windowsException) {
            throw new IOException(string + ": " + windowsException.errorString());
        }
        finally {
            nativeBuffer.release();
        }
    }

    static class Group
    extends User
    implements GroupPrincipal {
        Group(String string, int n, String string2) {
            super(string, n, string2);
        }
    }
}

