/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import javax.xml.validation.SecuritySupport;

class SchemaFactoryFinder {
    private static boolean debug = false;
    private static final SecuritySupport ss = new SecuritySupport();
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static final Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private final ClassLoader classLoader;
    private static final Class<SchemaFactory> SERVICE_CLASS;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public SchemaFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String schemaLanguage) {
        if (schemaLanguage == null) {
            throw new NullPointerException();
        }
        SchemaFactory f = this._newFactory(schemaLanguage);
        if (f != null) {
            SchemaFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + schemaLanguage);
        } else {
            SchemaFactoryFinder.debugPrintln("unable to find a factory for " + schemaLanguage);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String schemaLanguage) {
        SchemaFactory factoryImpl;
        block17: {
            SchemaFactory sf;
            String propertyName;
            block16: {
                propertyName = SERVICE_CLASS.getName() + ":" + schemaLanguage;
                try {
                    SchemaFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    String r = ss.getSystemProperty(propertyName);
                    if (r != null) {
                        SchemaFactoryFinder.debugPrintln("The value is '" + r + "'");
                        sf = this.createInstance(r, true);
                        if (sf != null) {
                            return sf;
                        }
                    } else {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block16;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = ss.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                SchemaFactoryFinder.debugPrintln("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                String factoryClassName = cacheProps.getProperty(propertyName);
                SchemaFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName, true)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block17;
                ex.printStackTrace();
            }
        }
        if ((factoryImpl = this.findServiceProvider(schemaLanguage)) != null) {
            return factoryImpl;
        }
        if (schemaLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
            SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema validator");
            return this.createInstance("com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", true);
        }
        SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class<?> createClass(String className) {
        Class<?> clazz;
        boolean internal = false;
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            internal = true;
        }
        try {
            clazz = this.classLoader != null && !internal ? Class.forName(className, false, this.classLoader) : Class.forName(className);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    SchemaFactory createInstance(String className) {
        return this.createInstance(className, false);
    }

    SchemaFactory createInstance(String className, boolean useServicesMechanism) {
        SchemaFactory schemaFactory = null;
        SchemaFactoryFinder.debugPrintln("createInstance(" + className + ")");
        Class<?> clazz = this.createClass(className);
        if (clazz == null) {
            SchemaFactoryFinder.debugPrintln("failed to getClass(" + className + ")");
            return null;
        }
        SchemaFactoryFinder.debugPrintln("loaded " + className + " from " + SchemaFactoryFinder.which(clazz));
        try {
            if (!SchemaFactory.class.isAssignableFrom(clazz)) {
                throw new ClassCastException(clazz.getName() + " cannot be cast to " + SchemaFactory.class);
            }
            if (!useServicesMechanism) {
                schemaFactory = SchemaFactoryFinder.newInstanceNoServiceLoader(clazz);
            }
            if (schemaFactory == null) {
                schemaFactory = (SchemaFactory)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return schemaFactory;
    }

    private static SchemaFactory newInstanceNoServiceLoader(Class<?> providerClass) {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method creationMethod = providerClass.getDeclaredMethod("newXMLSchemaFactoryNoServiceLoader", new Class[0]);
            int modifiers = creationMethod.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                return null;
            }
            Class<?> returnType = creationMethod.getReturnType();
            if (SERVICE_CLASS.isAssignableFrom(returnType)) {
                return SERVICE_CLASS.cast(creationMethod.invoke(null, (Object[])null));
            }
            throw new ClassCastException(returnType + " cannot be cast to " + SERVICE_CLASS);
        }
        catch (ClassCastException e) {
            throw new SchemaFactoryConfigurationError(e.getMessage(), e);
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private boolean isSchemaLanguageSupportedBy(final SchemaFactory factory, final String schemaLanguage, AccessControlContext acc) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return factory.isSchemaLanguageSupported(schemaLanguage);
            }
        }, acc);
    }

    private SchemaFactory findServiceProvider(final String schemaLanguage) {
        assert (schemaLanguage != null);
        final AccessControlContext acc = AccessController.getContext();
        try {
            return AccessController.doPrivileged(new PrivilegedAction<SchemaFactory>(){

                @Override
                public SchemaFactory run() {
                    ServiceLoader<SchemaFactory> loader = ServiceLoader.load(SERVICE_CLASS);
                    for (SchemaFactory factory : loader) {
                        if (!SchemaFactoryFinder.this.isSchemaLanguageSupportedBy(factory, schemaLanguage, acc)) continue;
                        return factory;
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError error) {
            throw new SchemaFactoryConfigurationError("Provider for " + SERVICE_CLASS + " cannot be created", error);
        }
    }

    private static String which(Class<?> clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = ss.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception unused) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
    }
}

