/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import sun.util.calendar.BaseCalendar;
import sun.util.logging.PlatformLogger;

public final class HijrahChronology
extends AbstractChronology
implements Serializable {
    private final transient String typeId;
    private final transient String calendarType;
    private static final long serialVersionUID = 3127340209035924785L;
    public static final HijrahChronology INSTANCE;
    private volatile transient boolean initComplete;
    private transient int[] hijrahEpochMonthStartDays;
    private transient int minEpochDay;
    private transient int maxEpochDay;
    private transient int hijrahStartEpochMonth;
    private transient int minMonthLength;
    private transient int maxMonthLength;
    private transient int minYearLength;
    private transient int maxYearLength;
    private static final transient Properties calendarProperties;
    private static final String PROP_PREFIX = "calendar.hijrah.";
    private static final String PROP_TYPE_SUFFIX = ".type";
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VERSION = "version";
    private static final String KEY_ISO_START = "iso-start";

    private static void registerVariants() {
        for (String string : calendarProperties.stringPropertyNames()) {
            String string2;
            if (!string.startsWith(PROP_PREFIX) || (string2 = string.substring(PROP_PREFIX.length())).indexOf(46) >= 0 || string2.equals(INSTANCE.getId())) continue;
            try {
                HijrahChronology hijrahChronology = new HijrahChronology(string2);
                AbstractChronology.registerChrono(hijrahChronology);
            }
            catch (DateTimeException dateTimeException) {
                PlatformLogger platformLogger = PlatformLogger.getLogger("java.time.chrono");
                platformLogger.severe("Unable to initialize Hijrah calendar: " + string2, dateTimeException);
            }
        }
    }

    private HijrahChronology(String string) throws DateTimeException {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("calendar id is empty");
        }
        String string2 = PROP_PREFIX + string + PROP_TYPE_SUFFIX;
        String string3 = calendarProperties.getProperty(string2);
        if (string3 == null || string3.isEmpty()) {
            throw new DateTimeException("calendarType is missing or empty for: " + string2);
        }
        this.typeId = string;
        this.calendarType = string3;
    }

    private void checkCalendarInit() {
        if (!this.initComplete) {
            this.loadCalendarData();
            this.initComplete = true;
        }
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public String getCalendarType() {
        return this.calendarType;
    }

    @Override
    public HijrahDate date(Era era, int n, int n2, int n3) {
        return this.date(this.prolepticYear(era, n), n2, n3);
    }

    @Override
    public HijrahDate date(int n, int n2, int n3) {
        return HijrahDate.of(this, n, n2, n3);
    }

    @Override
    public HijrahDate dateYearDay(Era era, int n, int n2) {
        return this.dateYearDay(this.prolepticYear(era, n), n2);
    }

    @Override
    public HijrahDate dateYearDay(int n, int n2) {
        HijrahDate hijrahDate = HijrahDate.of(this, n, 1, 1);
        if (n2 > hijrahDate.lengthOfYear()) {
            throw new DateTimeException("Invalid dayOfYear: " + n2);
        }
        return hijrahDate.plusDays(n2 - 1);
    }

    @Override
    public HijrahDate dateEpochDay(long l) {
        return HijrahDate.ofEpochDay(this, l);
    }

    @Override
    public HijrahDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public HijrahDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    @Override
    public HijrahDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public HijrahDate date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof HijrahDate) {
            return (HijrahDate)temporalAccessor;
        }
        return HijrahDate.ofEpochDay(this, temporalAccessor.getLong(ChronoField.EPOCH_DAY));
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporalAccessor) {
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        this.checkCalendarInit();
        int n = this.yearToEpochMonth((int)l);
        if (n < 0 || n > this.maxEpochDay) {
            throw new DateTimeException("Hijrah date out of range");
        }
        int n2 = this.getYearLength((int)l);
        return n2 > 354;
    }

    @Override
    public int prolepticYear(Era era, int n) {
        if (!(era instanceof HijrahEra)) {
            throw new ClassCastException("Era must be HijrahEra");
        }
        return n;
    }

    @Override
    public HijrahEra eraOf(int n) {
        switch (n) {
            case 1: {
                return HijrahEra.AH;
            }
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(HijrahEra.values());
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        this.checkCalendarInit();
        if (chronoField instanceof ChronoField) {
            ChronoField chronoField2 = chronoField;
            switch (chronoField2) {
                case DAY_OF_MONTH: {
                    return ValueRange.of(1L, 1L, this.getMinimumMonthLength(), this.getMaximumMonthLength());
                }
                case DAY_OF_YEAR: {
                    return ValueRange.of(1L, this.getMaximumDayOfYear());
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return ValueRange.of(1L, 5L);
                }
                case YEAR: 
                case YEAR_OF_ERA: {
                    return ValueRange.of(this.getMinimumYear(), this.getMaximumYear());
                }
                case ERA: {
                    return ValueRange.of(1L, 1L);
                }
            }
            return chronoField.range();
        }
        return chronoField.range();
    }

    @Override
    public HijrahDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        return (HijrahDate)super.resolveDate(map, resolverStyle);
    }

    int checkValidYear(long l) {
        if (l < (long)this.getMinimumYear() || l > (long)this.getMaximumYear()) {
            throw new DateTimeException("Invalid Hijrah year: " + l);
        }
        return (int)l;
    }

    void checkValidDayOfYear(int n) {
        if (n < 1 || n > this.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid Hijrah day of year: " + n);
        }
    }

    void checkValidMonth(int n) {
        if (n < 1 || n > 12) {
            throw new DateTimeException("Invalid Hijrah month: " + n);
        }
    }

    int[] getHijrahDateInfo(int n) {
        this.checkCalendarInit();
        if (n < this.minEpochDay || n >= this.maxEpochDay) {
            throw new DateTimeException("Hijrah date out of range");
        }
        int n2 = this.epochDayToEpochMonth(n);
        int n3 = this.epochMonthToYear(n2);
        int n4 = this.epochMonthToMonth(n2);
        int n5 = this.epochMonthToEpochDay(n2);
        int n6 = n - n5;
        int[] nArray = new int[]{n3, n4 + 1, n6 + 1};
        return nArray;
    }

    long getEpochDay(int n, int n2, int n3) {
        this.checkCalendarInit();
        this.checkValidMonth(n2);
        int n4 = this.yearToEpochMonth(n) + (n2 - 1);
        if (n4 < 0 || n4 >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + n + ", month: " + n2);
        }
        if (n3 < 1 || n3 > this.getMonthLength(n, n2)) {
            throw new DateTimeException("Invalid Hijrah day of month: " + n3);
        }
        return this.epochMonthToEpochDay(n4) + (n3 - 1);
    }

    int getDayOfYear(int n, int n2) {
        return this.yearMonthToDayOfYear(n, n2 - 1);
    }

    int getMonthLength(int n, int n2) {
        int n3 = this.yearToEpochMonth(n) + (n2 - 1);
        if (n3 < 0 || n3 >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + n + ", month: " + n2);
        }
        return this.epochMonthLength(n3);
    }

    int getYearLength(int n) {
        return this.yearMonthToDayOfYear(n, 12);
    }

    int getMinimumYear() {
        return this.epochMonthToYear(0);
    }

    int getMaximumYear() {
        return this.epochMonthToYear(this.hijrahEpochMonthStartDays.length - 1) - 1;
    }

    int getMaximumMonthLength() {
        return this.maxMonthLength;
    }

    int getMinimumMonthLength() {
        return this.minMonthLength;
    }

    int getMaximumDayOfYear() {
        return this.maxYearLength;
    }

    int getSmallestMaximumDayOfYear() {
        return this.minYearLength;
    }

    private int epochDayToEpochMonth(int n) {
        int n2 = Arrays.binarySearch(this.hijrahEpochMonthStartDays, n);
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return n2;
    }

    private int epochMonthToYear(int n) {
        return (n + this.hijrahStartEpochMonth) / 12;
    }

    private int yearToEpochMonth(int n) {
        return n * 12 - this.hijrahStartEpochMonth;
    }

    private int epochMonthToMonth(int n) {
        return (n + this.hijrahStartEpochMonth) % 12;
    }

    private int epochMonthToEpochDay(int n) {
        return this.hijrahEpochMonthStartDays[n];
    }

    private int yearMonthToDayOfYear(int n, int n2) {
        int n3 = this.yearToEpochMonth(n);
        return this.epochMonthToEpochDay(n3 + n2) - this.epochMonthToEpochDay(n3);
    }

    private int epochMonthLength(int n) {
        return this.hijrahEpochMonthStartDays[n + 1] - this.hijrahEpochMonthStartDays[n];
    }

    private static Properties readConfigProperties(String string) throws Exception {
        try {
            return AccessController.doPrivileged(() -> {
                String string2 = System.getProperty("java.home") + File.separator + "lib";
                File file = new File(string2, string);
                Properties properties = new Properties();
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    properties.load(fileInputStream);
                }
                return properties;
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    private void loadCalendarData() {
        try {
            String string = calendarProperties.getProperty(PROP_PREFIX + this.typeId);
            Objects.requireNonNull(string, "Resource missing for calendar: calendar.hijrah." + this.typeId);
            Properties properties = HijrahChronology.readConfigProperties(string);
            HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n3 = 0;
            block16: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string5;
                switch (string5 = (String)entry.getKey()) {
                    case "id": {
                        string2 = (String)entry.getValue();
                        continue block16;
                    }
                    case "type": {
                        string3 = (String)entry.getValue();
                        continue block16;
                    }
                    case "version": {
                        string4 = (String)entry.getValue();
                        continue block16;
                    }
                    case "iso-start": {
                        int[] nArray = this.parseYMD((String)entry.getValue());
                        n3 = (int)LocalDate.of(nArray[0], nArray[1], nArray[2]).toEpochDay();
                        continue block16;
                    }
                }
                try {
                    int n4 = Integer.valueOf(string5);
                    int[] nArray = this.parseMonths((String)entry.getValue());
                    hashMap.put(n4, nArray);
                    n2 = Math.max(n2, n4);
                    n = Math.min(n, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("bad key: " + string5);
                }
            }
            if (!this.getId().equals(string2)) {
                throw new IllegalArgumentException("Configuration is for a different calendar: " + string2);
            }
            if (!this.getCalendarType().equals(string3)) {
                throw new IllegalArgumentException("Configuration is for a different calendar type: " + string3);
            }
            if (string4 == null || string4.isEmpty()) {
                throw new IllegalArgumentException("Configuration does not contain a version");
            }
            if (n3 == 0) {
                throw new IllegalArgumentException("Configuration does not contain a ISO start date");
            }
            this.hijrahStartEpochMonth = n * 12;
            this.minEpochDay = n3;
            this.hijrahEpochMonthStartDays = this.createEpochMonths(this.minEpochDay, n, n2, hashMap);
            this.maxEpochDay = this.hijrahEpochMonthStartDays[this.hijrahEpochMonthStartDays.length - 1];
            for (int i = n; i < n2; ++i) {
                int n5 = this.getYearLength(i);
                this.minYearLength = Math.min(this.minYearLength, n5);
                this.maxYearLength = Math.max(this.maxYearLength, n5);
            }
        }
        catch (Exception exception) {
            PlatformLogger platformLogger = PlatformLogger.getLogger("java.time.chrono");
            platformLogger.severe("Unable to initialize Hijrah calendar proxy: " + this.typeId, exception);
            throw new DateTimeException("Unable to initialize HijrahCalendar: " + this.typeId, exception);
        }
    }

    private int[] createEpochMonths(int n, int n2, int n3, Map<Integer, int[]> map) {
        int n4 = (n3 - n2 + 1) * 12 + 1;
        int n5 = 0;
        int[] nArray = new int[n4];
        this.minMonthLength = Integer.MAX_VALUE;
        this.maxMonthLength = Integer.MIN_VALUE;
        for (int i = n2; i <= n3; ++i) {
            int[] nArray2 = map.get(i);
            for (int j = 0; j < 12; ++j) {
                int n6 = nArray2[j];
                nArray[n5++] = n;
                if (n6 < 29 || n6 > 32) {
                    throw new IllegalArgumentException("Invalid month length in year: " + n2);
                }
                n += n6;
                this.minMonthLength = Math.min(this.minMonthLength, n6);
                this.maxMonthLength = Math.max(this.maxMonthLength, n6);
            }
        }
        nArray[n5++] = n;
        if (n5 != nArray.length) {
            throw new IllegalStateException("Did not fill epochMonths exactly: ndx = " + n5 + " should be " + nArray.length);
        }
        return nArray;
    }

    private int[] parseMonths(String string) {
        int[] nArray = new int[12];
        Object[] objectArray = string.split("\\s");
        if (objectArray.length != 12) {
            throw new IllegalArgumentException("wrong number of months on line: " + Arrays.toString(objectArray) + "; count: " + objectArray.length);
        }
        for (int i = 0; i < 12; ++i) {
            try {
                nArray[i] = Integer.valueOf((String)objectArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("bad key: " + (String)objectArray[i]);
            }
        }
        return nArray;
    }

    private int[] parseYMD(String string) {
        string = string.trim();
        try {
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new IllegalArgumentException("date must be yyyy-MM-dd");
            }
            int[] nArray = new int[]{Integer.valueOf(string.substring(0, 4)), Integer.valueOf(string.substring(5, 7)), Integer.valueOf(string.substring(8, 10))};
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("date must be yyyy-MM-dd", numberFormatException);
        }
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    static {
        try {
            calendarProperties = BaseCalendar.getCalendarProperties();
        }
        catch (IOException iOException) {
            throw new InternalError("Can't initialize lib/calendars.properties", iOException);
        }
        try {
            INSTANCE = new HijrahChronology("Hijrah-umalqura");
            AbstractChronology.registerChrono(INSTANCE, "Hijrah");
            AbstractChronology.registerChrono(INSTANCE, "islamic");
        }
        catch (DateTimeException dateTimeException) {
            PlatformLogger platformLogger = PlatformLogger.getLogger("java.time.chrono");
            platformLogger.severe("Unable to initialize Hijrah calendar: Hijrah-umalqura", dateTimeException);
            throw new RuntimeException("Unable to initialize Hijrah-umalqura calendar", dateTimeException.getCause());
        }
        HijrahChronology.registerVariants();
    }
}

