/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

class ByteBufferAsCharBufferL
extends CharBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsCharBufferL(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 1, byteBuffer.remaining() >> 1);
        this.bb = byteBuffer;
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.offset = n2;
    }

    ByteBufferAsCharBufferL(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.bb = byteBuffer;
        this.offset = n5;
    }

    @Override
    public CharBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = (n << 1) + this.offset;
        assert (n4 >= 0);
        return new ByteBufferAsCharBufferL(this.bb, -1, 0, n3, n3, n4);
    }

    @Override
    public CharBuffer duplicate() {
        return new ByteBufferAsCharBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new ByteBufferAsCharBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return (n << 1) + this.offset;
    }

    @Override
    public char get() {
        return Bits.getCharL((ByteBuffer)this.bb, (int)this.ix(this.nextGetIndex()));
    }

    @Override
    public char get(int n) {
        return Bits.getCharL((ByteBuffer)this.bb, (int)this.ix(this.checkIndex(n)));
    }

    @Override
    char getUnchecked(int n) {
        return Bits.getCharL((ByteBuffer)this.bb, (int)this.ix(n));
    }

    @Override
    public CharBuffer put(char c) {
        Bits.putCharL((ByteBuffer)this.bb, (int)this.ix(this.nextPutIndex()), (char)c);
        return this;
    }

    @Override
    public CharBuffer put(int n, char c) {
        Bits.putCharL((ByteBuffer)this.bb, (int)this.ix(this.checkIndex(n)), (char)c);
        return this;
    }

    @Override
    public CharBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n2));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n << 1);
        byteBuffer2.compact();
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString(int n, int n2) {
        if (n2 > this.limit() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int n3 = n2 - n;
            char[] cArray = new char[n3];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharBuffer charBuffer2 = this.duplicate();
            charBuffer2.position(n);
            charBuffer2.limit(n2);
            charBuffer.put(charBuffer2);
            return new String(cArray);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int n, int n2) {
        int n3 = this.position();
        int n4 = this.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        int n5 = n4 - n3;
        if (n < 0 || n2 > n5 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteBufferAsCharBufferL(this.bb, -1, n3 + n, n3 + n2, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

