; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

;Gets the date time for versioninig
#define MyDateTimeString GetDateTimeString('yymm', '', '');
; Read the previuos build number. If there is none take 0 instead.
#define BuildNum Int(ReadIni(SourcePath	+ "\\BuildInfo.ini","Info","Build","2"))

; Increment the build number by one.
#expr BuildNum = BuildNum + 1
; /verysilent /paraLibName=ParaLib.exe  /isSilent=silent /cloudName=mycloud /certName=*.parablusys.com 
; Store the number in the ini file for the next build.
#expr WriteIni(SourcePath + "\\BuildInfo.ini","Info","Build", BuildNum)
#define MyAppName "Parablu_EPA"
;release number
;#define releaseNum "2.3.6.9.24"
#define releaseNum version
#define MyServiceVersion version
;#define MyServiceVersion "2.3.6.9.24"
#define MyAppPublisher "Parablu Inc"
#define MyAppURL "http://www.parablu.com/"
#define MyAppExeName "BluSync.exe"
#define Mainclass "com/parablu/epa/view/BluSyncLauncher"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
SetupLogging=yes
AppId={{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}}
AppMutex=ParaBlu
AppName={#MyAppName}
AppVersion={#releaseNum}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\ParaBlu
LicenseFile=Parablu EULA v1.5.rtf
OutputDir=bin
OutputBaseFilename={#MyAppName}_v{#releaseNum}
Compression=lzma
SolidCompression=no
DisableDirPage=yes
UsePreviousAppDir=False
VersionInfoVersion={#releaseNum}
VersionInfoCompany=ParaBlu
VersionInfoDescription=ParaBlu EPA
VersionInfoProductName=BluSync
VersionInfoProductVersion={#releaseNum}
MinVersion=0,5.01sp1
WizardImageFile=BluSync_Big_Image.bmp
UninstallDisplayIcon={app}\Parablu.ico
DisableReadyPage=True
AppendDefaultDirName=False
DefaultGroupName=ParaBlu
EnableDirDoesntExistWarning=True
DirExistsWarning=yes
PrivilegesRequired=admin
ShowUndisplayableLanguages=True
DisableReadyMemo=True
DisableProgramGroupPage=yes
AppCopyright=False
UninstallDisplayName=Parablu EPA
MergeDuplicateFiles=False
ChangesEnvironment=yes
UsePreviousLanguage=no
CloseApplications=no


[Languages]
[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Files]
Source: "service\rt\*";             DestDir: "{app}\rt";    Flags: ignoreversion recursesubdirs createallsubdirs;
Source: "{app}\rt\*";               DestDir: "{app}\bin\rt";Flags: ignoreversion recursesubdirs createallsubdirs external;
Source: "pbarsc.dll";               DestDir: "{app}";       Flags: ignoreversion
Source: "DefaultFoldersFinder.dll"; DestDir: "{app}";       Flags: ignoreversion;
Source: "sigar-x86-winnt.dll";      DestDir: "{app}";       Flags: ignoreversion;
Source: "jacob-1.14.3-x64.dll";     DestDir: "{app}";       Flags: ignoreversion;
Source: "jacob-1.14.3-x86.dll";     DestDir: "{app}";       Flags: ignoreversion;
Source: "splash.jar";               DestDir: "{app}";       Flags: ignoreversion
Source: "Parablu EULA v1.5.rtf";    DestDir: "{app}";       Flags: ignoreversion

Source: "SyncWindows\resource\*";   DestDir: "{app}\resource";Flags: ignoreversion createallsubdirs recursesubdirs
Source: "Parablu.ico";              DestDir: "{app}";         Flags: ignoreversion
Source: "folder_icon.ico";          DestDir: "{app}";         Flags: ignoreversion
Source: "MVC1032\*";                DestDir: "{app}";         Flags: recursesubdirs createallsubdirs uninsrestartdelete;
Source: "vshadow\*";                DestDir: "{app}\vshadow"; Flags: ignoreversion;
Source: "Scripts\*";                DestDir: "{app}\Scripts"; Flags: ignoreversion recursesubdirs createallsubdirs;
source: "BluSync.exe";              DestDir: "{app}";         Flags: ignoreversion
Source: "ParaLib.exe";              DestDir: "{app}";         Flags: ignoreversion;
Source: "ParabluExt\VSSAPIProvider.dll";  DestDir: "{app}\lib\shell32"; Flags: ignoreversion;

Source: "ParaBlu-BluSync-Extensions.exe"; DestDir: "{app}\bin"; Flags: ignoreversion;
Source: "service\ParaBluSvc.exe";         DestDir: "{app}\bin"; Flags: ignoreversion;
Source: "setupTriggerInfo.exe";           DestDir: "{app}";     Flags: ignoreversion;
Source: "InstallParaBluSvc.bat";DestDir: "{app}";               Flags: ignoreversion
Source: "DeletePbluService.bat";DestDir: "{app}";               Flags: ignoreversion;         AfterInstall: DeletePbluService;

Source: "parabludl.dll";            DestDir: "{app}\lib\shell32"; Flags: restartreplace uninsrestartdelete;
Source: "parabludlr.dll";           DestDir: "{app}\lib\shell32"; Flags: restartreplace uninsrestartdelete;
Source: "parabludl.dll.manifest";   DestDir: "{app}\lib\shell32"; Flags: restartreplace uninsrestartdelete;
Source: "parabludlr.dll.manifest";  DestDir: "{app}\lib\shell32"; Flags: restartreplace uninsrestartdelete;

; relook this  for upgrade
Source: "MVC10\*";                              DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist recursesubdirs createallsubdirs uninsrestartdelete;Check:Not IsWin64; 
Source: "ParabluExt\ParaBluIONS.dll";           DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
Source: "ParabluExt\ParaBluIONS.dll.manifest";  DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64
Source: "ParabluExt\ParaBluIOS.dll";            DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
Source: "ParabluExt\ParaBluIOS.dll.manifest";   DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64; 
Source: "ParabluExt\ParaBluExt.dll.manifest";   DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64;
Source: "ParabluExt\ParaBluExt.dll";            DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete;Check: Not IsWin64;

Source: "MVC10x64\*";                           DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist recursesubdirs createallsubdirs uninsrestartdelete;Check: IsWin64; 
Source: "ParabluExt\ParaBluIONS64.dll";         DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;
Source: "ParabluExt\ParaBluIONS64.dll.manifest";DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;
Source: "ParabluExt\ParaBluIOS64.dll";          DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;
Source: "ParabluExt\ParaBluIOS64.dll.manifest"; DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;
Source: "ParabluExt\ParaBluExt64.dll.manifest"; DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;
Source: "ParabluExt\ParaBluExt64.dll";          DestDir: "{app}\lib\shell"; Flags: onlyifdoesntexist uninsrestartdelete; Check: IsWin64;

Source: "WL.properties";            DestDir: "{app}\Staging";   Flags: ignoreversion; AfterInstall: InsertDomainNames;
Source: "Parablu-log4j.properties"; DestDir: "{app}\Staging";   Flags: ignoreversion;
Source: "ServiceLog4j\ParabluService-log4j.properties"; DestDir: "{app}\Blusync";  Flags: ignoreversion;
Source: "SystemstateBackup.bat";                     DestDir: "{app}";       Flags: ignoreversion
Source: "SystemstateRemoveDump.bat";                 DestDir: "{app}";       Flags: ignoreversion

[Icons]
Name: "{group}\ParaBlu\{#MyAppName}"; Filename: "{app}\BluSync.exe"; WorkingDir: "{app}"; IconFilename: "{app}\Parablu.ico"; 
Name: "{commonstartup}\{#MyAppName}"; Filename: "{app}\BluSync.exe"; WorkingDir: "{app}"; IconFilename: "{app}\Parablu.ico"; 
;Name: "{userdesktop}\{#MyAppName}"; Filename: "{app}\BluSync.exe"; IconFilename: "{app}\Parablu.ico";

[Run]
;Filename: "{app}\InstallParaBluSvc.bat"; Parameters: """{app}"""; Flags: runhidden
Filename: "{app}\BluSync.exe"; Parameters:{param:start} {param:exePath}; WorkingDir: "{app}"; Flags: nowait postinstall; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}";Check: WizardSilent;

[UninstallDelete]
Type: filesandordirs; Name: "{app}"; 

[Messages]
english.SetupWindowTitle=Parablu EndPoint Agent Setup Wizard

[Registry]
Root: HKLM; Subkey: "Software\ParaBlu\BluSync"; Flags: uninsdeletekey;  Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Path";      ValueType: "string"; ValueData: "{app}";              Flags: preservestringtype; Check: Not IsWin64; 
Root: HKLM; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Version";   ValueType: "string"; ValueData: "{#releaseNum}";      Flags: preservestringtype; Check: Not IsWin64;

; Parameters are always of type string, these are the values that will be passed to BluSync.exe 
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "cloudName";  ValueType: "string"; ValueData: "{param:cloudName}";  Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "cloudIP";    ValueType: "string"; ValueData: "{param:cloudIP}";    Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "certName";   ValueType: "string"; ValueData: "{param:certName}";   Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "isSilent";   ValueType: "string"; ValueData: "{param:isSilent}";   Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "paraLibName";ValueType: "string"; ValueData: "{param:paraLibName}";Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "Software\ParaBlu\BluSync\Params"; ValueName: "mainClass";  ValueType: "string"; ValueData: "{#Mainclass}";       Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueName: "USER_INT";  ValueType: "string"; ValueData: "{code:getParentPath|{app}}";       Flags: preservestringtype; Check: Not IsWin64;
Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueName: "parabluUserProfile";  ValueType: "string"; ValueData: {app};       Flags: preservestringtype; Check: Not IsWin64;

Root: HKLM64; Subkey: "Software\ParaBlu\BluSync"; Flags: uninsdeletekey; Check: IsWin64; 
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Path";      ValueType: "string"; ValueData: "{app}";            Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync"; ValueName: "Version";   ValueType: "string"; ValueData: "{#releaseNum}";    Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueName: "USER_INT";  ValueType: "string"; ValueData: "{code:getParentPath|{app}}";       Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueName: "parabluUserProfile";  ValueType: "string"; ValueData: "{code:getParentPath|{app}}";       Flags: preservestringtype; Check: IsWin64;
; Parameters are always of type string, these are the values that will be passed to BluSync.exe 
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "cloudName";   ValueType: "string"; ValueData: "{param:cloudName}";  Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "cloudIP";     ValueType: "string"; ValueData: "{param:cloudIP}";    Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "certName";    ValueType: "string"; ValueData: "{param:certName}";   Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "isSilent";    ValueType: "string"; ValueData: "{param:isSilent}";   Flags: preservestringtype; Check: IsWin64; 
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "paraLibName"; ValueType: "string"; ValueData: "{param:paraLibName}";Flags: preservestringtype; Check: IsWin64; 
Root: HKLM64; Subkey: "Software\ParaBlu\BluSync\Params";  ValueName: "mainClass";   ValueType: "string"; ValueData: "{#Mainclass}";       Flags: preservestringtype; Check: IsWin64;

Root: HKLM; Subkey: "SOFTWARE\WOW6432Node\ParaBluSvc";    ValueName: "Path";        ValueType: "string"; ValueData: "{app}\bin";           Flags: preservestringtype; Check: IsWin64;
Root: HKLM; Subkey: "SOFTWARE\WOW6432Node\ParaBluSvc";    ValueName: "Version";     ValueType: "string"; ValueData: "{#MyServiceVersion}"; Flags: preservestringtype; Check: IsWin64;

Root: HKLM; Subkey: "SOFTWARE\ParaBluSvc";    ValueName: "Path";        ValueType: "string"; ValueData: "{app}\bin";           Flags: preservestringtype; Check:Not IsWin64;
Root: HKLM; Subkey: "SOFTWARE\ParaBluSvc";    ValueName: "Version";     ValueType: "string"; ValueData: "{#MyServiceVersion}"; Flags: preservestringtype; Check:Not IsWin64;
; VSSAPI related changes that are needed only on 64 bit.
Root: HKCR; Subkey: "Wow6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}"; ValueName: ""; ValueType: "string"; ValueData: "PSFactoryBuffer"; Flags: preservestringtype; Check: IsWin64;
Root: HKCR; Subkey: "WOW6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}\InProcServer32"; ValueName: ""; ValueType: "expandsz"; ValueData: "%systemroot%\SysWOW64\vss_ps.dll"; Flags: preservestringtype; Check: IsWin64;
Root: HKCR; Subkey: "WOW6432Node\CLSID\{{F2C2787D-95AB-40D4-942D-298F5F757874}\InProcServer32"; ValueName: "ThreadingModel"; ValueType: "string"; ValueData: "Both"; Flags: preservestringtype; Check: IsWin64;
Root: HKLM64; Subkey: "SOFTWARE\WOW6432Node\ParaBluSvc"; ValueName: "SystemComponentValue";    ValueType: "string"; ValueData: "{param:RegisterwithWindows}";  Flags: preservestringtype; Check:IsWin64;                                                                                                                                    
Root: HKLM; Subkey: "SOFTWARE\ParaBluSvc";             ValueName: "SystemComponentValue";    ValueType: "string"; ValueData: "{param:RegisterwithWindows}";  Flags: preservestringtype; Check:Not IsWin64;
Root: HKLM64; Subkey: "SOFTWARE\WOW6432Node\ParaBlu"; ValueName: "ProxyEnabled";    ValueType: "string"; ValueData: "{param:ProxyEnabled}";  Flags: preservestringtype; Check:IsWin64;                                                                                                                                    
Root: HKLM; Subkey: "SOFTWARE\ParaBlu";             ValueName: "ProxyEnabled";    ValueType: "string"; ValueData: "{param:ProxyEnabled}";  Flags: preservestringtype; Check:Not IsWin64;
[code]


#include "ServiceHelper.iss"
#include "CleanupPaths.iss"

function getParentPath(fileName: String) : String;
begin
Result := ExtractFilePath(fileName);
end;

{
  check if a given command line parameter is present
}
function CmdLineParamExists(const Value: string): Boolean;
var
  I: Integer;  
  C: Integer;
begin
  Result := False;
  for I := 1 to ParamCount do
  begin
    C := CompareText(ParamStr(I), Value);
    Log(Format('==Parameter %d %s %s %d', [I,ParamStr(I), Value, C]));
    if (C = 0) then
    begin
      Log(Format('Parameter Matches %d %s %s', [I,ParamStr(I), Value]));
      Result := True;
      Exit;
    end
  end;
end;


function CheckWin32Install() : Boolean;
var
IsUpgradeShell : Boolean;
begin
  IsUpgradeShell := DirExists(ExpandConstant('{app}\rt'));
  Result :=  not (IsUpgradeShell or IsWin64);
end;

function CheckWin64Install() : Boolean;
var
IsUpgradeShell : Boolean;
begin
  IsUpgradeShell := DirExists(ExpandConstant('{app}\rt'));
  Result := ((not IsUpgradeShell) and  IsWin64);
end;

function InstallService(): Boolean;
begin
  Result := True;
end;

procedure TaskKill(FileName: String);
var
  ResultCode: Integer;
begin
    Exec(ExpandConstant('taskkill.exe'), '/f /im ' + '"' + FileName + '"', '', SW_HIDE,
     ewWaitUntilTerminated, ResultCode);
end;

procedure UninstallMsiInstaller(FileName: String);
var
 ResultCode: Integer;
begin
   Exec(ExpandConstant('wmic.exe'), ' product where name=' + '"' + FileName + '"' + ' call uninstall /nointeractive' , '', SW_HIDE,
    ewWaitUntilTerminated, ResultCode);
end;

function LaunchUpgrade: Boolean;
begin
  Result := CmdLineParamExists('/UPGRADE');
end;


function NextIntfromVersion(var version :String): Integer;
var
  P : Integer;
begin
  Result := 0;
  P := Pos('.', version);
  if P > 0 then
  begin
     Result := StrToInt(Copy(version, 1, P - 1));
     Delete(version, 1, P);
  end
  else 
  begin
    if version <> '' then
    begin
      Result := StrToInt(version);
      version := '';
    end
  end
end;

function CompareVersion(V1 :String; V2 :String): Integer;
var 
N1 : Integer;
N2 : Integer;
begin
  Result := 0;
  //Log(Format('---Comparing %s %s', [V1, V2]));
  while (Result = 0) and ((V1 <> '') or (V2 <> '')) do
  begin
    N1 := NextIntfromVersion(V1);
    N2 := NextIntfromVersion(V2);
   // Log(Format('-----comparing %d - %d = %d (%s %s)', [N1, N2, (N1-N2), V1, V2]));
    Result := N1 - N2  ;  
  end
end;

function CheckIfUpgradePossible: Boolean;
var
installedVersion : String;
begin
  Result := True;
  // If the version key is not present or if it is present and is less than the current version.
  if RegQueryStringValue(GetHKLMNative, 'Software\ParaBlu\BluSync', 'Version',  installedVersion) then
  begin
    if(CompareVersion('{#releaseNum}', installedVersion) <= 0) then
    begin
      Log(Format('Unable to upgrade from {#releaseNum} to %s ',[installedVersion])); 
      Result := False;
    end 
    else 
    begin
      Log(Format('Upgrading to from {#releaseNum} to %s ',[installedVersion])); 
    end
  end
    Exit
end;

{
  This code enumerates all the uninstall keys to check if bits are already installed or not.
}
function RegCheckInstall(RootKey: Integer; KeyName: String; Pattern: String;  var ResultStr: String): Boolean;
var
  I: Integer;  
  Name: String;
  Names: TArrayOfString;
  UninstallPath: String;
begin
  Result := false;
  if RegGetSubkeyNames(RootKey, KeyName, Names) then
  begin
     Log(Format('==== Looking for key name %s  %s', [KeyName, Pattern]))
    for I := 0 to GetArrayLength(Names) - 1 do
    begin
      Name := Names[I];
      Log(Format('Found key %s', [Name]));
      if Pos(Pattern, Name) > 0 then
      begin
         //Log(Format('Found #### %s!!!!', [Name]));
         if RegQueryStringValue(RootKey, KeyName + Name, 'UninstallString', UninstallPath) then
         begin
            if Length(UninstallPath) > 0 then 
              Log(Format('Found uninstall Name %s key %s ', [Name, UninstallPath]));
              ResultStr := Name; 
              Result := true;
              Exit
         end
      end       
    end
  end
end;
 
{
  check if there is a version of application already installed
}
function CheckIfAlreadyInstalled(): Boolean;
var 
ResultStr : String;
UninstallKey : String;
begin
  if IsWin64 then
  begin
    UninstallKey := 'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\';
  end
  else
  begin
    UninstallKey := 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\';
  end
  
  Result := False;    
  if RegCheckInstall( HKEY_LOCAL_MACHINE, UninstallKey, '44EEB8EA-37A5-4866-8852-0AC4B90F86CD', ResultStr) then 
  begin
    Result := true;    
  end
end;

{
  This cleans up any existing 
}
procedure CheckAndCleanupOldInstallKey();
var
ResultStr : String;
SubKey    : String;
UninstallKey : String;
begin
  if IsWin64 then
  begin
    UninstallKey := 'SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\';
  end
  else
  begin
    UninstallKey := 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\'
  end
  if RegCheckInstall( HKEY_LOCAL_MACHINE, UninstallKey, '44EEB8EA-37A5-4866-8852-0AC4B90F86CD}_', ResultStr) then 
  begin
    SubKey :=  UninstallKey + ResultStr;
    Log(Format('Cleaning up #### %s!!!!', [SubKey]));
    // be very careful here, in no condition we should end up deleting the root uninstall key itself.
    if(Length(ResultStr) > 0) and (Length(Subkey) > Length(UninstallKey)) then
    begin
        RegDeleteKeyIncludingSubkeys(HKEY_LOCAL_MACHINE, SubKey);
    end
    else
    begin
        Log(Format('Failed to cleanup #### %s!!!!', [SubKey]));
    end    
  end
end;

function PrepareToInstall(var NeedsRestart: Boolean): String;
begin
  Log('Parablu_EPA version:# {#releaseNum} # Prep to Install!');     
end;
{
Initialises setup
Called before the Setup UI rendered
Checks if a previous installation of ParaBlu Exists
  *Show uninstall messgae
  *result=true if previous versions doesnt exist
}
function InitializeSetup(): Boolean;
begin
  Log('Parablu_EPA version:# {#releaseNum} #');
  
  {if not LaunchUpgrade() then
  begin
    result := not CheckIfAlreadyInstalled();
    if not result then
    begin
      MsgBox('Setup has detected that another version of Parablu EPA is installed.'+#13#10+'Please uninstall it and try again.', mbInformation, MB_OK);
    end
  end
  else 
  begin
  }
  Log('Parablu_EPA version:# {#releaseNum} # Checking for upgrade!');
  result := true;
  if not result then
  begin
    MsgBox('Setup has detected that another version of Parablu EPA is installed.'+#13#10+'Please uninstall it and try again.', mbInformation, MB_OK);
  end
  else 
  begin
    Log('Parablu_EPA version:# {#releaseNum} # Triggering update');
    SimpleStopService('ParaBluSvc', True, True);
    TaskKill('BluSync.exe');
    TaskKill('Paralib.exe');
    Log('Parablu_EPA version:# {#releaseNum} # Process killed');
  end   
//  end    
end;

{
  Called just before rendering the first page hides the top right bitmap image
}
procedure InitializeWizard();
begin  
  WizardForm.WizardSmallBitmapImage.Hide;
end;

{
  Called just before Setup terminates. Note that this function is called even if the user exits Setup before anything is installed.
}
procedure DeinitializeSetup();
var
  logfilepathname, logfilename, newfilepathname: string;

begin
  logfilepathname := expandconstant('{log}');
  logfilename := ExtractFileName(logfilepathname);
  // Set the new target path as the directory where the installer is being run from
  newfilepathname := expandconstant('{drive:{win}}')+'\Windows\Temp\ParaBlu_EPA\'+logfilename;
  filecopy(logfilepathname, newfilepathname, false);
end; 


{
  called to uninstall service
}
procedure DeletePbluService();
begin
     SimpleDeleteService('ParaBluSvc');
end;

{
  Run during setup to install shell extensions called after all dlls are moved
}
procedure RunPostInstallationSteps(fileType,installtype: String);
var
  exeFilePath: String;
  resultCode: Integer;
  resultCode1: Integer;
  reInstallExt: Boolean;
  serviceFilePath: String;
  installAppPath: String;

begin
  reInstallExt:=true;
  exeFilePath:=ExpandConstant('{app}')+'\bin\ParaBlu-BluSync-Extensions.exe';
  serviceFilePath:=ExpandConstant('{app}')+'\InstallParaBluSvc.bat';
  installAppPath:= ExpandConstant('"{app}"');
 
  if IsWin64 then 
  begin  
    while reInstallExt do 
    begin
        Log('Parablu_EPA install info file path while reading:#  #'+installAppPath);
        reInstallExt:=false;
        SimpleCreateService('ParaBluSvc','ParaBluSvc',ExpandConstant('{app}')+'\bin\ParaBluSvc.exe ',SERVICE_AUTO_START,'','',True,True);
        SimpleChangeServiceConfigRestartParams('ParaBluSvc');
        SimpleStartService('ParaBluSvc',True ,True);    
        Log('Parablu_EPA install info file path while reading::::::::#  #'+installAppPath);
        Exec(ExpandConstant('{app}\setupTriggerInfo.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);
        //ShellExec('runas',exeFilePath,'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluExt64.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIONS64.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIOS64.dll" '+fileType+' '+installtype,'' , SW_HIDE, ewWaitUntilTerminated, resultCode);
        Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);   
    end
  end
  else begin
    while reInstallExt do 
    begin  
      if ShellExec('runas',serviceFilePath,'"'+ ExpandConstant('{app}')+'"','', SW_HIDE, ewWaitUntilTerminated, resultCode) then 
      begin
        reInstallExt:=false;
        SimpleCreateService('ParaBluSvc','ParaBluSvc',ExpandConstant('{app}')+'\bin\ParaBluSvc.exe ',SERVICE_AUTO_START,'','',True,True);
        SimpleChangeServiceConfigRestartParams('ParaBluSvc');
        SimpleStartService('ParaBluSvc',True,True);
        Exec(ExpandConstant('{app}\setupTriggerInfo.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);
        //ShellExec('runas',exeFilePath,'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluExt.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIONS.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIOS.dll" '+fileType+' '+installtype,'' , SW_HIDE, ewWaitUntilTerminated, resultCode)
        Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);   
      end      
    end
  end
  CheckAndCleanupOldInstallKey(); 
  UninstallMsiInstaller('ParaLightMsi'); 
end;

{
  Run during setup to uninstall shell extensions called  before the dlls are moved
}
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  exeFilePath: String;
  installtype: String;
  fileType: String;
  resultCode,resultCode1: Integer;
begin  
  if  CurUninstallStep = usUninstall then
  begin
    exeFilePath:=ExpandConstant('{app}')+'\bin\ParaBlu-BluSync-Extensions.exe';    
    installtype:='uninstall';
    if IsWin64 then
    begin
      fileType:='64';
      if ShellExec('runas',exeFilePath,'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluExt64.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIONS64.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIOS64.dll" '+fileType+' '+installtype,'' , SW_HIDE, ewWaitUntilTerminated, resultCode) then 
      begin
       Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);
      end
    end
    else
    begin
        fileType:='32';
        if ShellExec('runas',exeFilePath,'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluExt.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIONS.dll" '+'"'+ExpandConstant('{app}')+'\lib\shell\ParaBluIOS.dll" '+fileType+' '+installtype,'' , SW_HIDE, ewWaitUntilTerminated, resultCode) then 
        begin
          Exec(ExpandConstant('{win}\explorer.exe'), '', '', SW_SHOW, ewNoWait, resultCode1);
        end  
    end
  end
end;

function InitializeUninstall(): Boolean;
var                                                       
  ErrorCode: Integer;
  reInstallExt: Boolean;
  UninsServiceFilePath: String;
begin
  reInstallExt := true;
  UninsServiceFilePath := ExpandConstant('{app}')+'\DeletePbluService.bat';
  Result := True;
  CleanupPaths();
  while reInstallExt do 
  begin 
    if ShellExec('runas', UninsServiceFilePath, '', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode) then 
    begin
      reInstallExt:=false;
    end
    else 
    begin
      if MsgBox('Without admin access this Uninstallation will fail.Are you sure you want to proceed?',mbconfirmation,MB_YESNO) = IDYES  then 
      begin
        reInstallExt:=false;
        Result := False;
      end    
    end
  end;
end;

procedure InsertDomainNames();
var
  confFilePath: String;
  S: AnsiString;
  domainsFilePath: String;
begin
  confFilePath:=ExpandConstant('{app}\Staging')+'\WL.properties';
  domainsFilePath:= ExpandConstant('{drive:{win}}')+'\Windows\Temp\ParaBlu_EPA\ParabluConfig.conf';
  Log('Parablu_EPA domainsFilePath :#### #'+domainsFilePath);
  Log('Parablu_EPA WL Path :#### #'+confFilePath);  
  if FileExists(domainsFilePath) then
  begin
    Log('Domains file Exists ');
    if LoadStringFromFile(domainsFilePath, S) then
    begin
      Log('Loaded String :'+S);    
      SaveStringToFile(confFilePath, S + #13#10, True);
      Log('After Save String');
    end
  end
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin  
  if CurStep = ssPostInstall then
  begin
    Log('Current step is post install');
    if IsWin64 then
    begin
      RunPostInstallationSteps('64','install');
    end
    else
    begin
      RunPostInstallationSteps('32','install');
    end
  end;
end;