/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.RegistrationLiterals;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.registration.CloudRegistrationUtility;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.ProgressBarPaneView;
import java.awt.Desktop;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationView {
    private Logger logger = LoggerFactory.getLogger(RegistrationView.class);
    private static final int MINIMUM_HEIGHT = 350;
    private Shell shell = null;
    private Display display = null;
    private Image registrationImage = null;
    private Label pageDescription = null;
    private StackLayout registrationPanelStackLayout = null;
    private Composite registrationPanel = null;
    private Composite registrationStackPanel = null;
    private Composite registrationPanelForInputTexts = null;
    private Group registrationPanelParentForDeviceInputs;
    private Group registrationPanelForCloudAndUserInputs = null;
    private Composite registrationInputPanelForCloudInput = null;
    private Composite registrationInputPanelForDeviceInput = null;
    private Composite registrationInputPanelForUserInputs = null;
    private Composite buttonPanel = null;
    private Composite mainTextPanel;
    private Composite headerBodyComposite;
    private Label userNameLabel = null;
    private Text userNameInputText = null;
    private Label cloudNameLabel = null;
    private Text cloudNameInputText = null;
    private Label deviceNameLabel = null;
    private Text deviceNameInputText = null;
    private Label deviceNameLabelInfo = null;
    private Label passwordLabel = null;
    private Text passwordInputText = null;
    private Link helpHyperlink = null;
    private Button registerButton = null;
    private Button exitButton = null;
    private Label horizontalLineSeperatorAfterMainTitle = null;
    private Label horizontalLineSeperatorAftercompositeFields = null;
    FontsManager fontsManager;
    RegisterSelectionAdapter registerSelectionAdapter = new RegisterSelectionAdapter();
    String deviceName = null;

    public void loadRegistrationUI() {
        if (Display.getCurrent() != null && !Display.getCurrent().isDisposed()) {
            Display.getCurrent().dispose();
        }
        this.display = new Display();
        this.shell = new Shell(192);
        GridLayout shellGridLayout = new GridLayout();
        GridData shellGridData = new GridData();
        shellGridLayout.marginLeft = 0;
        shellGridLayout.marginTop = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.marginRight = 0;
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        ImageData registrationImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.registrationImage = new Image((Device)this.display, registrationImageData.scaledTo(72, 72));
        this.shell.setImage(this.registrationImage);
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        int xAxisLocation = this.shell.getDisplay().getClientArea().width / 2 - 150;
        int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 150;
        this.shell.setLocation(xAxisLocation, yAxisLocation);
        this.shell.setBackgroundMode(1);
        this.shell.setBackground(new Color((Device)this.display, 255, 255, 255));
        this.shell.setLayout((Layout)shellGridLayout);
        this.shell.setLayoutData((Object)shellGridData);
        this.generateLocalUIFields();
        this.shell.setTabList(new Control[]{this.registrationPanel});
        this.shell.setDefaultButton(this.registerButton);
        this.shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent event) {
                MessageBox messageBox = new MessageBox(RegistrationView.this.shell, 65728);
                messageBox.setText("Confirm Exit");
                messageBox.setMessage(PropertyHelper.EXIT_MSG_CONFIRMATION_LABEL);
                if (messageBox.open() == 64) {
                    RegistrationView.this.logger.debug("BluSync UI Close action called from UIMain");
                    RegistrationView.this.disposeShellAndWakeDisplay();
                    System.exit(0);
                } else {
                    event.doit = false;
                }
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent arg0) {
            }
        });
        DisposeListener disposeListener = arg0 -> this.disposeShellAndWakeDisplay();
        this.shell.addDisposeListener(disposeListener);
        this.shell.pack();
        this.shell.open();
        this.shell.setVisible(true);
        this.shell.forceActive();
        while (!this.shell.isDisposed()) {
            if (this.display.isDisposed() || this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.logger.debug("shell closed");
        this.display.dispose();
        this.shell = null;
        this.display = null;
    }

    public void disposeShellAndWakeDisplay() {
        this.disposeRegistrationUI();
        this.display.wake();
    }

    private void generateLocalUIFields() {
        int textBoxHeight = 15;
        int textBoxWidth = 150;
        this.registrationPanelStackLayout = new StackLayout();
        GridLayout registrationPanelGridLayout = new GridLayout();
        GridLayout registrationInputPanelGridLayoutForCloudInput = new GridLayout();
        GridLayout registrationInputPanelGridLayoutForDeviceInput = new GridLayout();
        GridLayout registrationInputPanelGridLayoutForUserInputs = new GridLayout();
        GridLayout buttonPanelGridLayout = new GridLayout();
        GridLayout mainPanelGridLayout = new GridLayout();
        this.fontsManager = new FontsManager(this.display);
        GridData registrationPanelGridData = new GridData(1808);
        GridData mainPanelGridData = new GridData(768);
        GridData buttonPanelGridData = new GridData(1808);
        GridData userNameTextData = new GridData();
        GridData deviceNameTextData = new GridData();
        GridData cloudNameTextData = new GridData();
        GridData passwordTextData = new GridData();
        mainPanelGridLayout.numColumns = 1;
        mainPanelGridLayout.marginLeft = 90;
        mainPanelGridLayout.marginHeight = 20;
        mainPanelGridLayout.marginBottom = 5;
        registrationPanelGridLayout.marginLeft = 10;
        registrationPanelGridLayout.marginRight = 10;
        registrationInputPanelGridLayoutForCloudInput.numColumns = 2;
        registrationInputPanelGridLayoutForCloudInput.makeColumnsEqualWidth = false;
        registrationInputPanelGridLayoutForCloudInput.marginLeft = 0;
        registrationInputPanelGridLayoutForCloudInput.verticalSpacing = 4;
        registrationInputPanelGridLayoutForCloudInput.marginHeight = 4;
        registrationInputPanelGridLayoutForCloudInput.horizontalSpacing = 30;
        registrationInputPanelGridLayoutForDeviceInput.numColumns = 2;
        registrationInputPanelGridLayoutForDeviceInput.makeColumnsEqualWidth = false;
        registrationInputPanelGridLayoutForDeviceInput.marginLeft = 0;
        registrationInputPanelGridLayoutForDeviceInput.verticalSpacing = 4;
        registrationInputPanelGridLayoutForDeviceInput.marginHeight = 4;
        registrationInputPanelGridLayoutForDeviceInput.horizontalSpacing = 50;
        registrationInputPanelGridLayoutForUserInputs.numColumns = 2;
        registrationInputPanelGridLayoutForUserInputs.makeColumnsEqualWidth = false;
        registrationInputPanelGridLayoutForUserInputs.marginLeft = 0;
        registrationInputPanelGridLayoutForUserInputs.verticalSpacing = 15;
        registrationInputPanelGridLayoutForUserInputs.marginHeight = 4;
        registrationInputPanelGridLayoutForUserInputs.horizontalSpacing = 80;
        buttonPanelGridLayout.numColumns = 2;
        buttonPanelGridLayout.makeColumnsEqualWidth = false;
        buttonPanelGridLayout.marginLeft = 12;
        buttonPanelGridLayout.marginHeight = 25;
        buttonPanelGridLayout.horizontalSpacing = 180;
        this.registrationPanel = new Composite((Composite)this.shell, 0x1000000);
        this.registrationPanel.setLayout((Layout)registrationPanelGridLayout);
        registrationPanelGridData.minimumHeight = 350;
        this.registrationPanel.setLayoutData((Object)registrationPanelGridData);
        this.registrationStackPanel = new Composite(this.registrationPanel, 0x1000000);
        this.registrationStackPanel.setLayout((Layout)this.registrationPanelStackLayout);
        this.headerBodyComposite = new Composite(this.registrationStackPanel, 4);
        GridLayout headerBodyCompositeGridLayout = new GridLayout();
        headerBodyCompositeGridLayout.horizontalSpacing = 0;
        headerBodyCompositeGridLayout.marginBottom = 0;
        headerBodyCompositeGridLayout.marginTop = 0;
        headerBodyCompositeGridLayout.marginWidth = 0;
        headerBodyCompositeGridLayout.marginHeight = 0;
        this.headerBodyComposite.setLayout((Layout)headerBodyCompositeGridLayout);
        this.headerBodyComposite.setParent(this.registrationStackPanel);
        this.registrationPanelStackLayout.topControl = this.headerBodyComposite;
        this.mainTextPanel = new Composite(this.headerBodyComposite, 4);
        this.mainTextPanel.setLayout((Layout)mainPanelGridLayout);
        this.mainTextPanel.setLayoutData((Object)mainPanelGridData);
        this.mainTextPanel.setBackgroundMode(1);
        this.pageDescription = new Label(this.mainTextPanel, 4);
        this.pageDescription.setText("       " + PropertyHelper.REGVIEW_CONNECT_TO_LABEL);
        this.pageDescription.setFont(this.fontsManager.getLargeNormalFont());
        this.pageDescription.setLayoutData((Object)new GridData(768));
        this.registrationPanelForInputTexts = new Composite(this.headerBodyComposite, 4);
        GridLayout registrationPanelForInputTextsGridLayout = new GridLayout();
        registrationPanelForInputTextsGridLayout.numColumns = 1;
        registrationPanelForInputTextsGridLayout.verticalSpacing = 10;
        this.registrationPanelForInputTexts.setLayout((Layout)registrationPanelForInputTextsGridLayout);
        this.registrationPanelForCloudAndUserInputs = new Group(this.registrationPanelForInputTexts, 4);
        GridLayout registrationPanelForCloudAndUserInputsGridLayout = new GridLayout();
        this.registrationPanelForCloudAndUserInputs.setText(PropertyHelper.REGVIEW_CLOUD_DETAILS);
        registrationPanelForCloudAndUserInputsGridLayout.marginLeft = 0;
        registrationPanelForCloudAndUserInputsGridLayout.marginWidth = 0;
        this.registrationPanelForCloudAndUserInputs.setLayout((Layout)registrationPanelForCloudAndUserInputsGridLayout);
        this.registrationPanelForCloudAndUserInputs.setLayoutData((Object)new GridData(1808));
        this.registrationInputPanelForCloudInput = new Composite((Composite)this.registrationPanelForCloudAndUserInputs, 4);
        this.registrationInputPanelForCloudInput.setLayout((Layout)registrationInputPanelGridLayoutForCloudInput);
        this.cloudNameLabel = new Label(this.registrationInputPanelForCloudInput, 192);
        this.cloudNameLabel.setText(RegistrationLiterals.CLOUD_NAME_UI_LABEL);
        this.cloudNameLabel.setText(PropertyHelper.REGVIEW_CLOUD_NAME);
        this.cloudNameLabel.setToolTipText(RegistrationLiterals.CLOUD_NAME_TOOL_TIP);
        this.cloudNameLabel.setFont(this.fontsManager.getMediumNormalFont());
        GridData cloudNameLabelGridData = new GridData();
        cloudNameLabelGridData.verticalSpan = 1;
        this.cloudNameLabel.setLayoutData((Object)cloudNameLabelGridData);
        this.cloudNameInputText = new Text(this.registrationInputPanelForCloudInput, 2048);
        cloudNameTextData.heightHint = 15;
        cloudNameTextData.widthHint = 150;
        this.cloudNameInputText.setTextLimit(64);
        this.cloudNameInputText.setLayoutData((Object)userNameTextData);
        if (!StringUtils.isEmpty((String)PropertyHelper.CLOUD_NAME)) {
            this.cloudNameInputText.setText(PropertyHelper.CLOUD_NAME);
            this.cloudNameInputText.setEnabled(false);
        }
        this.registrationInputPanelForUserInputs = new Composite((Composite)this.registrationPanelForCloudAndUserInputs, 4);
        this.registrationInputPanelForUserInputs.setLayout((Layout)registrationInputPanelGridLayoutForUserInputs);
        this.userNameLabel = new Label(this.registrationInputPanelForUserInputs, 64);
        this.userNameLabel.setText("User Name");
        this.userNameLabel.setToolTipText(RegistrationLiterals.USERNAME_TOOLTIP_LABEL);
        this.userNameLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.userNameLabel.setLayoutData((Object)new GridData());
        this.userNameInputText = new Text(this.registrationInputPanelForUserInputs, 2048);
        userNameTextData.heightHint = 15;
        userNameTextData.widthHint = 150;
        this.userNameInputText.setTextLimit(320);
        this.userNameInputText.setLayoutData((Object)userNameTextData);
        this.passwordLabel = new Label(this.registrationInputPanelForUserInputs, 64);
        this.passwordLabel.setText("Password");
        this.passwordLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.passwordLabel.setLayoutData((Object)new GridData());
        this.passwordInputText = new Text(this.registrationInputPanelForUserInputs, 0x400800);
        passwordTextData.heightHint = 15;
        passwordTextData.widthHint = 150;
        this.passwordInputText.setTextLimit(64);
        this.passwordInputText.setLayoutData((Object)passwordTextData);
        this.registrationPanelParentForDeviceInputs = new Group(this.registrationPanelForInputTexts, 4);
        GridLayout registrationPanelParentForDeviceInputsGridLayout = new GridLayout();
        registrationPanelParentForDeviceInputsGridLayout.marginLeft = 0;
        registrationPanelParentForDeviceInputsGridLayout.marginWidth = 0;
        this.registrationPanelParentForDeviceInputs.setLayout((Layout)registrationPanelParentForDeviceInputsGridLayout);
        this.registrationPanelParentForDeviceInputs.setLayoutData((Object)new GridData(1808));
        this.registrationPanelParentForDeviceInputs.setText("Device Customization");
        this.registrationInputPanelForDeviceInput = new Composite((Composite)this.registrationPanelParentForDeviceInputs, 128);
        this.registrationInputPanelForDeviceInput.setLayout((Layout)registrationInputPanelGridLayoutForDeviceInput);
        this.deviceNameLabel = new Label(this.registrationInputPanelForDeviceInput, 64);
        this.deviceNameLabel.setText("Computer Name");
        this.deviceNameLabel.setToolTipText("Used for identifying this machine");
        this.deviceNameLabel.setFont(this.fontsManager.getMediumNormalFont());
        GridData deviceNameLabelGridData = new GridData();
        deviceNameLabelGridData.verticalSpan = 2;
        this.deviceNameLabel.setLayoutData((Object)deviceNameLabelGridData);
        this.deviceNameInputText = new Text(this.registrationInputPanelForDeviceInput, 2048);
        deviceNameTextData.heightHint = 15;
        deviceNameTextData.widthHint = 150;
        this.deviceNameInputText.setText(this.getDeviceName());
        this.deviceNameInputText.setEnabled(false);
        this.deviceNameInputText.setLayoutData((Object)deviceNameTextData);
        this.deviceNameLabelInfo = new Label(this.registrationInputPanelForDeviceInput, 64);
        this.deviceNameLabelInfo.setText("Used for identifying this machine ");
        this.deviceNameLabelInfo.setFont(this.fontsManager.getSmallNormalFont());
        GridData grid = new GridData();
        grid.widthHint = 180;
        this.deviceNameLabelInfo.setLayoutData((Object)grid);
        this.buttonPanel = new Composite(this.registrationPanel, 0x1000000);
        this.buttonPanel.setLayoutData((Object)buttonPanelGridData);
        this.buttonPanel.setLayout((Layout)buttonPanelGridLayout);
        Listener listener = event -> {
            this.logger.debug("clicked on Help Hyperlink");
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(PropertyHelper.HELP_LINK_SEND_MAIL));
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("IOException" + e.getMessage());
            }
            catch (URISyntaxException e) {
                this.logger.trace("" + e);
                this.logger.error("URISyntax Exception " + e.getMessage());
            }
        };
        this.registerButton = new Button(this.buttonPanel, 0);
        this.registerButton.setText(" Login ");
        GridData registerButtonData = new GridData();
        this.registerButton.setLayoutData((Object)registerButtonData);
        this.registerButton.addSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registrationInputPanelForDeviceInput.setTabList(new Control[]{this.deviceNameInputText});
        this.registrationInputPanelForUserInputs.setTabList(new Control[]{this.userNameInputText, this.passwordInputText});
        this.buttonPanel.setTabList(new Control[]{this.registerButton});
        this.registrationPanelParentForDeviceInputs.setTabList(new Control[]{this.registrationInputPanelForDeviceInput});
        this.registrationPanelForCloudAndUserInputs.setTabList(new Control[]{this.registrationInputPanelForCloudInput, this.registrationInputPanelForUserInputs});
        this.registrationPanelForInputTexts.setTabList(new Control[]{this.registrationPanelForCloudAndUserInputs, this.registrationPanelParentForDeviceInputs});
        this.registrationStackPanel.setTabList(new Control[]{this.headerBodyComposite});
        this.registrationPanel.setTabList(new Control[]{this.registrationStackPanel, this.buttonPanel});
    }

    public void displayErrorMessageBox() {
        if (this.display == null) {
            return;
        }
        Runnable runnable = () -> {
            MessageBox dialog = new MessageBox(this.shell, 40);
            dialog.setText("Login failed");
            dialog.setMessage("Please fill in all the details");
            dialog.open();
            this.setLoginButtonEnableOrDisableAndChangeStatus(true);
        };
        this.display.asyncExec(runnable);
    }

    public void setLoginButtonEnableOrDisableAndChangeStatus(boolean value) {
        this.registerButton.setEnabled(value);
        if (value) {
            this.pageDescription.setText("");
            this.pageDescription.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
        } else {
            this.pageDescription.setText("");
            this.pageDescription.setText("       " + PropertyHelper.REGVIEW_CONNECT_TO_LABEL);
        }
    }

    public void disposeRegistrationUI() {
        this.disposeFontsAndImages();
        this.disposeLocalFields();
        this.shell.dispose();
    }

    private void disposeFontsAndImages() {
        if (this.registrationImage != null && !this.registrationImage.isDisposed()) {
            this.registrationImage.dispose();
        }
        this.fontsManager.disposeFonts();
    }

    private void disposeLocalFields() {
        if (this.pageDescription != null) {
            this.pageDescription.dispose();
        }
        if (this.userNameLabel != null) {
            this.userNameLabel.dispose();
        }
        if (this.userNameInputText != null) {
            this.userNameInputText.dispose();
        }
        if (this.cloudNameLabel != null) {
            this.cloudNameLabel.dispose();
        }
        if (this.deviceNameLabel != null) {
            this.deviceNameLabel.dispose();
        }
        if (this.deviceNameInputText != null) {
            this.deviceNameInputText.dispose();
        }
        if (this.passwordLabel != null) {
            this.passwordLabel.dispose();
        }
        if (this.passwordInputText != null) {
            this.passwordInputText.dispose();
        }
        if (this.registerButton != null) {
            this.registerButton.dispose();
        }
        if (this.exitButton != null) {
            this.exitButton.dispose();
        }
        if (this.helpHyperlink != null) {
            this.helpHyperlink.dispose();
        }
        if (this.horizontalLineSeperatorAftercompositeFields != null) {
            this.horizontalLineSeperatorAftercompositeFields.dispose();
        }
        if (this.horizontalLineSeperatorAfterMainTitle != null) {
            this.horizontalLineSeperatorAfterMainTitle.dispose();
        }
    }

    public String getDeviceName() {
        try {
            this.deviceName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.trace("" + e);
            this.logger.error("unknownhost Exception" + e.getMessage());
        }
        return this.deviceName;
    }

    public void loadSilentRegistration(String deviceName, String userName, String password, String cloudName) {
        this.logger.debug("user name and device name for wipro^^^^^^^^^^^^^^^^^^^^:" + deviceName + "kkk" + userName);
        CloudRegistrationUtility crs = new CloudRegistrationUtility(cloudName.trim(), deviceName.trim(), userName.trim(), SettingHelper.getKeystorePath());
        boolean isEnteredFieldValid = crs.validateDataForSilent();
        String pwd = password;
        if (password != null) {
            pwd = password.trim();
        }
        if (!isEnteredFieldValid) {
            this.displayErrorMessageBox();
            return;
        }
        ProgressBarPaneView prbpv = new ProgressBarPaneView(this.registrationStackPanel, cloudName.trim(), deviceName.trim(), userName.trim(), pwd, this.registerButton, this.registrationPanelStackLayout, this.headerBodyComposite, this.registerSelectionAdapter);
        Thread th = new Thread(prbpv);
        th.run();
    }

    protected class RegisterSelectionAdapter
    extends SelectionAdapter {
        protected RegisterSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            if ("silent".equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                RegistrationView.this.loadSilentRegistration(RegistrationView.this.deviceNameInputText.getText().trim(), RegistrationView.this.userNameInputText.getText().trim(), RegistrationView.this.passwordInputText.getText().trim(), RegistrationView.this.cloudNameInputText.getText().trim());
                RegistrationView.this.disposeRegistrationUI();
            } else {
                this.connectToCloud();
            }
        }

        private void connectToCloud() {
            CloudRegistrationUtility crs = new CloudRegistrationUtility(RegistrationView.this.cloudNameInputText.getText().trim(), RegistrationView.this.deviceNameInputText.getText().trim(), RegistrationView.this.userNameInputText.getText().trim(), RegistrationView.this.passwordInputText.getText().trim(), SettingHelper.getKeystorePath());
            boolean isEnteredFieldValid = crs.validateData();
            if (!isEnteredFieldValid) {
                RegistrationView.this.displayErrorMessageBox();
                return;
            }
            ProgressBarPaneView prbpv = new ProgressBarPaneView(RegistrationView.this.registrationStackPanel, RegistrationView.this.cloudNameInputText.getText().trim(), RegistrationView.this.deviceNameInputText.getText().trim(), RegistrationView.this.userNameInputText.getText().trim(), RegistrationView.this.passwordInputText.getText().trim(), RegistrationView.this.registerButton, RegistrationView.this.registrationPanelStackLayout, RegistrationView.this.headerBodyComposite, RegistrationView.this.registerSelectionAdapter);
            Thread th = new Thread(prbpv);
            th.start();
            RegistrationView.this.setLoginButtonEnableOrDisableAndChangeStatus(false);
        }
    }
}

