/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDownload;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLResponse;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

class WebDownloadDelegate {
    COMObject iWebDownloadDelegate;
    Browser browser;
    int refCount = 0;
    int status = -1;
    long size;
    long totalSize;
    String url;
    static final int DOWNLOAD_FINISHED = 0;
    static final int DOWNLOAD_CANCELLED = 1;
    static final int DOWNLOAD_ERROR = 3;

    WebDownloadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebDownloadDelegate = new COMObject(new int[]{2, 0, 0, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 1, 1}){

            @Override
            public int method0(int[] nArray) {
                return WebDownloadDelegate.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return WebDownloadDelegate.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return WebDownloadDelegate.this.Release();
            }

            @Override
            public int method3(int[] nArray) {
                return WebDownloadDelegate.this.decideDestinationWithSuggestedFilename(nArray[0], nArray[1]);
            }

            @Override
            public int method4(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method5(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method6(int[] nArray) {
                return WebDownloadDelegate.this.didFailWithError(nArray[0], nArray[1]);
            }

            @Override
            public int method7(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method8(int[] nArray) {
                return WebDownloadDelegate.this.didReceiveDataOfLength(nArray[0], nArray[1]);
            }

            @Override
            public int method9(int[] nArray) {
                return WebDownloadDelegate.this.didReceiveResponse(nArray[0], nArray[1]);
            }

            @Override
            public int method10(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method11(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method12(int[] nArray) {
                return WebDownloadDelegate.this.willSendRequest(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            @Override
            public int method13(int[] nArray) {
                return WebDownloadDelegate.this.didBegin(nArray[0]);
            }

            @Override
            public int method14(int[] nArray) {
                return WebDownloadDelegate.this.didFinish(nArray[0]);
            }
        };
    }

    int decideDestinationWithSuggestedFilename(int n, int n2) {
        String string = WebKit.extractBSTR(n2);
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        fileDialog.setOverwrite(true);
        String string2 = fileDialog.open();
        IWebDownload iWebDownload = new IWebDownload(n);
        iWebDownload.setDeletesFileUponFailure(0);
        if (string2 == null) {
            iWebDownload.setDestination(WebKit.createBSTR(""), 1);
            iWebDownload.cancel();
            iWebDownload.Release();
        } else {
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            iWebDownload.setDestination(WebKit.createBSTR(string2), 1);
            this.openDownloadWindow(iWebDownload, string2);
        }
        return 0;
    }

    int didBegin(int n) {
        new IWebDownload(n).AddRef();
        this.status = -1;
        this.size = 0L;
        this.totalSize = 0L;
        this.url = null;
        return 0;
    }

    int didFailWithError(int n, int n2) {
        new IWebDownload(n).Release();
        this.status = 3;
        return 0;
    }

    int didFinish(int n) {
        new IWebDownload(n).Release();
        this.status = 0;
        return 0;
    }

    int didReceiveDataOfLength(int n, int n2) {
        this.size += (long)n2;
        return 0;
    }

    int didReceiveResponse(int n, int n2) {
        if (n2 != 0) {
            int[] nArray;
            IWebURLResponse iWebURLResponse = new IWebURLResponse(n2);
            long[] lArray = new long[1];
            int n3 = iWebURLResponse.expectedContentLength(lArray);
            if (n3 == 0) {
                this.totalSize = lArray[0];
            }
            if ((n3 = iWebURLResponse.URL(nArray = new int[1])) == 0 && nArray[0] != 0) {
                this.url = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
            }
        }
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebDownloadDelegate != null) {
            this.iWebDownloadDelegate.dispose();
            this.iWebDownloadDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebDownloadDelegate.getAddress();
    }

    void openDownloadWindow(final IWebDownload iWebDownload, String string) {
        final Shell shell = new Shell();
        shell.setText(Compatibility.getMessage("SWT_FileDownload"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Download_Location", new Object[]{string, this.url}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width / 2;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                iWebDownload.cancel();
                WebDownloadDelegate.this.status = 1;
                iWebDownload.Release();
            }
        };
        button.addListener(13, listener);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed() || WebDownloadDelegate.this.status == 0 || WebDownloadDelegate.this.status == 1) {
                    shell.dispose();
                    return;
                }
                if (WebDownloadDelegate.this.status == 3) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    button.removeListener(13, listener);
                    button.addListener(13, new Listener(){

                        @Override
                        public void handleEvent(Event event) {
                            shell.dispose();
                        }
                    });
                    return;
                }
                long l = WebDownloadDelegate.this.size / 1024L;
                long l2 = WebDownloadDelegate.this.totalSize / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebDownloadDelegate)) {
            COM.MoveMemory(n2, new int[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int willSendRequest(int n, int n2, int n3, int n4) {
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(n2);
        iWebMutableURLRequest.AddRef();
        OS.MoveMemory(n4, new int[]{n2}, C.PTR_SIZEOF);
        return 0;
    }
}

