/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.SupportDialog;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelpAndAboutView
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(HelpAndAboutView.class);
    private Composite aboutParabluPanel = null;
    private Label aboutParabluLabel = null;
    private Link websiteHelpLink = null;
    private Link helpHyperlink = null;
    private FontsManager fontsManager;

    public HelpAndAboutView(Composite composite) {
        this.mainParentComposite = composite;
        this.generateUI();
    }

    private void generateUI() {
        StringBuilder aboutDisplayLabelText = new StringBuilder();
        this.readAboutStringFromFile(aboutDisplayLabelText);
        GridLayout aboutParabluPanelGridLayout = new GridLayout();
        aboutParabluPanelGridLayout.marginTop = 20;
        aboutParabluPanelGridLayout.marginLeft = 20;
        aboutParabluPanelGridLayout.verticalSpacing = 30;
        aboutParabluPanelGridLayout.numColumns = 2;
        aboutParabluPanelGridLayout.horizontalSpacing = 80;
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 16);
        this.baseGroup.setLayout((Layout)new GridLayout());
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        this.aboutParabluPanel = new Composite(this.baseGroup, 2048);
        this.aboutParabluPanel.setLayoutData((Object)new GridData(768));
        this.aboutParabluPanel.setLayout((Layout)aboutParabluPanelGridLayout);
        this.aboutParabluLabel = new Label(this.aboutParabluPanel, 320);
        GridData gridData = new GridData(512);
        gridData.horizontalSpan = 2;
        this.aboutParabluLabel.setLayoutData((Object)gridData);
        this.aboutParabluLabel.setText(aboutDisplayLabelText.toString());
        this.aboutParabluLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.websiteHelpLink = new Link(this.aboutParabluPanel, 256);
        this.websiteHelpLink.setLayoutData((Object)new GridData(768));
        this.websiteHelpLink.setText("<a>Support Request</a>");
        this.websiteHelpLink.setFont(this.fontsManager.getMediumNormalFont());
        Listener listener = event -> {
            if (SupportHelper.isSupportRequestInitiated()) {
                logger.debug("isSupportRequestInitiated = " + SupportHelper.isSupportRequestInitiated());
                return;
            }
            SupportDialog supportDialog = new SupportDialog(this.mainParentComposite.getShell());
            supportDialog.setText("Support Request");
            supportDialog.open();
        };
        this.websiteHelpLink.addListener(13, listener);
        this.helpHyperlink = new Link(this.aboutParabluPanel, 0);
        this.helpHyperlink.setLayoutData((Object)new GridData(768));
        this.helpHyperlink.setText("<a>Help</a>");
        this.helpHyperlink.setFont(this.fontsManager.getMediumNormalFont());
        Listener listener2 = event -> {
            logger.debug("clicked on Help Hyperlink");
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(PropertyHelper.HELP_LINK_SEND_MAIL));
            }
            catch (IOException e) {
                logger.error("IOException:" + e);
            }
            catch (URISyntaxException e) {
                logger.error("URISyntaxException" + e);
            }
        };
        this.helpHyperlink.addListener(13, listener2);
    }

    public void readAboutStringFromFile(StringBuilder aboutDisplayLabelText) {
        File aboutParabluFile = new File(MacSettingsHelper.baseResourceFolder + SyncConstants.ABOUT_PARABLU_FILE);
        try (FileReader fr = new FileReader(aboutParabluFile);
             BufferedReader br = new BufferedReader(fr);){
            String line = br.readLine();
            while (line != null) {
                aboutDisplayLabelText.append(line).append("\n");
                line = br.readLine();
            }
        }
        catch (IOException e) {
            logger.error("IOException while reading about parablu file" + e);
        }
    }

    public void disposeAllAboutParabluFields() {
        this.fontsManager.disposeFonts();
        this.disposeAllAboutParabluPanelFields();
        if (this.aboutParabluPanel != null && !this.aboutParabluPanel.isDisposed()) {
            this.aboutParabluPanel.dispose();
        }
        this.aboutParabluPanel = null;
    }

    private void disposeAllAboutParabluPanelFields() {
        if (this.aboutParabluLabel != null && !this.aboutParabluLabel.isDisposed()) {
            this.aboutParabluLabel.dispose();
        }
        if (this.websiteHelpLink != null && !this.websiteHelpLink.isDisposed()) {
            this.websiteHelpLink.dispose();
        }
        this.aboutParabluLabel = null;
        this.websiteHelpLink = null;
    }
}

