/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Name;

public class CertificateList
implements DEREncodable {
    TBSCertList tbsCertList;
    AlgorithmIdentifier sigAlgId;
    DERBitString sig;

    public CertificateList(ASN1Sequence aSN1Sequence) {
        this.tbsCertList = TBSCertList.getInstance(aSN1Sequence.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.sig = (DERBitString)aSN1Sequence.getObjectAt(2);
    }

    public TBSCertList getTBSCertList() {
        return this.tbsCertList;
    }

    public TBSCertList.CRLEntry[] getRevokedCertificates() {
        return this.tbsCertList.getRevokedCertificates();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sig;
    }

    public int getVersion() {
        return this.tbsCertList.getVersion();
    }

    public X509Name getIssuer() {
        return this.tbsCertList.getIssuer();
    }

    public DERUTCTime getThisUpdate() {
        return this.tbsCertList.getThisUpdate();
    }

    public DERUTCTime getNextUpdate() {
        return this.tbsCertList.getNextUpdate();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.tbsCertList);
        dERConstructedSequence.addObject(this.sigAlgId);
        dERConstructedSequence.addObject(this.sig);
        return dERConstructedSequence;
    }
}

